class NodeBase {
  constructor(options, body, labelModule) {
    this.body = body;
    this.labelModule = labelModule;
    this.setOptions(options);
    this.top = undefined;
    this.left = undefined;
    this.height = undefined;
    this.width = undefined;
    this.radius = undefined;
    this.boundingBox = {top: 0, left: 0, right: 0, bottom: 0};
  }

  setOptions(options) {
    this.options = options;
  }

  _distanceToBorder(angle) {
    var borderWidth = 1;
    return Math.min(
        Math.abs(this.width / 2 / Math.cos(angle)),
        Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
  }

  enableShadow(ctx) {
    if (this.options.shadow.enabled === true) {
      ctx.shadowColor = 'rgba(0,0,0,0.5)';
      ctx.shadowBlur = this.options.shadow.size;
      ctx.shadowOffsetX = this.options.shadow.x;
      ctx.shadowOffsetY = this.options.shadow.y;
    }
  }

  disableShadow(ctx) {
    if (this.options.shadow.enabled === true) {
      ctx.shadowColor = 'rgba(0,0,0,0)';
      ctx.shadowBlur = 0;
      ctx.shadowOffsetX = 0;
      ctx.shadowOffsetY = 0;
    }
  }
}

export default NodeBase;