/*
 * Copyright (C) 2013 Square, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package retrofit.http;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Named replacement in the URL path. Values are converted to string using
 * {@link String#valueOf(Object)}. Values are used literally without URL encoding. See
 * {@link retrofit.http.Path @Path} for URL encoding equivalent.
 * <p>
 * <pre>
 * &#64;GET("/image/{id}")
 * void example(@EncodedPath("id") int id, ..);
 * </pre>
 * <p>
 * Path parameters may not be {@code null}.
 *
 * @see Path
 * @deprecated Use {@link Path} with {@link Path#encode() encode = false}.
 */
@Documented
@Deprecated
@Retention(RUNTIME)
@Target(PARAMETER)
public @interface EncodedPath {
  String value();
}
