// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: ../wire-runtime/src/test/proto/person.proto
package retrofit.converter;

import com.squareup.wire.Message;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.ProtoField;
import java.util.Collections;
import java.util.List;

import static com.squareup.wire.Message.Datatype.ENUM;
import static com.squareup.wire.Message.Datatype.INT32;
import static com.squareup.wire.Message.Datatype.STRING;
import static com.squareup.wire.Message.Label.REPEATED;
import static com.squareup.wire.Message.Label.REQUIRED;

public final class Person extends Message {

  public static final String DEFAULT_NAME = "";
  public static final Integer DEFAULT_ID = 0;
  public static final String DEFAULT_EMAIL = "";
  public static final List<PhoneNumber> DEFAULT_PHONE = Collections.emptyList();

  /**
   * The customer's full name.
   */
  @ProtoField(tag = 1, type = STRING, label = REQUIRED)
  public final String name;

  /**
   * The customer's ID number.
   */
  @ProtoField(tag = 2, type = INT32, label = REQUIRED)
  public final Integer id;

  /**
   * Email address for the customer.
   */
  @ProtoField(tag = 3, type = STRING)
  public final String email;

  /**
   * A list of the customer's phone numbers.
   */
  @ProtoField(tag = 4, label = REPEATED)
  public final List<PhoneNumber> phone;

  public Person(String name, Integer id, String email, List<PhoneNumber> phone) {
    this.name = name;
    this.id = id;
    this.email = email;
    this.phone = immutableCopyOf(phone);
  }

  private Person(Builder builder) {
    this(builder.name, builder.id, builder.email, builder.phone);
    setBuilder(builder);
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Person)) return false;
    Person o = (Person) other;
    return equals(name, o.name)
        && equals(id, o.id)
        && equals(email, o.email)
        && equals(phone, o.phone);
  }

  @Override
  public int hashCode() {
    int result = hashCode;
    if (result == 0) {
      result = name != null ? name.hashCode() : 0;
      result = result * 37 + (id != null ? id.hashCode() : 0);
      result = result * 37 + (email != null ? email.hashCode() : 0);
      result = result * 37 + (phone != null ? phone.hashCode() : 1);
      hashCode = result;
    }
    return result;
  }

  public static final class Builder extends Message.Builder<Person> {

    public String name;
    public Integer id;
    public String email;
    public List<PhoneNumber> phone;

    public Builder() {
    }

    public Builder(Person message) {
      super(message);
      if (message == null) return;
      this.name = message.name;
      this.id = message.id;
      this.email = message.email;
      this.phone = copyOf(message.phone);
    }

    /**
     * The customer's full name.
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * The customer's ID number.
     */
    public Builder id(Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Email address for the customer.
     */
    public Builder email(String email) {
      this.email = email;
      return this;
    }

    /**
     * A list of the customer's phone numbers.
     */
    public Builder phone(List<PhoneNumber> phone) {
      this.phone = checkForNulls(phone);
      return this;
    }

    @Override
    public Person build() {
      checkRequiredFields();
      return new Person(this);
    }
  }

  public enum PhoneType
      implements ProtoEnum {
    MOBILE(0),
    HOME(1),
    /**
     * Could be phone or fax.
     */
    WORK(2);

    private final int value;

    private PhoneType(int value) {
      this.value = value;
    }

    @Override
    public int getValue() {
      return value;
    }
  }

  public static final class PhoneNumber extends Message {

    public static final String DEFAULT_NUMBER = "";
    public static final PhoneType DEFAULT_TYPE = PhoneType.HOME;

    /**
     * The customer's phone number.
     */
    @ProtoField(tag = 1, type = STRING, label = REQUIRED)
    public final String number;

    /**
     * The type of phone stored here.
     */
    @ProtoField(tag = 2, type = ENUM)
    public final PhoneType type;

    public PhoneNumber(String number, PhoneType type) {
      this.number = number;
      this.type = type;
    }

    private PhoneNumber(Builder builder) {
      this(builder.number, builder.type);
      setBuilder(builder);
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof PhoneNumber)) return false;
      PhoneNumber o = (PhoneNumber) other;
      return equals(number, o.number)
          && equals(type, o.type);
    }

    @Override
    public int hashCode() {
      int result = hashCode;
      if (result == 0) {
        result = number != null ? number.hashCode() : 0;
        result = result * 37 + (type != null ? type.hashCode() : 0);
        hashCode = result;
      }
      return result;
    }

    public static final class Builder extends Message.Builder<PhoneNumber> {

      public String number;
      public PhoneType type;

      public Builder() {
      }

      public Builder(PhoneNumber message) {
        super(message);
        if (message == null) return;
        this.number = message.number;
        this.type = message.type;
      }

      /**
       * The customer's phone number.
       */
      public Builder number(String number) {
        this.number = number;
        return this;
      }

      /**
       * The type of phone stored here.
       */
      public Builder type(PhoneType type) {
        this.type = type;
        return this;
      }

      @Override
      public PhoneNumber build() {
        checkRequiredFields();
        return new PhoneNumber(this);
      }
    }
  }
}
