# How to Develop TensorBoard

## Launching a Development Instance

The first step is getting a TensorBoard development environment set up. You
should start by making sure you have [nodejs](https://nodejs.org/en/) and
[npm](https://www.npmjs.com/). On Ubuntu, `sudo apt-get install -y nodejs
nodejs-legacy npm`.

Next, you'll want to install [gulp](http://gulpjs.com/) and
[bower](http://bower.io/), which are used for build tooling and dependency
management respectively. `sudo npm install -g gulp bower` will install them
globally for convenience.

Then, cd into the TensorBoard directory:

`cd tensorflow/tensorboard`

and install dependencies:

`npm run prepare`

Then, run gulp: `gulp`

(Don't worry if there are some linter errors.)

Now you can navigate to
[http://localhost:8000/demo/index.html](http://localhost:8000/demo/index.html)
and play with the demo TensorBoard instance. If you make changes to the source
code, `gulp` should detect it, recompile (if Typescript), and reload your
browser.

This demo TensorBoard will have a small amount of demo data generated by
[generate_testdata.py](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/tensorboard/scripts/generate_testdata.py).
You can use [serialize_tensorboard.py](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/tensorboard/scripts/serialize_tensorboard.py)
to create a realistic demo directory from your own data files.

## Launching TensorBoard with modified source

If you are developing in open source, and have made some changes to TensorBoard
that you'd like to try out on real data, then you need to regenerate
`dist/tf-tensorboard.html`.

Run `gulp regenerate`. That will recompile all of the TensorBoard assets, and
produce a new tf-tensorboard.html with your changes.

Now, you can use `bazel` to launch TensorBoard:

`bazel run //tensorflow/tensorboard:tensorboard -- --logdir=/path/to/logs`.
