var fs = require('fs')
var assert = require('assert')
var rmrf = require('rimraf')
var write = require('../src/write')

describe('write', function() {

  // Sometime Travis can be slow...
  this.timeout(20 * 1000)

  var tempPath = __dirname + '/../tmp'
  var filePath = tempPath + '/../tmp/test.txt'

  beforeEach(function() {
    rmrf.sync(tempPath)
    fs.mkdirSync(tempPath)
  })

  it('always writes data from the latest call', function(done) {
    // 1M characters
    var data = ''
    for (var i = 0; i <= 1000 * 1000; i++) {
      data += 'x'
    }

    for (var i = 0; i <= 1000 * 1000; i++) {
      write(filePath, data + i)
    }

    setTimeout(function() {
      assert.equal(fs.readFileSync(filePath, 'utf-8'), data + (i - 1))
      done()
    }, 1000)
  })

})