// ThreeExtras.js r43 - http://github.com/mrdoob/three.js
THREE.ColorUtils={adjustHSV:function(a,b,c,e){var f=THREE.ColorUtils.__hsv;THREE.ColorUtils.rgbToHsv(a,f);f.h=THREE.ColorUtils.clamp(f.h+b,0,1);f.s=THREE.ColorUtils.clamp(f.s+c,0,1);f.v=THREE.ColorUtils.clamp(f.v+e,0,1);a.setHSV(f.h,f.s,f.v)},rgbToHsv:function(a,b){var c=a.r,e=a.g,f=a.b,h=Math.max(Math.max(c,e),f),g=Math.min(Math.min(c,e),f);if(g==h)g=c=0;else{var j=h-g,g=j/h,c=c==h?(e-f)/j:e==h?2+(f-c)/j:4+(c-e)/j;c/=6;c<0&&(c+=1);c>1&&(c-=1)}b===void 0&&(b={h:0,s:0,v:0});b.h=c;b.s=g;b.v=h;return b},
clamp:function(a,b,c){return a<b?b:a>c?c:a}};THREE.ColorUtils.__hsv={h:0,s:0,v:0};
THREE.GeometryUtils={merge:function(a,b){var c=b instanceof THREE.Mesh,e=a.vertices.length,f=c?b.geometry:b,h=a.vertices,g=f.vertices,j=a.faces,k=f.faces,l=a.faceVertexUvs[0],f=f.faceVertexUvs[0];c&&b.matrixAutoUpdate&&b.updateMatrix();for(var m=0,n=g.length;m<n;m++){var o=new THREE.Vertex(g[m].position.clone());c&&b.matrix.multiplyVector3(o.position);h.push(o)}m=0;for(n=k.length;m<n;m++){var g=k[m],t,v,u=g.vertexNormals,o=g.vertexColors;g instanceof THREE.Face3?t=new THREE.Face3(g.a+e,g.b+e,g.c+
e):g instanceof THREE.Face4&&(t=new THREE.Face4(g.a+e,g.b+e,g.c+e,g.d+e));t.normal.copy(g.normal);c=0;for(h=u.length;c<h;c++)v=u[c],t.vertexNormals.push(v.clone());t.color.copy(g.color);c=0;for(h=o.length;c<h;c++)v=o[c],t.vertexColors.push(v.clone());t.materials=g.materials.slice();t.centroid.copy(g.centroid);j.push(t)}m=0;for(n=f.length;m<n;m++){e=f[m];j=[];c=0;for(h=e.length;c<h;c++)j.push(new THREE.UV(e[c].u,e[c].v));l.push(j)}},clone:function(a){var b=new THREE.Geometry,c,e=a.vertices,f=a.faces,
h=a.faceVertexUvs[0],a=0;for(c=e.length;a<c;a++){var g=new THREE.Vertex(e[a].position.clone());b.vertices.push(g)}a=0;for(c=f.length;a<c;a++){var j=f[a],k,l,m=j.vertexNormals,n=j.vertexColors;j instanceof THREE.Face3?k=new THREE.Face3(j.a,j.b,j.c):j instanceof THREE.Face4&&(k=new THREE.Face4(j.a,j.b,j.c,j.d));k.normal.copy(j.normal);e=0;for(g=m.length;e<g;e++)l=m[e],k.vertexNormals.push(l.clone());k.color.copy(j.color);e=0;for(g=n.length;e<g;e++)l=n[e],k.vertexColors.push(l.clone());k.materials=j.materials.slice();
k.centroid.copy(j.centroid);b.faces.push(k)}a=0;for(c=h.length;a<c;a++){f=h[a];k=[];e=0;for(g=f.length;e<g;e++)k.push(new THREE.UV(f[e].u,f[e].v));b.faceVertexUvs[0].push(k)}return b},randomPointInTriangle:function(a,b,c){var e,f,h,g=new THREE.Vector3,j=THREE.GeometryUtils.__v1;e=THREE.GeometryUtils.random();f=THREE.GeometryUtils.random();e+f>1&&(e=1-e,f=1-f);h=1-e-f;g.copy(a);g.multiplyScalar(e);j.copy(b);j.multiplyScalar(f);g.addSelf(j);j.copy(c);j.multiplyScalar(h);g.addSelf(j);return g},randomPointInFace:function(a,
b,c){var e,f,h;if(a instanceof THREE.Face3)return e=b.vertices[a.a].position,f=b.vertices[a.b].position,h=b.vertices[a.c].position,THREE.GeometryUtils.randomPointInTriangle(e,f,h);else if(a instanceof THREE.Face4){e=b.vertices[a.a].position;f=b.vertices[a.b].position;h=b.vertices[a.c].position;var b=b.vertices[a.d].position,g;c?a._area1&&a._area2?(c=a._area1,g=a._area2):(c=THREE.GeometryUtils.triangleArea(e,f,b),g=THREE.GeometryUtils.triangleArea(f,h,b),a._area1=c,a._area2=g):(c=THREE.GeometryUtils.triangleArea(e,
f,b),g=THREE.GeometryUtils.triangleArea(f,h,b));return THREE.GeometryUtils.random()*(c+g)<c?THREE.GeometryUtils.randomPointInTriangle(e,f,b):THREE.GeometryUtils.randomPointInTriangle(f,h,b)}},randomPointsInGeometry:function(a,b){function c(a){function c(b,e){if(e<b)return b;var g=b+Math.floor((e-b)/2);return l[g]>a?c(b,g-1):l[g]<a?c(g+1,e):g}return c(0,l.length-1)}var e,f,h=a.faces,g=a.vertices,j=h.length,k=0,l=[],m,n,o,t;for(f=0;f<j;f++){e=h[f];if(e instanceof THREE.Face3)m=g[e.a].position,n=g[e.b].position,
o=g[e.c].position,e._area=THREE.GeometryUtils.triangleArea(m,n,o);else if(e instanceof THREE.Face4)m=g[e.a].position,n=g[e.b].position,o=g[e.c].position,t=g[e.d].position,e._area1=THREE.GeometryUtils.triangleArea(m,n,t),e._area2=THREE.GeometryUtils.triangleArea(n,o,t),e._area=e._area1+e._area2;k+=e._area;l[f]=k}e=[];g={};for(f=0;f<b;f++)j=THREE.GeometryUtils.random()*k,j=c(j),e[f]=THREE.GeometryUtils.randomPointInFace(h[j],a,!0),g[j]?g[j]+=1:g[j]=1;return e},triangleArea:function(a,b,c){var e,f=THREE.GeometryUtils.__v1;
f.sub(a,b);e=f.length();f.sub(a,c);a=f.length();f.sub(b,c);c=f.length();b=0.5*(e+a+c);return Math.sqrt(b*(b-e)*(b-a)*(b-c))},random16:function(){return(65280*Math.random()+255*Math.random())/65535}};THREE.GeometryUtils.random=THREE.GeometryUtils.random16;THREE.GeometryUtils.__v1=new THREE.Vector3;
THREE.ImageUtils={loadTexture:function(a,b,c){var e=new Image,f=new THREE.Texture(e,b);e.onload=function(){f.needsUpdate=!0;c&&c(this)};e.crossOrigin="";e.src=a;return f},loadTextureCube:function(a,b,c){var e,f=[],h=new THREE.Texture(f,b),b=f.loadCount=0;for(e=a.length;b<e;++b)f[b]=new Image,f[b].onload=function(){f.loadCount+=1;if(f.loadCount==6)h.needsUpdate=!0;c&&c(this)},f[b].crossOrigin="",f[b].src=a[b];return h}};
THREE.SceneUtils={showHierarchy:function(a,b){THREE.SceneUtils.traverseHierarchy(a,function(a){a.visible=b})},traverseHierarchy:function(a,b){var c,e,f=a.children.length;for(e=0;e<f;e++)c=a.children[e],b(c),THREE.SceneUtils.traverseHierarchy(c,b)}};
if(THREE.WebGLRenderer)THREE.ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.fog,THREE.UniformsLib.lights,{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},enableSpecular:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tSpecular:{type:"t",value:3,texture:null},tAO:{type:"t",value:4,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:5,texture:null},uDisplacementBias:{type:"f",value:0},uDisplacementScale:{type:"f",value:1},uDiffuseColor:{type:"c",
value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30},uOpacity:{type:"f",value:1}}]),fragmentShader:["uniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform float uOpacity;\nuniform bool enableDiffuse;\nuniform bool enableSpecular;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tSpecular;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;",
THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( 1.0 );\nvec4 mColor = vec4( uDiffuseColor, uOpacity );\nvec4 mSpecular = vec4( uSpecularColor, uOpacity );\nvec3 specularTex = vec3( 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ngl_FragColor = gl_FragColor * texture2D( tDiffuse, vUv );\nif( enableAO )\ngl_FragColor = gl_FragColor * texture2D( tAO, vUv );\nif( enableSpecular )\nspecularTex = texture2D( tSpecular, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointTotal = vec4( vec3( 0.0 ), 1.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nvec3 pointHalfVector = normalize( vPointLight[ i ].xyz + viewPosition );\nfloat pointDistance = vPointLight[ i ].w;\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = specularTex.r * pow( pointDotNormalHalf, uShininess );\npointTotal  += pointDistance * vec4( pointLightColor[ i ], 1.0 ) * ( mColor * pointDiffuseWeight + mSpecular * pointSpecularWeight * pointDiffuseWeight );\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirTotal = vec4( vec3( 0.0 ), 1.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + viewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = specularTex.r * pow( dirDotNormalHalf, uShininess );\ndirTotal  += vec4( directionalLightColor[ i ], 1.0 ) * ( mColor * dirDiffuseWeight + mSpecular * dirSpecularWeight * dirDiffuseWeight );\n}\n#endif\nvec4 totalLight = vec4( ambientLightColor * uAmbientColor, uOpacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirTotal;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointTotal;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:"attribute vec4 tangent;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nvPointLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"},convolution:{uniforms:{tDiffuse:{type:"t",
value:0,texture:null},uImageIncrement:{type:"v2",value:new THREE.Vector2(0.001953125,0)},cKernel:{type:"fv1",value:[]}},vertexShader:"varying vec2 vUv;\nuniform vec2 uImageIncrement;\nvoid main(void) {\nvUv = uv - ((KERNEL_SIZE - 1.0) / 2.0) * uImageIncrement;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform vec2 uImageIncrement;\nuniform float cKernel[KERNEL_SIZE];\nvoid main(void) {\nvec2 imageCoord = vUv;\nvec4 sum = vec4( 0.0, 0.0, 0.0, 0.0 );\nfor( int i=0; i<KERNEL_SIZE; ++i ) {\nsum += texture2D( tDiffuse, imageCoord ) * cKernel[i];\nimageCoord += uImageIncrement;\n}\ngl_FragColor = sum;\n}"},
film:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},time:{type:"f",value:0},nIntensity:{type:"f",value:0.5},sIntensity:{type:"f",value:0.05},sCount:{type:"f",value:4096},grayscale:{type:"i",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float time;\nuniform bool grayscale;\nuniform float nIntensity;\nuniform float sIntensity;\nuniform float sCount;\nvoid main() {\nvec4 cTextureScreen = texture2D( tDiffuse, vUv );\nfloat x = vUv.x * vUv.y * time *  1000.0;\nx = mod( x, 13.0 ) * mod( x, 123.0 );\nfloat dx = mod( x, 0.01 );\nvec3 cResult = cTextureScreen.rgb + cTextureScreen.rgb * clamp( 0.1 + dx * 100.0, 0.0, 1.0 );\nvec2 sc = vec2( sin( vUv.y * sCount ), cos( vUv.y * sCount ) );\ncResult += cTextureScreen.rgb * vec3( sc.x, sc.y, sc.x ) * sIntensity;\ncResult = cTextureScreen.rgb + clamp( nIntensity, 0.0,1.0 ) * ( cResult - cTextureScreen.rgb );\nif( grayscale ) {\ncResult = vec3( cResult.r * 0.3 + cResult.g * 0.59 + cResult.b * 0.11 );\n}\ngl_FragColor =  vec4( cResult, cTextureScreen.a );\n}"},
screen:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},opacity:{type:"f",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float opacity;\nvoid main() {\nvec4 texel = texture2D( tDiffuse, vUv );\ngl_FragColor = opacity * texel;\n}"},basic:{uniforms:{},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0, 0.0, 0.0, 0.5 );\n}"}},buildKernel:function(a){var b,c,e,f,h=2*Math.ceil(a*3)+1;h>25&&(h=25);f=(h-1)*0.5;c=Array(h);for(b=e=0;b<h;++b)c[b]=Math.exp(-((b-f)*(b-f))/(2*a*a)),e+=c[b];for(b=0;b<h;++b)c[b]/=e;return c}};
THREE.AnimationHandler=function(){var a=[],b={},c={update:function(c){for(var b=0;b<a.length;b++)a[b].update(c)},addToUpdate:function(c){a.indexOf(c)===-1&&a.push(c)},removeFromUpdate:function(c){c=a.indexOf(c);c!==-1&&a.splice(c,1)},add:function(a){b[a.name]!==void 0&&console.log("THREE.AnimationHandler.add: Warning! "+a.name+" already exists in library. Overwriting.");b[a.name]=a;if(a.initialized!==!0){for(var c=0;c<a.hierarchy.length;c++){for(var e=0;e<a.hierarchy[c].keys.length;e++){if(a.hierarchy[c].keys[e].time<
0)a.hierarchy[c].keys[e].time=0;if(a.hierarchy[c].keys[e].rot!==void 0&&!(a.hierarchy[c].keys[e].rot instanceof THREE.Quaternion)){var j=a.hierarchy[c].keys[e].rot;a.hierarchy[c].keys[e].rot=new THREE.Quaternion(j[0],j[1],j[2],j[3])}}if(a.hierarchy[c].keys[0].morphTargets!==void 0){j={};for(e=0;e<a.hierarchy[c].keys.length;e++)for(var k=0;k<a.hierarchy[c].keys[e].morphTargets.length;k++){var l=a.hierarchy[c].keys[e].morphTargets[k];j[l]=-1}a.hierarchy[c].usedMorphTargets=j;for(e=0;e<a.hierarchy[c].keys.length;e++){var m=
{};for(l in j){for(k=0;k<a.hierarchy[c].keys[e].morphTargets.length;k++)if(a.hierarchy[c].keys[e].morphTargets[k]===l){m[l]=a.hierarchy[c].keys[e].morphTargetsInfluences[k];break}k===a.hierarchy[c].keys[e].morphTargets.length&&(m[l]=0)}a.hierarchy[c].keys[e].morphTargetsInfluences=m}}for(e=1;e<a.hierarchy[c].keys.length;e++)a.hierarchy[c].keys[e].time===a.hierarchy[c].keys[e-1].time&&(a.hierarchy[c].keys.splice(e,1),e--);for(e=1;e<a.hierarchy[c].keys.length;e++)a.hierarchy[c].keys[e].index=e}e=parseInt(a.length*
a.fps,10);a.JIT={};a.JIT.hierarchy=[];for(c=0;c<a.hierarchy.length;c++)a.JIT.hierarchy.push(Array(e));a.initialized=!0}},get:function(a){if(typeof a==="string")return b[a]?b[a]:(console.log("THREE.AnimationHandler.get: Couldn't find animation "+a),null)},parse:function(a){var c=[];if(a instanceof THREE.SkinnedMesh)for(var b=0;b<a.bones.length;b++)c.push(a.bones[b]);else e(a,c);return c}},e=function(a,c){c.push(a);for(var b=0;b<a.children.length;b++)e(a.children[b],c)};c.LINEAR=0;c.CATMULLROM=1;c.CATMULLROM_FORWARD=
2;return c}();THREE.Animation=function(a,b,c,e){this.root=a;this.data=THREE.AnimationHandler.get(b);this.hierarchy=THREE.AnimationHandler.parse(a);this.currentTime=0;this.timeScale=1;this.isPlaying=!1;this.loop=this.isPaused=!0;this.interpolationType=c!==void 0?c:THREE.AnimationHandler.LINEAR;this.JITCompile=e!==void 0?e:!0;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(a,b){if(!this.isPlaying){this.isPlaying=!0;this.loop=a!==void 0?a:!0;this.currentTime=b!==void 0?b:0;var c,e=this.hierarchy.length,f;for(c=0;c<e;c++){f=this.hierarchy[c];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)f.useQuaternion=!0;f.matrixAutoUpdate=!0;if(f.animationCache===void 0)f.animationCache={},f.animationCache.prevKey={pos:0,rot:0,scl:0},f.animationCache.nextKey={pos:0,rot:0,scl:0},f.animationCache.originalMatrix=f instanceof
THREE.Bone?f.skinMatrix:f.matrix;var h=f.animationCache.prevKey;f=f.animationCache.nextKey;h.pos=this.data.hierarchy[c].keys[0];h.rot=this.data.hierarchy[c].keys[0];h.scl=this.data.hierarchy[c].keys[0];f.pos=this.getNextKeyWith("pos",c,1);f.rot=this.getNextKeyWith("rot",c,1);f.scl=this.getNextKeyWith("scl",c,1)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPaused=this.isPlaying=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var a=0;a<this.hierarchy.length;a++)if(this.hierarchy[a].animationCache!==void 0)this.hierarchy[a]instanceof THREE.Bone?this.hierarchy[a].skinMatrix=this.hierarchy[a].animationCache.originalMatrix:this.hierarchy[a].matrix=this.hierarchy[a].animationCache.originalMatrix,delete this.hierarchy[a].animationCache};
THREE.Animation.prototype.update=function(a){if(this.isPlaying){var b=["pos","rot","scl"],c,e,f,h,g,j,k,l,m=this.data.JIT.hierarchy,n,o;this.currentTime+=a*this.timeScale;o=this.currentTime;n=this.currentTime%=this.data.length;l=parseInt(Math.min(n*this.data.fps,this.data.length*this.data.fps),10);for(var t=0,v=this.hierarchy.length;t<v;t++)if(a=this.hierarchy[t],k=a.animationCache,this.JITCompile&&m[t][l]!==void 0)a instanceof THREE.Bone?(a.skinMatrix=m[t][l],a.matrixAutoUpdate=!1,a.matrixWorldNeedsUpdate=
!1):(a.matrix=m[t][l],a.matrixAutoUpdate=!1,a.matrixWorldNeedsUpdate=!0);else{if(this.JITCompile)a instanceof THREE.Bone?a.skinMatrix=a.animationCache.originalMatrix:a.matrix=a.animationCache.originalMatrix;for(var u=0;u<3;u++){c=b[u];g=k.prevKey[c];j=k.nextKey[c];if(j.time<=o){if(n<o)if(this.loop){g=this.data.hierarchy[t].keys[0];for(j=this.getNextKeyWith(c,t,1);j.time<n;)g=j,j=this.getNextKeyWith(c,t,j.index+1)}else{this.stop();return}else{do g=j,j=this.getNextKeyWith(c,t,j.index+1);while(j.time<
n)}k.prevKey[c]=g;k.nextKey[c]=j}a.matrixAutoUpdate=!0;a.matrixWorldNeedsUpdate=!0;e=(n-g.time)/(j.time-g.time);f=g[c];h=j[c];if(e<0||e>1)console.log("THREE.Animation.update: Warning! Scale out of bounds:"+e+" on bone "+t),e=e<0?0:1;if(c==="pos")if(c=a.position,this.interpolationType===THREE.AnimationHandler.LINEAR)c.x=f[0]+(h[0]-f[0])*e,c.y=f[1]+(h[1]-f[1])*e,c.z=f[2]+(h[2]-f[2])*e;else{if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)if(this.points[0]=
this.getPrevKeyWith("pos",t,g.index-1).pos,this.points[1]=f,this.points[2]=h,this.points[3]=this.getNextKeyWith("pos",t,j.index+1).pos,e=e*0.33+0.33,f=this.interpolateCatmullRom(this.points,e),c.x=f[0],c.y=f[1],c.z=f[2],this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)e=this.interpolateCatmullRom(this.points,e*1.01),this.target.set(e[0],e[1],e[2]),this.target.subSelf(c),this.target.y=0,this.target.normalize(),e=Math.atan2(this.target.x,this.target.z),a.rotation.set(0,e,0)}else if(c===
"rot")THREE.Quaternion.slerp(f,h,a.quaternion,e);else if(c==="scl")c=a.scale,c.x=f[0]+(h[0]-f[0])*e,c.y=f[1]+(h[1]-f[1])*e,c.z=f[2]+(h[2]-f[2])*e}}if(this.JITCompile&&m[0][l]===void 0){this.hierarchy[0].update(void 0,!0);for(t=0;t<this.hierarchy.length;t++)m[t][l]=this.hierarchy[t]instanceof THREE.Bone?this.hierarchy[t].skinMatrix.clone():this.hierarchy[t].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(a,b){var c=[],e=[],f,h,g,j,k,l;f=(a.length-1)*b;h=Math.floor(f);f-=h;c[0]=h==0?h:h-1;c[1]=h;c[2]=h>a.length-2?h:h+1;c[3]=h>a.length-3?h:h+2;h=a[c[0]];j=a[c[1]];k=a[c[2]];l=a[c[3]];c=f*f;g=f*c;e[0]=this.interpolate(h[0],j[0],k[0],l[0],f,c,g);e[1]=this.interpolate(h[1],j[1],k[1],l[1],f,c,g);e[2]=this.interpolate(h[2],j[2],k[2],l[2],f,c,g);return e};
THREE.Animation.prototype.interpolate=function(a,b,c,e,f,h,g){a=(c-a)*0.5;e=(e-b)*0.5;return(2*(b-c)+a+e)*g+(-3*(b-c)-2*a-e)*h+a*f+b};THREE.Animation.prototype.getNextKeyWith=function(a,b,c){var e=this.data.hierarchy[b].keys;for(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?c=c<e.length-1?c:e.length-1:c%=e.length;c<e.length;c++)if(e[c][a]!==void 0)return e[c];return this.data.hierarchy[b].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(a,b,c){for(var e=this.data.hierarchy[b].keys,c=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?c>0?c:0:c>=0?c:c+e.length;c>=0;c--)if(e[c][a]!==void 0)return e[c];return this.data.hierarchy[b].keys[e.length-1]};
THREE.FirstPersonCamera=function(a){function b(a,b){return function(){b.apply(a,arguments)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.movementSpeed=1;this.lookSpeed=0.005;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.activeLook=!0;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.constrainVertical=!1;this.verticalMin=0;this.verticalMax=3.14;this.domElement=document;this.lastUpdate=(new Date).getTime();this.tdiff=0;if(a){if(a.movementSpeed!==void 0)this.movementSpeed=
a.movementSpeed;if(a.lookSpeed!==void 0)this.lookSpeed=a.lookSpeed;if(a.noFly!==void 0)this.noFly=a.noFly;if(a.lookVertical!==void 0)this.lookVertical=a.lookVertical;if(a.autoForward!==void 0)this.autoForward=a.autoForward;if(a.activeLook!==void 0)this.activeLook=a.activeLook;if(a.heightSpeed!==void 0)this.heightSpeed=a.heightSpeed;if(a.heightCoef!==void 0)this.heightCoef=a.heightCoef;if(a.heightMin!==void 0)this.heightMin=a.heightMin;if(a.heightMax!==void 0)this.heightMax=a.heightMax;if(a.constrainVertical!==
void 0)this.constrainVertical=a.constrainVertical;if(a.verticalMin!==void 0)this.verticalMin=a.verticalMin;if(a.verticalMax!==void 0)this.verticalMax=a.verticalMax;if(a.domElement!==void 0)this.domElement=a.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=this.autoSpeedFactor=0;this.mouseDragOn=this.freeze=this.moveRight=this.moveLeft=this.moveBackward=this.moveForward=!1;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;this.onMouseDown=function(a){a.preventDefault();
a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}this.mouseDragOn=!0};this.onMouseUp=function(a){a.preventDefault();a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.mouseDragOn=!1};this.onMouseMove=function(a){this.mouseX=a.clientX-this.windowHalfX;this.mouseY=a.clientY-this.windowHalfY};this.onKeyDown=function(a){switch(a.keyCode){case 38:case 87:this.moveForward=
!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0;break;case 82:this.moveUp=!0;break;case 70:this.moveDown=!0;break;case 81:this.freeze=!this.freeze}};this.onKeyUp=function(a){switch(a.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=!1;break;case 39:case 68:this.moveRight=!1;break;case 82:this.moveUp=!1;break;case 70:this.moveDown=!1}};this.update=
function(){var a=(new Date).getTime();this.tdiff=(a-this.lastUpdate)/1E3;this.lastUpdate=a;if(!this.freeze){this.autoSpeedFactor=this.heightSpeed?this.tdiff*((this.position.y<this.heightMin?this.heightMin:this.position.y>this.heightMax?this.heightMax:this.position.y)-this.heightMin)*this.heightCoef:0;var b=this.tdiff*this.movementSpeed;(this.moveForward||this.autoForward&&!this.moveBackward)&&this.translateZ(-(b+this.autoSpeedFactor));this.moveBackward&&this.translateZ(b);this.moveLeft&&this.translateX(-b);
this.moveRight&&this.translateX(b);this.moveUp&&this.translateY(b);this.moveDown&&this.translateY(-b);b=this.tdiff*this.lookSpeed;this.activeLook||(b=0);this.lon+=this.mouseX*b;this.lookVertical&&(this.lat-=this.mouseY*b);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;var a=this.target.position,f=this.position;a.x=f.x+100*Math.sin(this.phi)*Math.cos(this.theta);a.y=f.y+100*Math.cos(this.phi);a.z=f.z+100*Math.sin(this.phi)*Math.sin(this.theta)}a=
1;this.constrainVertical&&(a=3.14/(this.verticalMax-this.verticalMin));this.lon+=this.mouseX*b;this.lookVertical&&(this.lat-=this.mouseY*b*a);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;if(this.constrainVertical)this.phi=(this.phi-0)*(this.verticalMax-this.verticalMin)/3.14+this.verticalMin;a=this.target.position;f=this.position;a.x=f.x+100*Math.sin(this.phi)*Math.cos(this.theta);a.y=f.y+100*Math.cos(this.phi);a.z=f.z+100*Math.sin(this.phi)*
Math.sin(this.theta);this.supr.update.call(this)};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",b(this,this.onMouseMove),!1);this.domElement.addEventListener("mousedown",b(this,this.onMouseDown),!1);this.domElement.addEventListener("mouseup",b(this,this.onMouseUp),!1);this.domElement.addEventListener("keydown",b(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",b(this,this.onKeyUp),!1)};
THREE.FirstPersonCamera.prototype=new THREE.Camera;THREE.FirstPersonCamera.prototype.constructor=THREE.FirstPersonCamera;THREE.FirstPersonCamera.prototype.supr=THREE.Camera.prototype;THREE.FirstPersonCamera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);if(this.noFly)b.y=0;this.position.addSelf(b.multiplyScalar(a));this.target.position.addSelf(b.multiplyScalar(a))};
THREE.PathCamera=function(a){function b(a,c,b,e){var g={name:b,fps:0.6,length:e,hierarchy:[]},h,f=c.getControlPointsArray(),j=c.getLength(),k=f.length,x=0;h=k-1;c={parent:-1,keys:[]};c.keys[0]={time:0,pos:f[0],rot:[0,0,0,1],scl:[1,1,1]};c.keys[h]={time:e,pos:f[h],rot:[0,0,0,1],scl:[1,1,1]};for(h=1;h<k-1;h++)x=e*j.chunks[h]/j.total,c.keys[h]={time:x,pos:f[h]};g.hierarchy[0]=c;THREE.AnimationHandler.add(g);return new THREE.Animation(a,b,THREE.AnimationHandler.CATMULLROM_FORWARD,!1)}function c(a,c){var b,
e,g=new THREE.Geometry;for(b=0;b<a.points.length*c;b++)e=b/(a.points.length*c),e=a.getPoint(e),g.vertices[b]=new THREE.Vertex(new THREE.Vector3(e.x,e.y,e.z));return g}function e(a,b){var e=c(b,10),g=c(b,10),h=new THREE.LineBasicMaterial({color:16711680,linewidth:3});lineObj=new THREE.Line(e,h);particleObj=new THREE.ParticleSystem(g,new THREE.ParticleBasicMaterial({color:16755200,size:3}));lineObj.scale.set(1,1,1);a.addChild(lineObj);particleObj.scale.set(1,1,1);a.addChild(particleObj);g=new THREE.SphereGeometry(1,
16,8);h=new THREE.MeshBasicMaterial({color:65280});for(i=0;i<b.points.length;i++)e=new THREE.Mesh(g,h),e.position.copy(b.points[i]),e.updateMatrix(),a.addChild(e)}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.id="PathCamera"+THREE.PathCameraIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=!0;this.resamplingCoef=50;this.debugPath=new THREE.Object3D;this.debugDummy=new THREE.Object3D;this.animationParent=new THREE.Object3D;this.lookSpeed=0.005;this.lookHorizontal=
this.lookVertical=!0;this.verticalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.horizontalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.domElement=document;if(a){if(a.duration!==void 0)this.duration=a.duration*1E3;if(a.waypoints!==void 0)this.waypoints=a.waypoints;if(a.useConstantSpeed!==void 0)this.useConstantSpeed=a.useConstantSpeed;if(a.resamplingCoef!==void 0)this.resamplingCoef=a.resamplingCoef;if(a.createDebugPath!==void 0)this.createDebugPath=a.createDebugPath;if(a.createDebugDummy!==
void 0)this.createDebugDummy=a.createDebugDummy;if(a.lookSpeed!==void 0)this.lookSpeed=a.lookSpeed;if(a.lookVertical!==void 0)this.lookVertical=a.lookVertical;if(a.lookHorizontal!==void 0)this.lookHorizontal=a.lookHorizontal;if(a.verticalAngleMap!==void 0)this.verticalAngleMap=a.verticalAngleMap;if(a.horizontalAngleMap!==void 0)this.horizontalAngleMap=a.horizontalAngleMap;if(a.domElement!==void 0)this.domElement=a.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=0;this.windowHalfX=
window.innerWidth/2;this.windowHalfY=window.innerHeight/2;var f=Math.PI*2,h=Math.PI/180;this.update=function(a,c,b){var e,g;this.lookHorizontal&&(this.lon+=this.mouseX*this.lookSpeed);this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed);this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*h;this.theta=this.lon*h;e=this.phi%f;this.phi=e>=0?e:e+f;e=this.verticalAngleMap.srcRange;g=this.verticalAngleMap.dstRange;var j=g[1]-g[0];this.phi=
TWEEN.Easing.Quadratic.EaseInOut(((this.phi-e[0])*(g[1]-g[0])/(e[1]-e[0])+g[0]-g[0])/j)*j+g[0];e=this.horizontalAngleMap.srcRange;g=this.horizontalAngleMap.dstRange;j=g[1]-g[0];this.theta=TWEEN.Easing.Quadratic.EaseInOut(((this.theta-e[0])*(g[1]-g[0])/(e[1]-e[0])+g[0]-g[0])/j)*j+g[0];e=this.target.position;e.x=100*Math.sin(this.phi)*Math.cos(this.theta);e.y=100*Math.cos(this.phi);e.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this,a,c,b)};this.onMouseMove=function(a){this.mouseX=
a.clientX-this.windowHalfX;this.mouseY=a.clientY-this.windowHalfY};this.spline=new THREE.Spline;this.spline.initFromArray(this.waypoints);this.useConstantSpeed&&this.spline.reparametrizeByArcLength(this.resamplingCoef);if(this.createDebugDummy){var a=new THREE.MeshLambertMaterial({color:30719}),g=new THREE.MeshLambertMaterial({color:65280}),j=new THREE.CubeGeometry(10,10,20),k=new THREE.CubeGeometry(2,2,10);this.animationParent=new THREE.Mesh(j,a);a=new THREE.Mesh(k,g);a.position.set(0,10,0);this.animation=
b(this.animationParent,this.spline,this.id,this.duration);this.animationParent.addChild(this);this.animationParent.addChild(this.target);this.animationParent.addChild(a)}else this.animation=b(this.animationParent,this.spline,this.id,this.duration),this.animationParent.addChild(this.target),this.animationParent.addChild(this);this.createDebugPath&&e(this.debugPath,this.spline);this.domElement.addEventListener("mousemove",function(a,c){return function(){c.apply(a,arguments)}}(this,this.onMouseMove),
!1)};THREE.PathCamera.prototype=new THREE.Camera;THREE.PathCamera.prototype.constructor=THREE.PathCamera;THREE.PathCamera.prototype.supr=THREE.Camera.prototype;THREE.PathCameraIdCounter=0;
THREE.FlyCamera=function(a){function b(a,b){return function(){b.apply(a,arguments)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.tmpQuaternion=new THREE.Quaternion;this.movementSpeed=1;this.rollSpeed=0.005;this.autoForward=this.dragToLook=!1;this.domElement=document;if(a){if(a.movementSpeed!==void 0)this.movementSpeed=a.movementSpeed;if(a.rollSpeed!==void 0)this.rollSpeed=a.rollSpeed;if(a.dragToLook!==void 0)this.dragToLook=a.dragToLook;if(a.autoForward!==void 0)this.autoForward=
a.autoForward;if(a.domElement!==void 0)this.domElement=a.domElement}this.useTarget=!1;this.useQuaternion=!0;this.mouseStatus=0;this.moveState={up:0,down:0,left:0,right:0,forward:0,back:0,pitchUp:0,pitchDown:0,yawLeft:0,yawRight:0,rollLeft:0,rollRight:0};this.moveVector=new THREE.Vector3(0,0,0);this.rotationVector=new THREE.Vector3(0,0,0);this.lastUpdate=-1;this.tdiff=0;this.handleEvent=function(a){if(typeof this[a.type]=="function")this[a.type](a)};this.keydown=function(a){if(!a.altKey){switch(a.keyCode){case 16:this.movementSpeedMultiplier=
0.1;break;case 87:this.moveState.forward=1;break;case 83:this.moveState.back=1;break;case 65:this.moveState.left=1;break;case 68:this.moveState.right=1;break;case 82:this.moveState.up=1;break;case 70:this.moveState.down=1;break;case 38:this.moveState.pitchUp=1;break;case 40:this.moveState.pitchDown=1;break;case 37:this.moveState.yawLeft=1;break;case 39:this.moveState.yawRight=1;break;case 81:this.moveState.rollLeft=1;break;case 69:this.moveState.rollRight=1}this.updateMovementVector();this.updateRotationVector()}};
this.keyup=function(a){switch(a.keyCode){case 16:this.movementSpeedMultiplier=1;break;case 87:this.moveState.forward=0;break;case 83:this.moveState.back=0;break;case 65:this.moveState.left=0;break;case 68:this.moveState.right=0;break;case 82:this.moveState.up=0;break;case 70:this.moveState.down=0;break;case 38:this.moveState.pitchUp=0;break;case 40:this.moveState.pitchDown=0;break;case 37:this.moveState.yawLeft=0;break;case 39:this.moveState.yawRight=0;break;case 81:this.moveState.rollLeft=0;break;
case 69:this.moveState.rollRight=0}this.updateMovementVector();this.updateRotationVector()};this.mousedown=function(a){a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus++;else switch(a.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}};this.mousemove=function(a){if(!this.dragToLook||this.mouseStatus>0){var b=this.getContainerDimensions(),f=b.size[0]/2,h=b.size[1]/2;this.moveState.yawLeft=-(a.clientX-b.offset[0]-f)/f;this.moveState.pitchDown=(a.clientY-
b.offset[1]-h)/h;this.updateRotationVector()}};this.mouseup=function(a){a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus--,this.moveState.yawLeft=this.moveState.pitchDown=0;else switch(a.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.updateRotationVector()};this.update=function(){var a=(new Date).getTime();if(this.lastUpdate==-1)this.lastUpdate=a;this.tdiff=(a-this.lastUpdate)/1E3;this.lastUpdate=a;var a=this.tdiff*this.movementSpeed,b=this.tdiff*
this.rollSpeed;this.translateX(this.moveVector.x*a);this.translateY(this.moveVector.y*a);this.translateZ(this.moveVector.z*a);this.tmpQuaternion.set(this.rotationVector.x*b,this.rotationVector.y*b,this.rotationVector.z*b,1).normalize();this.quaternion.multiplySelf(this.tmpQuaternion);this.matrix.setPosition(this.position);this.matrix.setRotationFromQuaternion(this.quaternion);this.matrixWorldNeedsUpdate=!0;this.supr.update.call(this)};this.updateMovementVector=function(){var a=this.moveState.forward||
this.autoForward&&!this.moveState.back?1:0;this.moveVector.x=-this.moveState.left+this.moveState.right;this.moveVector.y=-this.moveState.down+this.moveState.up;this.moveVector.z=-a+this.moveState.back};this.updateRotationVector=function(){this.rotationVector.x=-this.moveState.pitchDown+this.moveState.pitchUp;this.rotationVector.y=-this.moveState.yawRight+this.moveState.yawLeft;this.rotationVector.z=-this.moveState.rollRight+this.moveState.rollLeft};this.getContainerDimensions=function(){return this.domElement!=
document?{size:[this.domElement.offsetWidth,this.domElement.offsetHeight],offset:[this.domElement.offsetLeft,this.domElement.offsetTop]}:{size:[window.innerWidth,window.innerHeight],offset:[0,0]}};this.domElement.addEventListener("mousemove",b(this,this.mousemove),!1);this.domElement.addEventListener("mousedown",b(this,this.mousedown),!1);this.domElement.addEventListener("mouseup",b(this,this.mouseup),!1);window.addEventListener("keydown",b(this,this.keydown),!1);window.addEventListener("keyup",b(this,
this.keyup),!1);this.updateMovementVector();this.updateRotationVector()};THREE.FlyCamera.prototype=new THREE.Camera;THREE.FlyCamera.prototype.constructor=THREE.FlyCamera;THREE.FlyCamera.prototype.supr=THREE.Camera.prototype;
THREE.RollCamera=function(a,b,c,e){THREE.Camera.call(this,a,b,c,e);this.mouseLook=!0;this.autoForward=!1;this.rollSpeed=this.movementSpeed=this.lookSpeed=1;this.constrainVertical=[-0.9,0.9];this.domElement=document;this.matrixAutoUpdate=this.useTarget=!1;this.forward=new THREE.Vector3(0,0,1);this.roll=0;this.lastUpdate=-1;this.delta=0;var f=new THREE.Vector3,h=new THREE.Vector3,g=new THREE.Vector3,j=new THREE.Matrix4,k=!1,l=1,m=0,n=0,o=0,t=0,v=0,u=window.innerWidth/2,w=window.innerHeight/2;this.update=
function(){var a=(new Date).getTime();if(this.lastUpdate==-1)this.lastUpdate=a;this.delta=(a-this.lastUpdate)/1E3;this.lastUpdate=a;this.mouseLook&&(a=this.delta*this.lookSpeed,this.rotateHorizontally(a*t),this.rotateVertically(a*v));a=this.delta*this.movementSpeed;this.translateZ(a*(m>0||this.autoForward&&!(m<0)?1:m));this.translateX(a*n);this.translateY(a*o);k&&(this.roll+=this.rollSpeed*this.delta*l);if(this.forward.y>this.constrainVertical[1])this.forward.y=this.constrainVertical[1],this.forward.normalize();
else if(this.forward.y<this.constrainVertical[0])this.forward.y=this.constrainVertical[0],this.forward.normalize();g.copy(this.forward);h.set(0,1,0);f.cross(h,g).normalize();h.cross(g,f).normalize();this.matrix.n11=f.x;this.matrix.n12=h.x;this.matrix.n13=g.x;this.matrix.n21=f.y;this.matrix.n22=h.y;this.matrix.n23=g.y;this.matrix.n31=f.z;this.matrix.n32=h.z;this.matrix.n33=g.z;j.identity();j.n11=Math.cos(this.roll);j.n12=-Math.sin(this.roll);j.n21=Math.sin(this.roll);j.n22=Math.cos(this.roll);this.matrix.multiplySelf(j);
this.matrixWorldNeedsUpdate=!0;this.matrix.n14=this.position.x;this.matrix.n24=this.position.y;this.matrix.n34=this.position.z;this.supr.update.call(this)};this.translateX=function(a){this.position.x+=this.matrix.n11*a;this.position.y+=this.matrix.n21*a;this.position.z+=this.matrix.n31*a};this.translateY=function(a){this.position.x+=this.matrix.n12*a;this.position.y+=this.matrix.n22*a;this.position.z+=this.matrix.n32*a};this.translateZ=function(a){this.position.x-=this.matrix.n13*a;this.position.y-=
this.matrix.n23*a;this.position.z-=this.matrix.n33*a};this.rotateHorizontally=function(a){f.set(this.matrix.n11,this.matrix.n21,this.matrix.n31);f.multiplyScalar(a);this.forward.subSelf(f);this.forward.normalize()};this.rotateVertically=function(a){h.set(this.matrix.n12,this.matrix.n22,this.matrix.n32);h.multiplyScalar(a);this.forward.addSelf(h);this.forward.normalize()};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",
function(a){t=(a.clientX-u)/window.innerWidth;v=(a.clientY-w)/window.innerHeight},!1);this.domElement.addEventListener("mousedown",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:m=1;break;case 2:m=-1}},!1);this.domElement.addEventListener("mouseup",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:m=0;break;case 2:m=0}},!1);this.domElement.addEventListener("keydown",function(a){switch(a.keyCode){case 38:case 87:m=1;break;case 37:case 65:n=-1;break;
case 40:case 83:m=-1;break;case 39:case 68:n=1;break;case 81:k=!0;l=1;break;case 69:k=!0;l=-1;break;case 82:o=1;break;case 70:o=-1}},!1);this.domElement.addEventListener("keyup",function(a){switch(a.keyCode){case 38:case 87:m=0;break;case 37:case 65:n=0;break;case 40:case 83:m=0;break;case 39:case 68:n=0;break;case 81:k=!1;break;case 69:k=!1;break;case 82:o=0;break;case 70:o=0}},!1)};THREE.RollCamera.prototype=new THREE.Camera;THREE.RollCamera.prototype.constructor=THREE.RollCamera;
THREE.RollCamera.prototype.supr=THREE.Camera.prototype;
THREE.TrackballCamera=function(a){function b(a,b){return function(){b.apply(a,arguments)}}a=a||{};THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.domElement=a.domElement||document;this.screen=a.screen||{width:window.innerWidth,height:window.innerHeight,offsetLeft:0,offsetTop:0};this.radius=a.radius||(this.screen.width+this.screen.height)/4;this.rotateSpeed=a.rotateSpeed||1;this.zoomSpeed=a.zoomSpeed||1.2;this.panSpeed=a.panSpeed||0.3;this.noZoom=a.noZoom||!1;this.noPan=a.noPan||
!1;this.staticMoving=a.staticMoving||!1;this.dynamicDampingFactor=a.dynamicDampingFactor||0.2;this.minDistance=a.minDistance||0;this.maxDistance=a.maxDistance||Infinity;this.keys=a.keys||[65,83,68];this.useTarget=!0;var c=!1,e=this.STATE.NONE,f=new THREE.Vector3,h=new THREE.Vector3,g=new THREE.Vector3,j=new THREE.Vector2,k=new THREE.Vector2,l=new THREE.Vector2,m=new THREE.Vector2;this.handleEvent=function(a){if(typeof this[a.type]=="function")this[a.type](a)};this.getMouseOnScreen=function(a,b){return new THREE.Vector2((a-
this.screen.offsetLeft)/this.radius*0.5,(b-this.screen.offsetTop)/this.radius*0.5)};this.getMouseProjectionOnBall=function(a,b){var c=new THREE.Vector3((a-this.screen.width*0.5-this.screen.offsetLeft)/this.radius,(this.screen.height*0.5+this.screen.offsetTop-b)/this.radius,0),e=c.length();e>1?c.normalize():c.z=Math.sqrt(1-e*e);f=this.position.clone().subSelf(this.target.position);e=this.up.clone().setLength(c.y);e.addSelf(this.up.clone().crossSelf(f).setLength(c.x));e.addSelf(f.setLength(c.z));return e};
this.rotateCamera=function(){var a=Math.acos(h.dot(g)/h.length()/g.length());if(a){var b=(new THREE.Vector3).cross(h,g).normalize(),c=new THREE.Quaternion;a*=this.rotateSpeed;c.setFromAxisAngle(b,-a);c.multiplyVector3(f);c.multiplyVector3(this.up);c.multiplyVector3(g);this.staticMoving?h=g:(c.setFromAxisAngle(b,a*(this.dynamicDampingFactor-1)),c.multiplyVector3(h))}};this.zoomCamera=function(){var a=1+(k.y-j.y)*this.zoomSpeed;a!==1&&a>0&&(f.multiplyScalar(a),this.staticMoving?j=k:j.y+=(k.y-j.y)*this.dynamicDampingFactor)};
this.panCamera=function(){var a=m.clone().subSelf(l);if(a.lengthSq()){a.multiplyScalar(f.length()*this.panSpeed);var b=f.clone().crossSelf(this.up).setLength(a.x);b.addSelf(this.up.clone().setLength(a.y));this.position.addSelf(b);this.target.position.addSelf(b);this.staticMoving?l=m:l.addSelf(a.sub(m,l).multiplyScalar(this.dynamicDampingFactor))}};this.checkDistances=function(){if(!this.noZoom||!this.noPan)this.position.lengthSq()>this.maxDistance*this.maxDistance&&this.position.setLength(this.maxDistance),
f.lengthSq()<this.minDistance*this.minDistance&&this.position.add(this.target.position,f.setLength(this.minDistance))};this.update=function(a,b,c){f=this.position.clone().subSelf(this.target.position);this.rotateCamera();this.noZoom||this.zoomCamera();this.noPan||this.panCamera();this.position.add(this.target.position,f);this.checkDistances();this.supr.update.call(this,a,b,c)};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",
b(this,function(a){c&&(h=g=this.getMouseProjectionOnBall(a.clientX,a.clientY),j=k=this.getMouseOnScreen(a.clientX,a.clientY),l=m=this.getMouseOnScreen(a.clientX,a.clientY),c=!1);e!==this.STATE.NONE&&(e===this.STATE.ROTATE?g=this.getMouseProjectionOnBall(a.clientX,a.clientY):e===this.STATE.ZOOM&&!this.noZoom?k=this.getMouseOnScreen(a.clientX,a.clientY):e===this.STATE.PAN&&!this.noPan&&(m=this.getMouseOnScreen(a.clientX,a.clientY)))}),!1);this.domElement.addEventListener("mousedown",b(this,function(a){a.preventDefault();
a.stopPropagation();if(e===this.STATE.NONE)e=a.button,e===this.STATE.ROTATE?h=g=this.getMouseProjectionOnBall(a.clientX,a.clientY):e===this.STATE.ZOOM&&!this.noZoom?j=k=this.getMouseOnScreen(a.clientX,a.clientY):this.noPan||(l=m=this.getMouseOnScreen(a.clientX,a.clientY))}),!1);this.domElement.addEventListener("mouseup",b(this,function(a){a.preventDefault();a.stopPropagation();e=this.STATE.NONE}),!1);window.addEventListener("keydown",b(this,function(a){if(e===this.STATE.NONE){if(a.keyCode===this.keys[this.STATE.ROTATE])e=
this.STATE.ROTATE;else if(a.keyCode===this.keys[this.STATE.ZOOM]&&!this.noZoom)e=this.STATE.ZOOM;else if(a.keyCode===this.keys[this.STATE.PAN]&&!this.noPan)e=this.STATE.PAN;e!==this.STATE.NONE&&(c=!0)}}),!1);window.addEventListener("keyup",b(this,function(){if(e!==this.STATE.NONE)e=this.STATE.NONE}),!1)};THREE.TrackballCamera.prototype=new THREE.Camera;THREE.TrackballCamera.prototype.constructor=THREE.TrackballCamera;THREE.TrackballCamera.prototype.supr=THREE.Camera.prototype;
THREE.TrackballCamera.prototype.STATE={NONE:-1,ROTATE:0,ZOOM:1,PAN:2};THREE.QuakeCamera=THREE.FirstPersonCamera;THREE.Curve=function(){};THREE.Curve.prototype.getPoint=function(){console.log("Warning, getPoint() not implemented!");return null};THREE.Curve.prototype.getPointAt=function(a){return this.getPoint(this.getUtoTmapping(a))};THREE.Curve.prototype.getPoints=function(a){a||(a=5);var b,c=[];for(b=0;b<=a;b++)c.push(this.getPoint(b/a));return c};
THREE.Curve.prototype.getSpacedPoints=function(a){a||(a=5);var b,c=[];for(b=0;b<=a;b++)c.push(this.getPointAt(b/a));return c};THREE.Curve.prototype.getLength=function(){var a=this.getLengths();return a[a.length-1]};
THREE.Curve.prototype.getLengths=function(a){a||(a=200);if(this.cacheArcLengths&&this.cacheArcLengths.length==a+1)return this.cacheArcLengths;var b=[],c,e=this.getPoint(0),f,h=0;b.push(0);for(f=1;f<=a;f++)c=this.getPoint(f/a),h+=c.distanceTo(e),b.push(h),e=c;return this.cacheArcLengths=b};
THREE.Curve.prototype.getUtoTmapping=function(a,b){var c=this.getLengths(),e=0,f=c.length,h;h=b?b:a*c[f-1];time=Date.now();for(var g=0,j=f-1,k;g<=j;)if(e=Math.floor(g+(j-g)/2),k=c[e]-h,k<0)g=e+1;else if(k>0)j=e-1;else{j=e;break}e=j;if(c[e]==h)return e/(f-1);g=c[e];return c=(e+(h-g)/(c[e+1]-g))/(f-1)};THREE.Curve.prototype.getNormalVector=function(a){a=this.getTangent(a);return new THREE.Vector2(-a.y,a.x)};
THREE.Curve.prototype.getTangent=function(a){var b=a-1.0E-4;a+=1.0E-4;b<0&&(b=0);a>1&&(a=1);var b=this.getPoint(b),a=this.getPoint(a),c=new THREE.Vector2;c.sub(a,b);return c.unit()};THREE.LineCurve=function(a,b){a instanceof THREE.Vector2?(this.v1=a,this.v2=b):THREE.LineCurve.oldConstructor.apply(this,arguments)};THREE.LineCurve.oldConstructor=function(a,b,c,e){this.constructor(new THREE.Vector2(a,b),new THREE.Vector2(c,e))};THREE.LineCurve.prototype=new THREE.Curve;
THREE.LineCurve.prototype.constructor=THREE.LineCurve;THREE.LineCurve.prototype.getPoint=function(a){var b=new THREE.Vector2;b.sub(this.v2,this.v1);b.multiplyScalar(a).addSelf(this.v1);return b};THREE.LineCurve.prototype.getPointAt=function(a){return this.getPoint(a)};THREE.LineCurve.prototype.getTangent=function(){var a=new THREE.Vector2;a.sub(this.v2,this.v1);a.normalize();return a};
THREE.QuadraticBezierCurve=function(a,b,c){if(!(b instanceof THREE.Vector2))var e=Array.prototype.slice.call(arguments),a=new THREE.Vector2(e[0],e[1]),b=new THREE.Vector2(e[2],e[3]),c=new THREE.Vector2(e[4],e[5]);this.v0=a;this.v1=b;this.v2=c};THREE.QuadraticBezierCurve.prototype=new THREE.Curve;THREE.QuadraticBezierCurve.prototype.constructor=THREE.QuadraticBezierCurve;
THREE.QuadraticBezierCurve.prototype.getPoint=function(a){var b;b=THREE.Shape.Utils.b2(a,this.v0.x,this.v1.x,this.v2.x);a=THREE.Shape.Utils.b2(a,this.v0.y,this.v1.y,this.v2.y);return new THREE.Vector2(b,a)};THREE.QuadraticBezierCurve.prototype.getTangent=function(a){var b;b=THREE.Curve.Utils.tangentQuadraticBezier(a,this.v0.x,this.v1.x,this.v2.x);a=THREE.Curve.Utils.tangentQuadraticBezier(a,this.v0.y,this.v1.y,this.v2.y);b=new THREE.Vector2(b,a);b.normalize();return b};
THREE.CubicBezierCurve=function(a,b,c,e){if(!(b instanceof THREE.Vector2))var f=Array.prototype.slice.call(arguments),a=new THREE.Vector2(f[0],f[1]),b=new THREE.Vector2(f[2],f[3]),c=new THREE.Vector2(f[4],f[5]),e=new THREE.Vector2(f[6],f[7]);this.v0=a;this.v1=b;this.v2=c;this.v3=e};THREE.CubicBezierCurve.prototype=new THREE.Curve;THREE.CubicBezierCurve.prototype.constructor=THREE.CubicBezierCurve;
THREE.CubicBezierCurve.prototype.getPoint=function(a){var b;b=THREE.Shape.Utils.b3(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x);a=THREE.Shape.Utils.b3(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y);return new THREE.Vector2(b,a)};THREE.CubicBezierCurve.prototype.getTangent=function(a){var b;b=THREE.Curve.Utils.tangentCubicBezier(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x);a=THREE.Curve.Utils.tangentCubicBezier(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y);b=new THREE.Vector2(b,a);b.normalize();return b};
THREE.SplineCurve=function(a){this.points=a};THREE.SplineCurve.prototype=new THREE.Curve;THREE.SplineCurve.prototype.constructor=THREE.SplineCurve;
THREE.SplineCurve.prototype.getPoint=function(a){var b=new THREE.Vector2,c=[],e=this.points,f;f=(e.length-1)*a;a=Math.floor(f);f-=a;c[0]=a==0?a:a-1;c[1]=a;c[2]=a>e.length-2?a:a+1;c[3]=a>e.length-3?a:a+2;b.x=THREE.Curve.Utils.interpolate(e[c[0]].x,e[c[1]].x,e[c[2]].x,e[c[3]].x,f);b.y=THREE.Curve.Utils.interpolate(e[c[0]].y,e[c[1]].y,e[c[2]].y,e[c[3]].y,f);return b};THREE.ArcCurve=function(a,b,c,e,f,h){this.aX=a;this.aY=b;this.aRadius=c;this.aStartAngle=e;this.aEndAngle=f;this.aClockwise=h};
THREE.ArcCurve.prototype=new THREE.Curve;THREE.ArcCurve.prototype.constructor=THREE.ArcCurve;THREE.ArcCurve.prototype.getPoint=function(a){var b=this.aEndAngle-this.aStartAngle;this.aClockwise||(a=1-a);a=this.aStartAngle+a*b;return new THREE.Vector2(this.aX+this.aRadius*Math.cos(a),this.aY+this.aRadius*Math.sin(a))};
THREE.Curve.Utils={tangentQuadraticBezier:function(a,b,c,e){return 2*(1-a)*(c-b)+2*a*(e-c)},tangentCubicBezier:function(a,b,c,e,f){return-3*b*(1-a)*(1-a)+3*c*(1-a)*(1-a)-6*a*c*(1-a)+6*a*e*(1-a)-3*a*a*e+3*a*a*f},tangentSpline:function(a){return 6*a*a-6*a+(3*a*a-4*a+1)+(-6*a*a+6*a)+(3*a*a-2*a)},interpolate:function(a,b,c,e,f){var a=(c-a)*0.5,e=(e-b)*0.5,h=f*f;return(2*b-2*c+a+e)*f*h+(-3*b+3*c-2*a-e)*h+a*f+b}};
THREE.Curve.create=function(a,b){a.prototype=new THREE.Curve;a.prototype.constructor=a;a.prototype.getPoint=b;return a};THREE.LineCurve3=THREE.Curve.create(function(a,b){this.v1=a;this.v2=b},function(a){var b=new THREE.Vector3;b.sub(v2,v1);b.multiplyScalar(a);b.addSelf(this.v1);return b});
THREE.QuadraticBezierCurve3=THREE.Curve.create(function(a,b,c){this.v0=a;this.v1=b;this.v2=c},function(a){var b,c;b=THREE.Shape.Utils.b2(a,this.v0.x,this.v1.x,this.v2.x);c=THREE.Shape.Utils.b2(a,this.v0.y,this.v1.y,this.v2.y);a=THREE.Shape.Utils.b2(a,this.v0.z,this.v1.z,this.v2.z);return new THREE.Vector3(b,c,a)});THREE.CurvePath=function(){this.curves=[];this.bends=[]};THREE.CurvePath.prototype=new THREE.Curve;THREE.CurvePath.prototype.constructor=THREE.CurvePath;THREE.CurvePath.prototype.add=function(a){this.curves.push(a)};
THREE.CurvePath.prototype.checkConnection=function(){};THREE.CurvePath.prototype.closePath=function(){};THREE.CurvePath.prototype.getPoint=function(a){for(var b=a*this.getLength(),c=this.getCurveLengths(),a=0;a<c.length;){if(c[a]>=b)return b=c[a]-b,a=this.curves[a],b=1-b/a.getLength(),a.getPointAt(b);a++}return null};THREE.CurvePath.prototype.getLength=function(){var a=this.getCurveLengths();return a[a.length-1]};
THREE.CurvePath.prototype.getCurveLengths=function(){if(this.cacheLengths&&this.cacheLengths.length==this.curves.length)return this.cacheLengths;var a=[],b=0,c,e=this.curves.length;for(c=0;c<e;c++)b+=this.curves[c].getLength(),a.push(b);return this.cacheLengths=a};
THREE.CurvePath.prototype.getBoundingBox=function(){var a=this.getPoints(),b,c,e,f;b=c=Number.NEGATIVE_INFINITY;e=f=Number.POSITIVE_INFINITY;var h,g,j,k;k=new THREE.Vector2;g=0;for(j=a.length;g<j;g++){h=a[g];if(h.x>b)b=h.x;else if(h.x<e)e=h.x;if(h.y>c)c=h.y;else if(h.y<c)f=h.y;k.addSelf(h.x,h.y)}return{minX:e,minY:f,maxX:b,maxY:c,centroid:k.divideScalar(j)}};THREE.CurvePath.prototype.createPointsGeometry=function(a){return this.createGeometry(this.getPoints(a,!0))};
THREE.CurvePath.prototype.createSpacedPointsGeometry=function(a){return this.createGeometry(this.getSpacedPoints(a,!0))};THREE.CurvePath.prototype.createGeometry=function(a){for(var b=new THREE.Geometry,c=0;c<a.length;c++)b.vertices.push(new THREE.Vertex(new THREE.Vector3(a[c].x,a[c].y,0)));return b};THREE.CurvePath.prototype.addWrapPath=function(a){this.bends.push(a)};
THREE.CurvePath.prototype.getTransformedPoints=function(a,b){var c=this.getPoints(a),e,f;if(!b)b=this.bends;e=0;for(f=b.length;e<f;e++)c=this.getWrapPoints(c,b[e]);return c};THREE.CurvePath.prototype.getTransformedSpacedPoints=function(a,b){var c=this.getSpacedPoints(a),e,f;if(!b)b=this.bends;e=0;for(f=b.length;e<f;e++)c=this.getWrapPoints(c,b[e]);return c};
THREE.CurvePath.prototype.getWrapPoints=function(a,b){var c=this.getBoundingBox(),e,f,h,g,j,k;e=0;for(f=a.length;e<f;e++)h=a[e],g=h.x,j=h.y,k=g/c.maxX,k=b.getUtoTmapping(k,g),g=b.getPoint(k),j=b.getNormalVector(k).multiplyScalar(j),h.x=g.x+j.x,h.y=g.y+j.y;return a};THREE.Path=function(a){THREE.CurvePath.call(this);this.actions=[];a&&this.fromPoints(a)};THREE.Path.prototype=new THREE.CurvePath;THREE.Path.prototype.constructor=THREE.Path;
THREE.PathActions={MOVE_TO:"moveTo",LINE_TO:"lineTo",QUADRATIC_CURVE_TO:"quadraticCurveTo",BEZIER_CURVE_TO:"bezierCurveTo",CSPLINE_THRU:"splineThru",ARC:"arc"};THREE.Path.prototype.fromPoints=function(a){this.moveTo(a[0].x,a[0].y);var b,c=a.length;for(b=1;b<c;b++)this.lineTo(a[b].x,a[b].y)};THREE.Path.prototype.moveTo=function(){var a=Array.prototype.slice.call(arguments);this.actions.push({action:THREE.PathActions.MOVE_TO,args:a})};
THREE.Path.prototype.lineTo=function(a,b){var c=Array.prototype.slice.call(arguments),e=this.actions[this.actions.length-1].args;this.curves.push(new THREE.LineCurve(new THREE.Vector2(e[e.length-2],e[e.length-1]),new THREE.Vector2(a,b)));this.actions.push({action:THREE.PathActions.LINE_TO,args:c})};
THREE.Path.prototype.quadraticCurveTo=function(a,b,c,e){var f=Array.prototype.slice.call(arguments),h=this.actions[this.actions.length-1].args;this.curves.push(new THREE.QuadraticBezierCurve(new THREE.Vector2(h[h.length-2],h[h.length-1]),new THREE.Vector2(a,b),new THREE.Vector2(c,e)));this.actions.push({action:THREE.PathActions.QUADRATIC_CURVE_TO,args:f})};
THREE.Path.prototype.bezierCurveTo=function(a,b,c,e,f,h){var g=Array.prototype.slice.call(arguments),j=this.actions[this.actions.length-1].args;this.curves.push(new THREE.CubicBezierCurve(new THREE.Vector2(j[j.length-2],j[j.length-1]),new THREE.Vector2(a,b),new THREE.Vector2(c,e),new THREE.Vector2(f,h)));this.actions.push({action:THREE.PathActions.BEZIER_CURVE_TO,args:g})};
THREE.Path.prototype.splineThru=function(a){var b=Array.prototype.slice.call(arguments),c=this.actions[this.actions.length-1].args,c=[new THREE.Vector2(c[c.length-2],c[c.length-1])],c=c.concat(a);this.curves.push(new THREE.SplineCurve(c));this.actions.push({action:THREE.PathActions.CSPLINE_THRU,args:b})};THREE.Path.prototype.arc=function(a,b,c,e,f,h){var g=Array.prototype.slice.call(arguments);this.curves.push(new THREE.ArcCurve(a,b,c,e,f,h));this.actions.push({action:THREE.PathActions.ARC,args:g})};
THREE.Path.prototype.getSpacedPoints=function(a){a||(a=40);for(var b=[],c=0;c<a;c++)b.push(this.getPoint(c/a));return b};
THREE.Path.prototype.getPoints=function(a,b){var a=a||12,c=[],e,f,h,g,j,k,l,m,n,o,t,v,u;e=0;for(f=this.actions.length;e<f;e++)switch(h=this.actions[e],g=h.action,h=h.args,g){case THREE.PathActions.LINE_TO:c.push(new THREE.Vector2(h[0],h[1]));break;case THREE.PathActions.QUADRATIC_CURVE_TO:j=h[2];k=h[3];n=h[0];o=h[1];c.length>0?(g=c[c.length-1],t=g.x,v=g.y):(g=this.actions[e-1].args,t=g[g.length-2],v=g[g.length-1]);for(g=1;g<=a;g++)u=g/a,h=THREE.Shape.Utils.b2(u,t,n,j),u=THREE.Shape.Utils.b2(u,v,o,
k),c.push(new THREE.Vector2(h,u));break;case THREE.PathActions.BEZIER_CURVE_TO:j=h[4];k=h[5];n=h[0];o=h[1];l=h[2];m=h[3];c.length>0?(g=c[c.length-1],t=g.x,v=g.y):(g=this.actions[e-1].args,t=g[g.length-2],v=g[g.length-1]);for(g=1;g<=a;g++)u=g/a,h=THREE.Shape.Utils.b3(u,t,n,l,j),u=THREE.Shape.Utils.b3(u,v,o,m,k),c.push(new THREE.Vector2(h,u));break;case THREE.PathActions.CSPLINE_THRU:g=this.actions[e-1].args;g=[new THREE.Vector2(g[g.length-2],g[g.length-1])];u=a*h[0].length;g=g.concat(h[0]);h=new THREE.SplineCurve(g);
for(g=1;g<=u;g++)c.push(h.getPointAt(g/u));break;case THREE.PathActions.ARC:g=this.actions[e-1].args;j=h[0];k=h[1];l=h[2];n=h[3];u=h[4];o=!!h[5];m=g[g.length-2];t=g[g.length-1];g.length==0&&(m=t=0);v=u-n;var w=a*2;for(g=1;g<=w;g++)u=g/w,o||(u=1-u),u=n+u*v,h=m+j+l*Math.cos(u),u=t+k+l*Math.sin(u),c.push(new THREE.Vector2(h,u))}b&&c.push(c[0]);return c};THREE.Path.prototype.transform=function(a,b){this.getBoundingBox();return this.getWrapPoints(this.getPoints(b),a)};
THREE.Path.prototype.nltransform=function(a,b,c,e,f,h){var g=this.getPoints(),j,k,l,m,n;j=0;for(k=g.length;j<k;j++)l=g[j],m=l.x,n=l.y,l.x=a*m+b*n+c,l.y=e*n+f*m+h;return g};
THREE.Path.prototype.debug=function(a){var b=this.getBoundingBox();a||(a=document.createElement("canvas"),a.setAttribute("width",b.maxX+100),a.setAttribute("height",b.maxY+100),document.body.appendChild(a));b=a.getContext("2d");b.fillStyle="white";b.fillRect(0,0,a.width,a.height);b.strokeStyle="black";b.beginPath();var c,e,f,a=0;for(c=this.actions.length;a<c;a++)e=this.actions[a],f=e.args,e=e.action,e!=THREE.PathActions.CSPLINE_THRU&&b[e].apply(b,f);b.stroke();b.closePath();b.strokeStyle="red";e=
this.getPoints();a=0;for(c=e.length;a<c;a++)f=e[a],b.beginPath(),b.arc(f.x,f.y,1.5,0,Math.PI*2,!1),b.stroke(),b.closePath()};
THREE.Path.prototype.toShapes=function(){var a,b,c,e,f=[],h=new THREE.Path;a=0;for(b=this.actions.length;a<b;a++)c=this.actions[a],e=c.args,c=c.action,c==THREE.PathActions.MOVE_TO&&h.actions.length!=0&&(f.push(h),h=new THREE.Path),h[c].apply(h,e);h.actions.length!=0&&f.push(h);if(f.length==0)return[];var g,h=[];if(THREE.Shape.Utils.isClockWise(f[0].getPoints())){a=0;for(b=f.length;a<b;a++)e=f[a],THREE.Shape.Utils.isClockWise(e.getPoints())?(g&&h.push(g),g=new THREE.Shape,g.actions=e.actions,g.curves=
e.curves):g.holes.push(e);h.push(g)}else{g=new THREE.Shape;a=0;for(b=f.length;a<b;a++)e=f[a],THREE.Shape.Utils.isClockWise(e.getPoints())?(g.actions=e.actions,g.curves=e.curves,h.push(g),g=new THREE.Shape):g.holes.push(e)}return h};THREE.Shape=function(){THREE.Path.apply(this,arguments);this.holes=[]};THREE.Shape.prototype=new THREE.Path;THREE.Shape.prototype.constructor=THREE.Path;THREE.Shape.prototype.extrude=function(a){return new THREE.ExtrudeGeometry(this,a)};
THREE.Shape.prototype.getPointsHoles=function(a){var b,c=this.holes.length,e=[];for(b=0;b<c;b++)e[b]=this.holes[b].getTransformedPoints(a,this.bends);return e};THREE.Shape.prototype.getSpacedPointsHoles=function(a){var b,c=this.holes.length,e=[];for(b=0;b<c;b++)e[b]=this.holes[b].getTransformedSpacedPoints(a,this.bends);return e};THREE.Shape.prototype.extractAllPoints=function(a){return{shape:this.getTransformedPoints(a),holes:this.getPointsHoles(a)}};
THREE.Shape.prototype.extractAllSpacedPoints=function(a){return{shape:this.getTransformedSpacedPoints(a),holes:this.getSpacedPointsHoles(a)}};
THREE.Shape.Utils={removeHoles:function(a,b){var c=a.concat(),e=c.concat(),f,h,g,j,k,l,m,n,o,t,v=[];for(k=0;k<b.length;k++){l=b[k];e=e.concat(l);h=Number.POSITIVE_INFINITY;for(f=0;f<l.length;f++){o=l[f];t=[];for(n=0;n<c.length;n++)m=c[n],m=o.distanceToSquared(m),t.push(m),m<h&&(h=m,g=f,j=n)}f=j-1>=0?j-1:c.length-1;h=g-1>=0?g-1:l.length-1;var u=[l[g],c[j],c[f]];n=THREE.FontUtils.Triangulate.area(u);var w=[l[g],l[h],c[j]];o=THREE.FontUtils.Triangulate.area(w);t=j;m=g;j+=1;g+=-1;j<0&&(j+=c.length);j%=
c.length;g<0&&(g+=l.length);g%=l.length;f=j-1>=0?j-1:c.length-1;h=g-1>=0?g-1:l.length-1;u=[l[g],c[j],c[f]];u=THREE.FontUtils.Triangulate.area(u);w=[l[g],l[h],c[j]];w=THREE.FontUtils.Triangulate.area(w);n+o>u+w&&(j=t,g=m,j<0&&(j+=c.length),j%=c.length,g<0&&(g+=l.length),g%=l.length,f=j-1>=0?j-1:c.length-1,h=g-1>=0?g-1:l.length-1);n=c.slice(0,j);o=c.slice(j);t=l.slice(g);m=l.slice(0,g);h=[l[g],l[h],c[j]];v.push([l[g],c[j],c[f]]);v.push(h);c=n.concat(t).concat(m).concat(o)}return{shape:c,isolatedPts:v,
allpoints:e}},triangulateShape:function(a,b){var c=THREE.Shape.Utils.removeHoles(a,b),e=c.allpoints,f=c.isolatedPts,c=THREE.FontUtils.Triangulate(c.shape,!1),h,g,j,k,l={};h=0;for(g=e.length;h<g;h++)k=e[h].x+":"+e[h].y,l[k]!==void 0&&console.log("Duplicate point",k),l[k]=h;h=0;for(g=c.length;h<g;h++){j=c[h];for(e=0;e<3;e++)k=j[e].x+":"+j[e].y,k=l[k],k!==void 0&&(j[e]=k)}h=0;for(g=f.length;h<g;h++){j=f[h];for(e=0;e<3;e++)k=j[e].x+":"+j[e].y,k=l[k],k!==void 0&&(j[e]=k)}return c.concat(f)},isClockWise:function(a){return THREE.FontUtils.Triangulate.area(a)<
0},b2p0:function(a,b){var c=1-a;return c*c*b},b2p1:function(a,b){return 2*(1-a)*a*b},b2p2:function(a,b){return a*a*b},b2:function(a,b,c,e){return this.b2p0(a,b)+this.b2p1(a,c)+this.b2p2(a,e)},b3p0:function(a,b){var c=1-a;return c*c*c*b},b3p1:function(a,b){var c=1-a;return 3*c*c*a*b},b3p2:function(a,b){return 3*(1-a)*a*a*b},b3p3:function(a,b){return a*a*a*b},b3:function(a,b,c,e,f){return this.b3p0(a,b)+this.b3p1(a,c)+this.b3p2(a,e)+this.b3p3(a,f)}};
THREE.TextPath=function(a,b){THREE.Path.call(this);this.parameters=b||{};this.set(a)};THREE.TextPath.prototype.set=function(a,b){this.text=a;var b=b||this.parameters,c=b.curveSegments!==void 0?b.curveSegments:4,e=b.font!==void 0?b.font:"helvetiker",f=b.weight!==void 0?b.weight:"normal",h=b.style!==void 0?b.style:"normal";THREE.FontUtils.size=b.size!==void 0?b.size:100;THREE.FontUtils.divisions=c;THREE.FontUtils.face=e;THREE.FontUtils.weight=f;THREE.FontUtils.style=h};
THREE.TextPath.prototype.toShapes=function(){for(var a=THREE.FontUtils.drawText(this.text).paths,b=[],c=0,e=a.length;c<e;c++)b=b.concat(a[c].toShapes());return b};
THREE.CubeGeometry=function(a,b,c,e,f,h,g,j,k){function l(a,b,c,g,j,k,l,n){var t,o,v=e||1,u=f||1,E=j/2,F=k/2,L=m.vertices.length;if(a=="x"&&b=="y"||a=="y"&&b=="x")t="z";else if(a=="x"&&b=="z"||a=="z"&&b=="x")t="y",u=h||1;else if(a=="z"&&b=="y"||a=="y"&&b=="z")t="x",v=h||1;var M=v+1,O=u+1;j/=v;var Q=k/u;for(o=0;o<O;o++)for(k=0;k<M;k++){var C=new THREE.Vector3;C[a]=(k*j-E)*c;C[b]=(o*Q-F)*g;C[t]=l;m.vertices.push(new THREE.Vertex(C))}for(o=0;o<u;o++)for(k=0;k<v;k++)m.faces.push(new THREE.Face4(k+M*o+
L,k+M*(o+1)+L,k+1+M*(o+1)+L,k+1+M*o+L,null,null,n)),m.faceVertexUvs[0].push([new THREE.UV(k/v,o/u),new THREE.UV(k/v,(o+1)/u),new THREE.UV((k+1)/v,(o+1)/u),new THREE.UV((k+1)/v,o/u)])}THREE.Geometry.call(this);var m=this,n=a/2,o=b/2,t=c/2,j=j?-1:1;if(g!==void 0)if(g instanceof Array)this.materials=g;else{this.materials=[];for(var v=0;v<6;v++)this.materials.push([g])}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(k!=void 0)for(var u in k)this.sides[u]!=void 0&&(this.sides[u]=
k[u]);this.sides.px&&l("z","y",1*j,-1,c,b,-n,this.materials[0]);this.sides.nx&&l("z","y",-1*j,-1,c,b,n,this.materials[1]);this.sides.py&&l("x","z",1*j,1,a,c,o,this.materials[2]);this.sides.ny&&l("x","z",1*j,-1,a,c,-o,this.materials[3]);this.sides.pz&&l("x","y",1*j,-1,a,b,t,this.materials[4]);this.sides.nz&&l("x","y",-1*j,-1,a,b,-t,this.materials[5]);(function(){for(var a=[],b=[],c=0,e=m.vertices.length;c<e;c++){for(var g=m.vertices[c],h=!1,f=0,j=a.length;f<j;f++){var k=a[f];if(g.position.x==k.position.x&&
g.position.y==k.position.y&&g.position.z==k.position.z){b[c]=f;h=!0;break}}if(!h)b[c]=a.length,a.push(new THREE.Vertex(g.position.clone()))}c=0;for(e=m.faces.length;c<e;c++)g=m.faces[c],g.a=b[g.a],g.b=b[g.b],g.c=b[g.c],g.d=b[g.d];m.vertices=a})();this.computeCentroids();this.computeFaceNormals()};THREE.CubeGeometry.prototype=new THREE.Geometry;THREE.CubeGeometry.prototype.constructor=THREE.CubeGeometry;
THREE.CylinderGeometry=function(a,b,c,e,f,h){function g(a,b,c){j.vertices.push(new THREE.Vertex(new THREE.Vector3(a,b,c)))}THREE.Geometry.call(this);var j=this,k,l=Math.PI*2,m=e/2;for(k=0;k<a;k++)g(Math.sin(l*k/a)*b,Math.cos(l*k/a)*b,-m);for(k=0;k<a;k++)g(Math.sin(l*k/a)*c,Math.cos(l*k/a)*c,m);for(k=0;k<a;k++)j.faces.push(new THREE.Face4(k,k+a,a+(k+1)%a,(k+1)%a));if(c>0){g(0,0,-m-(h||0));for(k=a;k<a+a/2;k++)j.faces.push(new THREE.Face4(2*a,(2*k-2*a)%a,(2*k-2*a+1)%a,(2*k-2*a+2)%a))}if(b>0){g(0,0,m+
(f||0));for(k=a+a/2;k<2*a;k++)j.faces.push(new THREE.Face4(2*a+1,(2*k-2*a+2)%a+a,(2*k-2*a+1)%a+a,(2*k-2*a)%a+a))}k=0;for(a=this.faces.length;k<a;k++){var b=[],c=this.faces[k],f=this.vertices[c.a],h=this.vertices[c.b],m=this.vertices[c.c],n=this.vertices[c.d];b.push(new THREE.UV(0.5+Math.atan2(f.position.x,f.position.y)/l,0.5+f.position.z/e));b.push(new THREE.UV(0.5+Math.atan2(h.position.x,h.position.y)/l,0.5+h.position.z/e));b.push(new THREE.UV(0.5+Math.atan2(m.position.x,m.position.y)/l,0.5+m.position.z/
e));c instanceof THREE.Face4&&b.push(new THREE.UV(0.5+Math.atan2(n.position.x,n.position.y)/l,0.5+n.position.z/e));this.faceVertexUvs[0].push(b)}this.computeCentroids();this.computeFaceNormals()};THREE.CylinderGeometry.prototype=new THREE.Geometry;THREE.CylinderGeometry.prototype.constructor=THREE.CylinderGeometry;THREE.ExtrudeGeometry=function(a,b){if(typeof a!="undefined"){THREE.Geometry.call(this);var a=a instanceof Array?a:[a],c,e=a.length,f;for(c=0;c<e;c++)f=a[c],this.addShape(f,b)}};
THREE.ExtrudeGeometry.prototype=new THREE.Geometry;THREE.ExtrudeGeometry.prototype.constructor=THREE.ExtrudeGeometry;
THREE.ExtrudeGeometry.prototype.addShape=function(a,b){function c(a,b,c){b||console.log("die");return b.clone().multiplyScalar(c).addSelf(a)}function e(a,b,c){var e=THREE.ExtrudeGeometry.__v1,g=THREE.ExtrudeGeometry.__v2,h=THREE.ExtrudeGeometry.__v3,f=THREE.ExtrudeGeometry.__v4,j=THREE.ExtrudeGeometry.__v5,k=THREE.ExtrudeGeometry.__v6;e.set(a.x-b.x,a.y-b.y);g.set(a.x-c.x,a.y-c.y);e=e.normalize();g=g.normalize();h.set(-e.y,e.x);f.set(g.y,-g.x);j.copy(a).addSelf(h);k.copy(a).addSelf(f);if(j.equals(k))return f.clone();
j.copy(b).addSelf(h);k.copy(c).addSelf(f);h=e.dot(f);f=k.subSelf(j).dot(f);h==0&&(console.log("Either infinite or no solutions!"),f==0?console.log("Its finite solutions."):console.log("Too bad, no solutions."));f/=h;if(f<0)return b=Math.atan2(b.y-a.y,b.x-a.x),a=Math.atan2(c.y-a.y,c.x-a.x),b>a&&(a+=Math.PI*2),anglec=(b+a)/2,new THREE.Vector2(-Math.cos(anglec),-Math.sin(anglec));return e.multiplyScalar(f).addSelf(j).subSelf(a).clone()}function f(a){for(A=a.length;--A>=0;){K=A;N=A-1;N<0&&(N=a.length-
1);for(var b=0,b=0;b<t+m*2;b++){var c=L*b,e=L*(b+1),g=R+K+c,c=R+N+c,h=R+N+e,e=R+K+e;g+=H;c+=H;h+=H;e+=H;G.faces.push(new THREE.Face4(g,c,h,e))}}}function h(a,b,c){G.vertices.push(new THREE.Vertex(new THREE.Vector3(a,b,c)))}function g(a,b,c){a+=H;b+=H;c+=H;G.faces.push(new THREE.Face3(a,b,c))}var j=b.amount!==void 0?b.amount:100,k=b.bevelThickness!==void 0?b.bevelThickness:6,l=b.bevelSize!==void 0?b.bevelSize:k-2,m=b.bevelSegments!==void 0?b.bevelSegments:3,n=b.bevelEnabled!==void 0?b.bevelEnabled:
!0,o=b.curveSegments!==void 0?b.curveSegments:12,t=b.steps!==void 0?b.steps:1,v=b.bendPath,u=b.extrudePath,w,y=!1,x=b.useSpacedPoints!==void 0?b.useSpacedPoints:!1;if(u)w=u.getPoints(o),t=w.length,y=!0,n=!1;n||(l=k=m=0);var p,z,B,G=this,H=this.vertices.length;v&&a.addWrapPath(v);o=x?a.extractAllSpacedPoints(o):a.extractAllPoints(o);v=o.shape;o=o.holes;if(u=!THREE.Shape.Utils.isClockWise(v)){v=v.reverse();z=0;for(B=o.length;z<B;z++)p=o[z],THREE.Shape.Utils.isClockWise(p)&&(o[z]=p.reverse());u=!1}u=
THREE.Shape.Utils.triangulateShape(v,o);x=v;z=0;for(B=o.length;z<B;z++)p=o[z],v=v.concat(p);var A,D,J,I,E,F,L=v.length,M=u.length,O=[];A=0;D=x.length;K=D-1;for(N=A+1;A<D;A++,K++,N++)K==D&&(K=0),N==D&&(N=0),O[A]=e(x[A],x[K],x[N]);var Q=[],C,P=O.concat();z=0;for(B=o.length;z<B;z++){p=o[z];C=[];A=0;D=p.length;K=D-1;for(N=A+1;A<D;A++,K++,N++)K==D&&(K=0),N==D&&(N=0),C[A]=e(p[A],p[K],p[N]);Q.push(C);P=P.concat(C)}for(J=0;J<m;J++){I=J/m;E=k*(1-I);I=l*Math.sin(I*Math.PI/2);A=0;for(D=x.length;A<D;A++)F=c(x[A],
O[A],I),h(F.x,F.y,-E);z=0;for(B=o.length;z<B;z++){p=o[z];C=Q[z];A=0;for(D=p.length;A<D;A++)F=c(p[A],C[A],I),h(F.x,F.y,-E)}}I=l;for(A=0;A<L;A++)F=n?c(v[A],P[A],I):v[A],y?h(F.x,F.y+w[0].y,w[0].x):h(F.x,F.y,0);for(J=1;J<=t;J++)for(A=0;A<L;A++)F=n?c(v[A],P[A],I):v[A],y?h(F.x,F.y+w[J-1].y,w[J-1].x):h(F.x,F.y,j/t*J);for(J=m-1;J>=0;J--){I=J/m;E=k*(1-I);I=l*Math.sin(I*Math.PI/2);A=0;for(D=x.length;A<D;A++)F=c(x[A],O[A],I),h(F.x,F.y,j+E);z=0;for(B=o.length;z<B;z++){p=o[z];C=Q[z];A=0;for(D=p.length;A<D;A++)F=
c(p[A],C[A],I),y?h(F.x,F.y+w[t-1].y,w[t-1].x+E):h(F.x,F.y,j+E)}}if(n){k=L*0;for(A=0;A<M;A++)j=u[A],g(j[2]+k,j[1]+k,j[0]+k);k=L*(t+m*2);for(A=0;A<M;A++)j=u[A],g(j[0]+k,j[1]+k,j[2]+k)}else{for(A=0;A<M;A++)j=u[A],g(j[2],j[1],j[0]);for(A=0;A<M;A++)j=u[A],g(j[0]+L*t,j[1]+L*t,j[2]+L*t)}var K,N,R=0;f(x);R+=x.length;z=0;for(B=o.length;z<B;z++)p=o[z],f(p),R+=p.length;this.computeCentroids();this.computeFaceNormals()};THREE.ExtrudeGeometry.__v1=new THREE.Vector2;THREE.ExtrudeGeometry.__v2=new THREE.Vector2;
THREE.ExtrudeGeometry.__v3=new THREE.Vector2;THREE.ExtrudeGeometry.__v4=new THREE.Vector2;THREE.ExtrudeGeometry.__v5=new THREE.Vector2;THREE.ExtrudeGeometry.__v6=new THREE.Vector2;
THREE.IcosahedronGeometry=function(a){function b(a,b,c){var e=Math.sqrt(a*a+b*b+c*c);return f.vertices.push(new THREE.Vertex(new THREE.Vector3(a/e,b/e,c/e)))-1}function c(a,b,c,e){e.faces.push(new THREE.Face3(a,b,c))}function e(a,c){var e=f.vertices[a].position,g=f.vertices[c].position;return b((e.x+g.x)/2,(e.y+g.y)/2,(e.z+g.z)/2)}var f=this,h=new THREE.Geometry;this.subdivisions=a||0;THREE.Geometry.call(this);a=(1+Math.sqrt(5))/2;b(-1,a,0);b(1,a,0);b(-1,-a,0);b(1,-a,0);b(0,-1,a);b(0,1,a);b(0,-1,
-a);b(0,1,-a);b(a,0,-1);b(a,0,1);b(-a,0,-1);b(-a,0,1);c(0,11,5,h);c(0,5,1,h);c(0,1,7,h);c(0,7,10,h);c(0,10,11,h);c(1,5,9,h);c(5,11,4,h);c(11,10,2,h);c(10,7,6,h);c(7,1,8,h);c(3,9,4,h);c(3,4,2,h);c(3,2,6,h);c(3,6,8,h);c(3,8,9,h);c(4,9,5,h);c(2,4,11,h);c(6,2,10,h);c(8,6,7,h);c(9,8,1,h);for(var g=0;g<this.subdivisions;g++){var a=new THREE.Geometry,j;for(j in h.faces){var k=e(h.faces[j].a,h.faces[j].b),l=e(h.faces[j].b,h.faces[j].c),m=e(h.faces[j].c,h.faces[j].a);c(h.faces[j].a,k,m,a);c(h.faces[j].b,l,
k,a);c(h.faces[j].c,m,l,a);c(k,l,m,a)}h.faces=a.faces}f.faces=h.faces;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.IcosahedronGeometry.prototype=new THREE.Geometry;THREE.IcosahedronGeometry.prototype.constructor=THREE.IcosahedronGeometry;
THREE.LatheGeometry=function(a,b,c){THREE.Geometry.call(this);this.steps=b||12;this.angle=c||2*Math.PI;for(var b=this.angle/this.steps,c=[],e=[],f=[],h=[],g=(new THREE.Matrix4).setRotationZ(b),j=0;j<a.length;j++)this.vertices.push(new THREE.Vertex(a[j])),c[j]=a[j].clone(),e[j]=this.vertices.length-1;for(var k=0;k<=this.angle+0.001;k+=b){for(j=0;j<c.length;j++)k<this.angle?(c[j]=g.multiplyVector3(c[j].clone()),this.vertices.push(new THREE.Vertex(c[j])),f[j]=this.vertices.length-1):f=h;k==0&&(h=e);
for(j=0;j<e.length-1;j++)this.faces.push(new THREE.Face4(f[j],f[j+1],e[j+1],e[j])),this.faceVertexUvs[0].push([new THREE.UV(1-k/this.angle,j/a.length),new THREE.UV(1-k/this.angle,(j+1)/a.length),new THREE.UV(1-(k-b)/this.angle,(j+1)/a.length),new THREE.UV(1-(k-b)/this.angle,j/a.length)]);e=f;f=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.LatheGeometry.prototype=new THREE.Geometry;THREE.LatheGeometry.prototype.constructor=THREE.LatheGeometry;
THREE.PlaneGeometry=function(a,b,c,e){THREE.Geometry.call(this);var f,h=a/2,g=b/2,c=c||1,e=e||1,j=c+1,k=e+1;a/=c;var l=b/e;for(f=0;f<k;f++)for(b=0;b<j;b++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(b*a-h,-(f*l-g),0)));for(f=0;f<e;f++)for(b=0;b<c;b++)this.faces.push(new THREE.Face4(b+j*f,b+j*(f+1),b+1+j*(f+1),b+1+j*f)),this.faceVertexUvs[0].push([new THREE.UV(b/c,f/e),new THREE.UV(b/c,(f+1)/e),new THREE.UV((b+1)/c,(f+1)/e),new THREE.UV((b+1)/c,f/e)]);this.computeCentroids();this.computeFaceNormals()};
THREE.PlaneGeometry.prototype=new THREE.Geometry;THREE.PlaneGeometry.prototype.constructor=THREE.PlaneGeometry;
THREE.SphereGeometry=function(a,b,c){THREE.Geometry.call(this);for(var a=a||50,e,f=Math.PI,h=Math.max(3,b||8),g=Math.max(2,c||6),b=[],c=0;c<g+1;c++){e=c/g;var j=a*Math.cos(e*f),k=a*Math.sin(e*f),l=[],m=0;for(e=0;e<h;e++){var n=2*e/h,o=k*Math.sin(n*f),n=k*Math.cos(n*f);(c==0||c==g)&&e>0||(m=this.vertices.push(new THREE.Vertex(new THREE.Vector3(n,j,o)))-1);l.push(m)}b.push(l)}for(var t,v,u,f=b.length,c=0;c<f;c++)if(h=b[c].length,c>0)for(e=0;e<h;e++){l=e==h-1;g=b[c][l?0:e+1];j=b[c][l?h-1:e];k=b[c-1][l?
h-1:e];l=b[c-1][l?0:e+1];o=c/(f-1);t=(c-1)/(f-1);v=(e+1)/h;var n=e/h,m=new THREE.UV(1-v,o),o=new THREE.UV(1-n,o),n=new THREE.UV(1-n,t),w=new THREE.UV(1-v,t);c<b.length-1&&(t=this.vertices[g].position.clone(),v=this.vertices[j].position.clone(),u=this.vertices[k].position.clone(),t.normalize(),v.normalize(),u.normalize(),this.faces.push(new THREE.Face3(g,j,k,[new THREE.Vector3(t.x,t.y,t.z),new THREE.Vector3(v.x,v.y,v.z),new THREE.Vector3(u.x,u.y,u.z)])),this.faceVertexUvs[0].push([m,o,n]));c>1&&(t=
this.vertices[g].position.clone(),v=this.vertices[k].position.clone(),u=this.vertices[l].position.clone(),t.normalize(),v.normalize(),u.normalize(),this.faces.push(new THREE.Face3(g,k,l,[new THREE.Vector3(t.x,t.y,t.z),new THREE.Vector3(v.x,v.y,v.z),new THREE.Vector3(u.x,u.y,u.z)])),this.faceVertexUvs[0].push([m,n,w]))}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.boundingSphere={radius:a}};THREE.SphereGeometry.prototype=new THREE.Geometry;
THREE.SphereGeometry.prototype.constructor=THREE.SphereGeometry;
THREE.TextGeometry=function(a,b){var c=(new THREE.TextPath(a,b)).toShapes();b.amount=b.height!==void 0?b.height:50;if(b.bevelThickness===void 0)b.bevelThickness=10;if(b.bevelSize===void 0)b.bevelSize=8;if(b.bevelEnabled===void 0)b.bevelEnabled=!1;if(b.bend){var e=c[c.length-1].getBoundingBox().maxX;b.bendPath=new THREE.QuadraticBezierCurve(new THREE.Vector2(0,0),new THREE.Vector2(e/2,120),new THREE.Vector2(e,0))}THREE.ExtrudeGeometry.call(this,c,b)};THREE.TextGeometry.prototype=new THREE.ExtrudeGeometry;
THREE.TextGeometry.prototype.constructor=THREE.TextGeometry;
THREE.FontUtils={faces:{},face:"helvetiker",weight:"normal",style:"normal",size:150,divisions:10,getFace:function(){return this.faces[this.face][this.weight][this.style]},getTextShapes:function(a,b){return(new TextPath(a,b)).toShapes()},loadFace:function(a){var b=a.familyName.toLowerCase();this.faces[b]=this.faces[b]||{};this.faces[b][a.cssFontWeight]=this.faces[b][a.cssFontWeight]||{};this.faces[b][a.cssFontWeight][a.cssFontStyle]=a;return this.faces[b][a.cssFontWeight][a.cssFontStyle]=a},drawText:function(a){for(var b=
this.getFace(),c=this.size/b.resolution,e=0,f=String(a).split(""),h=f.length,g=[],a=0;a<h;a++){var j=new THREE.Path,j=this.extractGlyphPoints(f[a],b,c,e,j);e+=j.offset;g.push(j.path)}return{paths:g,offset:e/2}},extractGlyphPoints:function(a,b,c,e,f){var h=[],g,j,k,l,m,n,o,t,v,u,w=b.glyphs[a]||b.glyphs[ctxt.options.fallbackCharacter];if(w){if(w.o){b=w._cachedOutline||(w._cachedOutline=w.o.split(" "));k=b.length;for(a=0;a<k;)switch(j=b[a++],j){case "m":j=b[a++]*c+e;l=b[a++]*c;h.push(new THREE.Vector2(j,
l));f.moveTo(j,l);break;case "l":j=b[a++]*c+e;l=b[a++]*c;h.push(new THREE.Vector2(j,l));f.lineTo(j,l);break;case "q":j=b[a++]*c+e;l=b[a++]*c;o=b[a++]*c+e;t=b[a++]*c;f.quadraticCurveTo(o,t,j,l);if(g=h[h.length-1]){m=g.x;n=g.y;g=1;for(divisions=this.divisions;g<=divisions;g++){var y=g/divisions,x=THREE.Shape.Utils.b2(y,m,o,j),y=THREE.Shape.Utils.b2(y,n,t,l);h.push(new THREE.Vector2(x,y))}}break;case "b":if(j=b[a++]*c+e,l=b[a++]*c,o=b[a++]*c+e,t=b[a++]*-c,v=b[a++]*c+e,u=b[a++]*-c,f.bezierCurveTo(j,l,
o,t,v,u),g=h[h.length-1]){m=g.x;n=g.y;g=1;for(divisions=this.divisions;g<=divisions;g++)y=g/divisions,x=THREE.Shape.Utils.b3(y,m,o,v,j),y=THREE.Shape.Utils.b3(y,n,t,u,l),h.push(new THREE.Vector2(x,y))}}}return{offset:w.ha*c,points:h,path:f}}}};
(function(a){var b=function(a){for(var b=a.length,f=0,h=b-1,g=0;g<b;h=g++)f+=a[h].x*a[g].y-a[g].x*a[h].y;return f*0.5};a.Triangulate=function(a,e){var f=a.length;if(f<3)return null;var h=[],g=[],j=[],k,l,m;if(b(a)>0)for(l=0;l<f;l++)g[l]=l;else for(l=0;l<f;l++)g[l]=f-1-l;var n=2*f;for(l=f-1;f>2;){if(n--<=0){console.log("Warning, unable to triangulate polygon!");if(e)return j;return h}k=l;f<=k&&(k=0);l=k+1;f<=l&&(l=0);m=l+1;f<=m&&(m=0);var o;a:{o=a;var t=k,v=l,u=m,w=f,y=g,x=void 0,p=void 0,z=void 0,
B=void 0,G=void 0,H=void 0,A=void 0,D=void 0,J=void 0,p=o[y[t]].x,z=o[y[t]].y,B=o[y[v]].x,G=o[y[v]].y,H=o[y[u]].x,A=o[y[u]].y;if(1.0E-10>(B-p)*(A-z)-(G-z)*(H-p))o=!1;else{for(x=0;x<w;x++)if(!(x==t||x==v||x==u)){var D=o[y[x]].x,J=o[y[x]].y,I=void 0,E=void 0,F=void 0,L=void 0,M=void 0,O=void 0,Q=void 0,C=void 0,P=void 0,K=void 0,N=void 0,R=void 0,I=F=M=void 0,I=H-B,E=A-G,F=p-H,L=z-A,M=B-p,O=G-z,Q=D-p,C=J-z,P=D-B,K=J-G,N=D-H,R=J-A,I=I*K-E*P,M=M*C-O*Q,F=F*R-L*N;if(I>=0&&F>=0&&M>=0){o=!1;break a}}o=!0}}if(o){h.push([a[g[k]],
a[g[l]],a[g[m]]]);j.push([g[k],g[l],g[m]]);k=l;for(m=l+1;m<f;k++,m++)g[k]=g[m];f--;n=2*f}}if(e)return j;return h};a.Triangulate.area=b;return a})(THREE.FontUtils);window._typeface_js={faces:THREE.FontUtils.faces,loadFace:THREE.FontUtils.loadFace};
THREE.TorusGeometry=function(a,b,c,e){THREE.Geometry.call(this);this.radius=a||100;this.tube=b||40;this.segmentsR=c||8;this.segmentsT=e||6;a=[];for(b=0;b<=this.segmentsR;++b)for(c=0;c<=this.segmentsT;++c){var e=c/this.segmentsT*2*Math.PI,f=b/this.segmentsR*2*Math.PI;this.vertices.push(new THREE.Vertex(new THREE.Vector3((this.radius+this.tube*Math.cos(f))*Math.cos(e),(this.radius+this.tube*Math.cos(f))*Math.sin(e),this.tube*Math.sin(f))));a.push([c/this.segmentsT,1-b/this.segmentsR])}for(b=1;b<=this.segmentsR;++b)for(c=
1;c<=this.segmentsT;++c){var e=(this.segmentsT+1)*b+c,f=(this.segmentsT+1)*b+c-1,h=(this.segmentsT+1)*(b-1)+c-1,g=(this.segmentsT+1)*(b-1)+c;this.faces.push(new THREE.Face4(e,f,h,g));this.faceVertexUvs[0].push([new THREE.UV(a[e][0],a[e][1]),new THREE.UV(a[f][0],a[f][1]),new THREE.UV(a[h][0],a[h][1]),new THREE.UV(a[g][0],a[g][1])])}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.TorusGeometry.prototype=new THREE.Geometry;
THREE.TorusGeometry.prototype.constructor=THREE.TorusGeometry;
THREE.TorusKnotGeometry=function(a,b,c,e,f,h,g){function j(a,b,c,e,g,h){b=c/e*a;c=Math.cos(b);return new THREE.Vector3(g*(2+c)*0.5*Math.cos(a),g*(2+c)*Math.sin(a)*0.5,h*g*Math.sin(b)*0.5)}THREE.Geometry.call(this);this.radius=a||200;this.tube=b||40;this.segmentsR=c||64;this.segmentsT=e||8;this.p=f||2;this.q=h||3;this.heightScale=g||1;this.grid=Array(this.segmentsR);c=new THREE.Vector3;e=new THREE.Vector3;h=new THREE.Vector3;for(a=0;a<this.segmentsR;++a){this.grid[a]=Array(this.segmentsT);for(b=0;b<
this.segmentsT;++b){var k=a/this.segmentsR*2*this.p*Math.PI,g=b/this.segmentsT*2*Math.PI,f=j(k,g,this.q,this.p,this.radius,this.heightScale),k=j(k+0.01,g,this.q,this.p,this.radius,this.heightScale);c.x=k.x-f.x;c.y=k.y-f.y;c.z=k.z-f.z;e.x=k.x+f.x;e.y=k.y+f.y;e.z=k.z+f.z;h.cross(c,e);e.cross(h,c);h.normalize();e.normalize();k=-this.tube*Math.cos(g);g=this.tube*Math.sin(g);f.x+=k*e.x+g*h.x;f.y+=k*e.y+g*h.y;f.z+=k*e.z+g*h.z;this.grid[a][b]=this.vertices.push(new THREE.Vertex(new THREE.Vector3(f.x,f.y,
f.z)))-1}}for(a=0;a<this.segmentsR;++a)for(b=0;b<this.segmentsT;++b){var e=(a+1)%this.segmentsR,h=(b+1)%this.segmentsT,f=this.grid[a][b],c=this.grid[e][b],e=this.grid[e][h],h=this.grid[a][h],g=new THREE.UV(a/this.segmentsR,b/this.segmentsT),k=new THREE.UV((a+1)/this.segmentsR,b/this.segmentsT),l=new THREE.UV((a+1)/this.segmentsR,(b+1)/this.segmentsT),m=new THREE.UV(a/this.segmentsR,(b+1)/this.segmentsT);this.faces.push(new THREE.Face4(f,c,e,h));this.faceVertexUvs[0].push([g,k,l,m])}this.computeCentroids();
this.computeFaceNormals();this.computeVertexNormals()};THREE.TorusKnotGeometry.prototype=new THREE.Geometry;THREE.TorusKnotGeometry.prototype.constructor=THREE.TorusKnotGeometry;THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={addStatusElement:function(){var a=document.createElement("div");a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="rgba(0,0,0,0.25)";a.style.color="#fff";a.style.width="120px";a.style.padding="0.5em 0.5em 0.5em 0.5em";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var b="Loaded ";b+=a.total?(100*a.loaded/a.total).toFixed(0)+"%":(a.loaded/1E3).toFixed(2)+" KB";
this.statusDomElement.innerHTML=b},extractUrlbase:function(a){a=a.split("/");a.pop();return a.join("/")},init_materials:function(a,b,c){a.materials=[];for(var e=0;e<b.length;++e)a.materials[e]=[THREE.Loader.prototype.createMaterial(b[e],c)]},hasNormals:function(a){var b,c,e=a.materials.length;for(c=0;c<e;c++)if(b=a.materials[c][0],b instanceof THREE.MeshShaderMaterial)return!0;return!1},createMaterial:function(a,b){function c(a){a=Math.log(a)/Math.LN2;return Math.floor(a)==a}function e(a,b){var e=
new Image;e.onload=function(){if(!c(this.width)||!c(this.height)){var b=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),e=Math.pow(2,Math.round(Math.log(this.height)/Math.LN2));a.image.width=b;a.image.height=e;a.image.getContext("2d").drawImage(this,0,0,b,e)}else a.image=this;a.needsUpdate=!0};e.src=b}function f(a,c,g,h,f,j){var k=document.createElement("canvas");a[c]=new THREE.Texture(k);a[c].sourceFile=g;if(h){a[c].repeat.set(h[0],h[1]);if(h[0]!=1)a[c].wrapS=THREE.RepeatWrapping;if(h[1]!=
1)a[c].wrapT=THREE.RepeatWrapping}f&&a[c].offset.set(f[0],f[1]);if(j){h={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(h[j[0]]!==void 0)a[c].wrapS=h[j[0]];if(h[j[1]]!==void 0)a[c].wrapT=h[j[1]]}e(a[c],b+"/"+g)}function h(a){return(a[0]*255<<16)+(a[1]*255<<8)+a[2]*255}var g,j,k;j="MeshLambertMaterial";g={color:15658734,opacity:1,map:null,lightMap:null,normalMap:null,wireframe:a.wireframe};a.shading&&(a.shading=="Phong"?j="MeshPhongMaterial":a.shading=="Basic"&&(j="MeshBasicMaterial"));
if(a.blending)if(a.blending=="Additive")g.blending=THREE.AdditiveBlending;else if(a.blending=="Subtractive")g.blending=THREE.SubtractiveBlending;else if(a.blending=="Multiply")g.blending=THREE.MultiplyBlending;if(a.transparent!==void 0||a.opacity<1)g.transparent=a.transparent;if(a.depthTest!==void 0)g.depthTest=a.depthTest;if(a.vertexColors!==void 0)if(a.vertexColors=="face")g.vertexColors=THREE.FaceColors;else if(a.vertexColors)g.vertexColors=THREE.VertexColors;if(a.colorDiffuse)g.color=h(a.colorDiffuse);
else if(a.DbgColor)g.color=a.DbgColor;if(a.colorSpecular)g.specular=h(a.colorSpecular);if(a.colorAmbient)g.ambient=h(a.colorAmbient);if(a.transparency)g.opacity=a.transparency;if(a.specularCoef)g.shininess=a.specularCoef;a.mapDiffuse&&b&&f(g,"map",a.mapDiffuse,a.mapDiffuseRepeat,a.mapDiffuseOffset,a.mapDiffuseWrap);a.mapLight&&b&&f(g,"lightMap",a.mapLight,a.mapLightRepeat,a.mapLightOffset,a.mapLightWrap);a.mapNormal&&b&&f(g,"normalMap",a.mapNormal,a.mapNormalRepeat,a.mapNormalOffset,a.mapNormalWrap);
a.mapSpecular&&b&&f(g,"specularMap",a.mapSpecular,a.mapSpecularRepeat,a.mapSpecularOffset,a.mapSpecularWrap);if(a.mapNormal){var l=THREE.ShaderUtils.lib.normal,m=THREE.UniformsUtils.clone(l.uniforms),n=g.color;j=g.specular;k=g.ambient;var o=g.shininess;m.tNormal.texture=g.normalMap;if(a.mapNormalFactor)m.uNormalScale.value=a.mapNormalFactor;if(g.map)m.tDiffuse.texture=g.map,m.enableDiffuse.value=!0;if(g.specularMap)m.tSpecular.texture=g.specularMap,m.enableSpecular.value=!0;if(g.lightMap)m.tAO.texture=
g.lightMap,m.enableAO.value=!0;m.uDiffuseColor.value.setHex(n);m.uSpecularColor.value.setHex(j);m.uAmbientColor.value.setHex(k);m.uShininess.value=o;if(g.opacity)m.uOpacity.value=g.opacity;g=new THREE.MeshShaderMaterial({fragmentShader:l.fragmentShader,vertexShader:l.vertexShader,uniforms:m,lights:!0,fog:!0})}else g=new THREE[j](g);return g},constructor:THREE.Loader};THREE.JSONLoader=function(a){THREE.Loader.call(this,a)};THREE.JSONLoader.prototype=new THREE.Loader;
THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;THREE.JSONLoader.prototype.supr=THREE.Loader.prototype;THREE.JSONLoader.prototype.load=function(a){var b=this,c=a.model,e=a.callback,f=a.texture_path?a.texture_path:this.extractUrlbase(c),a=new Worker(c);a.onmessage=function(a){b.createModel(a.data,e,f);b.onLoadComplete()};this.onLoadStart();a.postMessage((new Date).getTime())};
THREE.JSONLoader.prototype.createModel=function(a,b,c){var e=new THREE.Geometry,f=a.scale!==void 0?1/a.scale:1;this.init_materials(e,a.materials,c);(function(b){if(a.version===void 0||a.version!=2)console.error("Deprecated file format.");else{var c,f,k,l,m,n,o,t,v,u,w,y,x,p,z=a.faces;n=a.vertices;var B=a.normals,G=a.colors,H=0;for(c=0;c<a.uvs.length;c++)a.uvs[c].length&&H++;for(c=0;c<H;c++)e.faceUvs[c]=[],e.faceVertexUvs[c]=[];l=0;for(m=n.length;l<m;)o=new THREE.Vertex,o.position.x=n[l++]*b,o.position.y=
n[l++]*b,o.position.z=n[l++]*b,e.vertices.push(o);l=0;for(m=z.length;l<m;){b=z[l++];n=b&1;k=b&2;c=b&4;f=b&8;t=b&16;o=b&32;u=b&64;b&=128;n?(w=new THREE.Face4,w.a=z[l++],w.b=z[l++],w.c=z[l++],w.d=z[l++],n=4):(w=new THREE.Face3,w.a=z[l++],w.b=z[l++],w.c=z[l++],n=3);if(k)k=z[l++],w.materials=e.materials[k];k=e.faces.length;if(c)for(c=0;c<H;c++)y=a.uvs[c],v=z[l++],p=y[v*2],v=y[v*2+1],e.faceUvs[c][k]=new THREE.UV(p,v);if(f)for(c=0;c<H;c++){y=a.uvs[c];x=[];for(f=0;f<n;f++)v=z[l++],p=y[v*2],v=y[v*2+1],x[f]=
new THREE.UV(p,v);e.faceVertexUvs[c][k]=x}if(t)t=z[l++]*3,f=new THREE.Vector3,f.x=B[t++],f.y=B[t++],f.z=B[t],w.normal=f;if(o)for(c=0;c<n;c++)t=z[l++]*3,f=new THREE.Vector3,f.x=B[t++],f.y=B[t++],f.z=B[t],w.vertexNormals.push(f);if(u)o=z[l++],o=new THREE.Color(G[o]),w.color=o;if(b)for(c=0;c<n;c++)o=z[l++],o=new THREE.Color(G[o]),w.vertexColors.push(o);e.faces.push(w)}}})(f);(function(){var b,c,f,k;if(a.skinWeights){b=0;for(c=a.skinWeights.length;b<c;b+=2)f=a.skinWeights[b],k=a.skinWeights[b+1],e.skinWeights.push(new THREE.Vector4(f,
k,0,0))}if(a.skinIndices){b=0;for(c=a.skinIndices.length;b<c;b+=2)f=a.skinIndices[b],k=a.skinIndices[b+1],e.skinIndices.push(new THREE.Vector4(f,k,0,0))}e.bones=a.bones;e.animation=a.animation})();(function(b){if(a.morphTargets!==void 0){var c,f,k,l,m,n,o,t,v;c=0;for(f=a.morphTargets.length;c<f;c++){e.morphTargets[c]={};e.morphTargets[c].name=a.morphTargets[c].name;e.morphTargets[c].vertices=[];t=e.morphTargets[c].vertices;v=a.morphTargets[c].vertices;k=0;for(l=v.length;k<l;k+=3)m=v[k]*b,n=v[k+1]*
b,o=v[k+2]*b,t.push(new THREE.Vertex(new THREE.Vector3(m,n,o)))}}if(a.morphColors!==void 0){c=0;for(f=a.morphColors.length;c<f;c++){e.morphColors[c]={};e.morphColors[c].name=a.morphColors[c].name;e.morphColors[c].colors=[];l=e.morphColors[c].colors;m=a.morphColors[c].colors;b=0;for(k=m.length;b<k;b+=3)n=new THREE.Color(16755200),n.setRGB(m[b],m[b+1],m[b+2]),l.push(n)}}})(f);(function(){if(a.edges!==void 0){var b,c,f;for(b=0;b<a.edges.length;b+=2)c=a.edges[b],f=a.edges[b+1],e.edges.push(new THREE.Edge(e.vertices[c],
e.vertices[f],c,f))}})();e.computeCentroids();e.computeFaceNormals();this.hasNormals(e)&&e.computeTangents();b(e)};THREE.BinaryLoader=function(a){THREE.Loader.call(this,a)};THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;THREE.BinaryLoader.prototype.supr=THREE.Loader.prototype;
THREE.BinaryLoader.prototype={load:function(a){var b=a.model,c=a.callback,e=a.texture_path?a.texture_path:THREE.Loader.prototype.extractUrlbase(b),f=a.bin_path?a.bin_path:THREE.Loader.prototype.extractUrlbase(b),a=(new Date).getTime(),b=new Worker(b),h=this.showProgress?THREE.Loader.prototype.updateProgress:null;b.onmessage=function(a){THREE.BinaryLoader.prototype.loadAjaxBuffers(a.data.buffers,a.data.materials,c,f,e,h)};b.onerror=function(a){alert("worker.onerror: "+a.message+"\n"+a.data);a.preventDefault()};
b.postMessage(a)},loadAjaxBuffers:function(a,b,c,e,f,h){var g=new XMLHttpRequest,j=e+"/"+a,k=0;g.onreadystatechange=function(){g.readyState==4?g.status==200||g.status==0?THREE.BinaryLoader.prototype.createBinModel(g.responseText,c,f,b):alert("Couldn't load ["+j+"] ["+g.status+"]"):g.readyState==3?h&&(k==0&&(k=g.getResponseHeader("Content-Length")),h({total:k,loaded:g.responseText.length})):g.readyState==2&&(k=g.getResponseHeader("Content-Length"))};g.open("GET",j,!0);g.overrideMimeType("text/plain; charset=x-user-defined");
g.setRequestHeader("Content-Type","text/plain");g.send(null)},createBinModel:function(a,b,c,e){var f=function(b){function c(a,b){var e=m(a,b),f=m(a,b+1),g=m(a,b+2),h=m(a,b+3),j=(h<<1&255|g>>7)-127;e|=(g&127)<<16|f<<8;if(e==0&&j==-127)return 0;return(1-2*(h>>7))*(1+e*Math.pow(2,-23))*Math.pow(2,j)}function f(a,b){var c=m(a,b),e=m(a,b+1),g=m(a,b+2);return(m(a,b+3)<<24)+(g<<16)+(e<<8)+c}function k(a,b){var c=m(a,b);return(m(a,b+1)<<8)+c}function l(a,b){var c=m(a,b);return c>127?c-256:c}function m(a,
b){return a.charCodeAt(b)&255}function n(b){var c,e,g;c=f(a,b);e=f(a,b+G);g=f(a,b+H);b=k(a,b+A);THREE.BinaryLoader.prototype.f3(y,c,e,g,b)}function o(b){var c,e,g,h,l,m;c=f(a,b);e=f(a,b+G);g=f(a,b+H);h=k(a,b+A);l=f(a,b+D);m=f(a,b+J);b=f(a,b+I);THREE.BinaryLoader.prototype.f3n(y,z,c,e,g,h,l,m,b)}function t(b){var c,e,g,h;c=f(a,b);e=f(a,b+E);g=f(a,b+F);h=f(a,b+L);b=k(a,b+M);THREE.BinaryLoader.prototype.f4(y,c,e,g,h,b)}function v(b){var c,e,g,h,l,m,n,o;c=f(a,b);e=f(a,b+E);g=f(a,b+F);h=f(a,b+L);l=k(a,
b+M);m=f(a,b+O);n=f(a,b+Q);o=f(a,b+C);b=f(a,b+P);THREE.BinaryLoader.prototype.f4n(y,z,c,e,g,h,l,m,n,o,b)}function u(b){var c,e;c=f(a,b);e=f(a,b+K);b=f(a,b+N);THREE.BinaryLoader.prototype.uv3(y.faceVertexUvs[0],B[c*2],B[c*2+1],B[e*2],B[e*2+1],B[b*2],B[b*2+1])}function w(b){var c,e,g;c=f(a,b);e=f(a,b+R);g=f(a,b+Y);b=f(a,b+Z);THREE.BinaryLoader.prototype.uv4(y.faceVertexUvs[0],B[c*2],B[c*2+1],B[e*2],B[e*2+1],B[g*2],B[g*2+1],B[b*2],B[b*2+1])}var y=this,x=0,p,z=[],B=[],G,H,A,D,J,I,E,F,L,M,O,Q,C,P,K,N,
R,Y,Z,T,U,V,W,X,S;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(y,e,b);p={signature:a.substr(x,8),header_bytes:m(a,x+8),vertex_coordinate_bytes:m(a,x+9),normal_coordinate_bytes:m(a,x+10),uv_coordinate_bytes:m(a,x+11),vertex_index_bytes:m(a,x+12),normal_index_bytes:m(a,x+13),uv_index_bytes:m(a,x+14),material_index_bytes:m(a,x+15),nvertices:f(a,x+16),nnormals:f(a,x+16+4),nuvs:f(a,x+16+8),ntri_flat:f(a,x+16+12),ntri_smooth:f(a,x+16+16),ntri_flat_uv:f(a,x+16+20),ntri_smooth_uv:f(a,x+
16+24),nquad_flat:f(a,x+16+28),nquad_smooth:f(a,x+16+32),nquad_flat_uv:f(a,x+16+36),nquad_smooth_uv:f(a,x+16+40)};x+=p.header_bytes;G=p.vertex_index_bytes;H=p.vertex_index_bytes*2;A=p.vertex_index_bytes*3;D=p.vertex_index_bytes*3+p.material_index_bytes;J=p.vertex_index_bytes*3+p.material_index_bytes+p.normal_index_bytes;I=p.vertex_index_bytes*3+p.material_index_bytes+p.normal_index_bytes*2;E=p.vertex_index_bytes;F=p.vertex_index_bytes*2;L=p.vertex_index_bytes*3;M=p.vertex_index_bytes*4;O=p.vertex_index_bytes*
4+p.material_index_bytes;Q=p.vertex_index_bytes*4+p.material_index_bytes+p.normal_index_bytes;C=p.vertex_index_bytes*4+p.material_index_bytes+p.normal_index_bytes*2;P=p.vertex_index_bytes*4+p.material_index_bytes+p.normal_index_bytes*3;K=p.uv_index_bytes;N=p.uv_index_bytes*2;R=p.uv_index_bytes;Y=p.uv_index_bytes*2;Z=p.uv_index_bytes*3;b=p.vertex_index_bytes*3+p.material_index_bytes;S=p.vertex_index_bytes*4+p.material_index_bytes;T=p.ntri_flat*b;U=p.ntri_smooth*(b+p.normal_index_bytes*3);V=p.ntri_flat_uv*
(b+p.uv_index_bytes*3);W=p.ntri_smooth_uv*(b+p.normal_index_bytes*3+p.uv_index_bytes*3);X=p.nquad_flat*S;b=p.nquad_smooth*(S+p.normal_index_bytes*4);S=p.nquad_flat_uv*(S+p.uv_index_bytes*4);x+=function(b){for(var e,f,h,j=p.vertex_coordinate_bytes*3,k=b+p.nvertices*j;b<k;b+=j)e=c(a,b),f=c(a,b+p.vertex_coordinate_bytes),h=c(a,b+p.vertex_coordinate_bytes*2),THREE.BinaryLoader.prototype.v(y,e,f,h);return p.nvertices*j}(x);x+=function(b){for(var c,e,f,g=p.normal_coordinate_bytes*3,h=b+p.nnormals*g;b<h;b+=
g)c=l(a,b),e=l(a,b+p.normal_coordinate_bytes),f=l(a,b+p.normal_coordinate_bytes*2),z.push(c/127,e/127,f/127);return p.nnormals*g}(x);x+=function(b){for(var e,f,h=p.uv_coordinate_bytes*2,j=b+p.nuvs*h;b<j;b+=h)e=c(a,b),f=c(a,b+p.uv_coordinate_bytes),B.push(e,f);return p.nuvs*h}(x);T=x+T;U=T+U;V=U+V;W=V+W;X=W+X;b=X+b;S=b+S;(function(a){var b,c=p.vertex_index_bytes*3+p.material_index_bytes,e=c+p.uv_index_bytes*3,f=a+p.ntri_flat_uv*e;for(b=a;b<f;b+=e)n(b),u(b+c);return f-a})(U);(function(a){var b,c=p.vertex_index_bytes*
3+p.material_index_bytes+p.normal_index_bytes*3,e=c+p.uv_index_bytes*3,f=a+p.ntri_smooth_uv*e;for(b=a;b<f;b+=e)o(b),u(b+c);return f-a})(V);(function(a){var b,c=p.vertex_index_bytes*4+p.material_index_bytes,e=c+p.uv_index_bytes*4,f=a+p.nquad_flat_uv*e;for(b=a;b<f;b+=e)t(b),w(b+c);return f-a})(b);(function(a){var b,c=p.vertex_index_bytes*4+p.material_index_bytes+p.normal_index_bytes*4,e=c+p.uv_index_bytes*4,f=a+p.nquad_smooth_uv*e;for(b=a;b<f;b+=e)v(b),w(b+c);return f-a})(S);(function(a){var b,c=p.vertex_index_bytes*
3+p.material_index_bytes,e=a+p.ntri_flat*c;for(b=a;b<e;b+=c)n(b);return e-a})(x);(function(a){var b,c=p.vertex_index_bytes*3+p.material_index_bytes+p.normal_index_bytes*3,e=a+p.ntri_smooth*c;for(b=a;b<e;b+=c)o(b);return e-a})(T);(function(a){var b,c=p.vertex_index_bytes*4+p.material_index_bytes,e=a+p.nquad_flat*c;for(b=a;b<e;b+=c)t(b);return e-a})(W);(function(a){var b,c=p.vertex_index_bytes*4+p.material_index_bytes+p.normal_index_bytes*4,e=a+p.nquad_smooth*c;for(b=a;b<e;b+=c)v(b);return e-a})(X);
this.computeCentroids();this.computeFaceNormals();THREE.Loader.prototype.hasNormals(this)&&this.computeTangents()};f.prototype=new THREE.Geometry;f.prototype.constructor=f;b(new f(c))},v:function(a,b,c,e){a.vertices.push(new THREE.Vertex(new THREE.Vector3(b,c,e)))},f3:function(a,b,c,e,f){a.faces.push(new THREE.Face3(b,c,e,null,null,a.materials[f]))},f4:function(a,b,c,e,f,h){a.faces.push(new THREE.Face4(b,c,e,f,null,null,a.materials[h]))},f3n:function(a,b,c,e,f,h,g,j,k){var h=a.materials[h],l=b[j*
3],m=b[j*3+1],j=b[j*3+2],n=b[k*3],o=b[k*3+1],k=b[k*3+2];a.faces.push(new THREE.Face3(c,e,f,[new THREE.Vector3(b[g*3],b[g*3+1],b[g*3+2]),new THREE.Vector3(l,m,j),new THREE.Vector3(n,o,k)],null,h))},f4n:function(a,b,c,e,f,h,g,j,k,l,m){var g=a.materials[g],n=b[k*3],o=b[k*3+1],k=b[k*3+2],t=b[l*3],v=b[l*3+1],l=b[l*3+2],u=b[m*3],w=b[m*3+1],m=b[m*3+2];a.faces.push(new THREE.Face4(c,e,f,h,[new THREE.Vector3(b[j*3],b[j*3+1],b[j*3+2]),new THREE.Vector3(n,o,k),new THREE.Vector3(t,v,l),new THREE.Vector3(u,w,
m)],null,g))},uv3:function(a,b,c,e,f,h,g){var j=[];j.push(new THREE.UV(b,c));j.push(new THREE.UV(e,f));j.push(new THREE.UV(h,g));a.push(j)},uv4:function(a,b,c,e,f,h,g,j,k){var l=[];l.push(new THREE.UV(b,c));l.push(new THREE.UV(e,f));l.push(new THREE.UV(h,g));l.push(new THREE.UV(j,k));a.push(l)},constructor:THREE.BinaryLoader};
THREE.SceneLoader=function(){this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){};this.callbackSync=function(){};this.callbackProgress=function(){}};
THREE.SceneLoader.prototype={load:function(a,b){var c=this,e=new Worker(a);e.postMessage(0);var f=THREE.Loader.prototype.extractUrlbase(a);e.onmessage=function(a){function e(a,b){return b=="relativeToHTML"?a:f+"/"+a}function j(){for(t in E.objects)if(!C.objects[t])if(x=E.objects[t],x.geometry!==void 0){if(G=C.geometries[x.geometry]){var a=!1;J=[];for(K=0;K<x.materials.length;K++)J[K]=C.materials[x.materials[K]],a=J[K]instanceof THREE.MeshShaderMaterial;a&&G.computeTangents();p=x.position;r=x.rotation;
q=x.quaternion;s=x.scale;q=0;J.length==0&&(J[0]=new THREE.MeshFaceMaterial);J.length>1&&(J=[new THREE.MeshFaceMaterial]);object=new THREE.Mesh(G,J);object.name=t;object.position.set(p[0],p[1],p[2]);q?(object.quaternion.set(q[0],q[1],q[2],q[3]),object.useQuaternion=!0):object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=x.visible;C.scene.addObject(object);C.objects[t]=object;x.meshCollider&&(a=THREE.CollisionUtils.MeshColliderWBox(object),C.scene.collisions.colliders.push(a));
if(x.castsShadow)a=new THREE.ShadowVolume(G),C.scene.addChild(a),a.position=object.position,a.rotation=object.rotation,a.scale=object.scale;x.trigger&&x.trigger.toLowerCase()!="none"&&(a={type:x.trigger,object:x},C.triggers[object.name]=a)}}else p=x.position,r=x.rotation,q=x.quaternion,s=x.scale,q=0,object=new THREE.Object3D,object.name=t,object.position.set(p[0],p[1],p[2]),q?(object.quaternion.set(q[0],q[1],q[2],q[3]),object.useQuaternion=!0):object.rotation.set(r[0],r[1],r[2]),object.scale.set(s[0],
s[1],s[2]),object.visible=x.visible!==void 0?x.visible:!1,C.scene.addObject(object),C.objects[t]=object,C.empties[t]=object,x.trigger&&x.trigger.toLowerCase()!="none"&&(a={type:x.trigger,object:x},C.triggers[object.name]=a)}function k(a){return function(b){C.geometries[a]=b;j();L-=1;c.onLoadComplete();m()}}function l(a){return function(b){C.geometries[a]=b}}function m(){c.callbackProgress({totalModels:O,totalTextures:Q,loadedModels:O-L,loadedTextures:Q-M},C);c.onLoadProgress();L==0&&M==0&&b(C)}var n,
o,t,v,u,w,y,x,p,z,B,G,H,A,D,J,I,E,F,L,M,O,Q,C;E=a.data;D=new THREE.BinaryLoader;F=new THREE.JSONLoader;M=L=0;C={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},fogs:{},triggers:{},empties:{}};a=!1;for(t in E.objects)if(x=E.objects[t],x.meshCollider){a=!0;break}if(a)C.scene.collisions=new THREE.CollisionSystem;if(E.transform){a=E.transform.position;z=E.transform.rotation;var P=E.transform.scale;a&&C.scene.position.set(a[0],a[1],a[2]);z&&C.scene.rotation.set(z[0],
z[1],z[2]);P&&C.scene.scale.set(P[0],P[1],P[2]);(a||z||P)&&C.scene.updateMatrix()}a=function(){M-=1;m();c.onLoadComplete()};for(u in E.cameras){z=E.cameras[u];if(z.type=="perspective")H=new THREE.Camera(z.fov,z.aspect,z.near,z.far);else if(z.type=="ortho")H=new THREE.Camera,H.projectionMatrix=THREE.Matrix4.makeOrtho(z.left,z.right,z.top,z.bottom,z.near,z.far);p=z.position;z=z.target;H.position.set(p[0],p[1],p[2]);H.target.position.set(z[0],z[1],z[2]);C.cameras[u]=H}for(v in E.lights)u=E.lights[v],
H=u.color!==void 0?u.color:16777215,z=u.intensity!==void 0?u.intensity:1,u.type=="directional"?(p=u.direction,I=new THREE.DirectionalLight(H,z),I.position.set(p[0],p[1],p[2]),I.position.normalize()):u.type=="point"?(p=u.position,d=u.distance,I=new THREE.PointLight(H,z,d),I.position.set(p[0],p[1],p[2])):u.type=="ambient"&&(I=new THREE.AmbientLight(H)),C.scene.addLight(I),C.lights[v]=I;for(w in E.fogs)v=E.fogs[w],v.type=="linear"?A=new THREE.Fog(0,v.near,v.far):v.type=="exp2"&&(A=new THREE.FogExp2(0,
v.density)),z=v.color,A.color.setRGB(z[0],z[1],z[2]),C.fogs[w]=A;if(C.cameras&&E.defaults.camera)C.currentCamera=C.cameras[E.defaults.camera];if(C.fogs&&E.defaults.fog)C.scene.fog=C.fogs[E.defaults.fog];z=E.defaults.bgcolor;C.bgColor=new THREE.Color;C.bgColor.setRGB(z[0],z[1],z[2]);C.bgColorAlpha=E.defaults.bgalpha;for(n in E.geometries)if(w=E.geometries[n],w.type=="bin_mesh"||w.type=="ascii_mesh")L+=1,c.onLoadStart();O=L;for(n in E.geometries)w=E.geometries[n],w.type=="cube"?(G=new THREE.CubeGeometry(w.width,
w.height,w.depth,w.segmentsWidth,w.segmentsHeight,w.segmentsDepth,null,w.flipped,w.sides),C.geometries[n]=G):w.type=="plane"?(G=new THREE.PlaneGeometry(w.width,w.height,w.segmentsWidth,w.segmentsHeight),C.geometries[n]=G):w.type=="sphere"?(G=new THREE.SphereGeometry(w.radius,w.segmentsWidth,w.segmentsHeight),C.geometries[n]=G):w.type=="cylinder"?(G=new THREE.CylinderGeometry(w.numSegs,w.topRad,w.botRad,w.height,w.topOffset,w.botOffset),C.geometries[n]=G):w.type=="torus"?(G=new THREE.TorusGeometry(w.radius,
w.tube,w.segmentsR,w.segmentsT),C.geometries[n]=G):w.type=="icosahedron"?(G=new THREE.IcosahedronGeometry(w.subdivisions),C.geometries[n]=G):w.type=="bin_mesh"?D.load({model:e(w.url,E.urlBaseType),callback:k(n)}):w.type=="ascii_mesh"?F.load({model:e(w.url,E.urlBaseType),callback:k(n)}):w.type=="embedded_mesh"&&(w=E.embeds[w.id])&&F.createModel(w,l(n),"");for(y in E.textures)if(n=E.textures[y],n.url instanceof Array){M+=n.url.length;for(D=0;D<n.url.length;D++)c.onLoadStart()}else M+=1,c.onLoadStart();
Q=M;for(y in E.textures){n=E.textures[y];if(n.mapping!=void 0&&THREE[n.mapping]!=void 0)n.mapping=new THREE[n.mapping];if(n.url instanceof Array){D=[];for(var K=0;K<n.url.length;K++)D[K]=e(n.url[K],E.urlBaseType);D=THREE.ImageUtils.loadTextureCube(D,n.mapping,a)}else{D=THREE.ImageUtils.loadTexture(e(n.url,E.urlBaseType),n.mapping,a);if(THREE[n.minFilter]!=void 0)D.minFilter=THREE[n.minFilter];if(THREE[n.magFilter]!=void 0)D.magFilter=THREE[n.magFilter];if(n.repeat){D.repeat.set(n.repeat[0],n.repeat[1]);
if(n.repeat[0]!=1)D.wrapS=THREE.RepeatWrapping;if(n.repeat[1]!=1)D.wrapT=THREE.RepeatWrapping}n.offset&&D.offset.set(n.offset[0],n.offset[1]);if(n.wrap){F={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(F[n.wrap[0]]!==void 0)D.wrapS=F[n.wrap[0]];if(F[n.wrap[1]]!==void 0)D.wrapT=F[n.wrap[1]]}}C.textures[y]=D}for(o in E.materials){y=E.materials[o];for(B in y.parameters)if(B=="envMap"||B=="map"||B=="lightMap")y.parameters[B]=C.textures[y.parameters[B]];else if(B=="shading")y.parameters[B]=
y.parameters[B]=="flat"?THREE.FlatShading:THREE.SmoothShading;else if(B=="blending")y.parameters[B]=THREE[y.parameters[B]]?THREE[y.parameters[B]]:THREE.NormalBlending;else if(B=="combine")y.parameters[B]=y.parameters[B]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation;else if(B=="vertexColors")if(y.parameters[B]=="face")y.parameters[B]=THREE.FaceColors;else if(y.parameters[B])y.parameters[B]=THREE.VertexColors;if(y.parameters.opacity!==void 0&&y.parameters.opacity<1)y.parameters.transparent=
!0;if(y.parameters.normalMap){n=THREE.ShaderUtils.lib.normal;a=THREE.UniformsUtils.clone(n.uniforms);D=y.parameters.color;F=y.parameters.specular;w=y.parameters.ambient;A=y.parameters.shininess;a.tNormal.texture=C.textures[y.parameters.normalMap];if(y.parameters.normalMapFactor)a.uNormalScale.value=y.parameters.normalMapFactor;if(y.parameters.map)a.tDiffuse.texture=y.parameters.map,a.enableDiffuse.value=!0;if(y.parameters.lightMap)a.tAO.texture=y.parameters.lightMap,a.enableAO.value=!0;if(y.parameters.specularMap)a.tSpecular.texture=
C.textures[y.parameters.specularMap],a.enableSpecular.value=!0;a.uDiffuseColor.value.setHex(D);a.uSpecularColor.value.setHex(F);a.uAmbientColor.value.setHex(w);a.uShininess.value=A;if(y.parameters.opacity)a.uOpacity.value=y.parameters.opacity;y=new THREE.MeshShaderMaterial({fragmentShader:n.fragmentShader,vertexShader:n.vertexShader,uniforms:a,lights:!0,fog:!0})}else y=new THREE[y.type](y.parameters);C.materials[o]=y}j();c.callbackSync(C)}},constructor:THREE.SceneLoader};THREE.UTF8Loader=function(){};
THREE.UTF8Loader.prototype=new THREE.UTF8Loader;THREE.UTF8Loader.prototype.constructor=THREE.UTF8Loader;
THREE.UTF8Loader.prototype={load:function(a){var b=new XMLHttpRequest,c=a.model,e=a.callback,f=a.scale!==void 0?a.scale:1,h=a.offsetX!==void 0?a.offsetX:0,g=a.offsetY!==void 0?a.offsetY:0,j=a.offsetZ!==void 0?a.offsetZ:0;b.onreadystatechange=function(){b.readyState==4?b.status==200||b.status==0?THREE.UTF8Loader.prototype.createModel(b.responseText,e,f,h,g,j):alert("Couldn't load ["+c+"] ["+b.status+"]"):b.readyState!=3&&b.readyState==2&&b.getResponseHeader("Content-Length")};b.open("GET",c,!0);b.send(null)},
decompressMesh:function(a){var b=a.charCodeAt(0);b>=57344&&(b-=2048);b++;for(var c=new Float32Array(8*b),e=1,f=0;f<8;f++){for(var h=0,g=0;g<b;++g){var j=a.charCodeAt(g+e);h+=j>>1^-(j&1);c[8*g+f]=h}e+=b}b=a.length-e;h=new Uint16Array(b);for(f=g=0;f<b;f++)j=a.charCodeAt(f+e),h[f]=g-j,j==0&&g++;return[c,h]},createModel:function(a,b,c,e,f,h){var g=function(){var b=this;b.materials=[];THREE.Geometry.call(this);var g=THREE.UTF8Loader.prototype.decompressMesh(a),l=[],m=[];(function(a,g,k){for(var l,m,w,
y=a.length;k<y;k+=g)l=a[k],m=a[k+1],w=a[k+2],l=l/16383*c,m=m/16383*c,w=w/16383*c,l+=e,m+=f,w+=h,THREE.UTF8Loader.prototype.v(b,l,m,w)})(g[0],8,0);(function(a,b,c){for(var e,f,g=a.length;c<g;c+=b)e=a[c],f=a[c+1],e/=1023,f/=1023,m.push(e,f)})(g[0],8,3);(function(a,b,c){for(var e,f,g,h=a.length;c<h;c+=b)e=a[c],f=a[c+1],g=a[c+2],e=(e-512)/511,f=(f-512)/511,g=(g-512)/511,l.push(e,f,g)})(g[0],8,5);(function(a){var c,e,f,g,h,k,x,p=a.length;for(c=0;c<p;c+=3)e=a[c],f=a[c+1],g=a[c+2],THREE.UTF8Loader.prototype.f3n(b,
l,e,f,g,0,e,f,g),h=m[e*2],e=m[e*2+1],k=m[f*2],f=m[f*2+1],x=m[g*2],g=m[g*2+1],THREE.UTF8Loader.prototype.uv3(b.faceVertexUvs[0],h,e,k,f,x,g)})(g[1]);this.computeCentroids();this.computeFaceNormals()};g.prototype=new THREE.Geometry;g.prototype.constructor=g;b(new g)},v:function(a,b,c,e){a.vertices.push(new THREE.Vertex(new THREE.Vector3(b,c,e)))},f3n:function(a,b,c,e,f,h,g,j,k){var h=a.materials[h],l=b[j*3],m=b[j*3+1],j=b[j*3+2],n=b[k*3],o=b[k*3+1],k=b[k*3+2],g=new THREE.Vector3(b[g*3],b[g*3+1],b[g*
3+2]),j=new THREE.Vector3(l,m,j),k=new THREE.Vector3(n,o,k);a.faces.push(new THREE.Face3(c,e,f,[g,j,k],null,h))},uv3:function(a,b,c,e,f,h,g){var j=[];j.push(new THREE.UV(b,c));j.push(new THREE.UV(e,f));j.push(new THREE.UV(h,g));a.push(j)},constructor:THREE.UTF8Loader};
THREE.MarchingCubes=function(a,b){THREE.Object3D.call(this);this.materials=b instanceof Array?b:[b];this.init=function(a){this.isolation=80;this.size=a;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=
0;this.hasNormal=this.hasPos=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(a,b,f){return a+(b-a)*f};this.VIntX=function(a,b,f,h,g,j,k,l,m,n){g=(g-m)/(n-m);m=this.normal_cache;b[h]=j+g*this.delta;b[h+1]=k;b[h+2]=l;f[h]=this.lerp(m[a],m[a+3],g);f[h+1]=this.lerp(m[a+1],m[a+4],g);f[h+2]=this.lerp(m[a+2],m[a+5],g)};this.VIntY=function(a,b,f,h,g,j,k,l,m,n){g=(g-m)/(n-m);m=this.normal_cache;b[h]=j;b[h+1]=k+g*this.delta;b[h+
2]=l;b=a+this.yd*3;f[h]=this.lerp(m[a],m[b],g);f[h+1]=this.lerp(m[a+1],m[b+1],g);f[h+2]=this.lerp(m[a+2],m[b+2],g)};this.VIntZ=function(a,b,f,h,g,j,k,l,m,n){g=(g-m)/(n-m);m=this.normal_cache;b[h]=j;b[h+1]=k;b[h+2]=l+g*this.delta;b=a+this.zd*3;f[h]=this.lerp(m[a],m[b],g);f[h+1]=this.lerp(m[a+1],m[b+1],g);f[h+2]=this.lerp(m[a+2],m[b+2],g)};this.compNorm=function(a){var b=a*3;this.normal_cache[b]==0&&(this.normal_cache[b]=this.field[a-1]-this.field[a+1],this.normal_cache[b+1]=this.field[a-this.yd]-this.field[a+
this.yd],this.normal_cache[b+2]=this.field[a-this.zd]-this.field[a+this.zd])};this.polygonize=function(a,b,f,h,g,j){var k=h+1,l=h+this.yd,m=h+this.zd,n=k+this.yd,o=k+this.zd,t=h+this.yd+this.zd,v=k+this.yd+this.zd,u=0,w=this.field[h],y=this.field[k],x=this.field[l],p=this.field[n],z=this.field[m],B=this.field[o],G=this.field[t],H=this.field[v];w<g&&(u|=1);y<g&&(u|=2);x<g&&(u|=8);p<g&&(u|=4);z<g&&(u|=16);B<g&&(u|=32);G<g&&(u|=128);H<g&&(u|=64);var A=THREE.edgeTable[u];if(A==0)return 0;var D=this.delta,
J=a+D,I=b+D,D=f+D;A&1&&(this.compNorm(h),this.compNorm(k),this.VIntX(h*3,this.vlist,this.nlist,0,g,a,b,f,w,y));A&2&&(this.compNorm(k),this.compNorm(n),this.VIntY(k*3,this.vlist,this.nlist,3,g,J,b,f,y,p));A&4&&(this.compNorm(l),this.compNorm(n),this.VIntX(l*3,this.vlist,this.nlist,6,g,a,I,f,x,p));A&8&&(this.compNorm(h),this.compNorm(l),this.VIntY(h*3,this.vlist,this.nlist,9,g,a,b,f,w,x));A&16&&(this.compNorm(m),this.compNorm(o),this.VIntX(m*3,this.vlist,this.nlist,12,g,a,b,D,z,B));A&32&&(this.compNorm(o),
this.compNorm(v),this.VIntY(o*3,this.vlist,this.nlist,15,g,J,b,D,B,H));A&64&&(this.compNorm(t),this.compNorm(v),this.VIntX(t*3,this.vlist,this.nlist,18,g,a,I,D,G,H));A&128&&(this.compNorm(m),this.compNorm(t),this.VIntY(m*3,this.vlist,this.nlist,21,g,a,b,D,z,G));A&256&&(this.compNorm(h),this.compNorm(m),this.VIntZ(h*3,this.vlist,this.nlist,24,g,a,b,f,w,z));A&512&&(this.compNorm(k),this.compNorm(o),this.VIntZ(k*3,this.vlist,this.nlist,27,g,J,b,f,y,B));A&1024&&(this.compNorm(n),this.compNorm(v),this.VIntZ(n*
3,this.vlist,this.nlist,30,g,J,I,f,p,H));A&2048&&(this.compNorm(l),this.compNorm(t),this.VIntZ(l*3,this.vlist,this.nlist,33,g,a,I,f,x,G));u<<=4;for(g=h=0;THREE.triTable[u+g]!=-1;)a=u+g,b=a+1,f=a+2,this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[a],3*THREE.triTable[b],3*THREE.triTable[f],j),g+=3,h++;return h};this.posnormtriv=function(a,b,f,h,g,j){var k=this.count*3;this.positionArray[k]=a[f];this.positionArray[k+1]=a[f+1];this.positionArray[k+2]=a[f+2];this.positionArray[k+3]=a[h];this.positionArray[k+
4]=a[h+1];this.positionArray[k+5]=a[h+2];this.positionArray[k+6]=a[g];this.positionArray[k+7]=a[g+1];this.positionArray[k+8]=a[g+2];this.normalArray[k]=b[f];this.normalArray[k+1]=b[f+1];this.normalArray[k+2]=b[f+2];this.normalArray[k+3]=b[h];this.normalArray[k+4]=b[h+1];this.normalArray[k+5]=b[h+2];this.normalArray[k+6]=b[g];this.normalArray[k+7]=b[g+1];this.normalArray[k+8]=b[g+2];this.hasNormal=this.hasPos=!0;this.count+=3;this.count>=this.maxCount-3&&j(this)};this.begin=function(){this.count=0;
this.hasNormal=this.hasPos=!1};this.end=function(a){if(this.count!=0){for(var b=this.count*3;b<this.positionArray.length;b++)this.positionArray[b]=0;a(this)}};this.addBall=function(a,b,f,h,g){var j=this.size*Math.sqrt(h/g),k=f*this.size,l=b*this.size,m=a*this.size,n=Math.floor(k-j);n<1&&(n=1);k=Math.floor(k+j);k>this.size-1&&(k=this.size-1);var o=Math.floor(l-j);o<1&&(o=1);l=Math.floor(l+j);l>this.size-1&&(l=this.size-1);var t=Math.floor(m-j);t<1&&(t=1);j=Math.floor(m+j);j>this.size-1&&(j=this.size-
1);for(var v,u,w,y,x,p;n<k;n++){m=this.size2*n;u=n/this.size-f;x=u*u;for(u=o;u<l;u++){w=m+this.size*u;v=u/this.size-b;p=v*v;for(v=t;v<j;v++)y=v/this.size-a,y=h/(1.0E-6+y*y+p+x)-g,y>0&&(this.field[w+v]+=y)}}};this.addPlaneX=function(a,b){var f,h,g,j,k,l=this.size,m=this.yd,n=this.zd,o=this.field,t=l*Math.sqrt(a/b);t>l&&(t=l);for(f=0;f<t;f++)if(h=f/l,h*=h,j=a/(1.0E-4+h)-b,j>0)for(h=0;h<l;h++){k=f+h*m;for(g=0;g<l;g++)o[n*g+k]+=j}};this.addPlaneY=function(a,b){var f,h,g,j,k,l,m=this.size,n=this.yd,o=
this.zd,t=this.field,v=m*Math.sqrt(a/b);v>m&&(v=m);for(h=0;h<v;h++)if(f=h/m,f*=f,j=a/(1.0E-4+f)-b,j>0){k=h*n;for(f=0;f<m;f++){l=k+f;for(g=0;g<m;g++)t[o*g+l]+=j}}};this.addPlaneZ=function(a,b){var f,h,g,j,k,l;size=this.size;yd=this.yd;zd=this.zd;field=this.field;dist=size*Math.sqrt(a/b);dist>size&&(dist=size);for(g=0;g<dist;g++)if(f=g/size,f*=f,j=a/(1.0E-4+f)-b,j>0){k=zd*g;for(h=0;h<size;h++){l=k+h*yd;for(f=0;f<size;f++)field[l+f]+=j}}};this.reset=function(){var a;for(a=0;a<this.size3;a++)this.normal_cache[a*
3]=0,this.field[a]=0};this.render=function(a){this.begin();var b,f,h,g,j,k,l,m,n,o=this.size-2;for(g=1;g<o;g++){n=this.size2*g;l=(g-this.halfsize)/this.halfsize;for(h=1;h<o;h++){m=n+this.size*h;k=(h-this.halfsize)/this.halfsize;for(f=1;f<o;f++)j=(f-this.halfsize)/this.halfsize,b=m+f,this.polygonize(j,k,l,b,this.isolation,a)}}this.end(a)};this.generateGeometry=function(){var a=0,b=new THREE.Geometry,f=[];this.render(function(h){var g,j,k,l,m,n,o,t;for(g=0;g<h.count;g++)o=g*3,m=o+1,t=o+2,j=h.positionArray[o],
k=h.positionArray[m],l=h.positionArray[t],n=new THREE.Vector3(j,k,l),j=h.normalArray[o],k=h.normalArray[m],l=h.normalArray[t],o=new THREE.Vector3(j,k,l),o.normalize(),m=new THREE.Vertex(n),b.vertices.push(m),f.push(o);nfaces=h.count/3;for(g=0;g<nfaces;g++)o=(a+g)*3,m=o+1,t=o+2,n=f[o],j=f[m],k=f[t],o=new THREE.Face3(o,m,t,[n,j,k]),b.faces.push(o);a+=nfaces;h.count=0});return b};this.init(a)};THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
THREE.Trident=function(a){function b(b){return new THREE.Mesh(new THREE.CylinderGeometry(30,0.1,a.length/20,a.length/5),new THREE.MeshBasicMaterial({color:b}))}function c(a,b){var c=new THREE.Geometry;c.vertices=[new THREE.Vertex,new THREE.Vertex(a)];return new THREE.Line(c,new THREE.LineBasicMaterial({color:b}))}THREE.Object3D.call(this);var e=Math.PI/2,f,a=a||THREE.Trident.defaultParams;if(a!==THREE.Trident.defaultParams)for(f in THREE.Trident.defaultParams)a.hasOwnProperty(f)||(a[f]=THREE.Trident.defaultParams[f]);
this.scale=new THREE.Vector3(a.scale,a.scale,a.scale);this.addChild(c(new THREE.Vector3(a.length,0,0),a.xAxisColor));this.addChild(c(new THREE.Vector3(0,a.length,0),a.yAxisColor));this.addChild(c(new THREE.Vector3(0,0,a.length),a.zAxisColor));if(a.showArrows)f=b(a.xAxisColor),f.rotation.y=-e,f.position.x=a.length,this.addChild(f),f=b(a.yAxisColor),f.rotation.x=e,f.position.y=a.length,this.addChild(f),f=b(a.zAxisColor),f.rotation.y=Math.PI,f.position.z=a.length,this.addChild(f)};
THREE.Trident.prototype=new THREE.Object3D;THREE.Trident.prototype.constructor=THREE.Trident;THREE.Trident.defaultParams={xAxisColor:16711680,yAxisColor:65280,zAxisColor:255,showArrows:!0,length:100,scale:1};THREE.PlaneCollider=function(a,b){this.point=a;this.normal=b};THREE.SphereCollider=function(a,b){this.center=a;this.radius=b;this.radiusSq=b*b};THREE.BoxCollider=function(a,b){this.min=a;this.max=b;this.dynamic=!0;this.normal=new THREE.Vector3};
THREE.MeshCollider=function(a,b){this.mesh=a;this.box=b;this.numFaces=this.mesh.geometry.faces.length;this.normal=new THREE.Vector3};THREE.CollisionSystem=function(){this.collisionNormal=new THREE.Vector3;this.colliders=[];this.hits=[]};THREE.Collisions=new THREE.CollisionSystem;THREE.CollisionSystem.prototype.merge=function(a){this.colliders=this.colliders.concat(a.colliders);this.hits=this.hits.concat(a.hits)};
THREE.CollisionSystem.prototype.rayCastAll=function(a){a.direction.normalize();this.hits.length=0;var b,c,e,f,h=0;b=0;for(c=this.colliders.length;b<c;b++)if(f=this.colliders[b],e=this.rayCast(a,f),e<Number.MAX_VALUE)f.distance=e,e>h?this.hits.push(f):this.hits.unshift(f),h=e;return this.hits};
THREE.CollisionSystem.prototype.rayCastNearest=function(a){var b=this.rayCastAll(a);if(b.length==0)return null;for(var c=0;b[c]instanceof THREE.MeshCollider;){var e=this.rayMesh(a,b[c]);if(e.dist<Number.MAX_VALUE){b[c].distance=e.dist;b[c].faceIndex=e.faceIndex;break}c++}if(c>b.length)return null;return b[c]};
THREE.CollisionSystem.prototype.rayCast=function(a,b){if(b instanceof THREE.PlaneCollider)return this.rayPlane(a,b);else if(b instanceof THREE.SphereCollider)return this.raySphere(a,b);else if(b instanceof THREE.BoxCollider)return this.rayBox(a,b);else if(b instanceof THREE.MeshCollider&&b.box)return this.rayBox(a,b.box)};
THREE.CollisionSystem.prototype.rayMesh=function(a,b){for(var c=this.makeRayLocal(a,b.mesh),e=Number.MAX_VALUE,f,h=0;h<b.numFaces;h++){var g=b.mesh.geometry.faces[h],j=b.mesh.geometry.vertices[g.a].position,k=b.mesh.geometry.vertices[g.b].position,l=b.mesh.geometry.vertices[g.c].position,m=g instanceof THREE.Face4?b.mesh.geometry.vertices[g.d].position:null;g instanceof THREE.Face3?(g=this.rayTriangle(c,j,k,l,e,this.collisionNormal,b.mesh),g<e&&(e=g,f=h,b.normal.copy(this.collisionNormal),b.normal.normalize())):
g instanceof THREE.Face4&&(g=this.rayTriangle(c,j,k,m,e,this.collisionNormal,b.mesh),g<e&&(e=g,f=h,b.normal.copy(this.collisionNormal),b.normal.normalize()),g=this.rayTriangle(c,k,l,m,e,this.collisionNormal,b.mesh),g<e&&(e=g,f=h,b.normal.copy(this.collisionNormal),b.normal.normalize()))}return{dist:e,faceIndex:f}};
THREE.CollisionSystem.prototype.rayTriangle=function(a,b,c,e,f,h,g){var j=THREE.CollisionSystem.__v1,k=THREE.CollisionSystem.__v2;h.set(0,0,0);j.sub(c,b);k.sub(e,c);h.cross(j,k);j=h.dot(a.direction);if(!(j<0))if(g.doubleSided||g.flipSided)h.multiplyScalar(-1),j*=-1;else return Number.MAX_VALUE;g=h.dot(b)-h.dot(a.origin);if(!(g<=0))return Number.MAX_VALUE;if(!(g>=j*f))return Number.MAX_VALUE;g/=j;j=THREE.CollisionSystem.__v3;j.copy(a.direction);j.multiplyScalar(g);j.addSelf(a.origin);Math.abs(h.x)>
Math.abs(h.y)?Math.abs(h.x)>Math.abs(h.z)?(a=j.y-b.y,h=c.y-b.y,f=e.y-b.y,j=j.z-b.z,c=c.z-b.z,e=e.z-b.z):(a=j.x-b.x,h=c.x-b.x,f=e.x-b.x,j=j.y-b.y,c=c.y-b.y,e=e.y-b.y):Math.abs(h.y)>Math.abs(h.z)?(a=j.x-b.x,h=c.x-b.x,f=e.x-b.x,j=j.z-b.z,c=c.z-b.z,e=e.z-b.z):(a=j.x-b.x,h=c.x-b.x,f=e.x-b.x,j=j.y-b.y,c=c.y-b.y,e=e.y-b.y);b=h*e-c*f;if(b==0)return Number.MAX_VALUE;b=1/b;e=(a*e-j*f)*b;if(!(e>=0))return Number.MAX_VALUE;b*=h*j-c*a;if(!(b>=0))return Number.MAX_VALUE;if(!(1-e-b>=0))return Number.MAX_VALUE;return g};
THREE.CollisionSystem.prototype.makeRayLocal=function(a,b){var c=THREE.CollisionSystem.__m;THREE.Matrix4.makeInvert(b.matrixWorld,c);var e=THREE.CollisionSystem.__r;e.origin.copy(a.origin);e.direction.copy(a.direction);c.multiplyVector3(e.origin);c.rotateAxis(e.direction);e.direction.normalize();return e};
THREE.CollisionSystem.prototype.rayBox=function(a,b){var c;b.dynamic&&b.mesh&&b.mesh.matrixWorld?c=this.makeRayLocal(a,b.mesh):(c=THREE.CollisionSystem.__r,c.origin.copy(a.origin),c.direction.copy(a.direction));var e=0,f=0,h=0,g=0,j=0,k=0,l=!0;c.origin.x<b.min.x?(e=b.min.x-c.origin.x,e/=c.direction.x,l=!1,g=-1):c.origin.x>b.max.x&&(e=b.max.x-c.origin.x,e/=c.direction.x,l=!1,g=1);c.origin.y<b.min.y?(f=b.min.y-c.origin.y,f/=c.direction.y,l=!1,j=-1):c.origin.y>b.max.y&&(f=b.max.y-c.origin.y,f/=c.direction.y,
l=!1,j=1);c.origin.z<b.min.z?(h=b.min.z-c.origin.z,h/=c.direction.z,l=!1,k=-1):c.origin.z>b.max.z&&(h=b.max.z-c.origin.z,h/=c.direction.z,l=!1,k=1);if(l)return-1;l=0;f>e&&(l=1,e=f);h>e&&(l=2,e=h);switch(l){case 0:j=c.origin.y+c.direction.y*e;if(j<b.min.y||j>b.max.y)return Number.MAX_VALUE;c=c.origin.z+c.direction.z*e;if(c<b.min.z||c>b.max.z)return Number.MAX_VALUE;b.normal.set(g,0,0);break;case 1:g=c.origin.x+c.direction.x*e;if(g<b.min.x||g>b.max.x)return Number.MAX_VALUE;c=c.origin.z+c.direction.z*
e;if(c<b.min.z||c>b.max.z)return Number.MAX_VALUE;b.normal.set(0,j,0);break;case 2:g=c.origin.x+c.direction.x*e;if(g<b.min.x||g>b.max.x)return Number.MAX_VALUE;j=c.origin.y+c.direction.y*e;if(j<b.min.y||j>b.max.y)return Number.MAX_VALUE;b.normal.set(0,0,k)}return e};THREE.CollisionSystem.prototype.rayPlane=function(a,b){var c=a.direction.dot(b.normal),e=b.point.dot(b.normal);if(c<0)c=(e-a.origin.dot(b.normal))/c;else return Number.MAX_VALUE;return c>0?c:Number.MAX_VALUE};
THREE.CollisionSystem.prototype.raySphere=function(a,b){var c=b.center.clone().subSelf(a.origin);if(c.lengthSq<b.radiusSq)return-1;var e=c.dot(a.direction.clone());if(e<=0)return Number.MAX_VALUE;c=b.radiusSq-(c.lengthSq()-e*e);if(c>=0)return Math.abs(e)-Math.sqrt(c);return Number.MAX_VALUE};THREE.CollisionSystem.__v1=new THREE.Vector3;THREE.CollisionSystem.__v2=new THREE.Vector3;THREE.CollisionSystem.__v3=new THREE.Vector3;THREE.CollisionSystem.__nr=new THREE.Vector3;THREE.CollisionSystem.__m=new THREE.Matrix4;
THREE.CollisionSystem.__r=new THREE.Ray;THREE.CollisionUtils={};THREE.CollisionUtils.MeshOBB=function(a){a.geometry.computeBoundingBox();var b=a.geometry.boundingBox,c=new THREE.Vector3(b.x[0],b.y[0],b.z[0]),b=new THREE.Vector3(b.x[1],b.y[1],b.z[1]),c=new THREE.BoxCollider(c,b);c.mesh=a;return c};THREE.CollisionUtils.MeshAABB=function(a){var b=THREE.CollisionUtils.MeshOBB(a);b.min.addSelf(a.position);b.max.addSelf(a.position);b.dynamic=!1;return b};
THREE.CollisionUtils.MeshColliderWBox=function(a){return new THREE.MeshCollider(a,THREE.CollisionUtils.MeshOBB(a))};
if(THREE.WebGLRenderer)THREE.AnaglyphWebGLRenderer=function(a){THREE.WebGLRenderer.call(this,a);var b=this,c=this.setSize,e=this.render,f=new THREE.Camera,h=new THREE.Camera,g=new THREE.Matrix4,j=new THREE.Matrix4,k,l,m;f.useTarget=h.useTarget=!1;f.matrixAutoUpdate=h.matrixAutoUpdate=!1;var a={minFilter:THREE.LinearFilter,magFilter:THREE.NearestFilter,format:THREE.RGBAFormat},n=new THREE.WebGLRenderTarget(512,512,a),o=new THREE.WebGLRenderTarget(512,512,a),t=new THREE.Camera(53,1,1,1E4);t.position.z=
2;_material=new THREE.MeshShaderMaterial({uniforms:{mapLeft:{type:"t",value:0,texture:n},mapRight:{type:"t",value:1,texture:o}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D mapLeft;\nuniform sampler2D mapRight;\nvarying vec2 vUv;\nvoid main() {\nvec4 colorL, colorR;\nvec2 uv = vUv;\ncolorL = texture2D( mapLeft, uv );\ncolorR = texture2D( mapRight, uv );\ngl_FragColor = vec4( colorL.g * 0.7 + colorL.b * 0.3, colorR.g, colorR.b, colorL.a + colorR.a ) * 1.1;\n}"});
var v=new THREE.Scene;v.addObject(new THREE.Mesh(new THREE.PlaneGeometry(2,2),_material));this.setSize=function(a,e){c.call(b,a,e);n.width=a;n.height=e;o.width=a;o.height=e};this.render=function(a,c){c.update(null,!0);if(k!==c.aspect||l!==c.near||m!==c.fov){k=c.aspect;l=c.near;m=c.fov;var y=c.projectionMatrix.clone(),x=125/30*0.5,p=x*l/125,z=l*Math.tan(m*Math.PI/360),B;g.n14=x;j.n14=-x;x=-z*k+p;B=z*k+p;y.n11=2*l/(B-x);y.n13=(B+x)/(B-x);f.projectionMatrix=y.clone();x=-z*k-p;B=z*k-p;y.n11=2*l/(B-x);
y.n13=(B+x)/(B-x);h.projectionMatrix=y.clone()}f.matrix=c.matrixWorld.clone().multiplySelf(j);f.update(null,!0);f.position.copy(c.position);f.near=l;f.far=c.far;e.call(b,a,f,n,!0);h.matrix=c.matrixWorld.clone().multiplySelf(g);h.update(null,!0);h.position.copy(c.position);h.near=l;h.far=c.far;e.call(b,a,h,o,!0);e.call(b,v,t)}};
if(THREE.WebGLRenderer)THREE.CrosseyedWebGLRenderer=function(a){THREE.WebGLRenderer.call(this,a);this.autoClear=!1;var b=this,c=this.setSize,e=this.render,f,h,g=new THREE.Camera,j=new THREE.Camera;b.separation=10;if(a&&a.separation!==void 0)b.separation=a.separation;(new THREE.Camera(53,window.innerWidth/2/window.innerHeight,1,1E4)).position.z=-10;this.setSize=function(a,e){c.call(b,a,e);f=a/2;h=e};this.render=function(a,c){this.clear();g.fov=c.fov;g.aspect=0.5*c.aspect;g.near=c.near;g.far=c.far;
g.updateProjectionMatrix();g.position.copy(c.position);g.target.position.copy(c.target.position);g.translateX(b.separation);j.projectionMatrix=g.projectionMatrix;j.position.copy(c.position);j.target.position.copy(c.target.position);j.translateX(-b.separation);this.setViewport(0,0,f,h);e.call(b,a,g);this.setViewport(f,0,f,h);e.call(b,a,j,!1)}};
