// ThreeExtras.js r41/ROME - http://github.com/mrdoob/three.js
THREE.ColorUtils={adjustHSV:function(a,b,c,d){var e=THREE.ColorUtils.__hsv;THREE.ColorUtils.rgbToHsv(a,e);e.h=THREE.ColorUtils.clamp(e.h+b,0,1);e.s=THREE.ColorUtils.clamp(e.s+c,0,1);e.v=THREE.ColorUtils.clamp(e.v+d,0,1);a.setHSV(e.h,e.s,e.v)},rgbToHsv:function(a,b){var c=a.r,d=a.g,e=a.b,f=Math.max(Math.max(c,d),e),g=Math.min(Math.min(c,d),e);if(g==f)g=c=0;else{var j=f-g,g=j/f,c=c==f?(d-e)/j:d==f?2+(e-c)/j:4+(c-d)/j;c/=6;c<0&&(c+=1);c>1&&(c-=1)}b===void 0&&(b={h:0,s:0,v:0});b.h=c;b.s=g;b.v=f;return b},
clamp:function(a,b,c){return a<b?b:a>c?c:a}};THREE.ColorUtils.__hsv={h:0,s:0,v:0};
var GeometryUtils={merge:function(a,b){var c=b instanceof THREE.Mesh,d=a.vertices.length,e=c?b.geometry:b,f=a.vertices,g=e.vertices,j=a.faces,h=e.faces,l=a.faceVertexUvs[0],e=e.faceVertexUvs[0];c&&b.matrixAutoUpdate&&b.updateMatrix();for(var k=0,n=g.length;k<n;k++){var p=new THREE.Vertex(g[k].position.clone());c&&b.matrix.multiplyVector3(p.position);f.push(p)}k=0;for(n=h.length;k<n;k++){var g=h[k],o,t,v=g.vertexNormals,p=g.vertexColors;g instanceof THREE.Face3?o=new THREE.Face3(g.a+d,g.b+d,g.c+d):
g instanceof THREE.Face4&&(o=new THREE.Face4(g.a+d,g.b+d,g.c+d,g.d+d));o.normal.copy(g.normal);c=0;for(f=v.length;c<f;c++)t=v[c],o.vertexNormals.push(t.clone());o.color.copy(g.color);c=0;for(f=p.length;c<f;c++)t=p[c],o.vertexColors.push(t.clone());o.materials=g.materials.slice();o.centroid.copy(g.centroid);j.push(o)}k=0;for(n=e.length;k<n;k++){d=e[k];j=[];c=0;for(f=d.length;c<f;c++)j.push(new THREE.UV(d[c].u,d[c].v));l.push(j)}}};
THREE.ImageUtils={loadTexture:function(a,b,c){var d=new Image,e=new THREE.Texture(d,b);d.onload=function(){e.needsUpdate=!0;c&&c(this)};d.src=a;return e},loadTextureCube:function(a,b,c){var d,e=[],f=new THREE.Texture(e,b),b=e.loadCount=0;for(d=a.length;b<d;++b)e[b]=new Image,e[b].onload=function(){e.loadCount+=1;if(e.loadCount==6)f.needsUpdate=!0;c&&c(this)},e[b].src=a[b];return f}};
THREE.SceneUtils={addMesh:function(a,b,c,d,e,f,g,j,h,l){b=new THREE.Mesh(b,l);b.scale.x=b.scale.y=b.scale.z=c;b.position.x=d;b.position.y=e;b.position.z=f;b.rotation.x=g;b.rotation.y=j;b.rotation.z=h;a.addObject(b);return b},addPanoramaCubeWebGL:function(a,b,c){var d=THREE.ShaderUtils.lib.cube;d.uniforms.tCube.texture=c;c=new THREE.MeshShaderMaterial({fragmentShader:d.fragmentShader,vertexShader:d.vertexShader,uniforms:d.uniforms});b=new THREE.Mesh(new THREE.Cube(b,b,b,1,1,1,null,!0),c);a.addObject(b);
return b},addPanoramaCube:function(a,b,c){var d=[];d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[0])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[1])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[2])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[3])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[4])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(c[5])}));b=new THREE.Mesh(new THREE.Cube(b,b,b,1,1,d,!0),
new THREE.MeshFaceMaterial);a.addObject(b);return b},addPanoramaCubePlanes:function(a,b,c){var d=b/2,b=new THREE.Plane(b,b),e=Math.PI,f=Math.PI/2;THREE.SceneUtils.addMesh(a,b,1,0,0,-d,0,0,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[5])}));THREE.SceneUtils.addMesh(a,b,1,-d,0,0,0,f,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[0])}));THREE.SceneUtils.addMesh(a,b,1,d,0,0,0,-f,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[1])}));THREE.SceneUtils.addMesh(a,b,1,0,d,0,f,0,e,
new THREE.MeshBasicMaterial({map:new THREE.Texture(c[2])}));THREE.SceneUtils.addMesh(a,b,1,0,-d,0,-f,0,e,new THREE.MeshBasicMaterial({map:new THREE.Texture(c[3])}))},showHierarchy:function(a,b){THREE.SceneUtils.traverseHierarchy(a,function(a){a.visible=b})},traverseHierarchy:function(a,b){var c,d,e=a.children.length;for(d=0;d<e;d++)c=a.children[d],b(c),THREE.SceneUtils.traverseHierarchy(c,b)}};
THREE.ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},enableSpecular:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tSpecular:{type:"t",value:3,texture:null},tAO:{type:"t",value:4,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:5,texture:null},uDisplacementBias:{type:"f",value:-0.5},uDisplacementScale:{type:"f",value:2.5},uPointLightPos:{type:"v3",value:new THREE.Vector3},uPointLightColor:{type:"c",
value:new THREE.Color(15658734)},uDirLightPos:{type:"v3",value:new THREE.Vector3},uDirLightColor:{type:"c",value:new THREE.Color(15658734)},uAmbientLightColor:{type:"c",value:new THREE.Color(328965)},uDiffuseColor:{type:"c",value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30}},fragmentShader:"uniform vec3 uDirLightPos;\nuniform vec3 uAmbientLightColor;\nuniform vec3 uDirLightColor;\nuniform vec3 uPointLightColor;\nuniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform bool enableDiffuse;\nuniform bool enableSpecular;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tSpecular;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 diffuseTex = vec3( 1.0, 1.0, 1.0 );\nvec3 aoTex = vec3( 1.0, 1.0, 1.0 );\nvec3 specularTex = vec3( 1.0, 1.0, 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ndiffuseTex = texture2D( tDiffuse, vUv ).xyz;\nif( enableAO )\naoTex = texture2D( tAO, vUv ).xyz;\nif( enableSpecular )\nspecularTex = texture2D( tSpecular, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 pointDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 pointSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec3 pointVector = normalize( vPointLightVector );\nvec3 pointHalfVector = normalize( vPointLightVector + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = specularTex.r * pow( pointDotNormalHalf, uShininess );\npointDiffuse  += vec4( uDiffuseColor, 1.0 ) * pointDiffuseWeight;\npointSpecular += vec4( uSpecularColor, 1.0 ) * pointSpecularWeight * pointDiffuseWeight;\nvec4 dirDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 dirSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 lDirection = viewMatrix * vec4( uDirLightPos, 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = specularTex.r * pow( dirDotNormalHalf, uShininess );\ndirDiffuse  += vec4( uDiffuseColor, 1.0 ) * dirDiffuseWeight;\ndirSpecular += vec4( uSpecularColor, 1.0 ) * dirSpecularWeight * dirDiffuseWeight;\nvec4 totalLight = vec4( uAmbientLightColor * uAmbientColor, 1.0 );\ntotalLight += vec4( uDirLightColor, 1.0 ) * ( dirDiffuse + dirSpecular );\ntotalLight += vec4( uPointLightColor, 1.0 ) * ( pointDiffuse + pointSpecular );\ngl_FragColor = vec4( totalLight.xyz * aoTex * diffuseTex, 1.0 );\n}",
vertexShader:"attribute vec4 tangent;\nuniform vec3 uPointLightPos;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\nvec4 lPosition = viewMatrix * vec4( uPointLightPos, 1.0 );\nvPointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"},convolution:{uniforms:{tDiffuse:{type:"t",
value:0,texture:null},uImageIncrement:{type:"v2",value:new THREE.Vector2(0.001953125,0)},cKernel:{type:"fv1",value:[]}},vertexShader:"varying vec2 vUv;\nuniform vec2 uImageIncrement;\nvoid main(void) {\nvUv = uv - ((KERNEL_SIZE - 1.0) / 2.0) * uImageIncrement;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform vec2 uImageIncrement;\nuniform float cKernel[KERNEL_SIZE];\nvoid main(void) {\nvec2 imageCoord = vUv;\nvec4 sum = vec4( 0.0, 0.0, 0.0, 0.0 );\nfor( int i=0; i<KERNEL_SIZE; ++i ) {\nsum += texture2D( tDiffuse, imageCoord ) * cKernel[i];\nimageCoord += uImageIncrement;\n}\ngl_FragColor = sum;\n}"},
film:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},time:{type:"f",value:0},nIntensity:{type:"f",value:0.5},sIntensity:{type:"f",value:0.05},sCount:{type:"f",value:4096},grayscale:{type:"i",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float time;\nuniform bool grayscale;\nuniform float nIntensity;\nuniform float sIntensity;\nuniform float sCount;\nvoid main() {\nvec4 cTextureScreen = texture2D( tDiffuse, vUv );\nfloat x = vUv.x * vUv.y * time *  1000.0;\nx = mod( x, 13.0 ) * mod( x, 123.0 );\nfloat dx = mod( x, 0.01 );\nvec3 cResult = cTextureScreen.rgb + cTextureScreen.rgb * clamp( 0.1 + dx * 100.0, 0.0, 1.0 );\nvec2 sc = vec2( sin( vUv.y * sCount ), cos( vUv.y * sCount ) );\ncResult += cTextureScreen.rgb * vec3( sc.x, sc.y, sc.x ) * sIntensity;\ncResult = cTextureScreen.rgb + clamp( nIntensity, 0.0,1.0 ) * ( cResult - cTextureScreen.rgb );\nif( grayscale ) {\ncResult = vec3( cResult.r * 0.3 + cResult.g * 0.59 + cResult.b * 0.11 );\n}\ngl_FragColor =  vec4( cResult, cTextureScreen.a );\n}"},
screen:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},opacity:{type:"f",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float opacity;\nvoid main() {\nvec4 texel = texture2D( tDiffuse, vUv );\ngl_FragColor = opacity * texel;\n}"},basic:{uniforms:{},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0, 0.0, 0.0, 0.5 );\n}"}},buildKernel:function(a){var b,c,d,e,f=2*Math.ceil(a*3)+1;f>25&&(f=25);e=(f-1)*0.5;c=Array(f);for(b=d=0;b<f;++b)c[b]=Math.exp(-((b-e)*(b-e))/(2*a*a)),d+=c[b];for(b=0;b<f;++b)c[b]/=d;return c}};
THREE.AnimationHandler=function(){var a=[],b={},c={update:function(c){for(var b=0;b<a.length;b++)a[b].update(c)},addToUpdate:function(c){a.indexOf(c)===-1&&a.push(c)},removeFromUpdate:function(c){c=a.indexOf(c);c!==-1&&a.splice(c,1)},add:function(a){b[a.name]!==void 0&&console.log("THREE.AnimationHandler.add: Warning! "+a.name+" already exists in library. Overwriting.");b[a.name]=a;if(a.initialized!==!0){for(var c=0;c<a.hierarchy.length;c++){for(var d=0;d<a.hierarchy[c].keys.length;d++){if(a.hierarchy[c].keys[d].time<
0)a.hierarchy[c].keys[d].time=0;if(a.hierarchy[c].keys[d].rot!==void 0&&!(a.hierarchy[c].keys[d].rot instanceof THREE.Quaternion)){var j=a.hierarchy[c].keys[d].rot;a.hierarchy[c].keys[d].rot=new THREE.Quaternion(j[0],j[1],j[2],j[3])}}if(a.hierarchy[c].keys[0].morphTargets!==void 0){j={};for(d=0;d<a.hierarchy[c].keys.length;d++)for(var h=0;h<a.hierarchy[c].keys[d].morphTargets.length;h++){var l=a.hierarchy[c].keys[d].morphTargets[h];j[l]=-1}a.hierarchy[c].usedMorphTargets=j;for(d=0;d<a.hierarchy[c].keys.length;d++){var k=
{};for(l in j){for(h=0;h<a.hierarchy[c].keys[d].morphTargets.length;h++)if(a.hierarchy[c].keys[d].morphTargets[h]===l){k[l]=a.hierarchy[c].keys[d].morphTargetsInfluences[h];break}h===a.hierarchy[c].keys[d].morphTargets.length&&(k[l]=0)}a.hierarchy[c].keys[d].morphTargetsInfluences=k}}for(d=1;d<a.hierarchy[c].keys.length;d++)a.hierarchy[c].keys[d].time===a.hierarchy[c].keys[d-1].time&&(a.hierarchy[c].keys.splice(d,1),d--);for(d=1;d<a.hierarchy[c].keys.length;d++)a.hierarchy[c].keys[d].index=d}d=parseInt(a.length*
a.fps,10);a.JIT={};a.JIT.hierarchy=[];for(c=0;c<a.hierarchy.length;c++)a.JIT.hierarchy.push(Array(d));a.initialized=!0}},get:function(a){if(typeof a==="string")return b[a]?b[a]:(console.log("THREE.AnimationHandler.get: Couldn't find animation "+a),null)},parse:function(a){var c=[];if(a instanceof THREE.SkinnedMesh)for(var b=0;b<a.bones.length;b++)c.push(a.bones[b]);else d(a,c);return c}},d=function(a,c){c.push(a);for(var b=0;b<a.children.length;b++)d(a.children[b],c)};c.LINEAR=0;c.CATMULLROM=1;c.CATMULLROM_FORWARD=
2;return c}();THREE.Animation=function(a,b,c,d){this.root=a;this.data=THREE.AnimationHandler.get(b);this.hierarchy=THREE.AnimationHandler.parse(a);this.currentTime=0;this.timeScale=1;this.isPlaying=!1;this.loop=this.isPaused=!0;this.interpolationType=c!==void 0?c:THREE.AnimationHandler.LINEAR;this.JITCompile=d!==void 0?d:!0;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(a,b){if(!this.isPlaying){this.isPlaying=!0;this.loop=a!==void 0?a:!0;this.currentTime=b!==void 0?b:0;var c,d=this.hierarchy.length,e;for(c=0;c<d;c++){e=this.hierarchy[c];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)e.useQuaternion=!0;e.matrixAutoUpdate=!0;if(e.animationCache===void 0)e.animationCache={},e.animationCache.prevKey={pos:0,rot:0,scl:0},e.animationCache.nextKey={pos:0,rot:0,scl:0},e.animationCache.originalMatrix=e instanceof
THREE.Bone?e.skinMatrix:e.matrix;var f=e.animationCache.prevKey;e=e.animationCache.nextKey;f.pos=this.data.hierarchy[c].keys[0];f.rot=this.data.hierarchy[c].keys[0];f.scl=this.data.hierarchy[c].keys[0];e.pos=this.getNextKeyWith("pos",c,1);e.rot=this.getNextKeyWith("rot",c,1);e.scl=this.getNextKeyWith("scl",c,1)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPaused=this.isPlaying=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var a=0;a<this.hierarchy.length;a++)if(this.hierarchy[a].animationCache!==void 0)this.hierarchy[a]instanceof THREE.Bone?this.hierarchy[a].skinMatrix=this.hierarchy[a].animationCache.originalMatrix:this.hierarchy[a].matrix=this.hierarchy[a].animationCache.originalMatrix,delete this.hierarchy[a].animationCache};
THREE.Animation.prototype.update=function(a){if(this.isPlaying){var b=["pos","rot","scl"],c,d,e,f,g,j,h,l,k=this.data.JIT.hierarchy,n,p;this.currentTime+=a*this.timeScale;p=this.currentTime;n=this.currentTime%=this.data.length;l=parseInt(Math.min(n*this.data.fps,this.data.length*this.data.fps),10);for(var o=0,t=this.hierarchy.length;o<t;o++)if(a=this.hierarchy[o],h=a.animationCache,this.JITCompile&&k[o][l]!==void 0)a instanceof THREE.Bone?(a.skinMatrix=k[o][l],a.matrixAutoUpdate=!1,a.matrixWorldNeedsUpdate=
!1):(a.matrix=k[o][l],a.matrixAutoUpdate=!1,a.matrixWorldNeedsUpdate=!0);else{if(this.JITCompile)a instanceof THREE.Bone?a.skinMatrix=a.animationCache.originalMatrix:a.matrix=a.animationCache.originalMatrix;for(var v=0;v<3;v++){c=b[v];g=h.prevKey[c];j=h.nextKey[c];if(j.time<=p){if(n<p)if(this.loop){g=this.data.hierarchy[o].keys[0];for(j=this.getNextKeyWith(c,o,1);j.time<n;)g=j,j=this.getNextKeyWith(c,o,j.index+1)}else{this.stop();return}else{do g=j,j=this.getNextKeyWith(c,o,j.index+1);while(j.time<
n)}h.prevKey[c]=g;h.nextKey[c]=j}a.matrixAutoUpdate=!0;a.matrixWorldNeedsUpdate=!0;d=(n-g.time)/(j.time-g.time);e=g[c];f=j[c];if(d<0||d>1)console.log("THREE.Animation.update: Warning! Scale out of bounds:"+d+" on bone "+o),d=d<0?0:1;if(c==="pos")if(c=a.position,this.interpolationType===THREE.AnimationHandler.LINEAR)c.x=e[0]+(f[0]-e[0])*d,c.y=e[1]+(f[1]-e[1])*d,c.z=e[2]+(f[2]-e[2])*d;else{if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)if(this.points[0]=
this.getPrevKeyWith("pos",o,g.index-1).pos,this.points[1]=e,this.points[2]=f,this.points[3]=this.getNextKeyWith("pos",o,j.index+1).pos,d=d*0.33+0.33,e=this.interpolateCatmullRom(this.points,d),c.x=e[0],c.y=e[1],c.z=e[2],this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)d=this.interpolateCatmullRom(this.points,d*1.01),this.target.set(d[0],d[1],d[2]),this.target.subSelf(c),this.target.y=0,this.target.normalize(),d=Math.atan2(this.target.x,this.target.z),a.rotation.set(0,d,0)}else if(c===
"rot")THREE.Quaternion.slerp(e,f,a.quaternion,d);else if(c==="scl")c=a.scale,c.x=e[0]+(f[0]-e[0])*d,c.y=e[1]+(f[1]-e[1])*d,c.z=e[2]+(f[2]-e[2])*d}}if(this.JITCompile&&k[0][l]===void 0){this.hierarchy[0].update(void 0,!0);for(o=0;o<this.hierarchy.length;o++)k[o][l]=this.hierarchy[o]instanceof THREE.Bone?this.hierarchy[o].skinMatrix.clone():this.hierarchy[o].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(a,b){var c=[],d=[],e,f,g,j,h,l;e=(a.length-1)*b;f=Math.floor(e);e-=f;c[0]=f==0?f:f-1;c[1]=f;c[2]=f>a.length-2?f:f+1;c[3]=f>a.length-3?f:f+2;f=a[c[0]];j=a[c[1]];h=a[c[2]];l=a[c[3]];c=e*e;g=e*c;d[0]=this.interpolate(f[0],j[0],h[0],l[0],e,c,g);d[1]=this.interpolate(f[1],j[1],h[1],l[1],e,c,g);d[2]=this.interpolate(f[2],j[2],h[2],l[2],e,c,g);return d};
THREE.Animation.prototype.interpolate=function(a,b,c,d,e,f,g){a=(c-a)*0.5;d=(d-b)*0.5;return(2*(b-c)+a+d)*g+(-3*(b-c)-2*a-d)*f+a*e+b};THREE.Animation.prototype.getNextKeyWith=function(a,b,c){var d=this.data.hierarchy[b].keys;for(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?c=c<d.length-1?c:d.length-1:c%=d.length;c<d.length;c++)if(d[c][a]!==void 0)return d[c];return this.data.hierarchy[b].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(a,b,c){for(var d=this.data.hierarchy[b].keys,c=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?c>0?c:0:c>=0?c:c+d.length;c>=0;c--)if(d[c][a]!==void 0)return d[c];return this.data.hierarchy[b].keys[d.length-1]};
THREE.QuakeCamera=function(a){function b(a,d){return function(){d.apply(a,arguments)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.movementSpeed=1;this.lookSpeed=0.005;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.activeLook=!0;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.constrainVertical=!1;this.verticalMin=0;this.verticalMax=3.14;this.domElement=document;this.lastUpdate=(new Date).getTime();this.tdiff=0;if(a){if(a.movementSpeed!==void 0)this.movementSpeed=
a.movementSpeed;if(a.lookSpeed!==void 0)this.lookSpeed=a.lookSpeed;if(a.noFly!==void 0)this.noFly=a.noFly;if(a.lookVertical!==void 0)this.lookVertical=a.lookVertical;if(a.autoForward!==void 0)this.autoForward=a.autoForward;if(a.activeLook!==void 0)this.activeLook=a.activeLook;if(a.heightSpeed!==void 0)this.heightSpeed=a.heightSpeed;if(a.heightCoef!==void 0)this.heightCoef=a.heightCoef;if(a.heightMin!==void 0)this.heightMin=a.heightMin;if(a.heightMax!==void 0)this.heightMax=a.heightMax;if(a.constrainVertical!==
void 0)this.constrainVertical=a.constrainVertical;if(a.verticalMin!==void 0)this.verticalMin=a.verticalMin;if(a.verticalMax!==void 0)this.verticalMax=a.verticalMax;if(a.domElement!==void 0)this.domElement=a.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=this.autoSpeedFactor=0;this.mouseDragOn=this.freeze=this.moveRight=this.moveLeft=this.moveBackward=this.moveForward=!1;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;this.onMouseDown=function(a){a.preventDefault();
a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}this.mouseDragOn=!0};this.onMouseUp=function(a){a.preventDefault();a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.mouseDragOn=!1};this.onMouseMove=function(a){this.mouseX=a.clientX-this.windowHalfX;this.mouseY=a.clientY-this.windowHalfY};this.onKeyDown=function(a){switch(a.keyCode){case 38:case 87:this.moveForward=
!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0;break;case 81:this.freeze=!this.freeze}};this.onKeyUp=function(a){switch(a.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=!1;break;case 39:case 68:this.moveRight=!1}};this.update=function(){var a=(new Date).getTime();this.tdiff=(a-this.lastUpdate)/1E3;this.lastUpdate=a;if(!this.freeze){this.autoSpeedFactor=
this.heightSpeed?this.tdiff*((this.position.y<this.heightMin?this.heightMin:this.position.y>this.heightMax?this.heightMax:this.position.y)-this.heightMin)*this.heightCoef:0;var d=this.tdiff*this.movementSpeed;(this.moveForward||this.autoForward&&!this.moveBackward)&&this.translateZ(-(d+this.autoSpeedFactor));this.moveBackward&&this.translateZ(d);this.moveLeft&&this.translateX(-d);this.moveRight&&this.translateX(d);d=this.tdiff*this.lookSpeed;this.activeLook||(d=0);this.lon+=this.mouseX*d;this.lookVertical&&
(this.lat-=this.mouseY*d);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;var a=this.target.position,b=this.position;a.x=b.x+100*Math.sin(this.phi)*Math.cos(this.theta);a.y=b.y+100*Math.cos(this.phi);a.z=b.z+100*Math.sin(this.phi)*Math.sin(this.theta)}this.lon+=this.mouseX*d;this.lookVertical&&(this.lat-=this.mouseY*d);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;if(this.constrainVertical)this.phi=
(this.phi-0)*(this.verticalMax-this.verticalMin)/3.14+this.verticalMin;a=this.target.position;b=this.position;a.x=b.x+100*Math.sin(this.phi)*Math.cos(this.theta);a.y=b.y+100*Math.cos(this.phi);a.z=b.z+100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this)};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",b(this,this.onMouseMove),!1);this.domElement.addEventListener("mousedown",b(this,this.onMouseDown),
!1);this.domElement.addEventListener("mouseup",b(this,this.onMouseUp),!1);this.domElement.addEventListener("keydown",b(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",b(this,this.onKeyUp),!1)};THREE.QuakeCamera.prototype=new THREE.Camera;THREE.QuakeCamera.prototype.constructor=THREE.QuakeCamera;THREE.QuakeCamera.prototype.supr=THREE.Camera.prototype;
THREE.QuakeCamera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);if(this.noFly)b.y=0;this.position.addSelf(b.multiplyScalar(a));this.target.position.addSelf(b.multiplyScalar(a))};
THREE.PathCamera=function(a){function b(a,c,d,b){var f={name:d,fps:0.6,length:b,hierarchy:[]},g,e=c.getControlPointsArray(),j=c.getLength(),h=e.length,w=0;g=h-1;c={parent:-1,keys:[]};c.keys[0]={time:0,pos:e[0],rot:[0,0,0,1],scl:[1,1,1]};c.keys[g]={time:b,pos:e[g],rot:[0,0,0,1],scl:[1,1,1]};for(g=1;g<h-1;g++)w=b*j.chunks[g]/j.total,c.keys[g]={time:w,pos:e[g]};f.hierarchy[0]=c;THREE.AnimationHandler.add(f);return new THREE.Animation(a,d,THREE.AnimationHandler.CATMULLROM_FORWARD,!1)}function c(a,c){var d,
b,f=new THREE.Geometry;for(d=0;d<a.points.length*c;d++)b=d/(a.points.length*c),b=a.getPoint(b),f.vertices[d]=new THREE.Vertex(new THREE.Vector3(b.x,b.y,b.z));return f}function d(a,d){var b=c(d,10),f=c(d,10),g=new THREE.LineBasicMaterial({color:16711680,linewidth:3});lineObj=new THREE.Line(b,g);particleObj=new THREE.ParticleSystem(f,new THREE.ParticleBasicMaterial({color:16755200,size:3}));lineObj.scale.set(1,1,1);a.addChild(lineObj);particleObj.scale.set(1,1,1);a.addChild(particleObj);f=new THREE.Sphere(1,
16,8);g=new THREE.MeshBasicMaterial({color:65280});for(i=0;i<d.points.length;i++)b=new THREE.Mesh(f,g),b.position.copy(d.points[i]),b.updateMatrix(),a.addChild(b)}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.id="PathCamera"+THREE.PathCameraIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=!0;this.resamplingCoef=50;this.debugPath=new THREE.Object3D;this.debugDummy=new THREE.Object3D;this.animationParent=new THREE.Object3D;this.lookSpeed=0.005;this.lookHorizontal=
this.lookVertical=!0;this.verticalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.horizontalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.domElement=document;if(a){if(a.duration!==void 0)this.duration=a.duration*1E3;if(a.waypoints!==void 0)this.waypoints=a.waypoints;if(a.useConstantSpeed!==void 0)this.useConstantSpeed=a.useConstantSpeed;if(a.resamplingCoef!==void 0)this.resamplingCoef=a.resamplingCoef;if(a.createDebugPath!==void 0)this.createDebugPath=a.createDebugPath;if(a.createDebugDummy!==
void 0)this.createDebugDummy=a.createDebugDummy;if(a.lookSpeed!==void 0)this.lookSpeed=a.lookSpeed;if(a.lookVertical!==void 0)this.lookVertical=a.lookVertical;if(a.lookHorizontal!==void 0)this.lookHorizontal=a.lookHorizontal;if(a.verticalAngleMap!==void 0)this.verticalAngleMap=a.verticalAngleMap;if(a.horizontalAngleMap!==void 0)this.horizontalAngleMap=a.horizontalAngleMap;if(a.domElement!==void 0)this.domElement=a.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=0;this.windowHalfX=
window.innerWidth/2;this.windowHalfY=window.innerHeight/2;var e=Math.PI*2,f=Math.PI/180;this.update=function(a,c,d){var b,g;this.lookHorizontal&&(this.lon+=this.mouseX*this.lookSpeed);this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed);this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*f;this.theta=this.lon*f;b=this.phi%e;this.phi=b>=0?b:b+e;b=this.verticalAngleMap.srcRange;g=this.verticalAngleMap.dstRange;var j=g[1]-g[0];this.phi=
TWEEN.Easing.Quadratic.EaseInOut(((this.phi-b[0])*(g[1]-g[0])/(b[1]-b[0])+g[0]-g[0])/j)*j+g[0];b=this.horizontalAngleMap.srcRange;g=this.horizontalAngleMap.dstRange;j=g[1]-g[0];this.theta=TWEEN.Easing.Quadratic.EaseInOut(((this.theta-b[0])*(g[1]-g[0])/(b[1]-b[0])+g[0]-g[0])/j)*j+g[0];b=this.target.position;b.x=100*Math.sin(this.phi)*Math.cos(this.theta);b.y=100*Math.cos(this.phi);b.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this,a,c,d)};this.onMouseMove=function(a){this.mouseX=
a.clientX-this.windowHalfX;this.mouseY=a.clientY-this.windowHalfY};this.spline=new THREE.Spline;this.spline.initFromArray(this.waypoints);this.useConstantSpeed&&this.spline.reparametrizeByArcLength(this.resamplingCoef);if(this.createDebugDummy){var a=new THREE.MeshLambertMaterial({color:30719}),g=new THREE.MeshLambertMaterial({color:65280}),j=new THREE.Cube(10,10,20),h=new THREE.Cube(2,2,10);this.animationParent=new THREE.Mesh(j,a);a=new THREE.Mesh(h,g);a.position.set(0,10,0);this.animation=b(this.animationParent,
this.spline,this.id,this.duration);this.animationParent.addChild(this);this.animationParent.addChild(this.target);this.animationParent.addChild(a)}else this.animation=b(this.animationParent,this.spline,this.id,this.duration),this.animationParent.addChild(this.target),this.animationParent.addChild(this);this.createDebugPath&&d(this.debugPath,this.spline);this.domElement.addEventListener("mousemove",function(a,c){return function(){c.apply(a,arguments)}}(this,this.onMouseMove),!1)};
THREE.PathCamera.prototype=new THREE.Camera;THREE.PathCamera.prototype.constructor=THREE.PathCamera;THREE.PathCamera.prototype.supr=THREE.Camera.prototype;THREE.PathCameraIdCounter=0;
THREE.FlyCamera=function(a){function b(a,b){return function(){b.apply(a,arguments)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.tmpQuaternion=new THREE.Quaternion;this.movementSpeed=1;this.rollSpeed=0.005;this.autoForward=this.dragToLook=!1;this.domElement=document;if(a){if(a.movementSpeed!==void 0)this.movementSpeed=a.movementSpeed;if(a.rollSpeed!==void 0)this.rollSpeed=a.rollSpeed;if(a.dragToLook!==void 0)this.dragToLook=a.dragToLook;if(a.autoForward!==void 0)this.autoForward=
a.autoForward;if(a.domElement!==void 0)this.domElement=a.domElement}this.useTarget=!1;this.useQuaternion=!0;this.mouseStatus=0;this.moveState={up:0,down:0,left:0,right:0,forward:0,back:0,pitchUp:0,pitchDown:0,yawLeft:0,yawRight:0,rollLeft:0,rollRight:0};this.moveVector=new THREE.Vector3(0,0,0);this.rotationVector=new THREE.Vector3(0,0,0);this.lastUpdate=-1;this.tdiff=0;this.handleEvent=function(a){if(typeof this[a.type]=="function")this[a.type](a)};this.keydown=function(a){if(!a.altKey){switch(a.keyCode){case 16:this.movementSpeedMultiplier=
0.1;break;case 87:this.moveState.forward=1;break;case 83:this.moveState.back=1;break;case 65:this.moveState.left=1;break;case 68:this.moveState.right=1;break;case 82:this.moveState.up=1;break;case 70:this.moveState.down=1;break;case 38:this.moveState.pitchUp=1;break;case 40:this.moveState.pitchDown=1;break;case 37:this.moveState.yawLeft=1;break;case 39:this.moveState.yawRight=1;break;case 81:this.moveState.rollLeft=1;break;case 69:this.moveState.rollRight=1}this.updateMovementVector();this.updateRotationVector()}};
this.keyup=function(a){switch(a.keyCode){case 16:this.movementSpeedMultiplier=1;break;case 87:this.moveState.forward=0;break;case 83:this.moveState.back=0;break;case 65:this.moveState.left=0;break;case 68:this.moveState.right=0;break;case 82:this.moveState.up=0;break;case 70:this.moveState.down=0;break;case 38:this.moveState.pitchUp=0;break;case 40:this.moveState.pitchDown=0;break;case 37:this.moveState.yawLeft=0;break;case 39:this.moveState.yawRight=0;break;case 81:this.moveState.rollLeft=0;break;
case 69:this.moveState.rollRight=0}this.updateMovementVector();this.updateRotationVector()};this.mousedown=function(a){a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus++;else switch(a.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}};this.mousemove=function(a){if(!this.dragToLook||this.mouseStatus>0){var b=this.getContainerDimensions(),e=b.size[0]/2,f=b.size[1]/2;this.moveState.yawLeft=-(a.clientX-b.offset[0]-e)/e;this.moveState.pitchDown=(a.clientY-
b.offset[1]-f)/f;this.updateRotationVector()}};this.mouseup=function(a){a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus--,this.moveState.yawLeft=this.moveState.pitchDown=0;else switch(a.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.updateRotationVector()};this.update=function(){var a=(new Date).getTime();if(this.lastUpdate==-1)this.lastUpdate=a;this.tdiff=(a-this.lastUpdate)/1E3;this.lastUpdate=a;var a=this.tdiff*this.movementSpeed,b=this.tdiff*
this.rollSpeed;this.translateX(this.moveVector.x*a);this.translateY(this.moveVector.y*a);this.translateZ(this.moveVector.z*a);this.tmpQuaternion.set(this.rotationVector.x*b,this.rotationVector.y*b,this.rotationVector.z*b,1).normalize();this.quaternion.multiplySelf(this.tmpQuaternion);this.matrix.setPosition(this.position);this.matrix.setRotationFromQuaternion(this.quaternion);this.matrixWorldNeedsUpdate=!0;this.supr.update.call(this)};this.updateMovementVector=function(){var a=this.moveState.forward||
this.autoForward&&!this.moveState.back?1:0;this.moveVector.x=-this.moveState.left+this.moveState.right;this.moveVector.y=-this.moveState.down+this.moveState.up;this.moveVector.z=-a+this.moveState.back};this.updateRotationVector=function(){this.rotationVector.x=-this.moveState.pitchDown+this.moveState.pitchUp;this.rotationVector.y=-this.moveState.yawRight+this.moveState.yawLeft;this.rotationVector.z=-this.moveState.rollRight+this.moveState.rollLeft};this.getContainerDimensions=function(){return this.domElement!=
document?{size:[this.domElement.offsetWidth,this.domElement.offsetHeight],offset:[this.domElement.offsetLeft,this.domElement.offsetTop]}:{size:[window.innerWidth,window.innerHeight],offset:[0,0]}};this.domElement.addEventListener("mousemove",b(this,this.mousemove),!1);this.domElement.addEventListener("mousedown",b(this,this.mousedown),!1);this.domElement.addEventListener("mouseup",b(this,this.mouseup),!1);window.addEventListener("keydown",b(this,this.keydown),!1);window.addEventListener("keyup",b(this,
this.keyup),!1);this.updateMovementVector();this.updateRotationVector()};THREE.FlyCamera.prototype=new THREE.Camera;THREE.FlyCamera.prototype.constructor=THREE.FlyCamera;THREE.FlyCamera.prototype.supr=THREE.Camera.prototype;
THREE.RollCamera=function(a,b,c,d){THREE.Camera.call(this,a,b,c,d);this.mouseLook=!0;this.autoForward=!1;this.rollSpeed=this.movementSpeed=this.lookSpeed=1;this.constrainVertical=[-0.9,0.9];this.domElement=document;this.matrixAutoUpdate=this.useTarget=!1;this.forward=new THREE.Vector3(0,0,1);this.roll=0;this.lastUpdate=-1;this.delta=0;var e=new THREE.Vector3,f=new THREE.Vector3,g=new THREE.Vector3,j=new THREE.Matrix4,h=!1,l=1,k=0,n=0,p=0,o=0,t=0,v=window.innerWidth/2,u=window.innerHeight/2;this.update=
function(){var a=(new Date).getTime();if(this.lastUpdate==-1)this.lastUpdate=a;this.delta=(a-this.lastUpdate)/1E3;this.lastUpdate=a;this.mouseLook&&(a=this.delta*this.lookSpeed,this.rotateHorizontally(a*o),this.rotateVertically(a*t));a=this.delta*this.movementSpeed;this.translateZ(a*(k>0||this.autoForward&&!(k<0)?1:k));this.translateX(a*n);this.translateY(a*p);h&&(this.roll+=this.rollSpeed*this.delta*l);if(this.forward.y>this.constrainVertical[1])this.forward.y=this.constrainVertical[1],this.forward.normalize();
else if(this.forward.y<this.constrainVertical[0])this.forward.y=this.constrainVertical[0],this.forward.normalize();g.copy(this.forward);f.set(0,1,0);e.cross(f,g).normalize();f.cross(g,e).normalize();this.matrix.n11=e.x;this.matrix.n12=f.x;this.matrix.n13=g.x;this.matrix.n21=e.y;this.matrix.n22=f.y;this.matrix.n23=g.y;this.matrix.n31=e.z;this.matrix.n32=f.z;this.matrix.n33=g.z;j.identity();j.n11=Math.cos(this.roll);j.n12=-Math.sin(this.roll);j.n21=Math.sin(this.roll);j.n22=Math.cos(this.roll);this.matrix.multiplySelf(j);
this.matrixWorldNeedsUpdate=!0;this.matrix.n14=this.position.x;this.matrix.n24=this.position.y;this.matrix.n34=this.position.z;this.supr.update.call(this)};this.translateX=function(a){this.position.x+=this.matrix.n11*a;this.position.y+=this.matrix.n21*a;this.position.z+=this.matrix.n31*a};this.translateY=function(a){this.position.x+=this.matrix.n12*a;this.position.y+=this.matrix.n22*a;this.position.z+=this.matrix.n32*a};this.translateZ=function(a){this.position.x-=this.matrix.n13*a;this.position.y-=
this.matrix.n23*a;this.position.z-=this.matrix.n33*a};this.rotateHorizontally=function(a){e.set(this.matrix.n11,this.matrix.n21,this.matrix.n31);e.multiplyScalar(a);this.forward.subSelf(e);this.forward.normalize()};this.rotateVertically=function(a){f.set(this.matrix.n12,this.matrix.n22,this.matrix.n32);f.multiplyScalar(a);this.forward.addSelf(f);this.forward.normalize()};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",
function(a){o=(a.clientX-v)/window.innerWidth;t=(a.clientY-u)/window.innerHeight},!1);this.domElement.addEventListener("mousedown",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:k=1;break;case 2:k=-1}},!1);this.domElement.addEventListener("mouseup",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:k=0;break;case 2:k=0}},!1);this.domElement.addEventListener("keydown",function(a){switch(a.keyCode){case 38:case 87:k=1;break;case 37:case 65:n=-1;break;
case 40:case 83:k=-1;break;case 39:case 68:n=1;break;case 81:h=!0;l=1;break;case 69:h=!0;l=-1;break;case 82:p=1;break;case 70:p=-1}},!1);this.domElement.addEventListener("keyup",function(a){switch(a.keyCode){case 38:case 87:k=0;break;case 37:case 65:n=0;break;case 40:case 83:k=0;break;case 39:case 68:n=0;break;case 81:h=!1;break;case 69:h=!1;break;case 82:p=0;break;case 70:p=0}},!1)};THREE.RollCamera.prototype=new THREE.Camera;THREE.RollCamera.prototype.constructor=THREE.RollCamera;
THREE.RollCamera.prototype.supr=THREE.Camera.prototype;
THREE.TrackballCamera=function(a){function b(a,c){return function(){c.apply(a,arguments)}}a=a||{};THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.domElement=a.domElement||document;this.screen=a.screen||{width:window.innerWidth,height:window.innerHeight,offsetLeft:0,offsetTop:0};this.radius=a.radius||(this.screen.width+this.screen.height)/4;this.rotateSpeed=a.rotateSpeed||1;this.zoomSpeed=a.zoomSpeed||1.2;this.panSpeed=a.panSpeed||0.3;this.noZoom=a.noZoom||!1;this.noPan=a.noPan||
!1;this.staticMoving=a.staticMoving||!1;this.dynamicDampingFactor=a.dynamicDampingFactor||0.2;this.minDistance=a.minDistance||0;this.maxDistance=a.maxDistance||Infinity;this.keys=a.keys||[65,83,68];this.useTarget=!0;var c=!1,d=this.STATE.NONE,e=new THREE.Vector3,f=new THREE.Vector3,g=new THREE.Vector3,j=new THREE.Vector2,h=new THREE.Vector2,l=new THREE.Vector2,k=new THREE.Vector2;this.handleEvent=function(a){if(typeof this[a.type]=="function")this[a.type](a)};this.getMouseOnScreen=function(a,c){return new THREE.Vector2((a-
this.screen.offsetLeft)/this.radius*0.5,(c-this.screen.offsetTop)/this.radius*0.5)};this.getMouseProjectionOnBall=function(a,c){var b=new THREE.Vector3((a-this.screen.width*0.5-this.screen.offsetLeft)/this.radius,(this.screen.height*0.5+this.screen.offsetTop-c)/this.radius,0),d=b.length();d>1?b.normalize():b.z=Math.sqrt(1-d*d);e=this.position.clone().subSelf(this.target.position);d=this.up.clone().setLength(b.y);d.addSelf(this.up.clone().crossSelf(e).setLength(b.x));d.addSelf(e.setLength(b.z));return d};
this.rotateCamera=function(){var a=Math.acos(f.dot(g)/f.length()/g.length());if(a){var c=(new THREE.Vector3).cross(f,g).normalize(),b=new THREE.Quaternion;a*=this.rotateSpeed;b.setFromAxisAngle(c,-a);b.multiplyVector3(e);b.multiplyVector3(this.up);b.multiplyVector3(g);this.staticMoving?f=g:(b.setFromAxisAngle(c,a*(this.dynamicDampingFactor-1)),b.multiplyVector3(f))}};this.zoomCamera=function(){var a=1+(h.y-j.y)*this.zoomSpeed;a!==1&&a>0&&(e.multiplyScalar(a),this.staticMoving?j=h:j.y+=(h.y-j.y)*this.dynamicDampingFactor)};
this.panCamera=function(){var a=k.clone().subSelf(l);if(a.lengthSq()){a.multiplyScalar(e.length()*this.panSpeed);var c=e.clone().crossSelf(this.up).setLength(a.x);c.addSelf(this.up.clone().setLength(a.y));this.position.addSelf(c);this.target.position.addSelf(c);this.staticMoving?l=k:l.addSelf(a.sub(k,l).multiplyScalar(this.dynamicDampingFactor))}};this.checkDistances=function(){if(!this.noZoom||!this.noPan)this.position.lengthSq()>this.maxDistance*this.maxDistance&&this.position.setLength(this.maxDistance),
e.lengthSq()<this.minDistance*this.minDistance&&this.position.add(this.target.position,e.setLength(this.minDistance))};this.update=function(a,c,b){e=this.position.clone().subSelf(this.target.position);this.rotateCamera();this.noZoom||this.zoomCamera();this.noPan||this.panCamera();this.position.add(this.target.position,e);this.checkDistances();this.supr.update.call(this,a,c,b)};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",
b(this,function(a){c&&(f=g=this.getMouseProjectionOnBall(a.clientX,a.clientY),j=h=this.getMouseOnScreen(a.clientX,a.clientY),l=k=this.getMouseOnScreen(a.clientX,a.clientY),c=!1);d!==this.STATE.NONE&&(d===this.STATE.ROTATE?g=this.getMouseProjectionOnBall(a.clientX,a.clientY):d===this.STATE.ZOOM&&!this.noZoom?h=this.getMouseOnScreen(a.clientX,a.clientY):d===this.STATE.PAN&&!this.noPan&&(k=this.getMouseOnScreen(a.clientX,a.clientY)))}),!1);this.domElement.addEventListener("mousedown",b(this,function(a){a.preventDefault();
a.stopPropagation();if(d===this.STATE.NONE)d=a.button,d===this.STATE.ROTATE?f=g=this.getMouseProjectionOnBall(a.clientX,a.clientY):d===this.STATE.ZOOM&&!this.noZoom?j=h=this.getMouseOnScreen(a.clientX,a.clientY):this.noPan||(l=k=this.getMouseOnScreen(a.clientX,a.clientY))}),!1);this.domElement.addEventListener("mouseup",b(this,function(a){a.preventDefault();a.stopPropagation();d=this.STATE.NONE}),!1);window.addEventListener("keydown",b(this,function(a){if(d===this.STATE.NONE){if(a.keyCode===this.keys[this.STATE.ROTATE])d=
this.STATE.ROTATE;else if(a.keyCode===this.keys[this.STATE.ZOOM]&&!this.noZoom)d=this.STATE.ZOOM;else if(a.keyCode===this.keys[this.STATE.PAN]&&!this.noPan)d=this.STATE.PAN;d!==this.STATE.NONE&&(c=!0)}}),!1);window.addEventListener("keyup",b(this,function(){if(d!==this.STATE.NONE)d=this.STATE.NONE}),!1)};THREE.TrackballCamera.prototype=new THREE.Camera;THREE.TrackballCamera.prototype.constructor=THREE.TrackballCamera;THREE.TrackballCamera.prototype.supr=THREE.Camera.prototype;
THREE.TrackballCamera.prototype.STATE={NONE:-1,ROTATE:0,ZOOM:1,PAN:2};
THREE.Cube=function(a,b,c,d,e,f,g,j,h){function l(a,c,b,g,j,h,l,n){var o,p,t=d||1,v=e||1,K=j/2,H=h/2,L=k.vertices.length;if(a=="x"&&c=="y"||a=="y"&&c=="x")o="z";else if(a=="x"&&c=="z"||a=="z"&&c=="x")o="y",v=f||1;else if(a=="z"&&c=="y"||a=="y"&&c=="z")o="x",t=f||1;var I=t+1,z=v+1;j/=t;var G=h/v;for(p=0;p<z;p++)for(h=0;h<I;h++){var J=new THREE.Vector3;J[a]=(h*j-K)*b;J[c]=(p*G-H)*g;J[o]=l;k.vertices.push(new THREE.Vertex(J))}for(p=0;p<v;p++)for(h=0;h<t;h++)k.faces.push(new THREE.Face4(h+I*p+L,h+I*(p+
1)+L,h+1+I*(p+1)+L,h+1+I*p+L,null,null,n)),k.faceVertexUvs[0].push([new THREE.UV(h/t,p/v),new THREE.UV(h/t,(p+1)/v),new THREE.UV((h+1)/t,(p+1)/v),new THREE.UV((h+1)/t,p/v)])}THREE.Geometry.call(this);var k=this,n=a/2,p=b/2,o=c/2,j=j?-1:1;if(g!==void 0)if(g instanceof Array)this.materials=g;else{this.materials=[];for(var t=0;t<6;t++)this.materials.push([g])}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(h!=void 0)for(var v in h)this.sides[v]!=void 0&&(this.sides[v]=h[v]);
this.sides.px&&l("z","y",1*j,-1,c,b,-n,this.materials[0]);this.sides.nx&&l("z","y",-1*j,-1,c,b,n,this.materials[1]);this.sides.py&&l("x","z",1*j,1,a,c,p,this.materials[2]);this.sides.ny&&l("x","z",1*j,-1,a,c,-p,this.materials[3]);this.sides.pz&&l("x","y",1*j,-1,a,b,o,this.materials[4]);this.sides.nz&&l("x","y",-1*j,-1,a,b,-o,this.materials[5]);(function(){for(var a=[],c=[],b=0,d=k.vertices.length;b<d;b++){for(var f=k.vertices[b],g=!1,e=0,j=a.length;e<j;e++){var h=a[e];if(f.position.x==h.position.x&&
f.position.y==h.position.y&&f.position.z==h.position.z){c[b]=e;g=!0;break}}if(!g)c[b]=a.length,a.push(new THREE.Vertex(f.position.clone()))}b=0;for(d=k.faces.length;b<d;b++)f=k.faces[b],f.a=c[f.a],f.b=c[f.b],f.c=c[f.c],f.d=c[f.d];k.vertices=a})();this.computeCentroids();this.computeFaceNormals()};THREE.Cube.prototype=new THREE.Geometry;THREE.Cube.prototype.constructor=THREE.Cube;
THREE.Cylinder=function(a,b,c,d,e,f){function g(a,c,b){j.vertices.push(new THREE.Vertex(new THREE.Vector3(a,c,b)))}THREE.Geometry.call(this);var j=this,h,l=Math.PI*2,k=d/2;for(h=0;h<a;h++)g(Math.sin(l*h/a)*b,Math.cos(l*h/a)*b,-k);for(h=0;h<a;h++)g(Math.sin(l*h/a)*c,Math.cos(l*h/a)*c,k);for(h=0;h<a;h++)j.faces.push(new THREE.Face4(h,h+a,a+(h+1)%a,(h+1)%a));if(c>0){g(0,0,-k-(f||0));for(h=a;h<a+a/2;h++)j.faces.push(new THREE.Face4(2*a,(2*h-2*a)%a,(2*h-2*a+1)%a,(2*h-2*a+2)%a))}if(b>0){g(0,0,k+(e||0));
for(h=a+a/2;h<2*a;h++)j.faces.push(new THREE.Face4(2*a+1,(2*h-2*a+2)%a+a,(2*h-2*a+1)%a+a,(2*h-2*a)%a+a))}h=0;for(a=this.faces.length;h<a;h++){var b=[],c=this.faces[h],e=this.vertices[c.a],f=this.vertices[c.b],k=this.vertices[c.c],n=this.vertices[c.d];b.push(new THREE.UV(0.5+Math.atan2(e.position.x,e.position.y)/l,0.5+e.position.z/d));b.push(new THREE.UV(0.5+Math.atan2(f.position.x,f.position.y)/l,0.5+f.position.z/d));b.push(new THREE.UV(0.5+Math.atan2(k.position.x,k.position.y)/l,0.5+k.position.z/
d));c instanceof THREE.Face4&&b.push(new THREE.UV(0.5+Math.atan2(n.position.x,n.position.y)/l,0.5+n.position.z/d));this.faceVertexUvs[0].push(b)}this.computeCentroids();this.computeFaceNormals()};THREE.Cylinder.prototype=new THREE.Geometry;THREE.Cylinder.prototype.constructor=THREE.Cylinder;
THREE.Icosahedron=function(a){function b(a,c,b){var d=Math.sqrt(a*a+c*c+b*b);return e.vertices.push(new THREE.Vertex(new THREE.Vector3(a/d,c/d,b/d)))-1}function c(a,c,b,d){d.faces.push(new THREE.Face3(a,c,b))}function d(a,c){var d=e.vertices[a].position,f=e.vertices[c].position;return b((d.x+f.x)/2,(d.y+f.y)/2,(d.z+f.z)/2)}var e=this,f=new THREE.Geometry,g;this.subdivisions=a||0;THREE.Geometry.call(this);a=(1+Math.sqrt(5))/2;b(-1,a,0);b(1,a,0);b(-1,-a,0);b(1,-a,0);b(0,-1,a);b(0,1,a);b(0,-1,-a);b(0,
1,-a);b(a,0,-1);b(a,0,1);b(-a,0,-1);b(-a,0,1);c(0,11,5,f);c(0,5,1,f);c(0,1,7,f);c(0,7,10,f);c(0,10,11,f);c(1,5,9,f);c(5,11,4,f);c(11,10,2,f);c(10,7,6,f);c(7,1,8,f);c(3,9,4,f);c(3,4,2,f);c(3,2,6,f);c(3,6,8,f);c(3,8,9,f);c(4,9,5,f);c(2,4,11,f);c(6,2,10,f);c(8,6,7,f);c(9,8,1,f);for(a=0;a<this.subdivisions;a++){g=new THREE.Geometry;for(var j in f.faces){var h=d(f.faces[j].a,f.faces[j].b),l=d(f.faces[j].b,f.faces[j].c),k=d(f.faces[j].c,f.faces[j].a);c(f.faces[j].a,h,k,g);c(f.faces[j].b,l,h,g);c(f.faces[j].c,
k,l,g);c(h,l,k,g)}f.faces=g.faces}e.faces=f.faces;delete f;delete g;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.Icosahedron.prototype=new THREE.Geometry;THREE.Icosahedron.prototype.constructor=THREE.Icosahedron;
THREE.Lathe=function(a,b,c){THREE.Geometry.call(this);this.steps=b||12;this.angle=c||2*Math.PI;for(var b=this.angle/this.steps,c=[],d=[],e=[],f=[],g=(new THREE.Matrix4).setRotationZ(b),j=0;j<a.length;j++)this.vertices.push(new THREE.Vertex(a[j])),c[j]=a[j].clone(),d[j]=this.vertices.length-1;for(var h=0;h<=this.angle+0.001;h+=b){for(j=0;j<c.length;j++)h<this.angle?(c[j]=g.multiplyVector3(c[j].clone()),this.vertices.push(new THREE.Vertex(c[j])),e[j]=this.vertices.length-1):e=f;h==0&&(f=d);for(j=0;j<
d.length-1;j++)this.faces.push(new THREE.Face4(e[j],e[j+1],d[j+1],d[j])),this.faceVertexUvs[0].push([new THREE.UV(1-h/this.angle,j/a.length),new THREE.UV(1-h/this.angle,(j+1)/a.length),new THREE.UV(1-(h-b)/this.angle,(j+1)/a.length),new THREE.UV(1-(h-b)/this.angle,j/a.length)]);d=e;e=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.Lathe.prototype=new THREE.Geometry;THREE.Lathe.prototype.constructor=THREE.Lathe;
THREE.Plane=function(a,b,c,d){THREE.Geometry.call(this);var e,f=a/2,g=b/2,c=c||1,d=d||1,j=c+1,h=d+1;a/=c;var l=b/d;for(e=0;e<h;e++)for(b=0;b<j;b++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(b*a-f,-(e*l-g),0)));for(e=0;e<d;e++)for(b=0;b<c;b++)this.faces.push(new THREE.Face4(b+j*e,b+j*(e+1),b+1+j*(e+1),b+1+j*e)),this.faceVertexUvs[0].push([new THREE.UV(b/c,e/d),new THREE.UV(b/c,(e+1)/d),new THREE.UV((b+1)/c,(e+1)/d),new THREE.UV((b+1)/c,e/d)]);this.computeCentroids();this.computeFaceNormals()};
THREE.Plane.prototype=new THREE.Geometry;THREE.Plane.prototype.constructor=THREE.Plane;
THREE.Sphere=function(a,b,c){THREE.Geometry.call(this);for(var d,e=Math.PI,f=Math.max(3,b||8),g=Math.max(2,c||6),b=[],c=0;c<g+1;c++){d=c/g;var j=a*Math.cos(d*e),h=a*Math.sin(d*e),l=[],k=0;for(d=0;d<f;d++){var n=2*d/f,p=h*Math.sin(n*e),n=h*Math.cos(n*e);(c==0||c==g)&&d>0||(k=this.vertices.push(new THREE.Vertex(new THREE.Vector3(n,j,p)))-1);l.push(k)}b.push(l)}for(var o,t,v,e=b.length,c=0;c<e;c++)if(f=b[c].length,c>0)for(d=0;d<f;d++){l=d==f-1;g=b[c][l?0:d+1];j=b[c][l?f-1:d];h=b[c-1][l?f-1:d];l=b[c-
1][l?0:d+1];p=c/(e-1);o=(c-1)/(e-1);t=(d+1)/f;var n=d/f,k=new THREE.UV(1-t,p),p=new THREE.UV(1-n,p),n=new THREE.UV(1-n,o),u=new THREE.UV(1-t,o);c<b.length-1&&(o=this.vertices[g].position.clone(),t=this.vertices[j].position.clone(),v=this.vertices[h].position.clone(),o.normalize(),t.normalize(),v.normalize(),this.faces.push(new THREE.Face3(g,j,h,[new THREE.Vector3(o.x,o.y,o.z),new THREE.Vector3(t.x,t.y,t.z),new THREE.Vector3(v.x,v.y,v.z)])),this.faceVertexUvs[0].push([k,p,n]));c>1&&(o=this.vertices[g].position.clone(),
t=this.vertices[h].position.clone(),v=this.vertices[l].position.clone(),o.normalize(),t.normalize(),v.normalize(),this.faces.push(new THREE.Face3(g,h,l,[new THREE.Vector3(o.x,o.y,o.z),new THREE.Vector3(t.x,t.y,t.z),new THREE.Vector3(v.x,v.y,v.z)])),this.faceVertexUvs[0].push([k,n,u]))}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.boundingSphere={radius:a}};THREE.Sphere.prototype=new THREE.Geometry;THREE.Sphere.prototype.constructor=THREE.Sphere;
THREE.Torus=function(a,b,c,d){THREE.Geometry.call(this);this.radius=a||100;this.tube=b||40;this.segmentsR=c||8;this.segmentsT=d||6;a=[];for(b=0;b<=this.segmentsR;++b)for(c=0;c<=this.segmentsT;++c){var d=c/this.segmentsT*2*Math.PI,e=b/this.segmentsR*2*Math.PI;this.vertices.push(new THREE.Vertex(new THREE.Vector3((this.radius+this.tube*Math.cos(e))*Math.cos(d),(this.radius+this.tube*Math.cos(e))*Math.sin(d),this.tube*Math.sin(e))));a.push([c/this.segmentsT,1-b/this.segmentsR])}for(b=1;b<=this.segmentsR;++b)for(c=
1;c<=this.segmentsT;++c){var d=(this.segmentsT+1)*b+c,e=(this.segmentsT+1)*b+c-1,f=(this.segmentsT+1)*(b-1)+c-1,g=(this.segmentsT+1)*(b-1)+c;this.faces.push(new THREE.Face4(d,e,f,g));this.faceVertexUvs[0].push([new THREE.UV(a[d][0],a[d][1]),new THREE.UV(a[e][0],a[e][1]),new THREE.UV(a[f][0],a[f][1]),new THREE.UV(a[g][0],a[g][1])])}delete a;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.Torus.prototype=new THREE.Geometry;THREE.Torus.prototype.constructor=THREE.Torus;
THREE.TorusKnot=function(a,b,c,d,e,f,g){function j(a,c,b,d,f,g){c=b/d*a;b=Math.cos(c);return new THREE.Vector3(f*(2+b)*0.5*Math.cos(a),f*(2+b)*Math.sin(a)*0.5,g*f*Math.sin(c)*0.5)}THREE.Geometry.call(this);this.radius=a||200;this.tube=b||40;this.segmentsR=c||64;this.segmentsT=d||8;this.p=e||2;this.q=f||3;this.heightScale=g||1;this.grid=Array(this.segmentsR);c=new THREE.Vector3;d=new THREE.Vector3;f=new THREE.Vector3;for(a=0;a<this.segmentsR;++a){this.grid[a]=Array(this.segmentsT);for(b=0;b<this.segmentsT;++b){var h=
a/this.segmentsR*2*this.p*Math.PI,g=b/this.segmentsT*2*Math.PI,e=j(h,g,this.q,this.p,this.radius,this.heightScale),h=j(h+0.01,g,this.q,this.p,this.radius,this.heightScale);c.x=h.x-e.x;c.y=h.y-e.y;c.z=h.z-e.z;d.x=h.x+e.x;d.y=h.y+e.y;d.z=h.z+e.z;f.cross(c,d);d.cross(f,c);f.normalize();d.normalize();h=-this.tube*Math.cos(g);g=this.tube*Math.sin(g);e.x+=h*d.x+g*f.x;e.y+=h*d.y+g*f.y;e.z+=h*d.z+g*f.z;this.grid[a][b]=this.vertices.push(new THREE.Vertex(new THREE.Vector3(e.x,e.y,e.z)))-1}}for(a=0;a<this.segmentsR;++a)for(b=
0;b<this.segmentsT;++b){var d=(a+1)%this.segmentsR,f=(b+1)%this.segmentsT,e=this.grid[a][b],c=this.grid[d][b],d=this.grid[d][f],f=this.grid[a][f],g=new THREE.UV(a/this.segmentsR,b/this.segmentsT),h=new THREE.UV((a+1)/this.segmentsR,b/this.segmentsT),l=new THREE.UV((a+1)/this.segmentsR,(b+1)/this.segmentsT),k=new THREE.UV(a/this.segmentsR,(b+1)/this.segmentsT);this.faces.push(new THREE.Face4(e,c,d,f));this.faceVertexUvs[0].push([g,h,l,k])}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};
THREE.TorusKnot.prototype=new THREE.Geometry;THREE.TorusKnot.prototype.constructor=THREE.TorusKnot;THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={addStatusElement:function(){var a=document.createElement("div");a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="rgba(0,0,0,0.25)";a.style.color="#fff";a.style.width="120px";a.style.padding="0.5em 0.5em 0.5em 0.5em";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var b="Loaded ";b+=a.total?(100*a.loaded/a.total).toFixed(0)+"%":(a.loaded/1E3).toFixed(2)+" KB";
this.statusDomElement.innerHTML=b},extractUrlbase:function(a){a=a.split("/");a.pop();return a.join("/")},init_materials:function(a,b,c){a.materials=[];for(var d=0;d<b.length;++d)a.materials[d]=[THREE.Loader.prototype.createMaterial(b[d],c)]},createMaterial:function(a,b){function c(a){a=Math.log(a)/Math.LN2;return Math.floor(a)==a}function d(a,b){var d=new Image;d.onload=function(){if(!c(this.width)||!c(this.height)){var b=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),d=Math.pow(2,Math.round(Math.log(this.height)/
Math.LN2));a.image.width=b;a.image.height=d;a.image.getContext("2d").drawImage(this,0,0,b,d)}else a.image=this;a.needsUpdate=!0};d.src=b}var e,f,g;e="MeshLambertMaterial";f={color:15658734,opacity:1,map:null,lightMap:null,wireframe:a.wireframe};a.shading&&(a.shading=="Phong"?e="MeshPhongMaterial":a.shading=="Basic"&&(e="MeshBasicMaterial"));if(a.blending)if(a.blending=="Additive")f.blending=THREE.AdditiveBlending;else if(a.blending=="Subtractive")f.blending=THREE.SubtractiveBlending;else if(a.blending==
"Multiply")f.blending=THREE.MultiplyBlending;if(a.transparent!==void 0||a.opacity<1)f.transparent=a.transparent;if(a.depthTest!==void 0)f.depthTest=a.depthTest;if(a.vertexColors!==void 0)if(a.vertexColors=="face")f.vertexColors=THREE.FaceColors;else if(a.vertexColors)f.vertexColors=THREE.VertexColors;if(a.mapDiffuse&&b)g=document.createElement("canvas"),f.map=new THREE.Texture(g),f.map.sourceFile=a.mapDiffuse,d(f.map,b+"/"+a.mapDiffuse);else if(a.colorDiffuse)g=(a.colorDiffuse[0]*255<<16)+(a.colorDiffuse[1]*
255<<8)+a.colorDiffuse[2]*255,f.color=g,f.opacity=a.transparency;else if(a.DbgColor)f.color=a.DbgColor;if(a.mapLightmap&&b)g=document.createElement("canvas"),f.lightMap=new THREE.Texture(g),f.lightMap.sourceFile=a.mapLightmap,d(f.lightMap,b+"/"+a.mapLightmap);return new THREE[e](f)}};THREE.JSONLoader=function(a){THREE.Loader.call(this,a)};THREE.JSONLoader.prototype=new THREE.Loader;THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;THREE.JSONLoader.prototype.supr=THREE.Loader.prototype;
THREE.JSONLoader.prototype.load=function(a){var b=this,c=a.model,d=a.callback,e=a.texture_path?a.texture_path:this.extractUrlbase(c),a=new Worker(c);a.onmessage=function(a){b.createModel(a.data,d,e);b.onLoadComplete()};this.onLoadStart();a.postMessage((new Date).getTime())};
THREE.JSONLoader.prototype.createModel=function(a,b,c){var d=new THREE.Geometry,e=a.scale!==void 0?1/a.scale:1;this.init_materials(d,a.materials,c);(function(c){if(a.version===void 0||a.version!=2)console.error("Deprecated file format.");else{var b,e,h,l,k,n,p,o,t,v,u,y,w,m,x=a.faces;n=a.vertices;var A=a.normals,C=a.colors,D=0;for(b=0;b<a.uvs.length;b++)a.uvs[b].length&&D++;for(b=0;b<D;b++)d.faceUvs[b]=[],d.faceVertexUvs[b]=[];l=0;for(k=n.length;l<k;)p=new THREE.Vertex,p.position.x=n[l++]*c,p.position.y=
n[l++]*c,p.position.z=n[l++]*c,d.vertices.push(p);l=0;for(k=x.length;l<k;){c=x[l++];n=c&1;h=c&2;b=c&4;e=c&8;o=c&16;p=c&32;v=c&64;c&=128;n?(u=new THREE.Face4,u.a=x[l++],u.b=x[l++],u.c=x[l++],u.d=x[l++],n=4):(u=new THREE.Face3,u.a=x[l++],u.b=x[l++],u.c=x[l++],n=3);if(h)h=x[l++],u.materials=d.materials[h];h=d.faces.length;if(b)for(b=0;b<D;b++)y=a.uvs[b],t=x[l++],m=y[t*2],t=y[t*2+1],d.faceUvs[b][h]=new THREE.UV(m,t);if(e)for(b=0;b<D;b++){y=a.uvs[b];w=[];for(e=0;e<n;e++)t=x[l++],m=y[t*2],t=y[t*2+1],w[e]=
new THREE.UV(m,t);d.faceVertexUvs[b][h]=w}if(o)o=x[l++]*3,e=new THREE.Vector3,e.x=A[o++],e.y=A[o++],e.z=A[o],u.normal=e;if(p)for(b=0;b<n;b++)o=x[l++]*3,e=new THREE.Vector3,e.x=A[o++],e.y=A[o++],e.z=A[o],u.vertexNormals.push(e);if(v)p=x[l++],p=new THREE.Color(C[p]),u.color=p;if(c)for(b=0;b<n;b++)p=x[l++],p=new THREE.Color(C[p]),u.vertexColors.push(p);d.faces.push(u)}}})(e);(function(){var c,b,e,h;if(a.skinWeights){c=0;for(b=a.skinWeights.length;c<b;c+=2)e=a.skinWeights[c],h=a.skinWeights[c+1],d.skinWeights.push(new THREE.Vector4(e,
h,0,0))}if(a.skinIndices){c=0;for(b=a.skinIndices.length;c<b;c+=2)e=a.skinIndices[c],h=a.skinIndices[c+1],d.skinIndices.push(new THREE.Vector4(e,h,0,0))}d.bones=a.bones;d.animation=a.animation})();(function(c){if(a.morphTargets!==void 0){var b,e,h,l,k,n,p,o,t;b=0;for(e=a.morphTargets.length;b<e;b++){d.morphTargets[b]={};d.morphTargets[b].name=a.morphTargets[b].name;d.morphTargets[b].vertices=[];o=d.morphTargets[b].vertices;t=a.morphTargets[b].vertices;h=0;for(l=t.length;h<l;h+=3)k=t[h]*c,n=t[h+1]*
c,p=t[h+2]*c,o.push(new THREE.Vertex(new THREE.Vector3(k,n,p)))}}if(a.morphColors!==void 0){b=0;for(e=a.morphColors.length;b<e;b++){d.morphColors[b]={};d.morphColors[b].name=a.morphColors[b].name;d.morphColors[b].colors=[];l=d.morphColors[b].colors;k=a.morphColors[b].colors;c=0;for(h=k.length;c<h;c+=3)n=new THREE.Color(16755200),n.setRGB(k[c],k[c+1],k[c+2]),l.push(n)}}})(e);(function(){if(a.edges!==void 0){var c,b,e;for(c=0;c<a.edges.length;c+=2)b=a.edges[c],e=a.edges[c+1],d.edges.push(new THREE.Edge(d.vertices[b],
d.vertices[e],b,e))}})();d.computeCentroids();d.computeFaceNormals();b(d)};THREE.BinaryLoader=function(a){THREE.Loader.call(this,a)};THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;THREE.BinaryLoader.prototype.supr=THREE.Loader.prototype;
THREE.BinaryLoader.prototype={load:function(a){var b=a.model,c=a.callback,d=a.texture_path?a.texture_path:THREE.Loader.prototype.extractUrlbase(b),e=a.bin_path?a.bin_path:THREE.Loader.prototype.extractUrlbase(b),a=(new Date).getTime(),b=new Worker(b),f=this.showProgress?THREE.Loader.prototype.updateProgress:null;b.onmessage=function(a){THREE.BinaryLoader.prototype.loadAjaxBuffers(a.data.buffers,a.data.materials,c,e,d,f)};b.onerror=function(a){alert("worker.onerror: "+a.message+"\n"+a.data);a.preventDefault()};
b.postMessage(a)},loadAjaxBuffers:function(a,b,c,d,e,f){var g=new XMLHttpRequest,j=d+"/"+a,h=0;g.onreadystatechange=function(){g.readyState==4?g.status==200||g.status==0?THREE.BinaryLoader.prototype.createBinModel(g.responseText,c,e,b):alert("Couldn't load ["+j+"] ["+g.status+"]"):g.readyState==3?f&&(h==0&&(h=g.getResponseHeader("Content-Length")),f({total:h,loaded:g.responseText.length})):g.readyState==2&&(h=g.getResponseHeader("Content-Length"))};g.open("GET",j,!0);g.overrideMimeType("text/plain; charset=x-user-defined");
g.setRequestHeader("Content-Type","text/plain");g.send(null)},createBinModel:function(a,b,c,d){var e=function(c){function b(a,c){var d=k(a,c),e=k(a,c+1),f=k(a,c+2),g=k(a,c+3),h=(g<<1&255|f>>7)-127;d|=(f&127)<<16|e<<8;if(d==0&&h==-127)return 0;return(1-2*(g>>7))*(1+d*Math.pow(2,-23))*Math.pow(2,h)}function e(a,c){var b=k(a,c),d=k(a,c+1),f=k(a,c+2);return(k(a,c+3)<<24)+(f<<16)+(d<<8)+b}function h(a,c){var b=k(a,c);return(k(a,c+1)<<8)+b}function l(a,c){var b=k(a,c);return b>127?b-256:b}function k(a,
c){return a.charCodeAt(c)&255}function n(c){var b,d,f;b=e(a,c);d=e(a,c+C);f=e(a,c+D);c=h(a,c+E);THREE.BinaryLoader.prototype.f3(y,b,d,f,c)}function p(c){var b,d,f,g,k,l;b=e(a,c);d=e(a,c+C);f=e(a,c+D);g=h(a,c+E);k=e(a,c+F);l=e(a,c+B);c=e(a,c+N);THREE.BinaryLoader.prototype.f3n(y,x,b,d,f,g,k,l,c)}function o(c){var b,d,f,g;b=e(a,c);d=e(a,c+K);f=e(a,c+H);g=e(a,c+L);c=h(a,c+I);THREE.BinaryLoader.prototype.f4(y,b,d,f,g,c)}function t(c){var b,d,f,g,k,l,m,n;b=e(a,c);d=e(a,c+K);f=e(a,c+H);g=e(a,c+L);k=h(a,
c+I);l=e(a,c+z);m=e(a,c+G);n=e(a,c+J);c=e(a,c+M);THREE.BinaryLoader.prototype.f4n(y,x,b,d,f,g,k,l,m,n,c)}function v(c){var b,d;b=e(a,c);d=e(a,c+U);c=e(a,c+V);THREE.BinaryLoader.prototype.uv3(y.faceVertexUvs[0],A[b*2],A[b*2+1],A[d*2],A[d*2+1],A[c*2],A[c*2+1])}function u(c){var b,d,f;b=e(a,c);d=e(a,c+W);f=e(a,c+X);c=e(a,c+Y);THREE.BinaryLoader.prototype.uv4(y.faceVertexUvs[0],A[b*2],A[b*2+1],A[d*2],A[d*2+1],A[f*2],A[f*2+1],A[c*2],A[c*2+1])}var y=this,w=0,m,x=[],A=[],C,D,E,F,B,N,K,H,L,I,z,G,J,M,U,V,
W,X,Y,P,Q,R,S,T,O;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(y,d,c);m={signature:a.substr(w,8),header_bytes:k(a,w+8),vertex_coordinate_bytes:k(a,w+9),normal_coordinate_bytes:k(a,w+10),uv_coordinate_bytes:k(a,w+11),vertex_index_bytes:k(a,w+12),normal_index_bytes:k(a,w+13),uv_index_bytes:k(a,w+14),material_index_bytes:k(a,w+15),nvertices:e(a,w+16),nnormals:e(a,w+16+4),nuvs:e(a,w+16+8),ntri_flat:e(a,w+16+12),ntri_smooth:e(a,w+16+16),ntri_flat_uv:e(a,w+16+20),ntri_smooth_uv:e(a,w+
16+24),nquad_flat:e(a,w+16+28),nquad_smooth:e(a,w+16+32),nquad_flat_uv:e(a,w+16+36),nquad_smooth_uv:e(a,w+16+40)};w+=m.header_bytes;C=m.vertex_index_bytes;D=m.vertex_index_bytes*2;E=m.vertex_index_bytes*3;F=m.vertex_index_bytes*3+m.material_index_bytes;B=m.vertex_index_bytes*3+m.material_index_bytes+m.normal_index_bytes;N=m.vertex_index_bytes*3+m.material_index_bytes+m.normal_index_bytes*2;K=m.vertex_index_bytes;H=m.vertex_index_bytes*2;L=m.vertex_index_bytes*3;I=m.vertex_index_bytes*4;z=m.vertex_index_bytes*
4+m.material_index_bytes;G=m.vertex_index_bytes*4+m.material_index_bytes+m.normal_index_bytes;J=m.vertex_index_bytes*4+m.material_index_bytes+m.normal_index_bytes*2;M=m.vertex_index_bytes*4+m.material_index_bytes+m.normal_index_bytes*3;U=m.uv_index_bytes;V=m.uv_index_bytes*2;W=m.uv_index_bytes;X=m.uv_index_bytes*2;Y=m.uv_index_bytes*3;c=m.vertex_index_bytes*3+m.material_index_bytes;O=m.vertex_index_bytes*4+m.material_index_bytes;P=m.ntri_flat*c;Q=m.ntri_smooth*(c+m.normal_index_bytes*3);R=m.ntri_flat_uv*
(c+m.uv_index_bytes*3);S=m.ntri_smooth_uv*(c+m.normal_index_bytes*3+m.uv_index_bytes*3);T=m.nquad_flat*O;c=m.nquad_smooth*(O+m.normal_index_bytes*4);O=m.nquad_flat_uv*(O+m.uv_index_bytes*4);w+=function(c){for(var d,e,f,h=m.vertex_coordinate_bytes*3,j=c+m.nvertices*h;c<j;c+=h)d=b(a,c),e=b(a,c+m.vertex_coordinate_bytes),f=b(a,c+m.vertex_coordinate_bytes*2),THREE.BinaryLoader.prototype.v(y,d,e,f);return m.nvertices*h}(w);w+=function(c){for(var b,d,e,f=m.normal_coordinate_bytes*3,g=c+m.nnormals*f;c<g;c+=
f)b=l(a,c),d=l(a,c+m.normal_coordinate_bytes),e=l(a,c+m.normal_coordinate_bytes*2),x.push(b/127,d/127,e/127);return m.nnormals*f}(w);w+=function(c){for(var d,e,f=m.uv_coordinate_bytes*2,h=c+m.nuvs*f;c<h;c+=f)d=b(a,c),e=b(a,c+m.uv_coordinate_bytes),A.push(d,e);return m.nuvs*f}(w);P=w+P;Q=P+Q;R=Q+R;S=R+S;T=S+T;c=T+c;O=c+O;(function(a){var c,b=m.vertex_index_bytes*3+m.material_index_bytes,d=b+m.uv_index_bytes*3,e=a+m.ntri_flat_uv*d;for(c=a;c<e;c+=d)n(c),v(c+b);return e-a})(Q);(function(a){var c,b=m.vertex_index_bytes*
3+m.material_index_bytes+m.normal_index_bytes*3,d=b+m.uv_index_bytes*3,e=a+m.ntri_smooth_uv*d;for(c=a;c<e;c+=d)p(c),v(c+b);return e-a})(R);(function(a){var c,b=m.vertex_index_bytes*4+m.material_index_bytes,d=b+m.uv_index_bytes*4,e=a+m.nquad_flat_uv*d;for(c=a;c<e;c+=d)o(c),u(c+b);return e-a})(c);(function(a){var c,b=m.vertex_index_bytes*4+m.material_index_bytes+m.normal_index_bytes*4,d=b+m.uv_index_bytes*4,e=a+m.nquad_smooth_uv*d;for(c=a;c<e;c+=d)t(c),u(c+b);return e-a})(O);(function(a){var c,b=m.vertex_index_bytes*
3+m.material_index_bytes,d=a+m.ntri_flat*b;for(c=a;c<d;c+=b)n(c);return d-a})(w);(function(a){var c,b=m.vertex_index_bytes*3+m.material_index_bytes+m.normal_index_bytes*3,d=a+m.ntri_smooth*b;for(c=a;c<d;c+=b)p(c);return d-a})(P);(function(a){var c,b=m.vertex_index_bytes*4+m.material_index_bytes,d=a+m.nquad_flat*b;for(c=a;c<d;c+=b)o(c);return d-a})(S);(function(a){var c,b=m.vertex_index_bytes*4+m.material_index_bytes+m.normal_index_bytes*4,d=a+m.nquad_smooth*b;for(c=a;c<d;c+=b)t(c);return d-a})(T);
this.computeCentroids();this.computeFaceNormals()};e.prototype=new THREE.Geometry;e.prototype.constructor=e;b(new e(c))},v:function(a,b,c,d){a.vertices.push(new THREE.Vertex(new THREE.Vector3(b,c,d)))},f3:function(a,b,c,d,e){a.faces.push(new THREE.Face3(b,c,d,null,null,a.materials[e]))},f4:function(a,b,c,d,e,f){a.faces.push(new THREE.Face4(b,c,d,e,null,null,a.materials[f]))},f3n:function(a,b,c,d,e,f,g,j,h){var f=a.materials[f],l=b[j*3],k=b[j*3+1],j=b[j*3+2],n=b[h*3],p=b[h*3+1],h=b[h*3+2];a.faces.push(new THREE.Face3(c,
d,e,[new THREE.Vector3(b[g*3],b[g*3+1],b[g*3+2]),new THREE.Vector3(l,k,j),new THREE.Vector3(n,p,h)],null,f))},f4n:function(a,b,c,d,e,f,g,j,h,l,k){var g=a.materials[g],n=b[h*3],p=b[h*3+1],h=b[h*3+2],o=b[l*3],t=b[l*3+1],l=b[l*3+2],v=b[k*3],u=b[k*3+1],k=b[k*3+2];a.faces.push(new THREE.Face4(c,d,e,f,[new THREE.Vector3(b[j*3],b[j*3+1],b[j*3+2]),new THREE.Vector3(n,p,h),new THREE.Vector3(o,t,l),new THREE.Vector3(v,u,k)],null,g))},uv3:function(a,b,c,d,e,f,g){var j=[];j.push(new THREE.UV(b,c));j.push(new THREE.UV(d,
e));j.push(new THREE.UV(f,g));a.push(j)},uv4:function(a,b,c,d,e,f,g,j,h){var l=[];l.push(new THREE.UV(b,c));l.push(new THREE.UV(d,e));l.push(new THREE.UV(f,g));l.push(new THREE.UV(j,h));a.push(l)}};THREE.SceneLoader=function(){this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){};this.callbackSync=function(){};this.callbackProgress=function(){}};
THREE.SceneLoader.prototype={load:function(a,b){var c=this,d=new Worker(a);d.postMessage(0);var e=THREE.Loader.prototype.extractUrlbase(a);d.onmessage=function(a){function d(a,c){return c=="relativeToHTML"?a:e+"/"+a}function j(){for(o in B.objects)if(!z.objects[o])if(w=B.objects[o],w.geometry!==void 0){if(C=z.geometries[w.geometry]){F=[];for(M=0;M<w.materials.length;M++)F[M]=z.materials[w.materials[M]];m=w.position;r=w.rotation;q=w.quaternion;s=w.scale;q=0;F.length==0&&(F[0]=new THREE.MeshFaceMaterial);
F.length>1&&(F=[new THREE.MeshFaceMaterial]);object=new THREE.Mesh(C,F);object.name=o;object.position.set(m[0],m[1],m[2]);q?(object.quaternion.set(q[0],q[1],q[2],q[3]),object.useQuaternion=!0):object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=w.visible;z.scene.addObject(object);z.objects[o]=object;if(w.meshCollider){var a=THREE.CollisionUtils.MeshColliderWBox(object);z.scene.collisions.colliders.push(a)}if(w.castsShadow)a=new THREE.ShadowVolume(C),z.scene.addChild(a),
a.position=object.position,a.rotation=object.rotation,a.scale=object.scale;w.trigger&&w.trigger.toLowerCase()!="none"&&(a={type:w.trigger,object:w},z.triggers[object.name]=a)}}else m=w.position,r=w.rotation,q=w.quaternion,s=w.scale,q=0,object=new THREE.Object3D,object.name=o,object.position.set(m[0],m[1],m[2]),q?(object.quaternion.set(q[0],q[1],q[2],q[3]),object.useQuaternion=!0):object.rotation.set(r[0],r[1],r[2]),object.scale.set(s[0],s[1],s[2]),object.visible=w.visible!==void 0?w.visible:!1,z.scene.addObject(object),
z.objects[o]=object,z.empties[o]=object,w.trigger&&w.trigger.toLowerCase()!="none"&&(a={type:w.trigger,object:w},z.triggers[object.name]=a)}function h(a){return function(b){z.geometries[a]=b;j();K-=1;c.onLoadComplete();k()}}function l(a){return function(c){z.geometries[a]=c}}function k(){c.callbackProgress({totalModels:L,totalTextures:I,loadedModels:L-K,loadedTextures:I-H},z);c.onLoadProgress();K==0&&H==0&&b(z)}var n,p,o,t,v,u,y,w,m,x,A,C,D,E,F,B,N,K,H,L,I,z;B=a.data;a=new THREE.BinaryLoader;N=new THREE.JSONLoader;
H=K=0;z={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},fogs:{},triggers:{},empties:{}};var G=!1;for(o in B.objects)if(w=B.objects[o],w.meshCollider){G=!0;break}if(G)z.scene.collisions=new THREE.CollisionSystem;if(B.transform){G=B.transform.position;x=B.transform.rotation;var J=B.transform.scale;G&&z.scene.position.set(G[0],G[1],G[2]);x&&z.scene.rotation.set(x[0],x[1],x[2]);J&&z.scene.scale.set(J[0],J[1],J[2]);(G||x||J)&&z.scene.updateMatrix()}G=function(){H-=
1;k();c.onLoadComplete()};for(v in B.cameras){x=B.cameras[v];if(x.type=="perspective")D=new THREE.Camera(x.fov,x.aspect,x.near,x.far);else if(x.type=="ortho")D=new THREE.Camera,D.projectionMatrix=THREE.Matrix4.makeOrtho(x.left,x.right,x.top,x.bottom,x.near,x.far);m=x.position;x=x.target;D.position.set(m[0],m[1],m[2]);D.target.position.set(x[0],x[1],x[2]);z.cameras[v]=D}for(t in B.lights){v=B.lights[t];D=v.color!==void 0?v.color:16777215;x=v.intensity!==void 0?v.intensity:1;if(v.type=="directional")m=
v.direction,light=new THREE.DirectionalLight(D,x),light.position.set(m[0],m[1],m[2]),light.position.normalize();else if(v.type=="point")m=v.position,light=new THREE.PointLight(D,x),light.position.set(m[0],m[1],m[2]);z.scene.addLight(light);z.lights[t]=light}for(u in B.fogs)t=B.fogs[u],t.type=="linear"?E=new THREE.Fog(0,t.near,t.far):t.type=="exp2"&&(E=new THREE.FogExp2(0,t.density)),x=t.color,E.color.setRGB(x[0],x[1],x[2]),z.fogs[u]=E;if(z.cameras&&B.defaults.camera)z.currentCamera=z.cameras[B.defaults.camera];
if(z.fogs&&B.defaults.fog)z.scene.fog=z.fogs[B.defaults.fog];x=B.defaults.bgcolor;z.bgColor=new THREE.Color;z.bgColor.setRGB(x[0],x[1],x[2]);z.bgColorAlpha=B.defaults.bgalpha;for(n in B.geometries)if(u=B.geometries[n],u.type=="bin_mesh"||u.type=="ascii_mesh")K+=1,c.onLoadStart();L=K;for(n in B.geometries)u=B.geometries[n],u.type=="cube"?(C=new THREE.Cube(u.width,u.height,u.depth,u.segmentsWidth,u.segmentsHeight,u.segmentsDepth,null,u.flipped,u.sides),z.geometries[n]=C):u.type=="plane"?(C=new THREE.Plane(u.width,
u.height,u.segmentsWidth,u.segmentsHeight),z.geometries[n]=C):u.type=="sphere"?(C=new THREE.Sphere(u.radius,u.segmentsWidth,u.segmentsHeight),z.geometries[n]=C):u.type=="cylinder"?(C=new THREE.Cylinder(u.numSegs,u.topRad,u.botRad,u.height,u.topOffset,u.botOffset),z.geometries[n]=C):u.type=="torus"?(C=new THREE.Torus(u.radius,u.tube,u.segmentsR,u.segmentsT),z.geometries[n]=C):u.type=="icosahedron"?(C=new THREE.Icosahedron(u.subdivisions),z.geometries[n]=C):u.type=="bin_mesh"?a.load({model:d(u.url,
B.urlBaseType),callback:h(n)}):u.type=="ascii_mesh"?N.load({model:d(u.url,B.urlBaseType),callback:h(n)}):u.type=="embedded_mesh"&&(u=B.embeds[u.id])&&N.createModel(u,l(n),"");for(y in B.textures)if(n=B.textures[y],n.url instanceof Array){H+=n.url.length;for(a=0;a<n.url.length;a++)c.onLoadStart()}else H+=1,c.onLoadStart();I=H;for(y in B.textures){n=B.textures[y];if(n.mapping!=void 0&&THREE[n.mapping]!=void 0)n.mapping=new THREE[n.mapping];if(n.url instanceof Array){for(var a=[],M=0;M<n.url.length;M++)a[M]=
d(n.url[M],B.urlBaseType);a=THREE.ImageUtils.loadTextureCube(a,n.mapping,G)}else{a=THREE.ImageUtils.loadTexture(d(n.url,B.urlBaseType),n.mapping,G);if(THREE[n.minFilter]!=void 0)a.minFilter=THREE[n.minFilter];if(THREE[n.magFilter]!=void 0)a.magFilter=THREE[n.magFilter]}z.textures[y]=a}for(p in B.materials){y=B.materials[p];for(A in y.parameters)if(A=="envMap"||A=="map"||A=="lightMap")y.parameters[A]=z.textures[y.parameters[A]];else if(A=="shading")y.parameters[A]=y.parameters[A]=="flat"?THREE.FlatShading:
THREE.SmoothShading;else if(A=="blending")y.parameters[A]=THREE[y.parameters[A]]?THREE[y.parameters[A]]:THREE.NormalBlending;else if(A=="combine")y.parameters[A]=y.parameters[A]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation;else if(A=="vertexColors")if(y.parameters[A]=="face")y.parameters[A]=THREE.FaceColors;else if(y.parameters[A])y.parameters[A]=THREE.VertexColors;if(y.parameters.opacity!==void 0&&y.parameters.opacity<1)y.parameters.transparent=!0;y=new THREE[y.type](y.parameters);
z.materials[p]=y}j();c.callbackSync(z)}}};
THREE.MarchingCubes=function(a,b){THREE.Object3D.call(this);this.materials=b instanceof Array?b:[b];this.init=function(a){this.isolation=80;this.size=a;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=
0;this.hasNormal=this.hasPos=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(a,b,e){return a+(b-a)*e};this.VIntX=function(a,b,e,f,g,j,h,l,k,n){g=(g-k)/(n-k);k=this.normal_cache;b[f]=j+g*this.delta;b[f+1]=h;b[f+2]=l;e[f]=this.lerp(k[a],k[a+3],g);e[f+1]=this.lerp(k[a+1],k[a+4],g);e[f+2]=this.lerp(k[a+2],k[a+5],g)};this.VIntY=function(a,b,e,f,g,j,h,l,k,n){g=(g-k)/(n-k);k=this.normal_cache;b[f]=j;b[f+1]=h+g*this.delta;b[f+
2]=l;b=a+this.yd*3;e[f]=this.lerp(k[a],k[b],g);e[f+1]=this.lerp(k[a+1],k[b+1],g);e[f+2]=this.lerp(k[a+2],k[b+2],g)};this.VIntZ=function(a,b,e,f,g,j,h,l,k,n){g=(g-k)/(n-k);k=this.normal_cache;b[f]=j;b[f+1]=h;b[f+2]=l+g*this.delta;b=a+this.zd*3;e[f]=this.lerp(k[a],k[b],g);e[f+1]=this.lerp(k[a+1],k[b+1],g);e[f+2]=this.lerp(k[a+2],k[b+2],g)};this.compNorm=function(a){var b=a*3;this.normal_cache[b]==0&&(this.normal_cache[b]=this.field[a-1]-this.field[a+1],this.normal_cache[b+1]=this.field[a-this.yd]-this.field[a+
this.yd],this.normal_cache[b+2]=this.field[a-this.zd]-this.field[a+this.zd])};this.polygonize=function(a,b,e,f,g,j){var h=f+1,l=f+this.yd,k=f+this.zd,n=h+this.yd,p=h+this.zd,o=f+this.yd+this.zd,t=h+this.yd+this.zd,v=0,u=this.field[f],y=this.field[h],w=this.field[l],m=this.field[n],x=this.field[k],A=this.field[p],C=this.field[o],D=this.field[t];u<g&&(v|=1);y<g&&(v|=2);w<g&&(v|=8);m<g&&(v|=4);x<g&&(v|=16);A<g&&(v|=32);C<g&&(v|=128);D<g&&(v|=64);var E=THREE.edgeTable[v];if(E==0)return 0;var F=this.delta,
B=a+F,N=b+F,F=e+F;E&1&&(this.compNorm(f),this.compNorm(h),this.VIntX(f*3,this.vlist,this.nlist,0,g,a,b,e,u,y));E&2&&(this.compNorm(h),this.compNorm(n),this.VIntY(h*3,this.vlist,this.nlist,3,g,B,b,e,y,m));E&4&&(this.compNorm(l),this.compNorm(n),this.VIntX(l*3,this.vlist,this.nlist,6,g,a,N,e,w,m));E&8&&(this.compNorm(f),this.compNorm(l),this.VIntY(f*3,this.vlist,this.nlist,9,g,a,b,e,u,w));E&16&&(this.compNorm(k),this.compNorm(p),this.VIntX(k*3,this.vlist,this.nlist,12,g,a,b,F,x,A));E&32&&(this.compNorm(p),
this.compNorm(t),this.VIntY(p*3,this.vlist,this.nlist,15,g,B,b,F,A,D));E&64&&(this.compNorm(o),this.compNorm(t),this.VIntX(o*3,this.vlist,this.nlist,18,g,a,N,F,C,D));E&128&&(this.compNorm(k),this.compNorm(o),this.VIntY(k*3,this.vlist,this.nlist,21,g,a,b,F,x,C));E&256&&(this.compNorm(f),this.compNorm(k),this.VIntZ(f*3,this.vlist,this.nlist,24,g,a,b,e,u,x));E&512&&(this.compNorm(h),this.compNorm(p),this.VIntZ(h*3,this.vlist,this.nlist,27,g,B,b,e,y,A));E&1024&&(this.compNorm(n),this.compNorm(t),this.VIntZ(n*
3,this.vlist,this.nlist,30,g,B,N,e,m,D));E&2048&&(this.compNorm(l),this.compNorm(o),this.VIntZ(l*3,this.vlist,this.nlist,33,g,a,N,e,w,C));v<<=4;for(g=f=0;THREE.triTable[v+g]!=-1;)a=v+g,b=a+1,e=a+2,this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[a],3*THREE.triTable[b],3*THREE.triTable[e],j),g+=3,f++;return f};this.posnormtriv=function(a,b,e,f,g,j){var h=this.count*3;this.positionArray[h]=a[e];this.positionArray[h+1]=a[e+1];this.positionArray[h+2]=a[e+2];this.positionArray[h+3]=a[f];this.positionArray[h+
4]=a[f+1];this.positionArray[h+5]=a[f+2];this.positionArray[h+6]=a[g];this.positionArray[h+7]=a[g+1];this.positionArray[h+8]=a[g+2];this.normalArray[h]=b[e];this.normalArray[h+1]=b[e+1];this.normalArray[h+2]=b[e+2];this.normalArray[h+3]=b[f];this.normalArray[h+4]=b[f+1];this.normalArray[h+5]=b[f+2];this.normalArray[h+6]=b[g];this.normalArray[h+7]=b[g+1];this.normalArray[h+8]=b[g+2];this.hasNormal=this.hasPos=!0;this.count+=3;this.count>=this.maxCount-3&&j(this)};this.begin=function(){this.count=0;
this.hasNormal=this.hasPos=!1};this.end=function(a){if(this.count!=0){for(var b=this.count*3;b<this.positionArray.length;b++)this.positionArray[b]=0;a(this)}};this.addBall=function(a,b,e,f,g){var j=this.size*Math.sqrt(f/g),h=e*this.size,l=b*this.size,k=a*this.size,n=Math.floor(h-j);n<1&&(n=1);h=Math.floor(h+j);h>this.size-1&&(h=this.size-1);var p=Math.floor(l-j);p<1&&(p=1);l=Math.floor(l+j);l>this.size-1&&(l=this.size-1);var o=Math.floor(k-j);o<1&&(o=1);j=Math.floor(k+j);j>this.size-1&&(j=this.size-
1);for(var t,v,u,y,w,m;n<h;n++){k=this.size2*n;v=n/this.size-e;w=v*v;for(v=p;v<l;v++){u=k+this.size*v;t=v/this.size-b;m=t*t;for(t=o;t<j;t++)y=t/this.size-a,y=f/(1.0E-6+y*y+m+w)-g,y>0&&(this.field[u+t]+=y)}}};this.addPlaneX=function(a,b){var e,f,g,j,h,l=this.size,k=this.yd,n=this.zd,p=this.field,o=l*Math.sqrt(a/b);o>l&&(o=l);for(e=0;e<o;e++)if(f=e/l,f*=f,j=a/(1.0E-4+f)-b,j>0)for(f=0;f<l;f++){h=e+f*k;for(g=0;g<l;g++)p[n*g+h]+=j}};this.addPlaneY=function(a,b){var e,f,g,j,h,l,k=this.size,n=this.yd,p=
this.zd,o=this.field,t=k*Math.sqrt(a/b);t>k&&(t=k);for(f=0;f<t;f++)if(e=f/k,e*=e,j=a/(1.0E-4+e)-b,j>0){h=f*n;for(e=0;e<k;e++){l=h+e;for(g=0;g<k;g++)o[p*g+l]+=j}}};this.addPlaneZ=function(a,b){var e,f,g,j,h,l;size=this.size;yd=this.yd;zd=this.zd;field=this.field;dist=size*Math.sqrt(a/b);dist>size&&(dist=size);for(g=0;g<dist;g++)if(e=g/size,e*=e,j=a/(1.0E-4+e)-b,j>0){h=zd*g;for(f=0;f<size;f++){l=h+f*yd;for(e=0;e<size;e++)field[l+e]+=j}}};this.reset=function(){var a;for(a=0;a<this.size3;a++)this.normal_cache[a*
3]=0,this.field[a]=0};this.render=function(a){this.begin();var b,e,f,g,j,h,l,k,n,p=this.size-2;for(g=1;g<p;g++){n=this.size2*g;l=(g-this.halfsize)/this.halfsize;for(f=1;f<p;f++){k=n+this.size*f;h=(f-this.halfsize)/this.halfsize;for(e=1;e<p;e++)j=(e-this.halfsize)/this.halfsize,b=k+e,this.polygonize(j,h,l,b,this.isolation,a)}}this.end(a)};this.generateGeometry=function(){var a=0,b=new THREE.Geometry,e=[];this.render(function(f){var g,j,h,l,k,n,p,o;for(g=0;g<f.count;g++)p=g*3,k=p+1,o=p+2,j=f.positionArray[p],
h=f.positionArray[k],l=f.positionArray[o],n=new THREE.Vector3(j,h,l),j=f.normalArray[p],h=f.normalArray[k],l=f.normalArray[o],p=new THREE.Vector3(j,h,l),p.normalize(),k=new THREE.Vertex(n),b.vertices.push(k),e.push(p);nfaces=f.count/3;for(g=0;g<nfaces;g++)p=(a+g)*3,k=p+1,o=p+2,n=e[p],j=e[k],h=e[o],p=new THREE.Face3(p,k,o,[n,j,h]),b.faces.push(p);a+=nfaces;f.count=0});return b};this.init(a)};THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
THREE.Trident=function(a){function b(b){return new THREE.Mesh(new THREE.Cylinder(30,0.1,a.length/20,a.length/5),new THREE.MeshBasicMaterial({color:b}))}function c(a,b){var c=new THREE.Geometry;c.vertices=[new THREE.Vertex,new THREE.Vertex(a)];return new THREE.Line(c,new THREE.LineBasicMaterial({color:b}))}THREE.Object3D.call(this);var d=Math.PI/2,e,a=a||THREE.Trident.defaultParams;if(a!==THREE.Trident.defaultParams)for(e in THREE.Trident.defaultParams)a.hasOwnProperty(e)||(a[e]=THREE.Trident.defaultParams[e]);
this.scale=new THREE.Vector3(a.scale,a.scale,a.scale);this.addChild(c(new THREE.Vector3(a.length,0,0),a.xAxisColor));this.addChild(c(new THREE.Vector3(0,a.length,0),a.yAxisColor));this.addChild(c(new THREE.Vector3(0,0,a.length),a.zAxisColor));if(a.showArrows)e=b(a.xAxisColor),e.rotation.y=-d,e.position.x=a.length,this.addChild(e),e=b(a.yAxisColor),e.rotation.x=d,e.position.y=a.length,this.addChild(e),e=b(a.zAxisColor),e.rotation.y=Math.PI,e.position.z=a.length,this.addChild(e)};
THREE.Trident.prototype=new THREE.Object3D;THREE.Trident.prototype.constructor=THREE.Trident;THREE.Trident.defaultParams={xAxisColor:16711680,yAxisColor:65280,zAxisColor:255,showArrows:!0,length:100,scale:1};THREE.PlaneCollider=function(a,b){this.point=a;this.normal=b};THREE.SphereCollider=function(a,b){this.center=a;this.radius=b;this.radiusSq=b*b};THREE.BoxCollider=function(a,b){this.min=a;this.max=b;this.dynamic=!0;this.normal=new THREE.Vector3};
THREE.MeshCollider=function(a,b){this.mesh=a;this.box=b;this.numFaces=this.mesh.geometry.faces.length;this.normal=new THREE.Vector3};THREE.CollisionSystem=function(){this.collisionNormal=new THREE.Vector3;this.colliders=[];this.hits=[]};THREE.Collisions=new THREE.CollisionSystem;THREE.CollisionSystem.prototype.merge=function(a){this.colliders=this.colliders.concat(a.colliders);this.hits=this.hits.concat(a.hits)};
THREE.CollisionSystem.prototype.rayCastAll=function(a){a.direction.normalize();this.hits.length=0;var b,c,d,e,f=0;b=0;for(c=this.colliders.length;b<c;b++)if(e=this.colliders[b],d=this.rayCast(a,e),d<Number.MAX_VALUE)e.distance=d,d>f?this.hits.push(e):this.hits.unshift(e),f=d;return this.hits};
THREE.CollisionSystem.prototype.rayCastNearest=function(a){var b=this.rayCastAll(a);if(b.length==0)return null;for(var c=0;b[c]instanceof THREE.MeshCollider;){var d=this.rayMesh(a,b[c]);if(d.dist<Number.MAX_VALUE){b[c].distance=d.dist;b[c].faceIndex=d.faceIndex;break}c++}if(c>b.length)return null;return b[c]};
THREE.CollisionSystem.prototype.rayCast=function(a,b){if(b instanceof THREE.PlaneCollider)return this.rayPlane(a,b);else if(b instanceof THREE.SphereCollider)return this.raySphere(a,b);else if(b instanceof THREE.BoxCollider)return this.rayBox(a,b);else if(b instanceof THREE.MeshCollider&&b.box)return this.rayBox(a,b.box)};
THREE.CollisionSystem.prototype.rayMesh=function(a,b){for(var c=this.makeRayLocal(a,b.mesh),d=Number.MAX_VALUE,e,f=0;f<b.numFaces;f++){var g=b.mesh.geometry.faces[f],j=b.mesh.geometry.vertices[g.a].position,h=b.mesh.geometry.vertices[g.b].position,l=b.mesh.geometry.vertices[g.c].position,k=g instanceof THREE.Face4?b.mesh.geometry.vertices[g.d].position:null;g instanceof THREE.Face3?(g=this.rayTriangle(c,j,h,l,d,this.collisionNormal),g<d&&(d=g,e=f,b.normal.copy(this.collisionNormal),b.normal.normalize())):
g instanceof THREE.Face4&&(g=this.rayTriangle(c,j,h,k,d,this.collisionNormal),g<d&&(d=g,e=f,b.normal.copy(this.collisionNormal),b.normal.normalize()),g=this.rayTriangle(c,h,l,k,d,this.collisionNormal),g<d&&(d=g,e=f,b.normal.copy(this.collisionNormal),b.normal.normalize()))}return{dist:d,faceIndex:e}};
THREE.CollisionSystem.prototype.rayTriangle=function(a,b,c,d,e,f){var g=THREE.CollisionSystem.__v1,j=THREE.CollisionSystem.__v2;f.set(0,0,0);g.sub(c,b);j.sub(d,c);f.cross(g,j);j=f.dot(a.direction);if(!(j<0))return Number.MAX_VALUE;g=f.dot(b)-f.dot(a.origin);if(!(g<=0))return Number.MAX_VALUE;if(!(g>=j*e))return Number.MAX_VALUE;g/=j;j=THREE.CollisionSystem.__v3;j.copy(a.direction);j.multiplyScalar(g);j.addSelf(a.origin);Math.abs(f.x)>Math.abs(f.y)?Math.abs(f.x)>Math.abs(f.z)?(a=j.y-b.y,f=c.y-b.y,
e=d.y-b.y,j=j.z-b.z,c=c.z-b.z,d=d.z-b.z):(a=j.x-b.x,f=c.x-b.x,e=d.x-b.x,j=j.y-b.y,c=c.y-b.y,d=d.y-b.y):Math.abs(f.y)>Math.abs(f.z)?(a=j.x-b.x,f=c.x-b.x,e=d.x-b.x,j=j.z-b.z,c=c.z-b.z,d=d.z-b.z):(a=j.x-b.x,f=c.x-b.x,e=d.x-b.x,j=j.y-b.y,c=c.y-b.y,d=d.y-b.y);b=f*d-c*e;if(b==0)return Number.MAX_VALUE;b=1/b;d=(a*d-j*e)*b;if(!(d>=0))return Number.MAX_VALUE;b*=f*j-c*a;if(!(b>=0))return Number.MAX_VALUE;if(!(1-d-b>=0))return Number.MAX_VALUE;return g};
THREE.CollisionSystem.prototype.makeRayLocal=function(a,b){var c=THREE.CollisionSystem.__m;THREE.Matrix4.makeInvert(b.matrixWorld,c);var d=THREE.CollisionSystem.__r;d.origin.copy(a.origin);d.direction.copy(a.direction);c.multiplyVector3(d.origin);c.rotateAxis(d.direction);d.direction.normalize();return d};
THREE.CollisionSystem.prototype.rayBox=function(a,b){var c;b.dynamic&&b.mesh&&b.mesh.matrixWorld?c=this.makeRayLocal(a,b.mesh):(c=THREE.CollisionSystem.__r,c.origin.copy(a.origin),c.direction.copy(a.direction));var d=0,e=0,f=0,g=0,j=0,h=0,l=!0;c.origin.x<b.min.x?(d=b.min.x-c.origin.x,d/=c.direction.x,l=!1,g=-1):c.origin.x>b.max.x&&(d=b.max.x-c.origin.x,d/=c.direction.x,l=!1,g=1);c.origin.y<b.min.y?(e=b.min.y-c.origin.y,e/=c.direction.y,l=!1,j=-1):c.origin.y>b.max.y&&(e=b.max.y-c.origin.y,e/=c.direction.y,
l=!1,j=1);c.origin.z<b.min.z?(f=b.min.z-c.origin.z,f/=c.direction.z,l=!1,h=-1):c.origin.z>b.max.z&&(f=b.max.z-c.origin.z,f/=c.direction.z,l=!1,h=1);if(l)return-1;l=0;e>d&&(l=1,d=e);f>d&&(l=2,d=f);switch(l){case 0:j=c.origin.y+c.direction.y*d;if(j<b.min.y||j>b.max.y)return Number.MAX_VALUE;c=c.origin.z+c.direction.z*d;if(c<b.min.z||c>b.max.z)return Number.MAX_VALUE;b.normal.set(g,0,0);break;case 1:g=c.origin.x+c.direction.x*d;if(g<b.min.x||g>b.max.x)return Number.MAX_VALUE;c=c.origin.z+c.direction.z*
d;if(c<b.min.z||c>b.max.z)return Number.MAX_VALUE;b.normal.set(0,j,0);break;case 2:g=c.origin.x+c.direction.x*d;if(g<b.min.x||g>b.max.x)return Number.MAX_VALUE;j=c.origin.y+c.direction.y*d;if(j<b.min.y||j>b.max.y)return Number.MAX_VALUE;b.normal.set(0,0,h)}return d};THREE.CollisionSystem.prototype.rayPlane=function(a,b){var c=a.direction.dot(b.normal),d=b.point.dot(b.normal);if(c<0)c=(d-a.origin.dot(b.normal))/c;else return Number.MAX_VALUE;return c>0?c:Number.MAX_VALUE};
THREE.CollisionSystem.prototype.raySphere=function(a,b){var c=b.center.clone().subSelf(a.origin);if(c.lengthSq<b.radiusSq)return-1;var d=c.dot(a.direction.clone());if(d<=0)return Number.MAX_VALUE;c=b.radiusSq-(c.lengthSq()-d*d);if(c>=0)return Math.abs(d)-Math.sqrt(c);return Number.MAX_VALUE};THREE.CollisionSystem.__v1=new THREE.Vector3;THREE.CollisionSystem.__v2=new THREE.Vector3;THREE.CollisionSystem.__v3=new THREE.Vector3;THREE.CollisionSystem.__nr=new THREE.Vector3;THREE.CollisionSystem.__m=new THREE.Matrix4;
THREE.CollisionSystem.__r=new THREE.Ray;THREE.CollisionUtils={};THREE.CollisionUtils.MeshOBB=function(a){a.geometry.computeBoundingBox();var b=a.geometry.boundingBox,c=new THREE.Vector3(b.x[0],b.y[0],b.z[0]),b=new THREE.Vector3(b.x[1],b.y[1],b.z[1]),c=new THREE.BoxCollider(c,b);c.mesh=a;return c};THREE.CollisionUtils.MeshAABB=function(a){var b=THREE.CollisionUtils.MeshOBB(a);b.min.addSelf(a.position);b.max.addSelf(a.position);b.dynamic=!1;return b};
THREE.CollisionUtils.MeshColliderWBox=function(a){return new THREE.MeshCollider(a,THREE.CollisionUtils.MeshOBB(a))};
