# 0.6.0 Migration Guide

## Zero-downtime deployment

- You can now **actually** disable zero-downtime deployments per-app and per-process-type
  - Some config variables have been moved around
    - `DOKKU_CHECKS_ENABLED` has been migrated to `DOKKU_CHECKS_SKIPPED`
    - `DOKKU_CHECKS_DISABLED` is now a thing
    - The values for the above can be a comma-separated list of process-types or the literal string `_all_`
  - See the [updated `checks`](/dokku/deployment/zero-downtime-deploys/) docs for more info

## Proxy port mapping

- You can now configure host -> container proxy port mappings
  - The UI is handled by the [proxy](/dokku/advanced-usage/proxy-management/) interface plugin by setting the `DOKKU_PROXY_PORT_MAP` config variable in the format of `scheme:host-port:container-port`. The default `nginx-vhosts` proxy plugin supports both the `http` and `https` schemes.
- Default port mappings
  - buildpack apps will be set to `http:80:5000` and will also include `https:443:5000` if SSL is enabled.
  - dockerfile apps with explicitly exposed ports (i.e. using the `EXPOSE` directive) will be configured with a listener on each exposed port that proxies to the same port of the deployed application container.
    - You may override this behavior with the [`proxy:ports-*` commands](/dokku/advanced-usage/proxy-management/) or by directly setting `DOKKU_PROXY_PORT_MAP` with the `config:set` command
    - dockerfile apps without explicitly exposed ports will behave the same as a buildpack app
  - NOTE: These defaults **are not** automatically changed on subsequent pushes and must be manipulated with the aforementioned commands

## Calling the `dokku` binary

- Plugins should *not* call the `dokku` binary directly. Clients using the `--app` argument are potentially broken, amongst others, when doing so. Instead, please source the `functions` file for a given plugin when attempting to call Dokku internal functions. As a result, the following Dokku commands are no longer publicly exposed:
 - `dokku build`
 - `dokku receive`
 - `dokku release`
 - `dokku tar:build`
 - `dokku tar:build-locked`
 - `dokku git:build`
 - `dokku git:build-locked`
