# Developing Scala in IntelliJ IDEA

Use the latest IntelliJ release.

Make sure the Scala plugin is installed.  (It may come preinstalled;
if not, install it before proceeding.)

## Initial Setup

Do not attempt to import our sbt build into IntelliJ; it won't work.

Instead, create IntelliJ project files as follows.

  - Run `sbt intellij`

The project files are created as copies of the `.SAMPLE` files, which are under version
control. The actual IntelliJ project files are in `.gitignore` so that local changes
are ignored.

Then to start coding:

  - Open `src/intellij/scala.ipr` in IntelliJ
  - Wait for the project to index
  - On the `Build` menu, choose `Build Project`

Everything (library, compiler etc) should build within a few minutes.

## Troubleshooting

Recent versions of IntelliJ are able to find a JDK on your system and select it
automatically. If that doesn't happen:

  - In `File` → `Project Structure` → `Project` → `Project SDK`, create an SDK entry
    named "1.8" containing the Java 1.8 SDK

Note that 8 is the safest choice. If you're having trouble, you might check to see
if IntelliJ selected some later version.

## Switching Branches

If you often work on both the 2.12.x and 2.13.x branches, the safest approach is to
have a separate clone of the repository for each branch.

(But if you find that switching works even in the same clone, consider
submitting an update to this readme with any advice you have on this.)

## IntelliJ and sbt

Note that compilation IntelliJ is performed in a single pass (no
bootstrap), like the sbt build.

Note that the output directory when compiling in IntelliJ is the same as for the
sbt build. This allows building incrementally in IntelliJ
and directly using the changes using the command-line scripts in `build/quick/bin/`.

## Running JUnit Tests

JUnit tests can be executed by right-clicking on a test class or test method and
selecting "Run" or "Debug". The debugger will allow you to stop at breakpoints
within the Scala library.

It is possible to invoke the Scala compiler from a JUnit test (passing the source
code as a string) and inspect the generated bytecode, see for example
`scala.issues.BytecodeTest`. Debugging such a test is an easy way to stop at
breakpoints within the Scala compiler.

## Running the Compiler and REPL

You can create run/debug configurations to run the compiler and REPL directly within
IntelliJ, which might accelerate development and debugging of the compiler.

To debug the Scala codebase you can also use "Remote" debug configuration and pass
the corresponding arguments to the jvm running the compiler / program.

To run the compiler create an "Application" configuration with
  - Main class: `scala.tools.nsc.Main`
  - Program arguments: `-usejavacp -cp sandbox -d sandbox sandbox/Test.scala`
  - Working directory: the path of your checkout
  - Use classpath of module: `compiler`

To run the REPL create an "Application" configuration with
  - Main class: `scala.tools.nsc.MainGenericRunner`
  - Program arguments: `-usejavacp`
  - Working directory: the path of your checkout
  - Use classpath of module: `repl-frontend`

## Dependencies

For every module in the IntelliJ project there is a corresponding `-deps` library, for example `compiler-deps` provides JARs for the compiler codebase.
The `.jar` files in these `-deps` libraries can be easily kept up-to-date by running `sbt intellij` again.
This is necessary whenever the dependencies in the sbt build change, for example when the `starr` version is updated.

Note that this command only patches the dependency lists, all other settings in the IntelliJ project definition are unchanged.

To overwrite the project definition files by copying the `.SAMPLE` files again run `sbt intellijFromSample`.

## Updating the `.SAMPLE` files

The command `intellijToSample` overwrites the `.SAMPLE` files using the current project definition files.
