#!/bin/bash -e

if [ -z "$GPG_SUBKEY_SECRET" ]; then
  echo "GPG_SUBKEY_SECRET is missing/empty, so skipping credentials & gpg setup"
  exit
fi

sensitive() {
  envsubst < files/credentials-private-repo-netrc > ~/.credentials-private-repo-netrc
  openssl aes-256-cbc -md md5 -d -pass "pass:$GPG_SUBKEY_SECRET" -in files/gpg_subkey.enc | gpg --import
}

# don't let anything escape from the sensitive part (e.g. leak environment var by echoing to log on failure)
sensitive >/dev/null 2>&1

# just to verify
gpg --list-keys
gpg --list-secret-keys

mkdir -p ~/.sbt/1.0/plugins
cp files/gpg.sbt ~/.sbt/1.0/plugins/
