#!/bin/bash -e

function environment_compose() {
    "${DOCKER_CONF_LOCATION}/${ENVIRONMENT}/compose.sh" "$@"
}

SCRIPT_DIR=${BASH_SOURCE%/*}
DOCKER_CONF_LOCATION="${SCRIPT_DIR}/../conf/docker"

ENVIRONMENT=$1

if ! which jq > /dev/null; then
    echo "Please install jq"
    exit 1
fi

if [[ ! -f "$DOCKER_CONF_LOCATION/$ENVIRONMENT/compose.sh" ]]; then
    echo "Usage: $0 environment"
    exit 1
fi

SERVICES=$(environment_compose config | grep hostname | cut -d : -f 2)

echo "# GENERATED BY $0 - BEGIN #"
for SERVICE in $SERVICES; do
    if $(environment_compose ps | grep -q $SERVICE); then
        IP=$(docker inspect $(environment_compose ps -q $SERVICE) | jq '.[].NetworkSettings.Networks.common_default.IPAddress' -r)
        if ! test -z $IP; then
            echo $IP $SERVICE
        fi
    fi
done
echo "# GENERATED BY $0 - END #"
