# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

Generated by [`auto-changelog`](https://github.com/CookPete/auto-changelog).

### [3.10.2](https://www.github.com/netlify/build-image/compare/v3.10.1...v3.10.2) (2021-12-06)


### Bug Fixes

* included software link ([#698](https://www.github.com/netlify/build-image/issues/698)) ([52181f9](https://www.github.com/netlify/build-image/commit/52181f93b8c7959edab0b5fd15d2d5a1c9af9411))

### [3.10.1](https://www.github.com/netlify/build-image/compare/v3.10.0...v3.10.1) (2021-11-05)


### Bug Fixes

* **yarn:** add the default installed yarn binary to PATH ([#683](https://www.github.com/netlify/build-image/issues/683)) ([3e8f8af](https://www.github.com/netlify/build-image/commit/3e8f8af67644e144424d2575c2eb5ce1836ea732))

## [3.10.0](https://www.github.com/netlify/build-image/compare/v3.9.2...v3.10.0) (2021-10-28)


### Features

* add build-image codename env var (xenial) ([#674](https://www.github.com/netlify/build-image/issues/674)) ([52fd516](https://www.github.com/netlify/build-image/commit/52fd516edad13a0c277df45750de6a54e2035791))

### [3.9.2](https://www.github.com/netlify/build-image/compare/v3.9.1...v3.9.2) (2021-10-26)


### Bug Fixes

* buildbot group xenial ([#659](https://www.github.com/netlify/build-image/issues/659)) ([54a5e13](https://www.github.com/netlify/build-image/commit/54a5e13810bb3be9ff91c8d57f6e39d4006433e6))

### [3.9.1](https://www.github.com/netlify/build-image/compare/v3.9.0...v3.9.1) (2021-10-06)


### Bug Fixes

* multiple yarn flags xenial ([#644](https://www.github.com/netlify/build-image/issues/644)) ([78e9ac1](https://www.github.com/netlify/build-image/commit/78e9ac18b1c1f35cd649ece9752bcab8f9c1a430))

## [3.9.0](https://www.github.com/netlify/build-image/compare/v3.8.2...v3.9.0) (2021-08-10)


### Features

* cache directory for Rust functions ([#607](https://www.github.com/netlify/build-image/issues/607)) ([92b86a2](https://www.github.com/netlify/build-image/commit/92b86a2f3aaafcfba6751a6da3826009d380f53b))

### [3.8.2](https://www.github.com/netlify/build-image/compare/v3.8.1...v3.8.2) (2021-07-19)


### Bug Fixes

* **yarn:** make yarn install use the correct .yarn_cache path ([#595](https://www.github.com/netlify/build-image/issues/595)) ([eb3b47b](https://www.github.com/netlify/build-image/commit/eb3b47b7fb4b85df440bcedc8af452ca157f7bd9))

### [3.8.1](https://www.github.com/netlify/build-image/compare/v3.8.0...v3.8.1) (2021-07-14)


### Bug Fixes

* [#496](https://www.github.com/netlify/build-image/issues/496) NPM_FLAGS doesn't handle more than one flag ([#590](https://www.github.com/netlify/build-image/issues/590)) ([fe40157](https://www.github.com/netlify/build-image/commit/fe4015706a3fb8ea82d667e7d8beac5729ef4da9))
* replace gpg keyserver import for rvm ([#585](https://www.github.com/netlify/build-image/issues/585)) ([bfcce1e](https://www.github.com/netlify/build-image/commit/bfcce1e4353253130a555613aa3eff944465da54))

## [3.8.0](https://www.github.com/netlify/build-image/compare/v3.7.6...v3.8.0) (2021-06-17)


### Bug Fixes

* php/iptables support for xenial and ruby and yarn upgrades  ([#576](https://www.github.com/netlify/build-image/issues/576)) ([d51b4da](https://www.github.com/netlify/build-image/commit/d51b4da41df1087448804e27626a32d83f50380f))

### [3.7.6](https://www.github.com/netlify/build-image/compare/v3.7.5...v3.7.6) (2021-05-06)


### Bug Fixes

* release v3.7.6 ([#571](https://www.github.com/netlify/build-image/issues/571)) ([6fb55f1](https://www.github.com/netlify/build-image/commit/6fb55f1cf4cf9fe6c21318e4dbd8b537b2b645da))

### [3.7.5](https://www.github.com/netlify/build-image/compare/v3.7.4...v3.7.5) (2021-05-05)


### Bug Fixes

* remove duplicated go import path code ([#545](https://www.github.com/netlify/build-image/issues/545)) ([cb132de](https://www.github.com/netlify/build-image/commit/cb132de159b89eb9ed2f36ebffc8a5009000046b))
* **workspace:** don't log workspace detection errors from stderr ([#568](https://www.github.com/netlify/build-image/issues/568)) ([a5daf51](https://www.github.com/netlify/build-image/commit/a5daf5130c3326766b28f316e2deb2c2e65e96bf))

### [3.7.4](https://www.github.com/netlify/build-image/compare/v3.7.3...v3.7.4) (2021-05-04)


### Bug Fixes

* **workspaces:** remove yarn cache workspaces feature flag ([#561](https://www.github.com/netlify/build-image/issues/561)) ([236db04](https://www.github.com/netlify/build-image/commit/236db04125e7e8cd541fce4971413245a711d825))

### [3.7.3](https://www.github.com/netlify/build-image/compare/v3.7.2...v3.7.3) (2021-04-29)


### Bug Fixes

* simplify defaulting to a php version ([4551b07](https://www.github.com/netlify/build-image/commit/4551b0775c86295db468f9355ab0b591064ad2d9))

### [3.7.2](https://www.github.com/netlify/build-image/compare/v3.7.1...v3.7.2) (2021-04-26)


### Bug Fixes

* Update homebrew install ([#547](https://www.github.com/netlify/build-image/issues/547)) ([2925d87](https://www.github.com/netlify/build-image/commit/2925d8750b1ceb728d2aa7767dc5f584e1c5187d))

### [3.7.1](https://www.github.com/netlify/build-image/compare/v3.7.0...v3.7.1) (2021-03-25)


### Bug Fixes

* punctuation ([ec4de44](https://www.github.com/netlify/build-image/commit/ec4de44c35e33ae61c920b0aba3af235d43a7f85))

## [3.7.0](https://www.github.com/netlify/build-image/compare/v3.6.1...v3.7.0) (2021-03-10)


### Features

* better cache support for JS workspaces ([#526](https://www.github.com/netlify/build-image/issues/526)) ([a21ba04](https://www.github.com/netlify/build-image/commit/a21ba04b4692ab95a63b127ddcdc380b5bf4dd22))


### Bug Fixes

* changelog and pacakge.json versioning ([#529](https://www.github.com/netlify/build-image/issues/529)) ([a4bc88a](https://www.github.com/netlify/build-image/commit/a4bc88a07db4ee7b23c63cdc9a648546e98ef0fe))
* **releas-please:** set the correct branch name ([#532](https://www.github.com/netlify/build-image/issues/532)) ([b9e1d47](https://www.github.com/netlify/build-image/commit/b9e1d4732d9d3490c1a81e2bc6d4a1232c2888e3))

## [v3.6.1](https://github.com/netlify/build-image/compare/v3.6.1-pre1...v3.6.1) - 2021-01-14

### Merged

- Fix Rust caching issues [`#521`](https://github.com/netlify/build-image/pull/521)

### Commits

- Cache .rustup regardless of whether there are cargo files or not. [`4d33fdd`](https://github.com/netlify/build-image/commit/4d33fddd39a1c53a380ca346427ef57987172b9a)

## [v3.6.1-pre1](https://github.com/netlify/build-image/compare/v3.6.0...v3.6.1-pre1) - 2021-01-12

### Merged

- add webp to lfs config [`#515`](https://github.com/netlify/build-image/pull/515)
- Add change in Docker image size to PRs [`#516`](https://github.com/netlify/build-image/pull/516)

### Commits

- Use separate action [`3b3774b`](https://github.com/netlify/build-image/commit/3b3774ba6a60817b89bbdf8eb4a8bad47d4165b0)
- Test [`16f8265`](https://github.com/netlify/build-image/commit/16f8265e9b7b1eea80f8bd089387cf4002680ff4)
- Copy target directory using reflinks. [`ebc2ba7`](https://github.com/netlify/build-image/commit/ebc2ba70c2b710bf047bee80ee0b49068a25c9ee)
- Build dummy image [`c76d7a4`](https://github.com/netlify/build-image/commit/c76d7a473a45e47ec3fd6d53563446fcb8f7e65b)
- Test [`acd7c06`](https://github.com/netlify/build-image/commit/acd7c06acbf5cc10361939012677939730b88d96)
- Cache rust artifacts only when cargo files are detected [`3740589`](https://github.com/netlify/build-image/commit/3740589850303f67cf4fd17b65c4e39a7c1f9391)
- Add check [`6cc7b6d`](https://github.com/netlify/build-image/commit/6cc7b6dcf464b5820ba692f3961091dcce3f77b2)
- Cache the target directory only when a cargo file exists. [`4dbcb17`](https://github.com/netlify/build-image/commit/4dbcb17453c3531da43fdd5814c3a717feffafeb)
- Use real image [`d2e3dc9`](https://github.com/netlify/build-image/commit/d2e3dc95b323f5f49d7091607aecb37ae459c033)
- Add output [`5fffbb8`](https://github.com/netlify/build-image/commit/5fffbb86459fff9a6b93ccfa99a03afb718ab435)
- Update run-build-functions.sh [`f009c3b`](https://github.com/netlify/build-image/commit/f009c3b090cf61c8cfb76dc6826f1d5729f39731)
- Update tag [`861f5c0`](https://github.com/netlify/build-image/commit/861f5c0d6dce51e287cce6469ed3314f9e18a37a)
- Don't pre-pull default image [`8a8233c`](https://github.com/netlify/build-image/commit/8a8233c9ee127f81a7ad73a0c4d44d830a680be8)
- Evaluate SIZE [`7e6e676`](https://github.com/netlify/build-image/commit/7e6e676ed24a5b345712fb95498871263e3e4c1e)
- Tweak title [`33828e4`](https://github.com/netlify/build-image/commit/33828e4720231c0ac0c2761f9cfdec667be76f4b)
- Tweak conclusion [`cb2ccd1`](https://github.com/netlify/build-image/commit/cb2ccd1f6c53071abc43141f8d4e5fe9dc8f6187)

## [v3.6.0](https://github.com/netlify/build-image/compare/v3.6.0-pre1...v3.6.0) - 2020-12-07

### Merged

- Add Rust support [`#477`](https://github.com/netlify/build-image/pull/477)

### Commits

- Update included_software.md [`7f1e907`](https://github.com/netlify/build-image/commit/7f1e9073d3a1a9f400e5593888d3097ebf3fcc9b)
- Revert "Added rustup to the list of tools" [`23b30a7`](https://github.com/netlify/build-image/commit/23b30a7e4e3fc25bef908c25b911158b53f4e86d)
- Added rustup to the list of tools [`d66e848`](https://github.com/netlify/build-image/commit/d66e8483f1f9dcc55adca444c7b5d0099757f9da)

## [v3.6.0-pre1](https://github.com/netlify/build-image/compare/v3.5.0...v3.6.0-pre1) - 2020-12-04

### Merged

- Pin homebrew install to a specific commit [`#502`](https://github.com/netlify/build-image/pull/502)
- Document support for Zola [`#497`](https://github.com/netlify/build-image/pull/497)
- Update Swift docs in included_software.md [`#495`](https://github.com/netlify/build-image/pull/495)

### Commits

- Merge commit 8a965d0d4022211b40827efae49d344d9dec8783 (no conflict) [`21ae6eb`](https://github.com/netlify/build-image/commit/21ae6ebde094da7e2c17896b095786e83dd9262d)
- Cache .cargo/bin and .rustup too [`932e0af`](https://github.com/netlify/build-image/commit/932e0af1923e27a034fae9c8e557b615f772f608)
- CLEANUP [`7084515`](https://github.com/netlify/build-image/commit/70845157f66119081008b255200faa056c89eb32)
- Update included_software.md
 [`af4c1f7`](https://github.com/netlify/build-image/commit/af4c1f7e012ad6f46b7e80f475c177632ca5ad61)
- Fix comment [`71ac638`](https://github.com/netlify/build-image/commit/71ac6380a039b5fc11bf801deb4625607f854804)
- Do not install toolchain by default [`0da465e`](https://github.com/netlify/build-image/commit/0da465e848bc64e3f219a04aed3bf88e554699db)
- Merge commit fa6e85ee8d61e9ca22f0d26fa3ebf5fce3ef2fec (no conflict) [`d39611c`](https://github.com/netlify/build-image/commit/d39611c25b35130759559aac62ab0e85bd75a3e2)

## [v3.5.0](https://github.com/netlify/build-image/compare/v3.4.4...v3.5.0) - 2020-11-12

### Merged

- Remove default Swift version [`#491`](https://github.com/netlify/build-image/pull/491)
- Improve `CONTRIBUTING.md` [`#490`](https://github.com/netlify/build-image/pull/490)

### Commits

- Move constant to top of file [`d98357b`](https://github.com/netlify/build-image/commit/d98357b5d91ab0ebcc559bc5b9f9a084f4758cab)
- CLEANUP [`f14eeca`](https://github.com/netlify/build-image/commit/f14eeca9a17c4a7339a5d06152430fb55bc1d536)
- Merge commit 3dbb487a86b68d051559ccd9d490fe785d3860f4 (no conflict) [`6d1d1f6`](https://github.com/netlify/build-image/commit/6d1d1f6064c4c822d7f30564f3ca64743448629d)
- Merge commit 19b59c0408431d785c57f229aa9f701b0ae95613 (conflicts) [`0a8215d`](https://github.com/netlify/build-image/commit/0a8215dac743d92d2be2bda273f9fa852d888893)
- Merge commit 92f69f9fd7091370bb521169b2400ff5153f0dcc (no conflict) [`c0de9b0`](https://github.com/netlify/build-image/commit/c0de9b06445539f0aa1d3abee48c25a8841f9b8f)
- Merge commit 96a3c6f04f5879262aa727dea3a1027b6095ddb1 (conflicts) [`c56e184`](https://github.com/netlify/build-image/commit/c56e184ab50afa15d852c993580e2f70e9378ef5)
- Use Swift if SWIFT_VERSION is set by user [`457b353`](https://github.com/netlify/build-image/commit/457b353a77a72a106e7a5e491f6007146e74e88a)
- Don't install a default Swift version [`483cc50`](https://github.com/netlify/build-image/commit/483cc501246e88f59732c9380906ebbe813e5e46)
- Don't export version, create versions dir [`3be0ff2`](https://github.com/netlify/build-image/commit/3be0ff28bfa52898284011679e9480c948855f1f)
- Removed pre-compilation step [`60fd309`](https://github.com/netlify/build-image/commit/60fd309b0b9ac3c2e068f83b735e91fd985f3103)
- Lint [`4d250b3`](https://github.com/netlify/build-image/commit/4d250b34f740e29d51c3c32e6c7251dd33c1a4bb)
- Fix comment and use appropriate function [`b720533`](https://github.com/netlify/build-image/commit/b720533c31d9bf0f06559e03cf3d4b8d20baae4b)
- Check env when populating cache [`ccf90c3`](https://github.com/netlify/build-image/commit/ccf90c32620e828d060aa71ac6e1760eda71f432)
- Reorder lines [`e0b77be`](https://github.com/netlify/build-image/commit/e0b77be2e7fc42cb3c4a9992290b7f44de627ff7)
- Apply suggestion [`db4ab67`](https://github.com/netlify/build-image/commit/db4ab67d0833f564a4106947cc6f92412a09dd09)
- Removed ... something [`e4e7354`](https://github.com/netlify/build-image/commit/e4e7354e607847f563725c4b0b60dc557be4b6b2)
- Removed unneeded mkdir -p [`5cd8e76`](https://github.com/netlify/build-image/commit/5cd8e76608e8c2f748cd4c97ae1461528364c925)

## [v3.4.4](https://github.com/netlify/build-image/compare/v3.4.3...v3.4.4) - 2020-11-04

### Commits

- releasing v3.4.3 [`b8c7cc2`](https://github.com/netlify/build-image/commit/b8c7cc294285989a0d283e28c15d1ed18693e1ff)

## [v3.4.3](https://github.com/netlify/build-image/compare/v3.4.3-var-fix...v3.4.3) - 2020-11-04

## [v3.4.3-var-fix](https://github.com/netlify/build-image/compare/v3.4.2...v3.4.3-var-fix) - 2020-11-04

### Merged

- Fix homebrew default bundle file [`#489`](https://github.com/netlify/build-image/pull/489)
- Improve release docs [`#487`](https://github.com/netlify/build-image/pull/487)

## [v3.4.2](https://github.com/netlify/build-image/compare/v3.4.1-homebrew...v3.4.2) - 2020-11-02

### Merged

- Support installing tools via Homebrew (take 2) [`#474`](https://github.com/netlify/build-image/pull/474)

### Commits

- Improve release docs [`7b00759`](https://github.com/netlify/build-image/commit/7b007596900b4f103c9dd10fd3dc5f5302c670be)
- Remove wasmer mention in readme [`962be09`](https://github.com/netlify/build-image/commit/962be09326d883e5fa6d0dc5f03abfff5567899e)

## [v3.4.1](https://github.com/netlify/build-image/compare/v3.4.0...v3.4.1) - 2020-07-28

### Merged

- Remove pip cache flag [`#462`](https://github.com/netlify/build-image/pull/462)
- Move build binaries again (to /opt/build-bin this time) [`#460`](https://github.com/netlify/build-image/pull/460)
- Revert "Move build binaries from /usr/local/bin to /opt/build/bin (#450)" [`#459`](https://github.com/netlify/build-image/pull/459)

## [v3.4.1-homebrew](https://github.com/netlify/build-image/compare/v3.4.1...v3.4.1-homebrew) - 2020-09-28

### Merged

- Document `PYTHON_VERSION` option [`#471`](https://github.com/netlify/build-image/pull/471)
- Cache Cypress in ./node_modules/.cache/CypressBinary [`#467`](https://github.com/netlify/build-image/pull/467)
- Fix find_running_procs to exclude correct binary [`#461`](https://github.com/netlify/build-image/pull/461)

### Commits

- Support installing tools via homebrew [`96a3c6f`](https://github.com/netlify/build-image/commit/96a3c6f04f5879262aa727dea3a1027b6095ddb1)
- Remove wasmer permanently. [`19b59c0`](https://github.com/netlify/build-image/commit/19b59c0408431d785c57f229aa9f701b0ae95613)
- Move brew install before all other dependencies [`031d697`](https://github.com/netlify/build-image/commit/031d697fe6d4222443d229f13e8872f26b05dc3e)
- Rename Brewfile to Brewfile.netlify [`75fc194`](https://github.com/netlify/build-image/commit/75fc194cb16598b887882ba73caf023d70ff6f9b)
- Set custom file as default env variable. [`55d0b61`](https://github.com/netlify/build-image/commit/55d0b611f7c91e1eb8efe18312b4872b48124ce1)
- Warn about status of Homebrew support [`c588d67`](https://github.com/netlify/build-image/commit/c588d67a738d4b4e78d5f3d32556fe8edc7eb075)
- Temporarily remove wasmer. [`92f69f9`](https://github.com/netlify/build-image/commit/92f69f9fd7091370bb521169b2400ff5153f0dcc)
- Fix file name in includeD_software.md. [`b7c7cfb`](https://github.com/netlify/build-image/commit/b7c7cfbc59281cf1e429ec2bb8d58d1bffb39b9c)
- Log when installing Homebrew dependencies [`2706fac`](https://github.com/netlify/build-image/commit/2706fac3918c4788732fe8efd4a0e2b413090f47)
- Export variable [`966625c`](https://github.com/netlify/build-image/commit/966625c9f6d555bf3d8b8e222a90e595b1cd7cac)
- Set cypress cache folder in run-build-functions [`5451b1f`](https://github.com/netlify/build-image/commit/5451b1fd60609c87eb2311257e522c91df317205)

## [v3.4.0](https://github.com/netlify/build-image/compare/v3.3.20...v3.4.0) - 2020-07-16

### Merged

- Move build binaries from /usr/local/bin to /opt/build/bin [`#450`](https://github.com/netlify/build-image/pull/450)

## [v3.3.20](https://github.com/netlify/build-image/compare/v3.3.19...v3.3.20) - 2020-07-02

### Merged

- Don't cache full .cache dir [`#443`](https://github.com/netlify/build-image/pull/443)

### Commits

- Merge pull request #440 from Embraser01/patch-1 [`35ad865`](https://github.com/netlify/build-image/commit/35ad865a30fbefea32d048d1d9084351670e54e5)
- Alter cache strategy behind flag [`76d8e7e`](https://github.com/netlify/build-image/commit/76d8e7e2b8be4e22d64f18f5a89b3d10a2131f3e)
- Prefix env var with NETLIFY_ [`d0922eb`](https://github.com/netlify/build-image/commit/d0922ebbbd0b43a2be34ba672b7aaba047820803)

## [v3.3.19](https://github.com/netlify/build-image/compare/v3.3.18...v3.3.19) - 2020-06-26

### Merged

- Preinstall Ruby 2.6.2 [`#439`](https://github.com/netlify/build-image/pull/439)
- Add line of documentation about `CONTRIBUTING.md` [`#442`](https://github.com/netlify/build-image/pull/442)

## [v3.3.18](https://github.com/netlify/build-image/compare/v3.3.17...v3.3.18) - 2020-06-24

### Merged

- Add Intl for PHP [`#410`](https://github.com/netlify/build-image/pull/410)

### Commits

- Short-circuit yarn check when env var is set [`c1353e5`](https://github.com/netlify/build-image/commit/c1353e502ebe19e94623a7a67dadaf92a17d533f)
- Don't use yarn if USE_YARN is false and only force install yarn if true [`1520401`](https://github.com/netlify/build-image/commit/152040114eee1bedef62aef295ec48c997207e75)
- Allow to force Yarn usage [`f830666`](https://github.com/netlify/build-image/commit/f830666940c3bee5c73510636d381c6aef66212b)

## [v3.3.17](https://github.com/netlify/build-image/compare/3.3.17...v3.3.17) - 2020-06-17

### Commits

- Install bundler for Ruby 2.6.2 [`3031d4c`](https://github.com/netlify/build-image/commit/3031d4c9e432fd7016f6279fc9ad706f9205d845)

## [3.3.17](https://github.com/netlify/build-image/compare/v3.3.16...3.3.17) - 2020-06-17

### Commits

- Preinstall Ruby 2.6.2 [`8fe1bb2`](https://github.com/netlify/build-image/commit/8fe1bb2e99ea860d37d734aa796a72347aa56ce7)

## [v3.3.16](https://github.com/netlify/build-image/compare/v3.3.15...v3.3.16) - 2020-06-11

### Merged

- Upgrade preinstalled Node version to 12.18.0 [`#437`](https://github.com/netlify/build-image/pull/437)
- Upgrade preinstalled Ruby version [`#420`](https://github.com/netlify/build-image/pull/420)
- Upgrade preinstalled Go version [`#421`](https://github.com/netlify/build-image/pull/421)
- Make find_running_procs match the definition in buildbot [`#436`](https://github.com/netlify/build-image/pull/436)
- Upgrade preinstalled Yarn version [`#422`](https://github.com/netlify/build-image/pull/422)
- Remove separate ZISI installation [`#435`](https://github.com/netlify/build-image/pull/435)

## [v3.3.15](https://github.com/netlify/build-image/compare/v3.3.14...v3.3.15) - 2020-06-02

### Merged

- Add support for PYTHON_VERSION env variable. [`#363`](https://github.com/netlify/build-image/pull/363)

## [v3.3.14](https://github.com/netlify/build-image/compare/v3.3.14-cache-fix.0...v3.3.14) - 2020-05-19

### Commits

- Merge pull request #429 from netlify/fix/cache-plugins-dir [`633dbea`](https://github.com/netlify/build-image/commit/633dbea1ca3e11243c95f8443ef32b9e49bc26b1)

## [v3.3.14-cache-fix.0](https://github.com/netlify/build-image/compare/v3.3.12...v3.3.14-cache-fix.0) - 2020-05-19

### Commits

- Fix `.netlify/plugins` caching [`2efebc6`](https://github.com/netlify/build-image/commit/2efebc61c2bd7bc4050932578fc02a04edb84ca4)
- Merge pull request #428 from netlify/release/3.3.13 [`142fb9b`](https://github.com/netlify/build-image/commit/142fb9b769867d4cc133822ba3de09dbe39a1207)
- Merge pull request #427 from netlify/feat/revert-faster-yarn [`2c00f7e`](https://github.com/netlify/build-image/commit/2c00f7ed3fcc9cf82aa03d0542b3004385099e07)
- Revert "Yarn speed improvements PR" [`7305475`](https://github.com/netlify/build-image/commit/7305475dfe2b4eafce883a94f1333feb152c4ae2)
- Merge pull request #424 from netlify/feat/plugins-cache [`18310f2`](https://github.com/netlify/build-image/commit/18310f2cadf1b41eb79b129ac783f28a68400118)

## [v3.3.12](https://github.com/netlify/build-image/compare/v3.3.11...v3.3.12) - 2020-05-18

### Merged

- Move NF-build node to later image and lock node 10 version. [`#418`](https://github.com/netlify/build-image/pull/418)

## [v3.3.11](https://github.com/netlify/build-image/compare/v3.3.9-faster-yarn.1...v3.3.11) - 2020-05-18

### Merged

- Fix `nvm` caching [`#425`](https://github.com/netlify/build-image/pull/425)
- Fix xenial latest tag [`#419`](https://github.com/netlify/build-image/pull/419)
- Remove NETLIFY_BUILD_NODE_VERSION & special handling of its nvm dir [`#413`](https://github.com/netlify/build-image/pull/413)

### Commits

- Move Python-version-related error handling to a function, and use it when falling back to $PYTHON_VERSION. [`1ec8e7c`](https://github.com/netlify/build-image/commit/1ec8e7c153b49f6c39c69e4d63eabfb472128ead)
- Add support for PYTHON_VERSION env variable. [`388027a`](https://github.com/netlify/build-image/commit/388027a5dc44664b4fb02d35b210722c74d37cd9)
- Cache .netlify/plugins/ directory [`6b0deb5`](https://github.com/netlify/build-image/commit/6b0deb510b7fb195de09fb9bc15bad899829f8d2)
- Merge pull request #417 from netlify/feat/faster-yarn [`3cb2332`](https://github.com/netlify/build-image/commit/3cb2332c473d3cf120f420cb05c4a5e5b1946b74)

## [v3.3.10](https://github.com/netlify/build-image/compare/v3.3.9...v3.3.10) - 2020-05-08

### Merged

- Revert "Support installing tools via homebrew" [`#414`](https://github.com/netlify/build-image/pull/414)

### Commits

- Revert "Support installing tools via homebrew (#411)" [`4cbd219`](https://github.com/netlify/build-image/commit/4cbd219385eebc4aa83d4e9edbd4b77606262556)

## [v3.3.9](https://github.com/netlify/build-image/compare/v3.3.8...v3.3.9) - 2020-05-07

### Merged

- Support installing tools via homebrew [`#411`](https://github.com/netlify/build-image/pull/411)
- Don't pass PLATFORM, URL, or VERSION env vars to "swiftenv install" [`#401`](https://github.com/netlify/build-image/pull/401)
- Tag xenial builds as latest [`#409`](https://github.com/netlify/build-image/pull/409)
- Default to xenial tag for testing [`#407`](https://github.com/netlify/build-image/pull/407)

### Commits

- Add Intl for PHP [`af9121e`](https://github.com/netlify/build-image/commit/af9121e7ed944f9640e3ddd9e1130e23379cc135)
- Merge pull request #400 from netlify/fix/nvm-progress-bar [`0749a9c`](https://github.com/netlify/build-image/commit/0749a9c850ad21598a9c66af181cce606a799e7c)
- Fix nvm progress bar split on several lines [`98d08c9`](https://github.com/netlify/build-image/commit/98d08c974b9ec50df8202afb6c80d826ab23df89)

## [v3.3.9-faster-yarn.1](https://github.com/netlify/build-image/compare/v3.3.10...v3.3.9-faster-yarn.1) - 2020-05-11

### Commits

- Do not run `yarn` if `package.json` has not changed [`6fd8c6d`](https://github.com/netlify/build-image/commit/6fd8c6dd697438cdfa33823d286b7c837dfb39a1)
- Compute package-sha [`07269a1`](https://github.com/netlify/build-image/commit/07269a1c98d748deed14e0c70c48719da925d8c9)

## [v3.3.8](https://github.com/netlify/build-image/compare/v3.3.7...v3.3.8) - 2020-04-24

### Merged

- Swift Support [`#364`](https://github.com/netlify/build-image/pull/364)
- Pipe echo commands to bash shell [`#389`](https://github.com/netlify/build-image/pull/389)
- Add backend team as codeowners [`#387`](https://github.com/netlify/build-image/pull/387)

### Commits

- pipe commands from go installer [`9ffb22a`](https://github.com/netlify/build-image/commit/9ffb22af0ee65ab22debb6d7f880ca3b0b6e156e)

## [v3.3.7](https://github.com/netlify/build-image/compare/v3.3.6...v3.3.7) - 2020-03-05

### Merged

- Only remove Netlify Build's Node version if it's cached [`#379`](https://github.com/netlify/build-image/pull/379)

## [v3.3.6](https://github.com/netlify/build-image/compare/v3.3.5...v3.3.6) - 2020-03-03

### Merged

- Don't include documentation when installing bundler [`#369`](https://github.com/netlify/build-image/pull/369)
- Add PHP 7.4 [`#366`](https://github.com/netlify/build-image/pull/366)
- Add Clojure CLI tools [`#289`](https://github.com/netlify/build-image/pull/289)
- Define NETLIFY_BUILD_NODE_VERSION and "nvm install" it [`#375`](https://github.com/netlify/build-image/pull/375)
- Fix typo [`#373`](https://github.com/netlify/build-image/pull/373)
- Pin setuptools to &lt;45 to allow installing pipenv on python 2.7 [`#376`](https://github.com/netlify/build-image/pull/376)

## [v3.3.5](https://github.com/netlify/build-image/compare/v3.3.4...v3.3.5) - 2019-11-22

### Merged

- Use installed bundler version from Gemfile.lock [`#350`](https://github.com/netlify/build-image/pull/350)
- Fix test-tools/test-build.sh [`#349`](https://github.com/netlify/build-image/pull/349)

## [v3.3.4](https://github.com/netlify/build-image/compare/v3.3.3...v3.3.4) - 2019-11-15

### Merged

- Install bundler version specified in Gemfile.lock [`#348`](https://github.com/netlify/build-image/pull/348)

## [v3.3.3](https://github.com/netlify/build-image/compare/v3.3.2...v3.3.3) - 2019-11-05

### Commits

- Add GSL lib [`b31f332`](https://github.com/netlify/build-image/commit/b31f3326d42f71e8511255e2ecde88581f950359)

## [v3.3.2](https://github.com/netlify/build-image/compare/v3.3.1...v3.3.2) - 2019-05-09

### Merged

- Fix NETLIFY=true CI environment signal [`#314`](https://github.com/netlify/build-image/pull/314)

## [v3.3.1](https://github.com/netlify/build-image/compare/v3.3.0...v3.3.1) - 2019-05-08

### Merged

- Add Prep functions build function [`#309`](https://github.com/netlify/build-image/pull/309)

### Commits

- Add prep functions build function [`23b55c2`](https://github.com/netlify/build-image/commit/23b55c2959ea7a2b87742e7da7812514fb386bd0)

## [v3.3.0](https://github.com/netlify/build-image/compare/v3.2.2...v3.3.0) - 2019-05-07

### Merged

- Added Netlify environment variable. [`#297`](https://github.com/netlify/build-image/pull/297)
- Add rsvg. [`#300`](https://github.com/netlify/build-image/pull/300)
- Install Bower with Appropriate Package Manager [`#303`](https://github.com/netlify/build-image/pull/303)
- Handle ZOLA_VERSION [`#308`](https://github.com/netlify/build-image/pull/308)

### Commits

- Add Netlify ENV var [`648f7da`](https://github.com/netlify/build-image/commit/648f7dae75db4cbbf2563f8f3bb1d3a77543ec33)
- Add wasmer to included tools list [`979c605`](https://github.com/netlify/build-image/commit/979c605d5b0e28d1997a2a7854c57fdfa1b2e33a)

## [v3.2.2](https://github.com/netlify/build-image/compare/v3.2.1...v3.2.2) - 2019-04-30

### Merged

- Set wapm in the path, even when there is no wapm config files [`#307`](https://github.com/netlify/build-image/pull/307)

## [v3.2.1](https://github.com/netlify/build-image/compare/v3.2.0...v3.2.1) - 2019-04-29

### Merged

- Fix output when installing ZISI [`#305`](https://github.com/netlify/build-image/pull/305)

## [v3.2.0](https://github.com/netlify/build-image/compare/v3.1.3...v3.2.0) - 2019-04-29

### Merged

- Link the custom version of ZISI [`#304`](https://github.com/netlify/build-image/pull/304)
- Wasmer support. [`#301`](https://github.com/netlify/build-image/pull/301)

### Commits

- install bower with yarn if that's what the project uses [`d23ef79`](https://github.com/netlify/build-image/commit/d23ef798f1ab27a74480834b49501e3f2fffb67b)

## [v3.1.3](https://github.com/netlify/build-image/compare/v3.1.2...v3.1.3) - 2019-04-22

### Commits

- Update ZISI to 0.3.1 [`9389ebd`](https://github.com/netlify/build-image/commit/9389ebd48bcef659c3a007708716ae43f2f239eb)
- Add rsvg. [`ed94e6a`](https://github.com/netlify/build-image/commit/ed94e6a4d7eccc6c41edb2c5e8fb010ff1fa1be6)

## [v3.1.2](https://github.com/netlify/build-image/compare/v3.1.1...v3.1.2) - 2019-04-12

### Merged

- Fix caching bugs [`#298`](https://github.com/netlify/build-image/pull/298)

### Commits

- Added Netlify environment variable. [`55d8b78`](https://github.com/netlify/build-image/commit/55d8b7831778afd946f8b08c5b4b8d3fd8c8c221)

## [v3.1.1](https://github.com/netlify/build-image/compare/v3.1.0...v3.1.1) - 2019-04-09

### Commits

- Update ZISI to 0.2.5 [`5a564c2`](https://github.com/netlify/build-image/commit/5a564c254c4dc6b4795239c8213aa3960ada8ed5)

## [v3.1.0](https://github.com/netlify/build-image/compare/v3.0.2...v3.1.0) - 2019-04-09

### Merged

- Add zip-it-and-ship-it [`#291`](https://github.com/netlify/build-image/pull/291)
- Remove tmp files [`#288`](https://github.com/netlify/build-image/pull/288)
- Update python versions  [`#285`](https://github.com/netlify/build-image/pull/285)
- Use xenial distributions of PPAs and debs [`#283`](https://github.com/netlify/build-image/pull/283)
- Add Go version to included software list [`#282`](https://github.com/netlify/build-image/pull/282)

### Commits

- Update README.md [`0393c6e`](https://github.com/netlify/build-image/commit/0393c6e6d3e2a6ede23c6e5a00f3e5cb50bdc093)
- Allow for staging branch builds [`52572d7`](https://github.com/netlify/build-image/commit/52572d7ada03dbd5a03581673665ce0efd7f8537)
- Update included python versions [`19f0bff`](https://github.com/netlify/build-image/commit/19f0bfff6c51114fc90002a408ce8088c69ebb82)

## [v3.0.2](https://github.com/netlify/build-image/compare/v3.0.1...v3.0.2) - 2019-03-14

### Commits

- Update to ruby 2.6.2 [`f6d8f8a`](https://github.com/netlify/build-image/commit/f6d8f8aded7ffcb91b8bd6f40b69583f704b26c8)

## [v3.0.1](https://github.com/netlify/build-image/compare/v3.0.0...v3.0.1) - 2019-03-14

### Commits

- Fix README heading level [`b805ec3`](https://github.com/netlify/build-image/commit/b805ec39a78095efd568ce2ba38e28685e103ad3)
- Remove reference to master branch from README [`be65a07`](https://github.com/netlify/build-image/commit/be65a073cf8e699497600a72b0dc516cd3bee396)

## [v3.0.0](https://github.com/netlify/build-image/compare/v3.0.0-beta.7...v3.0.0) - 2019-03-14

## [v3.0.0-beta.7](https://github.com/netlify/build-image/compare/v3.0.0-beta.6...v3.0.0-beta.7) - 2019-03-14

### Merged

- Added support for 'Current' channel Dotnet Core in Dockerfile, using … [`#230`](https://github.com/netlify/build-image/pull/230)
- updated to wkhtmltopdf 0.12.5 and pandoc 2.4 [`#275`](https://github.com/netlify/build-image/pull/275)
- Replace trusty info with xenial info [`#278`](https://github.com/netlify/build-image/pull/278)

## [v3.0.0-beta.6](https://github.com/netlify/build-image/compare/v3.0.0-beta.5...v3.0.0-beta.6) - 2019-03-13

### Commits

- Cherrypick trusty README updates [`401af28`](https://github.com/netlify/build-image/commit/401af28a2978186bb33bafb3cae5ccbf3f51fe20)
- updated to wkhtmltopdf 0.12.5 and pandoc 2.4 [`6ac2421`](https://github.com/netlify/build-image/commit/6ac2421dc24ef266ba1225cdf748ea837c4d87b8)
- :sparkles: Added doxygen [`f593bbb`](https://github.com/netlify/build-image/commit/f593bbb3889c55f242d027b3e220d429238e6754)
- switch to LABEL, MAINTAINER is deprecated [`02126cb`](https://github.com/netlify/build-image/commit/02126cbca3a46591ac0cb7c4eee37f822aef403d)
- Install libenchant1c2a package [`53f83f6`](https://github.com/netlify/build-image/commit/53f83f62b688ad0fd5c15fef23dbbf325dd5bf23)

## [v3.0.0-beta.5](https://github.com/netlify/build-image/compare/v3.0.0-beta.4...v3.0.0-beta.5) - 2019-03-12

### Commits

- Update default versions in scripts [`bdbc3e8`](https://github.com/netlify/build-image/commit/bdbc3e898f0920a9e4999036b4ab03f9df9f12fd)
- Include git tag in environment variable NF_IMAGE_TAG [`c8d455b`](https://github.com/netlify/build-image/commit/c8d455b5789dfb548679a80a73fac324ff03ab51)
- Update version of Hugo in README [`bf465bb`](https://github.com/netlify/build-image/commit/bf465bb124c748bce45b8055972d031df358f93f)
- Update README to reflect versions of programs installed [`88fb4da`](https://github.com/netlify/build-image/commit/88fb4da848ba6007fbf026ac9e534bff5a766edf)
- Update default version of go to 1.12 [`af96293`](https://github.com/netlify/build-image/commit/af96293d02d04ad2e53390ac4959b129e43c4856)
- Use Node 10 LTS [`4e547a6`](https://github.com/netlify/build-image/commit/4e547a6249ee755c1ca1c27193c3e5c1b994f16f)

## [v3.0.0-beta.4](https://github.com/netlify/build-image/compare/v3.0.0-beta.3...v3.0.0-beta.4) - 2019-03-11

### Merged

- Suffix binrc cache with version number [`#274`](https://github.com/netlify/build-image/pull/274)

### Commits

- Fix command substitution for binrc cache [`63780cc`](https://github.com/netlify/build-image/commit/63780cc4dd9e859f1320208dbb0651dc584b53b1)

## [v3.0.0-beta.3](https://github.com/netlify/build-image/compare/v3.0.0-beta.2...v3.0.0-beta.3) - 2019-03-11

### Commits

- Print Hugo version when installing it [`6323241`](https://github.com/netlify/build-image/commit/6323241dd078ed33563d6725f694f56dd57697b4)

## [v3.0.0-beta.2](https://github.com/netlify/build-image/compare/v3.0.0-beta.1...v3.0.0-beta.2) - 2019-02-25

### Merged

- Xenial: Update to hugo 0.54 [`#270`](https://github.com/netlify/build-image/pull/270)

## [v3.0.0-beta.1](https://github.com/netlify/build-image/compare/v3.0.0-beta.0...v3.0.0-beta.1) - 2019-02-25

### Merged

- Use system jq [`#267`](https://github.com/netlify/build-image/pull/267)
- Install only one version of node + ruby [`#268`](https://github.com/netlify/build-image/pull/268)
- Add a comment around pandoc pacakges [`#269`](https://github.com/netlify/build-image/pull/269)
- Xenial: Update Node.js to v10 LTS [`#262`](https://github.com/netlify/build-image/pull/262)
- Bump test build ruby version [`#259`](https://github.com/netlify/build-image/pull/259)
- Xenial: Update to the latest stable ruby versions  [`#227`](https://github.com/netlify/build-image/pull/227)
- Fix branch names [`#258`](https://github.com/netlify/build-image/pull/258)
- Only squash tags [`#257`](https://github.com/netlify/build-image/pull/257)
- Add some new binary files to LFS config [`#229`](https://github.com/netlify/build-image/pull/229)

### Commits

- Update README.md [`7367f17`](https://github.com/netlify/build-image/commit/7367f17bac5744e822cde0d1af1312f57a2d8fdd)
- Update Node.js to v10 LTS [`9d2336f`](https://github.com/netlify/build-image/commit/9d2336f36bbdd1afab3d8399fab88985ce495808)
- Update the latest stable versions of ruby [`327b0c7`](https://github.com/netlify/build-image/commit/327b0c7aac6947aadbd84bea37a03be732d134cd)
- Fix version [`8ae7c85`](https://github.com/netlify/build-image/commit/8ae7c85f398f0f38e77601814cf6ebe02950c99b)
- Update rvm key servers again [`aeef1ae`](https://github.com/netlify/build-image/commit/aeef1aecbd0c67ea9cbda46703dff648ebbec5f5)
- 2.2 branch has been removed [`944fbf1`](https://github.com/netlify/build-image/commit/944fbf1a38d6068e9b853917d94616b11e15ed1f)

## [v3.0.0-beta.0](https://github.com/netlify/build-image/compare/v2.6.9...v3.0.0-beta.0) - 2019-02-01

### Merged

- Attempt a fix for rvm keys [`#255`](https://github.com/netlify/build-image/pull/255)
- Add Hugo 0.52 to dev image [`#244`](https://github.com/netlify/build-image/pull/244)
- Fix RVM gpg key retrieval [`#243`](https://github.com/netlify/build-image/pull/243)

### Commits

- Attempted python fixes [`5ce6a62`](https://github.com/netlify/build-image/commit/5ce6a62a5416a5a04a9cda3e68b8fe9cf7b37557)
- Attempting a python fix [`4d8c1fd`](https://github.com/netlify/build-image/commit/4d8c1fd62c3b888a8af073fce409e3ddc19d28da)
- Start building dev branch [`ce52a47`](https://github.com/netlify/build-image/commit/ce52a47407d7321ee98dea1be879845f6baa6b21)
- Install gnupg2 [`d9fbaf5`](https://github.com/netlify/build-image/commit/d9fbaf5a3b63ebd79962d0f34a393d46cbba5134)
- Remove missing language packages [`36045a1`](https://github.com/netlify/build-image/commit/36045a1adc1b1d4c9d08fe8c0900bc3cd900116e)
- Try updating rvm install process  [`c79cda3`](https://github.com/netlify/build-image/commit/c79cda3dfb177265a8f3dfaecea648578e3c4ca4)
- Install virtualenv with apt [`1e40d58`](https://github.com/netlify/build-image/commit/1e40d58ac6e2a3dbd885f14baafceecf75fe2bb7)
- Add Hugo 0.52 [`c70569c`](https://github.com/netlify/build-image/commit/c70569cb21a332b8e34e92fd32e05a2a9a0f6e5d)
- Update to Ubuntu 16.04 [`e2c2ac4`](https://github.com/netlify/build-image/commit/e2c2ac4563fbb4c0672c74f8216fd1f31a849d13)
- Remove offending ruby 2.2.9 [`8dec614`](https://github.com/netlify/build-image/commit/8dec6141ee372a5d034b07d05928ad790d18b984)
- Removing libgraphicsmagic-q16-3 [`7adbbdf`](https://github.com/netlify/build-image/commit/7adbbdfe2930e94e1b51532d00e9613de0bdb65f)

## [v2.6.9](https://github.com/netlify/build-image/compare/v2.6.8...v2.6.9) - 2018-12-21

### Merged

- Revert "Filter less on lingering process filter" [`#242`](https://github.com/netlify/build-image/pull/242)

## [v2.6.8](https://github.com/netlify/build-image/compare/v2.6.7...v2.6.8) - 2018-12-21

### Merged

- Filter less on lingering process filter [`#241`](https://github.com/netlify/build-image/pull/241)

### Fixed

- Add filters back [`#346`](https://github.com/netlify/buildbot/issues/346)

### Commits

- Remove process filters [`ce1e4bf`](https://github.com/netlify/build-image/commit/ce1e4bf048759c4ddf6d960f1a390b5aa1197304)

## [v2.6.7](https://github.com/netlify/build-image/compare/v2.6.6...v2.6.7) - 2018-12-08

### Commits

- Simplify Jenkinsfile to handle tags and special branches [`d888a79`](https://github.com/netlify/build-image/commit/d888a794e565c91a7e71658f2b177f9b1f9bc58d)

## [v2.6.6](https://github.com/netlify/build-image/compare/v2.6.5...v2.6.6) - 2018-12-08

### Commits

- Dump more env and fix tag reference env var [`bb7ccf8`](https://github.com/netlify/build-image/commit/bb7ccf8d67b56926e121bf541124250564b8046c)

## [v2.6.5](https://github.com/netlify/build-image/compare/v2.6.4...v2.6.5) - 2018-12-08

### Commits

- Fix tag env var reference [`9fb96e7`](https://github.com/netlify/build-image/commit/9fb96e78b80fccdaa21bed0fcfbec42edbdb9afa)
- Dump env [`ec8bae1`](https://github.com/netlify/build-image/commit/ec8bae1253b97b2c2e6dad249b3b808979357817)
- Merge tag 'v2.6.4' [`e94f528`](https://github.com/netlify/build-image/commit/e94f52877201eb44991b94c7b19a383965add0a7)

## [v2.6.4](https://github.com/netlify/build-image/compare/v2.6.3...v2.6.4) - 2018-12-07

### Merged

- Attempt to fix Jenkins tag build conditions [`#238`](https://github.com/netlify/build-image/pull/238)
- CONTRIBUTING.md Typos [`#236`](https://github.com/netlify/build-image/pull/236)

### Commits

- Typos [`9832510`](https://github.com/netlify/build-image/commit/983251033bf85a7d57a59e3dc428b5a05f22b4e9)

## [v2.6.3](https://github.com/netlify/build-image/compare/v2.6.2...v2.6.3) - 2018-12-07

### Merged

- Add versioning scripts [`#235`](https://github.com/netlify/build-image/pull/235)
- Fix untagged push [`#233`](https://github.com/netlify/build-image/pull/233)
- Add sha and tag docker tags [`#225`](https://github.com/netlify/build-image/pull/225)

### Fixed

- Add versioning scripts [`#234`](https://github.com/netlify/build-image/issues/234)

### Commits

- Add FILES [`a949ba3`](https://github.com/netlify/build-image/commit/a949ba36054d3a23001b498a17639689aec218e0)
- Finish up tagging conventions [`7419ce2`](https://github.com/netlify/build-image/commit/7419ce2e2f362e143db71f41f53176268c2d8166)
- Added support for 'Current' channel Dotnet Core in Dockerfile, using local install for buildbot. [`29da4a6`](https://github.com/netlify/build-image/commit/29da4a6c81bacfebf2131d9de4e1dd088e216b20)
- chore(deps): use latest Ruby patches [`770a7ef`](https://github.com/netlify/build-image/commit/770a7ef6a03d71832fe8e651e147a63655405425)
- Fix versioning script [`31b28c3`](https://github.com/netlify/build-image/commit/31b28c3dfa32b95100883fdbe30a322a96d2f858)
- Add some new binary files to LFS config [`3864846`](https://github.com/netlify/build-image/commit/386484698eed534e00419def2b6bc6eb845e1184)

## [v2.6.2](https://github.com/netlify/build-image/compare/v2.6.1...v2.6.2) - 2018-11-16

### Merged

- Fix false positive process warning on non-0 exit code [`#220`](https://github.com/netlify/build-image/pull/220)

## [v2.6.1](https://github.com/netlify/build-image/compare/v2.6.0...v2.6.1) - 2018-11-16

### Merged

- Fixed: Filter zombie processes [`#219`](https://github.com/netlify/build-image/pull/219)

### Commits

- Filter zombie processes  [`c9e72eb`](https://github.com/netlify/build-image/commit/c9e72ebcf0b8a4bb7ed3bb2ceb5edd4ef82b7498)

## [v2.6.0](https://github.com/netlify/build-image/compare/v2.5.0...v2.6.0) - 2018-11-16

### Merged

- Only filter builedbot path in ps list [`#218`](https://github.com/netlify/build-image/pull/218)
- Filter buildbot from lingering process message [`#216`](https://github.com/netlify/build-image/pull/216)
- Report lingering processes to the user [`#202`](https://github.com/netlify/build-image/pull/202)
- Fix vips dependency URL [`#203`](https://github.com/netlify/build-image/pull/203)

### Commits

- Update composer installer [`bedc321`](https://github.com/netlify/build-image/commit/bedc321c1aa8a0ee312c8661473ab4926cae7965)
- Specify the last working version of virtualenv [`f2e74fe`](https://github.com/netlify/build-image/commit/f2e74fee00488d6843d0c7d9a10e432054f12447)
- Fix missing dependency warning [`534ce16`](https://github.com/netlify/build-image/commit/534ce16b3dda07cff51918b7ed3816e838b4763c)

## [v2.5.0](https://github.com/netlify/build-image/compare/v2.4.4...v2.5.0) - 2018-09-06

### Merged

- Add standard directory tree generator [`#176`](https://github.com/netlify/build-image/pull/176)
- Add erlang and elixir [`#188`](https://github.com/netlify/build-image/pull/188)
- Add Zip and Curl for PHP [`#195`](https://github.com/netlify/build-image/pull/195)
- upgrade jq to 1.5 [`#192`](https://github.com/netlify/build-image/pull/192)
- document versions of some important software [`#191`](https://github.com/netlify/build-image/pull/191)

### Fixed

- Add Zip and Curl for PHP [`#194`](https://github.com/netlify/build-image/issues/194)

### Commits

- Add erlang repo with apt-add-repository [`a452e41`](https://github.com/netlify/build-image/commit/a452e414c08770f3bb818a0bf96c29d401c1808e)
- Update README [`6e6adef`](https://github.com/netlify/build-image/commit/6e6adef72df002da0b422755206cfe1cc5c7d19e)
- Put packages in alphabetic order [`be56523`](https://github.com/netlify/build-image/commit/be56523ffc248c5a90158067effb0771aa8fb43f)

## [v2.4.4](https://github.com/netlify/build-image/compare/v2.4.3...v2.4.4) - 2018-08-01

### Commits

- Remove build-image version output from script [`836d4b1`](https://github.com/netlify/build-image/commit/836d4b1b9f8aa85761d4be0698be3ac2f8c1f7f7)

## [v2.4.3](https://github.com/netlify/build-image/compare/v2.4.2...v2.4.3) - 2018-07-31

### Merged

- Add output of build-image version based on git commit [`#186`](https://github.com/netlify/build-image/pull/186)

## [v2.4.2](https://github.com/netlify/build-image/compare/v2.4.1...v2.4.2) - 2018-07-31

### Merged

- Install the gd and sqlite3 PHP extensions to minimally support Drupal [`#179`](https://github.com/netlify/build-image/pull/179)

### Commits

- Install the gd and sqlite3 PHP extensions. [`036ec5d`](https://github.com/netlify/build-image/commit/036ec5d0415cb5bd7011cf09d52926dee5d7aad9)
- Add standard directory tree generator [`59b0380`](https://github.com/netlify/build-image/commit/59b038012247da33a6acb5b84cafa647e46556e6)

## [v2.4.1](https://github.com/netlify/build-image/compare/v2.4.0...v2.4.1) - 2018-06-06

### Commits

- Update scripts to remove some differences between image and buildbot [`65e6d5c`](https://github.com/netlify/build-image/commit/65e6d5c2e258d1cabe831debfd07315e300425dc)

## [v2.4.0](https://github.com/netlify/build-image/compare/v2.3.0...v2.4.0) - 2018-06-06

### Merged

- add expect to handle automate interactive cli [`#164`](https://github.com/netlify/build-image/pull/164)
- Support Pipfile [`#168`](https://github.com/netlify/build-image/pull/168)
- install pandoc via deb provided by pandoc maintainer instead of distribution [`#174`](https://github.com/netlify/build-image/pull/174)
- Added Catalan, Basque and Galician [`#167`](https://github.com/netlify/build-image/pull/167)
- Add support with Go through Gimme. [`#160`](https://github.com/netlify/build-image/pull/160)

### Fixed

- Support Pipfile [`#151`](https://github.com/netlify/build-image/issues/151)

### Commits

- Fix Go installation. [`1c6830b`](https://github.com/netlify/build-image/commit/1c6830b5d088220272b03dc48226666899c46bdc)
- Fail if the default gimme command fails to install Go. [`44a82d1`](https://github.com/netlify/build-image/commit/44a82d1f57a2a57b47e1763adfae227703b3aef9)
- install deb provided by pandoc maintainer [`d55365f`](https://github.com/netlify/build-image/commit/d55365f578a83a09c84805bcd998047583b2a9be)
- Update README.md [`aeab297`](https://github.com/netlify/build-image/commit/aeab297b9d7f6000ed4ba3938735184a7ab48f37)
- Install Pipenv while building image [`0665e11`](https://github.com/netlify/build-image/commit/0665e11cb89d554ea3f12a4e5706f6b4f7836884)
- Pipenv should create virtualenv inside cwd [`c9eb9f4`](https://github.com/netlify/build-image/commit/c9eb9f41bf04a497f666efab57a26c2d79550080)
- Switch Pipenv runtime to 2.7 [`8ceabad`](https://github.com/netlify/build-image/commit/8ceabadfa9a613a5d0e7af3e727afa72f56c89d6)
- Show link to python versions when pipenv install fails [`01334f7`](https://github.com/netlify/build-image/commit/01334f7085e88769cd54eb7e6993c40ffc0bd48a)
- Pipenv should default to Python 2.7 [`fad2e71`](https://github.com/netlify/build-image/commit/fad2e7162f6d6739f97362d32701319e74b950d5)

## [v2.3.0](https://github.com/netlify/build-image/compare/v2.2.1...v2.3.0) - 2018-03-01

### Merged

- Add python3.5-dev and python3.6-dev packages [`#155`](https://github.com/netlify/build-image/pull/155)
- Better error on python fail [`#153`](https://github.com/netlify/build-image/pull/153)
- Add version list to README [`#152`](https://github.com/netlify/build-image/pull/152)

### Fixed

- Add python3.5-dev and python3.6-dev packages [`#154`](https://github.com/netlify/build-image/issues/154)

### Commits

- Fail build if python version is not available [`cad6eea`](https://github.com/netlify/build-image/commit/cad6eeaa83b381c5e1f325ad4b99267e678a4c52)
- Update CHANGELOG [`ea5bf0e`](https://github.com/netlify/build-image/commit/ea5bf0e840230ce726460b3aca762bfc24434e63)
- update error messaging with pointer to current versions [`49d9437`](https://github.com/netlify/build-image/commit/49d9437d12c9e4c4d55ae390012c20f4df6dfb98)
- update messaging [`fe344a4`](https://github.com/netlify/build-image/commit/fe344a4eb68ee1448d66683faa95ab4be231b37e)

## [v2.2.1](https://github.com/netlify/build-image/compare/v2.2.0...v2.2.1) - 2018-02-23

### Fixed

- Add nasm [`#140`](https://github.com/netlify/build-image/issues/140)

### Commits

- Add tags and a CHANGELOG [`106923d`](https://github.com/netlify/build-image/commit/106923d3d4e9cb3a0e663135e17221c1a57c57d6)

## [v2.2.0](https://github.com/netlify/build-image/compare/v2.1.2...v2.2.0) - 2018-02-22

### Merged

- Switch to PPA for python installs [`#145`](https://github.com/netlify/build-image/pull/145)
- Use PPA for emacs install [`#144`](https://github.com/netlify/build-image/pull/144)

### Fixed

- Add mbstring for PHP [`#149`](https://github.com/netlify/build-image/issues/149)

## [v2.1.2](https://github.com/netlify/build-image/compare/v2.1.1...v2.1.2) - 2018-02-21

### Merged

- Install composer  [`#148`](https://github.com/netlify/build-image/pull/148)

### Commits

- Build images for PRs/branches [`7473591`](https://github.com/netlify/build-image/commit/74735910646eeae6a2fea8bad4841fb43e67eba0)
- Add composer install back to Dockerfile [`7fdb498`](https://github.com/netlify/build-image/commit/7fdb498d5df0e585d871a4f115f730d8443e8ee4)

## [v2.1.1](https://github.com/netlify/build-image/compare/v2.1.0...v2.1.1) - 2018-02-19

### Fixed

- Add rsync [`#143`](https://github.com/netlify/build-image/issues/143)
- Add php xml extension [`#142`](https://github.com/netlify/build-image/issues/142)

## [v2.1.0](https://github.com/netlify/build-image/compare/v2.0.0...v2.1.0) - 2018-02-15

### Commits

- Ensure language env vars are set for everything [`97ea99b`](https://github.com/netlify/build-image/commit/97ea99b7a1f7e78cc658537926d292227c8b5891)
- Fix flags so nothing is included in the command if empty [`3d923ad`](https://github.com/netlify/build-image/commit/3d923ad4e06060256605a6c46bc13692436e9314)
- Add .gitconfig to root user, since that is who performs all the git operations [`c86646e`](https://github.com/netlify/build-image/commit/c86646e99e67f8324bc953c2471c37177aa3e2c9)

## [v2.0.0](https://github.com/netlify/build-image/compare/v1.4.0...v2.0.0) - 2018-02-09

### Merged

- Simplify hugo installs [`#136`](https://github.com/netlify/build-image/pull/136)
- Add better PHP support [`#135`](https://github.com/netlify/build-image/pull/135)
- Add libicu-dev to image [`#133`](https://github.com/netlify/build-image/pull/133)
- Cleanup how cache is saved/restored [`#132`](https://github.com/netlify/build-image/pull/132)
- Update libvips to 8.6 [`#120`](https://github.com/netlify/build-image/pull/120)
- Reduce installed ruby to latest supported versions.  [`#131`](https://github.com/netlify/build-image/pull/131)
- Update build-image to match current defaults for new sites [`#130`](https://github.com/netlify/build-image/pull/130)
- Update binrc version [`#129`](https://github.com/netlify/build-image/pull/129)
- Remove unused command [`#105`](https://github.com/netlify/build-image/pull/105)
- Cache Leiningen and Boot dependencies [`#117`](https://github.com/netlify/build-image/pull/117)

### Fixed

- Add better PHP support [`#124`](https://github.com/netlify/build-image/issues/124) [`#102`](https://github.com/netlify/build-image/issues/102)
- Fix python pip caching [`#119`](https://github.com/netlify/build-image/issues/119)
- Cache .emacs.d directory [`#115`](https://github.com/netlify/build-image/issues/115)
- Install latest git from PPA [`#121`](https://github.com/netlify/build-image/issues/121)
- Add support for BUNDLER_FLAGS [`#85`](https://github.com/netlify/build-image/issues/85)
- Fallback to .node-version if .nvmrc is missing [`#79`](https://github.com/netlify/build-image/issues/79)
- Reduce installed ruby to latest supported versions. Cache custom versions. [`#125`](https://github.com/netlify/build-image/issues/125)
- Add missing run-build-functions.sh to Dockerfile [`#116`](https://github.com/netlify/build-image/issues/116)

### Commits

- Add Jenkinsfile build normal and squashed images [`f28a47e`](https://github.com/netlify/build-image/commit/f28a47e6e682d75f6cc07ba5d82c18d59787e552)
- Add some minor cleanup [`f3956cd`](https://github.com/netlify/build-image/commit/f3956cd38cc69cfa2a7870896d84418810fe79be)
- Fix docker push [`20e98b9`](https://github.com/netlify/build-image/commit/20e98b9a536bcac36d604693a147ec4d3c146b78)
- Fix output coloring [`1a0316b`](https://github.com/netlify/build-image/commit/1a0316b6b323b621a39172c4a739f305af6d7e4a)
- Fix some formatting [`0bfa77b`](https://github.com/netlify/build-image/commit/0bfa77b3a1fc352e80ecf0c0d742df92946b4d95)
- Install node 8 since it is now a default [`9d1d9d5`](https://github.com/netlify/build-image/commit/9d1d9d58103209e8dade04e115a52a51f25aeb9f)
- Explicitly tell binrc where to install [`40adb61`](https://github.com/netlify/build-image/commit/40adb6101313799ff337815b7d79355bde2b056f)
- Use short flag name for binrc [`fec6157`](https://github.com/netlify/build-image/commit/fec61575b3de64de9ea906048f49f2315c4a97cc)
- binrc flags must come last apparently [`ea3c6c6`](https://github.com/netlify/build-image/commit/ea3c6c615245e4dd932ee3970105cba047d39de9)
- Fix php version switch [`8ceea6d`](https://github.com/netlify/build-image/commit/8ceea6db4cab9126be517e20d1ba452df0fba24f)
- Fix indentation [`688b515`](https://github.com/netlify/build-image/commit/688b5151fdd8188b2b2063f802e521b5ca9779c9)
- Remove semicolons [`7b77fe7`](https://github.com/netlify/build-image/commit/7b77fe76115ae4b37198c1d99895f6e01bcc0956)
- Use explicit credentials [`0f5db6c`](https://github.com/netlify/build-image/commit/0f5db6cd1f8ebb004de4421c506bfa6d660b9af5)
- Small tweaks to improve image [`28201bb`](https://github.com/netlify/build-image/commit/28201bb4faf1fbcb0eb3c1af8a902167ab3d785d)
- Ensure hugo is installed where buildbot user can access it [`fbd3070`](https://github.com/netlify/build-image/commit/fbd3070c04a866e90ee6dcf3058233f51777f537)
- Fix RUBY_VERSION handling [`3d9f40e`](https://github.com/netlify/build-image/commit/3d9f40e6d467410ed858e33674af7c549d2462e1)
- Update remaining YARN_VERSION [`e3071cb`](https://github.com/netlify/build-image/commit/e3071cbe41488a22512c1a0cc48d23d5c47d6b10)
- Extra } :( [`7c17d90`](https://github.com/netlify/build-image/commit/7c17d90e52c69ac549c0c4971220a0c78adf27e6)
- Missing ) [`74dbad0`](https://github.com/netlify/build-image/commit/74dbad0d02b2d5faf578394c758db59758f2c1b1)
- Add missing ssh dependency [`50b7ac8`](https://github.com/netlify/build-image/commit/50b7ac89933be0de98271592663bbbb262766ccb)
- Remove autogen from vips install [`3681ff8`](https://github.com/netlify/build-image/commit/3681ff8c744af3bf03e1480daa72fb3431254a2b)

## [v1.4.0](https://github.com/netlify/build-image/compare/v1.3.1...v1.4.0) - 2017-12-15

### Commits

- Cache Leiningen and Boot dependencies [`f3a4d49`](https://github.com/netlify/build-image/commit/f3a4d49a5a73c6c051af11daed2e0faad5f30ba4)

## [v1.3.1](https://github.com/netlify/build-image/compare/v1.3.0...v1.3.1) - 2017-12-14

### Merged

- This reverts commit bf9a87925ac2db8531eb1c45e2671bd32a9d6e22, reversing [`#114`](https://github.com/netlify/build-image/pull/114)
- Install npm modules if any of the npm lock files change [`#114`](https://github.com/netlify/build-image/pull/114)
- Simplify logic using || instead of negated if [`#107`](https://github.com/netlify/build-image/pull/107)
- Simplify logic using != [`#106`](https://github.com/netlify/build-image/pull/106)

### Fixed

- Install npm modules if any of the npm lock files change [`#113`](https://github.com/netlify/build-image/issues/113)

## [v1.3.0](https://github.com/netlify/build-image/compare/v1.2.3...v1.3.0) - 2017-12-06

### Merged

- adding cmake [`#110`](https://github.com/netlify/build-image/pull/110)
- Add LZ4 compression binaries [`#112`](https://github.com/netlify/build-image/pull/112)

### Commits

- Pin phpbrew to working version [`ae1480f`](https://github.com/netlify/build-image/commit/ae1480fc14576aac31550aeaecf62bd530a5f09b)
- Add missing space [`1e455dc`](https://github.com/netlify/build-image/commit/1e455dcc6c3b15c71e7c90080a719e100bf34c4f)
- Fix lz4 install [`9e2ed2d`](https://github.com/netlify/build-image/commit/9e2ed2d7a049a3153aaf4cb74b9c783b8ef9f7aa)

## [v1.2.3](https://github.com/netlify/build-image/compare/v1.2.2...v1.2.3) - 2017-12-04

### Commits

- adding cmake [`86d5c8e`](https://github.com/netlify/build-image/commit/86d5c8e4f505a398df89d3e4b71f2f66debe1633)
- add heading/anchor for cache testing [`dd11ce3`](https://github.com/netlify/build-image/commit/dd11ce307c545aae0dd12cd2be1de7bddb0bd767)

## [v1.2.2](https://github.com/netlify/build-image/compare/v1.2.1...v1.2.2) - 2017-11-21

### Merged

- Fix emacs install [`#104`](https://github.com/netlify/build-image/pull/104)

### Commits

- Simplify logic using || instead of negated if [`8cf34d8`](https://github.com/netlify/build-image/commit/8cf34d803123620c9a9de4eb2bd3ec79e3362740)
- Simplify logic using != [`b76d83c`](https://github.com/netlify/build-image/commit/b76d83c67c55033f4fd123c146412d80087dd429)
- Remove unused command [`425ea81`](https://github.com/netlify/build-image/commit/425ea8138e73ac054236119d5052704822ca098a)

## [v1.2.1](https://github.com/netlify/build-image/compare/v1.2.0...v1.2.1) - 2017-11-13

### Merged

- Add Emacs Cask support [`#73`](https://github.com/netlify/build-image/pull/73)

### Commits

- Move additional apt deps into the initial install [`12246ce`](https://github.com/netlify/build-image/commit/12246cece6a9dcf1b4cd83eff0e4a219a16adc51)

## [v1.2.0](https://github.com/netlify/build-image/compare/v1.1.1...v1.2.0) - 2017-11-09

### Merged

- added pandoc and wkhtmltopdf as dependencies [`#88`](https://github.com/netlify/build-image/pull/88)
- Add jq to dockerfile [`#71`](https://github.com/netlify/build-image/pull/71)
- Install Gutenberg based on the environment variable. [`#100`](https://github.com/netlify/build-image/pull/100)
- improve boot build speed (and hopefully fix mine) [`#44`](https://github.com/netlify/build-image/pull/44)
- Create .editorconfig [`#70`](https://github.com/netlify/build-image/pull/70)
- Install exiftool [`#87`](https://github.com/netlify/build-image/pull/87)
- Add headless Chrome support with libgtk-3-0 [`#90`](https://github.com/netlify/build-image/pull/90)
- Update Dockerfile for latest Ruby version 2.4.2 released [`#94`](https://github.com/netlify/build-image/pull/94)
- fixes for phpbrew install (#95) and libvips install (#92) [`#96`](https://github.com/netlify/build-image/pull/96)
- Update Binrc version to 0.2.2 [`#99`](https://github.com/netlify/build-image/pull/99)

### Commits

- Fix wkhtml install [`383ce05`](https://github.com/netlify/build-image/commit/383ce05f713f8e410e11adfc9252f53804f79b95)
- Update Dockerfile for latest Ruby versions released [`addc6c6`](https://github.com/netlify/build-image/commit/addc6c687f13a28130af454275d06da1670908bb)

## [v1.1.1](https://github.com/netlify/build-image/compare/v1.1.0...v1.1.1) - 2017-09-15

### Merged

- Get latest released version of nvm [`#80`](https://github.com/netlify/build-image/pull/80)

## [v1.1.0](https://github.com/netlify/build-image/compare/v1.0.1...v1.1.0) - 2017-08-09

### Merged

- Add python 3.6.2 [`#77`](https://github.com/netlify/build-image/pull/77)

## v1.0.1 - 2017-08-08

### Merged

- Add support for NPM_VERSION and NPM_FLAGS [`#76`](https://github.com/netlify/build-image/pull/76)
