---
layout: section
title: "Beam Presentation Materials"
section_menu: section-menu/community.html
permalink: /community/presentation-materials/
redirect_from:
 - /learn/presentation-materials/
 - /contribute/presentation-materials/
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Apache Beam Presentation Materials

Are you interested in learning more about Apache Beam or giving a talk about Apache Beam? Excellent! The Apache Beam community has created this collection of materials to help you get started. The community periodically reviews these materials to ensure they are accurate and up-to-date.

<div class="panel panel-default">
  <div class="panel-body">
    <iframe src="https://drive.google.com/embeddedfolderview?id=0B-IhJZh9Ab52a3JLVXFWMDltcHM#list" width="700" height="300" frameborder="0"></iframe>
  </div>
</div>

## Using these materials
These materials can be used by anyone. If you do use these materials, please remember to give credit to the authors cited in each presentation. These materials include speaker notes and you can view them by clicking **`View`** and selecting **`Show speaker notes`**. Some presentations have `[Long]` or `[Short]` in their name, such as the *Apache Beam Model*, which means there are two different presentations (a long and short version) depending on your needs and time constraints.

If you have any questions about the these materials, please ask on the [`user@beam.apache.org`](mailto:user@beam.apache.org) mailing list.

The Apache Beam community is looking for feedback on these materials to improve them over time. If you deliver a presentation based on these materials, we'd love to hear from you on the [`user@beam.apache.org`](mailto:user@beam.apache.org) mailing list. Please share your thoughts, questions you were asked, and (if available and appropriate) a link to the recording of your talk so the rest of the Apache Beam community can benefit from it.

## Contributing new content
The Apache Beam community is always looking for new core content and contributions!

If you are interested in contributing new content, we recommend you first search the [Apache Beam JIRA](https://issues.apache.org/jira/browse/BEAM) to see if your idea currently has an open JIRA item. If it does not, send an email to the [`user@beam.apache.org`](mailto:user@beam.apache.org) mailing list or open a new issue in the [Apache Beam JIRA](https://issues.apache.org/jira/browse/BEAM) using the [website](https://issues.apache.org/jira/issues/?jql=project%20%3D%20BEAM%20AND%20component%20%3D%20website) component. Based on community submissions or contributions, the Beam community collaboratively reviews or creates new content and then adds it to this shared space for everyone to use.

## Corrections and updates
If you encounter missing, incorrect, or out of date material, please make a comment in the presentation or send an email to the [`user@beam.apache.org`](mailto:user@beam.apache.org) mailing list.
