/*
 * Decompiled with CFR 0.152.
 */
package com.gopivotal.buildpack.support.tomcat;

import java.lang.reflect.Method;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardContext;

public class ApplicationStartupFailureDetectingLifecycleListener
implements LifecycleListener {
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            Container[] contexts;
            Container host = (Container)event.getLifecycle();
            for (Container container : contexts = host.findChildren()) {
                if (!(container instanceof StandardContext)) continue;
                this.checkContext((StandardContext)container);
            }
        }
    }

    private void checkContext(StandardContext context) {
        Object state = null;
        try {
            Method getStateMethod = StandardContext.class.getMethod("getState", new Class[0]);
            state = getStateMethod.invoke((Object)context, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.tomcat6ApplicationNotRunning(state) || this.tomcat7ApplicationNotRunning(state)) {
            String message = "Error: Application " + context.getDisplayName() + " failed (state = " + state + "): shutting down Tomcat";
            System.err.println(message);
            throw new IllegalStateException(message);
        }
    }

    private boolean tomcat6ApplicationNotRunning(Object state) {
        return state instanceof Integer && (Integer)state != 1;
    }

    private boolean tomcat7ApplicationNotRunning(Object state) {
        return !(state instanceof Integer) && state instanceof LifecycleState && (LifecycleState)state != LifecycleState.STARTED;
    }
}

