/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.sina.weibo.sdk.api.BaseMediaObject;
import com.sina.weibo.sdk.utils.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class ImageObject
extends BaseMediaObject {
    private static final int DATA_SIZE = 0x200000;
    public byte[] imageData;
    public String imagePath;
    public static final Parcelable.Creator<ImageObject> CREATOR = new Parcelable.Creator<ImageObject>(){

        public ImageObject createFromParcel(Parcel in) {
            return new ImageObject(in);
        }

        public ImageObject[] newArray(int size) {
            return new ImageObject[size];
        }
    };

    public ImageObject() {
    }

    public ImageObject(Parcel in) {
        this.imageData = in.createByteArray();
        this.imagePath = in.readString();
    }

    public final void setImageObject(Bitmap bitmap) {
        ByteArrayOutputStream os = null;
        try {
            try {
                os = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)os);
                this.imageData = os.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtil.e("Weibo.ImageObject", "put thumb failed");
                try {
                    os.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.imageData);
        dest.writeString(this.imagePath);
    }

    @Override
    public boolean checkArgs() {
        if (this.imageData == null && this.imagePath == null) {
            LogUtil.e("Weibo.ImageObject", "imageData and imagePath are null");
            return false;
        }
        if (this.imageData != null && this.imageData.length > 0x200000) {
            LogUtil.e("Weibo.ImageObject", "imageData is too large");
            return false;
        }
        if (this.imagePath != null && this.imagePath.length() > 512) {
            LogUtil.e("Weibo.ImageObject", "imagePath is too length");
            return false;
        }
        if (this.imagePath != null) {
            File file = new File(this.imagePath);
            try {
                if (!file.exists() || file.length() == 0L || file.length() > 0xA00000L) {
                    LogUtil.e("Weibo.ImageObject", "checkArgs fail, image content is too large or not exists");
                    return false;
                }
            }
            catch (SecurityException e) {
                LogUtil.e("Weibo.ImageObject", "checkArgs fail, image content is too large or not exists");
                return false;
            }
        }
        return true;
    }

    @Override
    public int getObjType() {
        return 2;
    }

    @Override
    protected BaseMediaObject toExtraMediaObject(String str) {
        return this;
    }

    @Override
    protected String toExtraMediaString() {
        return "";
    }
}

