/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.auth.WeiboParameters;
import com.sina.weibo.sdk.utils.BitmapHelper;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.NetworkHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class Utility {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final char[] encodes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final byte[] decodes = new byte[256];

    public static Bundle parseUrl(String url) {
        try {
            URL u = new URL(url);
            Bundle b = Utility.decodeUrl(u.getQuery());
            b.putAll(Utility.decodeUrl(u.getRef()));
            return b;
        }
        catch (MalformedURLException e) {
            return new Bundle();
        }
    }

    public static void showToast(String content, Context ct) {
        Toast.makeText((Context)ct, (CharSequence)content, (int)1).show();
    }

    public static Bundle decodeUrl(String s) {
        Bundle params = new Bundle();
        if (s != null) {
            String[] array;
            String[] stringArray = array = s.split("&");
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                String[] v = parameter.split("=");
                try {
                    params.putString(URLDecoder.decode(v[0], DEFAULT_CHARSET), URLDecoder.decode(v[1], DEFAULT_CHARSET));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return params;
    }

    public static String packUrl(HashMap<String, String> params) {
        if (params == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String value = "";
        boolean bFirst = true;
        for (String key : params.keySet()) {
            value = params.get(key);
            if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) continue;
            try {
                if (bFirst) {
                    bFirst = false;
                } else {
                    sb.append("&");
                }
                sb.append(URLEncoder.encode(key, DEFAULT_CHARSET)).append("=").append(URLEncoder.encode(value, DEFAULT_CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static Bundle unpackUrl(String url) {
        Bundle params = new Bundle();
        if (url != null) {
            String[] array;
            String[] stringArray = array = url.split("&");
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                String[] v = parameter.split("=");
                try {
                    params.putString(URLDecoder.decode(v[0], DEFAULT_CHARSET), URLDecoder.decode(v[1], DEFAULT_CHARSET));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return params;
    }

    public static String encodeUrl(WeiboParameters parameters) {
        if (parameters == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int loc = 0;
        while (loc < parameters.size()) {
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            String _key = parameters.getKey(loc);
            String _value = parameters.getValue(_key);
            if (_value == null) {
                LogUtil.i("encodeUrl", "key:" + _key + " 's value is null");
            } else {
                try {
                    sb.append(String.valueOf(URLEncoder.encode(parameters.getKey(loc), DEFAULT_CHARSET)) + "=" + URLEncoder.encode(parameters.getValue(loc), DEFAULT_CHARSET));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            LogUtil.i("encodeUrl", sb.toString());
            ++loc;
        }
        return sb.toString();
    }

    public static String encodeParameters(WeiboParameters httpParams) {
        if (httpParams == null || Utility.isBundleEmpty(httpParams)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int j = 0;
        int loc = 0;
        while (loc < httpParams.size()) {
            String key = httpParams.getKey(loc);
            if (j != 0) {
                buf.append("&");
            }
            try {
                buf.append(URLEncoder.encode(key, DEFAULT_CHARSET)).append("=").append(URLEncoder.encode(httpParams.getValue(key), DEFAULT_CHARSET));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ++j;
            ++loc;
        }
        return buf.toString();
    }

    public static Bundle formBundle(Oauth2AccessToken oat) {
        Bundle params = new Bundle();
        params.putString("access_token", oat.getToken());
        params.putString("refresh_token", oat.getRefreshToken());
        params.putString("expires_in", String.valueOf(oat.getExpiresTime()));
        return params;
    }

    public static Bundle formErrorBundle(Exception e) {
        Bundle params = new Bundle();
        params.putString("error", e.getMessage());
        return params;
    }

    private static boolean isBundleEmpty(WeiboParameters bundle) {
        return bundle == null || bundle.size() == 0;
    }

    public static String encodeBase62(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        int pos = 0;
        int val = 0;
        int i = 0;
        while (i < data.length) {
            val = val << 8 | data[i] & 0xFF;
            pos += 8;
            while (pos > 5) {
                char c = encodes[val >> (pos -= 6)];
                sb.append(c == 'i' ? "ia" : (c == '+' ? "ib" : (c == '/' ? "ic" : Character.valueOf(c))));
                val &= (1 << pos) - 1;
            }
            ++i;
        }
        if (pos > 0) {
            char c = encodes[val << 6 - pos];
            sb.append(c == 'i' ? "ia" : (c == '+' ? "ib" : (c == '/' ? "ic" : Character.valueOf(c))));
        }
        return sb.toString();
    }

    public static byte[] decodeBase62(String string) {
        if (string == null) {
            return null;
        }
        char[] data = string.toCharArray();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(string.toCharArray().length);
        int pos = 0;
        int val = 0;
        int i = 0;
        while (i < data.length) {
            int c = data[i];
            if (c == 105) {
                c = (c = data[++i]) == 97 ? 105 : (c == 98 ? 43 : (c == 99 ? 47 : data[--i]));
            }
            val = val << 6 | decodes[c];
            pos += 6;
            while (pos > 7) {
                baos.write(val >> (pos -= 8));
                val &= (1 << pos) - 1;
            }
            ++i;
        }
        return baos.toByteArray();
    }

    private static boolean deleteDependon(File file, int maxRetryCount) {
        int retryCount = 1;
        maxRetryCount = maxRetryCount < 1 ? 5 : maxRetryCount;
        boolean isDeleted = false;
        if (file != null) {
            while (!isDeleted && retryCount <= maxRetryCount && file.isFile() && file.exists()) {
                isDeleted = file.delete();
                if (isDeleted) continue;
                ++retryCount;
            }
        }
        return isDeleted;
    }

    private static void mkdirs(File dir_) {
        if (dir_ == null) {
            return;
        }
        if (!dir_.exists() && !dir_.mkdirs()) {
            throw new RuntimeException("fail to make " + dir_.getAbsolutePath());
        }
    }

    private static void createNewFile(File file_) {
        if (file_ == null) {
            return;
        }
        if (!Utility.__createNewFile(file_)) {
            throw new RuntimeException(String.valueOf(file_.getAbsolutePath()) + " doesn't be created!");
        }
    }

    private static void delete(File f) {
        if (f != null && f.exists() && !f.delete()) {
            throw new RuntimeException(String.valueOf(f.getAbsolutePath()) + " doesn't be deleted!");
        }
    }

    private static boolean __createNewFile(File file_) {
        if (file_ == null) {
            return false;
        }
        Utility.makesureParentExist(file_);
        if (file_.exists()) {
            Utility.delete(file_);
        }
        try {
            return file_.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean deleteDependon(String filepath, int maxRetryCount) {
        if (TextUtils.isEmpty((CharSequence)filepath)) {
            return false;
        }
        return Utility.deleteDependon(new File(filepath), maxRetryCount);
    }

    private static boolean deleteDependon(String filepath) {
        return Utility.deleteDependon(filepath, 0);
    }

    private static boolean doesExisted(File file) {
        return file != null && file.exists();
    }

    private static boolean doesExisted(String filepath) {
        if (TextUtils.isEmpty((CharSequence)filepath)) {
            return false;
        }
        return Utility.doesExisted(new File(filepath));
    }

    private static void makesureParentExist(File file_) {
        if (file_ == null) {
            return;
        }
        File parent = file_.getParentFile();
        if (parent != null && !parent.exists()) {
            Utility.mkdirs(parent);
        }
    }

    private static void makesureFileExist(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            Utility.makesureParentExist(file);
            Utility.createNewFile(file);
        }
    }

    private static void makesureFileExist(String filePath_) {
        if (filePath_ == null) {
            return;
        }
        Utility.makesureFileExist(new File(filePath_));
    }

    public static boolean isWifi(Context mContext) {
        ConnectivityManager connectivityManager = (ConnectivityManager)mContext.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }

    public static String generateGUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static boolean isChineseLocale(Context context) {
        try {
            Locale locale = context.getResources().getConfiguration().locale;
            return Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale) || Locale.SIMPLIFIED_CHINESE.equals(locale) || Locale.TAIWAN.equals(locale);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static Bundle errorSAX(String responsetext) {
        Bundle mErrorBun = new Bundle();
        if (responsetext != null && responsetext.indexOf("{") >= 0) {
            try {
                JSONObject json = new JSONObject(responsetext);
                mErrorBun.putString("error", json.optString("error"));
                mErrorBun.putString("error_code", json.optString("error_code"));
                mErrorBun.putString("error_description", json.optString("error_description"));
            }
            catch (JSONException e) {
                mErrorBun.putString("error", "JSONExceptionerror");
            }
        }
        return mErrorBun;
    }

    public static String getSign(Context context, String pkgName) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(pkgName, 64);
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            return null;
        }
        int j = 0;
        while (j < packageInfo.signatures.length) {
            byte[] str = packageInfo.signatures[j].toByteArray();
            if (str != null) {
                return MD5.hexdigest(str);
            }
            ++j;
        }
        return null;
    }

    public static final class UploadImageUtils {
        private static void revitionImageSizeHD(String picfile, int size, int quality) throws IOException {
            if (size <= 0) {
                throw new IllegalArgumentException("size must be greater than 0!");
            }
            if (!Utility.doesExisted(picfile)) {
                throw new FileNotFoundException(picfile == null ? "null" : picfile);
            }
            if (!BitmapHelper.verifyBitmap(picfile)) {
                throw new IOException("");
            }
            int photoSizesOrg = 2 * size;
            FileInputStream input = new FileInputStream(picfile);
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)opts);
            try {
                input.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            int rate = 0;
            int i = 0;
            while (true) {
                if (opts.outWidth >> i <= photoSizesOrg && opts.outHeight >> i <= photoSizesOrg) break;
                ++i;
            }
            rate = i;
            opts.inSampleSize = (int)Math.pow(2.0, rate);
            opts.inJustDecodeBounds = false;
            Bitmap temp = UploadImageUtils.safeDecodeBimtapFile(picfile, opts);
            if (temp == null) {
                throw new IOException("Bitmap decode error!");
            }
            Utility.deleteDependon(picfile);
            Utility.makesureFileExist(picfile);
            int org = temp.getWidth() > temp.getHeight() ? temp.getWidth() : temp.getHeight();
            float rateOutPut = (float)size / (float)org;
            if (rateOutPut < 1.0f) {
                Bitmap outputBitmap;
                while (true) {
                    try {
                        outputBitmap = Bitmap.createBitmap((int)((int)((float)temp.getWidth() * rateOutPut)), (int)((int)((float)temp.getHeight() * rateOutPut)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    }
                    catch (OutOfMemoryError e) {
                        System.gc();
                        rateOutPut = (float)((double)rateOutPut * 0.8);
                        continue;
                    }
                    break;
                }
                if (outputBitmap == null) {
                    temp.recycle();
                }
                Canvas canvas = new Canvas(outputBitmap);
                Matrix matrix = new Matrix();
                matrix.setScale(rateOutPut, rateOutPut);
                canvas.drawBitmap(temp, matrix, new Paint());
                temp.recycle();
                temp = outputBitmap;
            }
            FileOutputStream output = new FileOutputStream(picfile);
            if (opts != null && opts.outMimeType != null && opts.outMimeType.contains("png")) {
                temp.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)output);
            } else {
                temp.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)output);
            }
            try {
                output.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            temp.recycle();
        }

        private static void revitionImageSize(String picfile, int size, int quality) throws IOException {
            if (size <= 0) {
                throw new IllegalArgumentException("size must be greater than 0!");
            }
            if (!Utility.doesExisted(picfile)) {
                throw new FileNotFoundException(picfile == null ? "null" : picfile);
            }
            if (!BitmapHelper.verifyBitmap(picfile)) {
                throw new IOException("");
            }
            FileInputStream input = new FileInputStream(picfile);
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)opts);
            try {
                input.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int rate = 0;
            int i = 0;
            while (true) {
                if (opts.outWidth >> i <= size && opts.outHeight >> i <= size) break;
                ++i;
            }
            rate = i;
            opts.inSampleSize = (int)Math.pow(2.0, rate);
            opts.inJustDecodeBounds = false;
            Bitmap temp = UploadImageUtils.safeDecodeBimtapFile(picfile, opts);
            if (temp == null) {
                throw new IOException("Bitmap decode error!");
            }
            Utility.deleteDependon(picfile);
            Utility.makesureFileExist(picfile);
            FileOutputStream output = new FileOutputStream(picfile);
            if (opts != null && opts.outMimeType != null && opts.outMimeType.contains("png")) {
                temp.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)output);
            } else {
                temp.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)output);
            }
            try {
                output.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            temp.recycle();
        }

        public static boolean revitionPostImageSize(Context context, String picfile) {
            try {
                if (NetworkHelper.isWifiValid(context)) {
                    UploadImageUtils.revitionImageSizeHD(picfile, 1600, 75);
                } else {
                    UploadImageUtils.revitionImageSize(picfile, 1024, 75);
                }
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        private static Bitmap safeDecodeBimtapFile(String bmpFile, BitmapFactory.Options opts) {
            BitmapFactory.Options optsTmp = opts;
            if (optsTmp == null) {
                optsTmp = new BitmapFactory.Options();
                optsTmp.inSampleSize = 1;
            }
            Bitmap bmp = null;
            FileInputStream input = null;
            int MAX_TRIAL = 5;
            int i = 0;
            while (i < 5) {
                try {
                    input = new FileInputStream(bmpFile);
                    bmp = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)opts);
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                catch (OutOfMemoryError e) {
                    e.printStackTrace();
                    optsTmp.inSampleSize *= 2;
                    try {
                        input.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (FileNotFoundException e) {
                    break;
                }
                ++i;
            }
            return bmp;
        }
    }
}

