/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.auth;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.sina.weibo.sdk.auth.WeiboAuth;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.exception.WeiboAuthException;
import com.sina.weibo.sdk.exception.WeiboDialogException;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.NetworkHelper;
import com.sina.weibo.sdk.utils.ResourceManager;
import com.sina.weibo.sdk.utils.Utility;

public class WeiboDialog
extends Dialog {
    private static final String TAG = "WeiboDialog";
    private static final int WEBVIEW_CONTAINER_MARGIN_TOP = 25;
    private static final int WEBVIEW_MARGIN = 10;
    private Context mContext;
    private RelativeLayout mRootContainer;
    private RelativeLayout mWebViewContainer;
    private ProgressDialog mLoadingDlg;
    private WebView mWebView;
    private boolean mIsDetached = false;
    private String mAuthUrl;
    private WeiboAuthListener mListener;
    private WeiboAuth mWeibo;
    private static int theme = 0x1030010;

    public WeiboDialog(Context context, String authUrl, WeiboAuthListener listener, WeiboAuth weibo) {
        super(context, theme);
        this.mAuthUrl = authUrl;
        this.mListener = listener;
        this.mContext = context;
        this.mWeibo = weibo;
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.mListener != null) {
            this.mListener.onCancel();
        }
    }

    public void dismiss() {
        if (!this.mIsDetached) {
            if (this.mLoadingDlg != null && this.mLoadingDlg.isShowing()) {
                this.mLoadingDlg.dismiss();
            }
            super.dismiss();
        }
    }

    public void onAttachedToWindow() {
        this.mIsDetached = false;
        super.onAttachedToWindow();
    }

    public void onDetachedFromWindow() {
        if (this.mWebView != null) {
            this.mWebViewContainer.removeView((View)this.mWebView);
            this.mWebView.stopLoading();
            this.mWebView.removeAllViews();
            this.mWebView.destroy();
            this.mWebView = null;
        }
        this.mIsDetached = true;
        super.onDetachedFromWindow();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initWindow();
        this.initLoadingDlg();
        this.initWebView();
        this.initCloseButton();
    }

    private void initWindow() {
        this.requestWindowFeature(1);
        this.getWindow().setFeatureDrawableAlpha(0, 0);
        this.getWindow().setSoftInputMode(16);
        this.mRootContainer = new RelativeLayout(this.getContext());
        this.mRootContainer.setBackgroundColor(0);
        this.addContentView((View)this.mRootContainer, new ViewGroup.LayoutParams(-1, -1));
    }

    private void initLoadingDlg() {
        this.mLoadingDlg = new ProgressDialog(this.getContext());
        this.mLoadingDlg.requestWindowFeature(1);
        this.mLoadingDlg.setMessage((CharSequence)ResourceManager.getString(this.mContext, 1));
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView() {
        this.mWebViewContainer = new RelativeLayout(this.getContext());
        this.mWebView = new WebView(this.getContext());
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setSavePassword(false);
        this.mWebView.setWebViewClient((WebViewClient)new WeiboWebViewClient());
        this.mWebView.requestFocus();
        this.mWebView.setScrollBarStyle(0);
        this.mWebView.setVisibility(4);
        NetworkHelper.clearCookies(this.mContext, this.mAuthUrl);
        this.mWebView.loadUrl(this.mAuthUrl);
        RelativeLayout.LayoutParams webViewContainerLayout = new RelativeLayout.LayoutParams(-1, -1);
        RelativeLayout.LayoutParams webviewLayout = new RelativeLayout.LayoutParams(-1, -1);
        DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
        float density = dm.density;
        int margin = (int)(10.0f * density);
        webviewLayout.setMargins(margin, margin, margin, margin);
        Drawable background = ResourceManager.getNinePatchDrawable(this.mContext, 1);
        this.mWebViewContainer.setBackgroundDrawable(background);
        this.mWebViewContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)webviewLayout);
        this.mWebViewContainer.setGravity(17);
        Drawable drawable = ResourceManager.getDrawable(this.mContext, 2);
        int width = drawable.getIntrinsicWidth() / 2 + 1;
        webViewContainerLayout.setMargins(width, (int)(25.0f * dm.density), width, width);
        this.mRootContainer.addView((View)this.mWebViewContainer, (ViewGroup.LayoutParams)webViewContainerLayout);
    }

    private void initCloseButton() {
        ImageView closeImage = new ImageView(this.mContext);
        Drawable drawable = ResourceManager.getDrawable(this.mContext, 2);
        closeImage.setImageDrawable(drawable);
        closeImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WeiboDialog.this.dismiss();
                if (WeiboDialog.this.mListener != null) {
                    WeiboDialog.this.mListener.onCancel();
                }
            }
        });
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mWebViewContainer.getLayoutParams();
        layoutParams.leftMargin = params.leftMargin - drawable.getIntrinsicWidth() / 2 + 5;
        layoutParams.topMargin = params.topMargin - drawable.getIntrinsicHeight() / 2 + 5;
        this.mRootContainer.addView((View)closeImage, (ViewGroup.LayoutParams)layoutParams);
    }

    private void handleRedirectUrl(String url) {
        Bundle values = Utility.parseUrl(url);
        String errorType = values.getString("error");
        String errorCode = values.getString("error_code");
        String errorDescription = values.getString("error_description");
        if (errorType == null && errorCode == null) {
            this.mListener.onComplete(values);
        } else {
            this.mListener.onWeiboException(new WeiboAuthException(errorCode, errorType, errorDescription));
        }
    }

    private class WeiboWebViewClient
    extends WebViewClient {
        private boolean isCallBacked = false;

        private WeiboWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            LogUtil.i(WeiboDialog.TAG, "load URL: " + url);
            if (url.startsWith("sms:")) {
                Intent sendIntent = new Intent("android.intent.action.VIEW");
                sendIntent.putExtra("address", url.replace("sms:", ""));
                sendIntent.setType("vnd.android-dir/mms-sms");
                WeiboDialog.this.getContext().startActivity(sendIntent);
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            LogUtil.d(WeiboDialog.TAG, "onReceivedError: errorCode = " + errorCode + ", description = " + description + ", failingUrl = " + failingUrl);
            super.onReceivedError(view, errorCode, description, failingUrl);
            if (WeiboDialog.this.mListener != null) {
                WeiboDialog.this.mListener.onWeiboException(new WeiboDialogException(description, errorCode, failingUrl));
            }
            WeiboDialog.this.dismiss();
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            LogUtil.d(WeiboDialog.TAG, "onPageStarted URL: " + url);
            if (url.startsWith(WeiboDialog.this.mWeibo.getAuthInfo().getRedirectUrl()) && !this.isCallBacked) {
                this.isCallBacked = true;
                WeiboDialog.this.handleRedirectUrl(url);
                view.stopLoading();
                WeiboDialog.this.dismiss();
                return;
            }
            super.onPageStarted(view, url, favicon);
            if (!WeiboDialog.this.mIsDetached && WeiboDialog.this.mLoadingDlg != null && !WeiboDialog.this.mLoadingDlg.isShowing()) {
                WeiboDialog.this.mLoadingDlg.show();
            }
        }

        public void onPageFinished(WebView view, String url) {
            LogUtil.d(WeiboDialog.TAG, "onPageFinished URL: " + url);
            super.onPageFinished(view, url);
            if (!WeiboDialog.this.mIsDetached && WeiboDialog.this.mLoadingDlg != null) {
                WeiboDialog.this.mLoadingDlg.dismiss();
            }
            WeiboDialog.this.mWebView.setVisibility(0);
        }
    }
}

