/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api.share;

import android.content.Context;
import com.sina.weibo.sdk.api.CmdObject;
import com.sina.weibo.sdk.api.VoiceObject;
import com.sina.weibo.sdk.api.WeiboMessage;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.api.share.ApiUtils;
import com.sina.weibo.sdk.api.share.IVersionCheckHandler;
import com.sina.weibo.sdk.utils.LogUtil;

public class VersionCheckHandler
implements IVersionCheckHandler {
    private static final String TAG = "VersionCheckHandler";
    private String mPackageName;

    public VersionCheckHandler(String packageName) {
        this.mPackageName = packageName;
    }

    public VersionCheckHandler() {
    }

    public void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    @Override
    public boolean check(Context context, WeiboMessage message) {
        LogUtil.d(TAG, "check WeiboMessage package : " + this.mPackageName);
        if (this.mPackageName == null || this.mPackageName.length() == 0) {
            return false;
        }
        ApiUtils.WeiboInfo winfo = ApiUtils.queryWeiboInfoByPackage(context, this.mPackageName);
        if (winfo == null) {
            return false;
        }
        LogUtil.d(TAG, "check WeiboMessage WeiboInfo supportApi : " + winfo.supportApi);
        if (winfo.supportApi < 10351 && message.mediaObject != null && message.mediaObject instanceof VoiceObject) {
            message.mediaObject = null;
        }
        if (winfo.supportApi < 10352 && message.mediaObject != null && message.mediaObject instanceof CmdObject) {
            message.mediaObject = null;
        }
        return true;
    }

    @Override
    public boolean check(Context context, WeiboMultiMessage message) {
        LogUtil.d(TAG, "check WeiboMultiMessage package : " + this.mPackageName);
        if (this.mPackageName == null || this.mPackageName.length() == 0) {
            return false;
        }
        ApiUtils.WeiboInfo winfo = ApiUtils.queryWeiboInfoByPackage(context, this.mPackageName);
        if (winfo == null) {
            return false;
        }
        LogUtil.d(TAG, "check WeiboMultiMessage WeiboInfo supportApi : " + winfo.supportApi);
        if (winfo.supportApi < 10351) {
            return false;
        }
        if (winfo.supportApi < 10352 && message.mediaObject != null && message.mediaObject instanceof CmdObject) {
            message.mediaObject = null;
        }
        return true;
    }
}

