/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api.share;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiUtils {
    private static final String TAG = "ApiUtils";
    public static final int BUILD_INT = 10350;
    public static final int BUILD_INT_VER_2_2 = 10351;
    public static final int BUILD_INT_VER_2_3 = 10352;
    private static final String WEIBO_IDENTITY_ACTION = "com.sina.weibo.action.sdkidentity";
    private static final Uri WEIBO_NAME_URI = Uri.parse((String)"content://com.sina.weibo.sdkProvider/query/package");
    private static final String WEIBO_SIGN = "18da2bf10352443a00a5e046d9fca6bd";

    public static boolean isWeiboAppSupportAPI(int supportApi) {
        return supportApi >= 10350;
    }

    public static WeiboInfo queryWeiboInfoByPackage(Context context, String packageName) {
        if (context == null || packageName == null) {
            return null;
        }
        WeiboInfo info = ApiUtils.queryWeiboInfoByAsset(context, packageName);
        if (info != null) {
            return info;
        }
        info = ApiUtils.queryWeiboInfoByProvider(context);
        if (info != null && packageName.equals(info.packageName)) {
            return info;
        }
        return null;
    }

    public static WeiboInfo queryWeiboInfo(Context context) {
        WeiboInfo winfo = ApiUtils.queryWeiboInfoByProvider(context);
        if (winfo == null) {
            return ApiUtils.queryWeiboInfoByFile(context);
        }
        return winfo;
    }

    public static boolean validateWeiboSign(Context context, String pkgName) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(pkgName, 64);
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            return false;
        }
        return ApiUtils.containSign(packageInfo.signatures, WEIBO_SIGN);
    }

    public static boolean containSign(Signature[] signatures, String destSign) {
        if (signatures == null || destSign == null) {
            return false;
        }
        Signature[] signatureArray = signatures;
        int n = signatures.length;
        int n2 = 0;
        while (n2 < n) {
            Signature signature = signatureArray[n2];
            String s = MD5.hexdigest(signature.toByteArray());
            if (destSign.equals(s)) {
                LogUtil.d(TAG, "check pass");
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static WeiboInfo queryWeiboInfoByProvider(Context context) {
        block11: {
            ContentResolver cr = context.getContentResolver();
            Cursor cursor = null;
            try {
                cursor = cr.query(WEIBO_NAME_URI, null, null, null, null);
                if (cursor == null) {
                    return null;
                }
                int supportApiIndex = cursor.getColumnIndex("support_api");
                int packageIndex = cursor.getColumnIndex("package");
                if (!cursor.moveToFirst()) break block11;
                int supportApiInt = -1;
                String supportApi = cursor.getString(supportApiIndex);
                try {
                    supportApiInt = Integer.parseInt(supportApi);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                String packageName = cursor.getString(packageIndex);
                if (!TextUtils.isEmpty((CharSequence)packageName) && ApiUtils.validateWeiboSign(context, packageName)) {
                    WeiboInfo winfo = new WeiboInfo();
                    winfo.packageName = packageName;
                    winfo.supportApi = supportApiInt;
                    WeiboInfo weiboInfo = winfo;
                    return weiboInfo;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtil.e(TAG, e.getMessage());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                    cursor = null;
                }
            }
        }
        return null;
    }

    private static WeiboInfo queryWeiboInfoByFile(Context context) {
        Intent intent = new Intent(WEIBO_IDENTITY_ACTION);
        intent.addCategory("android.intent.category.DEFAULT");
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (ResolveInfo ri : list) {
            String packageName;
            WeiboInfo winfo;
            if (ri.serviceInfo == null || ri.serviceInfo.applicationInfo == null || ri.serviceInfo.applicationInfo.packageName == null || ri.serviceInfo.applicationInfo.packageName.length() == 0 || (winfo = ApiUtils.queryWeiboInfoByAsset(context, packageName = ri.serviceInfo.applicationInfo.packageName)) == null) continue;
            return winfo;
        }
        return null;
    }

    private static WeiboInfo queryWeiboInfoByAsset(Context context, String packageName) {
        block30: {
            WeiboInfo weiboInfo;
            if (context == null || packageName == null) {
                return null;
            }
            InputStream is = null;
            try {
                int readNum;
                Context weiboContext = context.createPackageContext(packageName, 2);
                int bufferSize = 1024;
                byte[] buf = new byte[1024];
                is = weiboContext.getAssets().open("weibo_for_sdk.json");
                StringBuilder sbContent = new StringBuilder();
                while ((readNum = is.read(buf, 0, 1024)) != -1) {
                    sbContent.append(new String(buf, 0, readNum));
                }
                if (TextUtils.isEmpty((CharSequence)sbContent.toString()) || !ApiUtils.validateWeiboSign(context, packageName)) {
                    return null;
                }
                JSONObject json = new JSONObject(sbContent.toString());
                int supportApi = json.optInt("support_api", -1);
                WeiboInfo winfo = new WeiboInfo();
                winfo.packageName = packageName;
                winfo.supportApi = supportApi;
                weiboInfo = winfo;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                break block30;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block30;
            }
            catch (JSONException e) {
                e.printStackTrace();
                break block30;
            }
            catch (Exception e) {
                LogUtil.e(TAG, e.getMessage());
                break block30;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return weiboInfo;
        }
        return null;
    }

    public static class WeiboInfo {
        public String packageName;
        public int supportApi;

        public String toString() {
            return "WeiboInfo: PackageName = " + this.packageName + ", supportApi = " + this.supportApi;
        }
    }
}

