package com.trilead.ssh2.signature;

import com.trilead.ssh2.crypto.PEMDecoder;

import org.junit.Test;

import static org.junit.Assert.*;

/**
 * Created by kenny on 12/25/15.
 */
public class ECDSASHA2VerifyTest {
	private static final byte[] DER_ENCODED_P521_SIG = new byte[]{
		(byte) 0x30, (byte) 0x81, (byte) 0x88, (byte) 0x02, (byte) 0x42, (byte) 0x00, (byte) 0xFB, (byte) 0x41, (byte) 0xFD, (byte) 0xBD, (byte) 0x61, (byte) 0x5D,
		(byte) 0xFE, (byte) 0x3F, (byte) 0x0C, (byte) 0xA1, (byte) 0xF0, (byte) 0x73, (byte) 0xF1, (byte) 0x18, (byte) 0xFB, (byte) 0x25, (byte) 0x57, (byte) 0xF4,
		(byte) 0xDE, (byte) 0xF5, (byte) 0xC1, (byte) 0xAA, (byte) 0xB2, (byte) 0xA7, (byte) 0x2B, (byte) 0x9F, (byte) 0x81, (byte) 0xD1, (byte) 0x21, (byte) 0x9D,
		(byte) 0x48, (byte) 0xC8, (byte) 0xC9, (byte) 0x31, (byte) 0xB9, (byte) 0x9B, (byte) 0xE5, (byte) 0x97, (byte) 0x94, (byte) 0x2F, (byte) 0xD5, (byte) 0x7E,
		(byte) 0x0C, (byte) 0x32, (byte) 0x2D, (byte) 0xF9, (byte) 0x76, (byte) 0xC6, (byte) 0x33, (byte) 0x2C, (byte) 0x49, (byte) 0x1D, (byte) 0xDF, (byte) 0x51,
		(byte) 0xA2, (byte) 0xD2, (byte) 0xB0, (byte) 0x72, (byte) 0x9B, (byte) 0x26, (byte) 0xC4, (byte) 0xB2, (byte) 0xA0, (byte) 0xF0, (byte) 0x7E, (byte) 0x02,
		(byte) 0x42, (byte) 0x01, (byte) 0x56, (byte) 0x94, (byte) 0x9B, (byte) 0xAB, (byte) 0x00, (byte) 0x6D, (byte) 0x3C, (byte) 0x28, (byte) 0x34, (byte) 0x1B,
		(byte) 0x00, (byte) 0xF3, (byte) 0xDF, (byte) 0xF7, (byte) 0x42, (byte) 0xAD, (byte) 0x8B, (byte) 0x20, (byte) 0x55, (byte) 0x2E, (byte) 0x80, (byte) 0x4F,
		(byte) 0xDE, (byte) 0x0F, (byte) 0xBC, (byte) 0xE7, (byte) 0xE2, (byte) 0x7C, (byte) 0xF3, (byte) 0x3B, (byte) 0xFD, (byte) 0x95, (byte) 0xB0, (byte) 0xF7,
		(byte) 0xD4, (byte) 0xE0, (byte) 0x63, (byte) 0xA9, (byte) 0x86, (byte) 0xA6, (byte) 0x49, (byte) 0xF4, (byte) 0x69, (byte) 0x66, (byte) 0x10, (byte) 0xD5,
		(byte) 0x3F, (byte) 0xB6, (byte) 0x30, (byte) 0xDC, (byte) 0x01, (byte) 0x0E, (byte) 0xBE, (byte) 0xD1, (byte) 0x62, (byte) 0x86, (byte) 0x2B, (byte) 0xE4,
		(byte) 0xF2, (byte) 0xF3, (byte) 0x6D, (byte) 0x4C, (byte) 0xE1, (byte) 0xD0, (byte) 0x5C
	};

	private static final byte[] SSH_ENCODED_P521_SIG = new byte[] {
		(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x13,
		(byte) 0x65, (byte) 0x63, (byte) 0x64, (byte) 0x73, (byte) 0x61, (byte) 0x2D, (byte) 0x73, (byte) 0x68,
		(byte) 0x61, (byte) 0x32, (byte) 0x2D, (byte) 0x6E, (byte) 0x69, (byte) 0x73, (byte) 0x74, (byte) 0x70,
		(byte) 0x35, (byte) 0x32, (byte) 0x31,
		(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x8C,
		(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x42,
		(byte) 0x00, (byte) 0xFB, (byte) 0x41, (byte) 0xFD, (byte) 0xBD, (byte) 0x61, (byte) 0x5D,
		(byte) 0xFE, (byte) 0x3F, (byte) 0x0C, (byte) 0xA1, (byte) 0xF0, (byte) 0x73, (byte) 0xF1, (byte) 0x18,
		(byte) 0xFB, (byte) 0x25, (byte) 0x57, (byte) 0xF4, (byte) 0xDE, (byte) 0xF5, (byte) 0xC1, (byte) 0xAA,
		(byte) 0xB2, (byte) 0xA7, (byte) 0x2B, (byte) 0x9F, (byte) 0x81, (byte) 0xD1, (byte) 0x21, (byte) 0x9D,
		(byte) 0x48, (byte) 0xC8, (byte) 0xC9, (byte) 0x31, (byte) 0xB9, (byte) 0x9B, (byte) 0xE5, (byte) 0x97,
		(byte) 0x94, (byte) 0x2F, (byte) 0xD5, (byte) 0x7E, (byte) 0x0C, (byte) 0x32, (byte) 0x2D, (byte) 0xF9,
		(byte) 0x76, (byte) 0xC6, (byte) 0x33, (byte) 0x2C, (byte) 0x49, (byte) 0x1D, (byte) 0xDF, (byte) 0x51,
		(byte) 0xA2, (byte) 0xD2, (byte) 0xB0, (byte) 0x72, (byte) 0x9B, (byte) 0x26, (byte) 0xC4, (byte) 0xB2,
		(byte) 0xA0, (byte) 0xF0, (byte) 0x7E,
		(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x42,
		(byte) 0x01, (byte) 0x56, (byte) 0x94, (byte) 0x9B, (byte) 0xAB, (byte) 0x00, (byte) 0x6D, (byte) 0x3C,
		(byte) 0x28, (byte) 0x34, (byte) 0x1B, (byte) 0x00, (byte) 0xF3, (byte) 0xDF, (byte) 0xF7, (byte) 0x42,
		(byte) 0xAD, (byte) 0x8B, (byte) 0x20, (byte) 0x55, (byte) 0x2E, (byte) 0x80, (byte) 0x4F, (byte) 0xDE,
		(byte) 0x0F, (byte) 0xBC, (byte) 0xE7, (byte) 0xE2, (byte) 0x7C, (byte) 0xF3, (byte) 0x3B, (byte) 0xFD,
		(byte) 0x95, (byte) 0xB0, (byte) 0xF7, (byte) 0xD4, (byte) 0xE0, (byte) 0x63, (byte) 0xA9, (byte) 0x86,
		(byte) 0xA6, (byte) 0x49, (byte) 0xF4, (byte) 0x69, (byte) 0x66, (byte) 0x10, (byte) 0xD5, (byte) 0x3F,
		(byte) 0xB6, (byte) 0x30, (byte) 0xDC, (byte) 0x01, (byte) 0x0E, (byte) 0xBE, (byte) 0xD1, (byte) 0x62,
		(byte) 0x86, (byte) 0x2B, (byte) 0xE4, (byte) 0xF2, (byte) 0xF3, (byte) 0x6D, (byte) 0x4C, (byte) 0xE1,
		(byte) 0xD0, (byte) 0x5C
	};

	@Test
	public void encodeSSHECDSASignature() throws Exception {
		byte[] encoded = ECDSASHA2Verify.encodeSSHECDSASignature(DER_ENCODED_P521_SIG,
			ECDSASHA2Verify.getCurveForSize(521));
		assertArrayEquals(SSH_ENCODED_P521_SIG, encoded);
	}

	@Test
	public void decodeSSHECDSASignature() throws Exception {
		byte[] encoded = ECDSASHA2Verify.decodeSSHECDSASignature(SSH_ENCODED_P521_SIG);
		assertArrayEquals(DER_ENCODED_P521_SIG, encoded);
	}

	@Test
	public void decodeP521PEMKey() throws Exception {
		char[] pemKey = ("-----BEGIN EC PRIVATE KEY-----\n" +
			"MIHbAgEBBEGiLM/lkLGNRu6KdnQaWhWM/PBqR0ibIokEW4xa0Nv5O1TDBpiM+lus\n" +
			"wi8oM6qzWJbKf685J322VH3uYAs5oIYxJ6AHBgUrgQQAI6GBiQOBhgAEAK6P4X/5\n" +
			"n3hZssRG1x1jPNBTSFG79H36JkJHsCerPrsdjCNzfh/P5a87bCOor/My8un/JFly\n" +
			"H5mVXAO0t2YQq7qfAMCBawq2HfC+rfCikl5mrSYg6d0bshQ5ZIYAwU85VIK9kdjA\n" +
			"ImRIKkyB7MN7qqQUASFcYZLFwwdeRZw/0Yp7Ma/+\n" +
			"-----END EC PRIVATE KEY-----\n").toCharArray();
		PEMDecoder.decode(pemKey, null);
	}
}
