<p align="center">
<img src="src/assets/logo-sticker.svg" alt="Rowy" height="69" />
</p>

<h1 align="center">
✨ Modern Backend Stack ✨ <br/>
</h1>
<h3 align="center">
Build prototypes that scale on Google Cloud Platform in minutes
</h3>
<p align="center">
Manage Firestore data in a spreadsheet-like UI, write Cloud Functions effortlessly in the browser, and connect to your favorite third party platforms such as SendGrid, Twilio, Algolia, Slack and more. 
</p>

<div align="center">

[![Discord](https://img.shields.io/discord/853498675484819476?color=%234200FF&label=Chat%20with%20us&logo=discord&logoColor=%23FFFFFF&style=for-the-badge)](https://discord.gg/B8yAD5PDX4)

<p align="center">
    <a href="http://www.rowy.io"><b>Website</b></a> •
    <a href="http://docs.rowy.io"><b>Documentation</b></a> •
    <a href="https://discord.gg/B8yAD5PDX4"><b>Discord</b></a> • 
    <a href="https://twitter.com/rowyio"><b>Twitter</b></a>
</p>

[![License](https://img.shields.io/github/license/rowyio/rowy)](https://github.com/rowyio/rowy/blob/main/LICENSE)
[![Last commit](https://img.shields.io/github/last-commit/rowyio/rowy/rc)](https://github.com/rowyio/rowy/commits/rc)
[![GitHub stars](https://img.shields.io/github/stars/rowyio/rowy)](https://github.com/rowyio/rowy/stargazers/)

</div>

<img width="100%" src="https://firebasestorage.googleapis.com/v0/b/rowyio.appspot.com/o/publicDemo%2FRowy%20Website%20Video%20GIF%20Small.gif?alt=media&token=3f699a8f-c1f2-4046-8ed5-e4ff66947cd8" />

## Live Demo
💥 Check out the [live demo](https://demo.rowy.io/) of Rowy 💥

## Quick Deploy

Set up Rowy on your Google Cloud Platform project with this one-click deploy
button.

[![Run on Google Cloud](https://deploy.cloud.run/button.svg)](https://rowy.app/deploy)

https://rowy.app/deploy

## Documentation

You can find the full documentation with how-to guides
[here](http://docs.rowy.io/).

## Features

### Powerful spreadsheet interface for Firestore

- CRUD operations
- Sort and filter by row values
- Lock, Freeze, Resize, Hide and Rename columns
- Multiple views for the same collection
- Bulk import or export data - csv, json

### Automate with cloud functions and ready made extensions

- Effortlessly build cloud functions on field level triggers right in the browser
    -  Use any NPM modules or APIs
- Connect to your favourite tool with pre-built extensions or create your own
    - SendGrid, Algolia, Twilio, Bigquery and more

### Rich and flexible data fields

- [30+ fields supported](https://docs.rowy.io/field-types/supported-fields)
    - Basic types: Short Text, Long Text, Email, Phone, URL…
    - Custom UI pickers: Date, Checkbox, Single Select, Multi Select…
    - Uploaders: Image, File
    - Rich Editors: JSON, Code, Rich Text (HTML)
 - Data validation, default values, required fields
- Action field: Clickable trigger for any Cloud Function
- Aggregate field: Populate cell with value aggregated from the row’s sub-table
- Connect Table: Get snapshot of data from another data table using Algolia
- Connect Service: Get data from any HTTP endpoint

### Collaborate with your team

- Granular table-level and field-level permission control  
  with custom user roles
- Built in user management
- Customizable views for different user roles

## Install

Set up Rowy on your Google Cloud project with this one-click deploy button. Your data and cloud functions stay on your own Firestore/GCP.

[![Run on Google Cloud](https://deploy.cloud.run/button.svg)](https://rowy.app/deploy)

The one-click deploy makes the process of setting up easy with a step by step
guide and ensures your project is setup correctly.

It deploys [Rowy Run](https://github.com/rowyio/rowyrun), an open-source Cloud
Run instance that operates exclusively on your GCP project. So we never have
access to your service account or any of your data.

Alternatively, you can manually install by
[following this guide](https://docs.rowy.io/setup/install).

## Roadmap

[View our roadmap](https://demo.rowy.io/table/roadmap) on Rowy - Upvote, downvote, share your thoughts!

If you'd like to propose a feature, submit an issue [here](https://github.com/rowyio/rowy/issues/new?assignees=&labels=&template=feature_request.md&title=).

## Join our community

We would love to connect and hear what you think!

- [Discord](https://discord.gg/B8yAD5PDX4)
- [Twitter](https://twitter.com/rowyio)
- [Email](mailto:rowy.io)
