<p align="center">
<img src="src/assets/logo-sticker.svg" alt="Rowy" height="69" />
</p>

<h1 align="center">
✨ Data x Code ✨ <br/>
</h1>
<h3 align="center">
Modern Backend Stack
</h3>
<p align="center">
Forget CLIs, configs, and DevOps. Focus on building your apps with a platform designed for developer productivity. Your production database (Firestore) in an Airtable-like UI with full coding extensibility via Cloud Functions visually in the browser.
</p>

<div align="center">

[![Discord](https://img.shields.io/discord/853498675484819476?color=%234200FF&label=Chat%20with%20us&logo=discord&logoColor=%23FFFFFF&style=for-the-badge)](https://discord.gg/fjBugmvzZP)

<p align="center">
    <a href="http://www.rowy.io"><b>Website</b></a> •
    <a href="http://docs.rowy.io"><b>Documentation</b></a> •
    <a href="https://discord.gg/fjBugmvzZP"><b>Discord</b></a> • 
    <a href="https://twitter.com/rowyio"><b>Twitter</b></a>
</p>

[![License](https://img.shields.io/github/license/rowyio/rowy)](https://github.com/rowyio/rowy/blob/main/LICENSE)
[![Last commit](https://img.shields.io/github/last-commit/rowyio/rowy/rc)](https://github.com/rowyio/rowy/commits/rc)
[![GitHub stars](https://img.shields.io/github/stars/rowyio/rowy)](https://github.com/rowyio/rowy/stargazers/)

</div>
<img width="100%" src="https://user-images.githubusercontent.com/307298/157184506-f94f3f5b-e6d3-49df-9a2c-f665511883f2.png" />

## Live Demo
💥 Check out the [live demo](https://demo.rowy.io/) of Rowy 💥 

## Quick Deploy

Set up Rowy on your Google Cloud Platform project with this easy deploy button.

[![Run on Google Cloud](https://deploy.cloud.run/button.svg)](https://deploy.rowy.app/)

https://deploy.rowy.app/

## Documentation

You can find the full documentation with how-to guides and templates 
[here](http://docs.rowy.io/).

## Features

https://user-images.githubusercontent.com/307298/157185793-f67511cd-7b7b-4229-9589-d7defbf7a63f.mp4

<!-- <img width="85%" src="https://firebasestorage.googleapis.com/v0/b/rowyio.appspot.com/o/publicDemo%2FRowy%20Website%20Video%20GIF%20Small.gif?alt=media&token=3f699a8f-c1f2-4046-8ed5-e4ff66947cd8" />
 -->
### Powerful spreadsheet interface for Firestore

- CRUD operations
- Sort and filter by row values
- Lock, Freeze, Resize, Hide and Rename columns
- Multiple views for the same collection
- Bulk import or export data - csv, json

### Automate with cloud functions and ready made extensions

- Effortlessly build cloud functions on field level triggers right in the browser
    -  Use any NPM modules or APIs
- Connect to your favourite tool with pre-built extensions or create your own
    - SendGrid, Algolia, Twilio, Bigquery and more

### Rich and flexible data fields

- [30+ fields supported](https://docs.rowy.io/field-types/supported-fields)
    - Basic types: Short Text, Long Text, Email, Phone, URL…
    - Custom UI pickers: Date, Checkbox, Single Select, Multi Select…
    - Uploaders: Image, File
    - Rich Editors: JSON, Code, Rich Text (HTML)
 - Data validation, default values, required fields
- Action field: Clickable trigger for any Cloud Function
- Aggregate field: Populate cell with value aggregated from the row’s sub-table
- Connect Table: Get snapshot of data from another data table using Algolia
- Connect Service: Get data from any HTTP endpoint

### Collaborate with your team

- Granular table-level and field-level permission control  
  with custom user roles
- Built in user management
- Customizable views for different user roles

## Install

Set up Rowy on your Google Cloud project with this one-click deploy button. Your data and cloud functions stay on your own Firestore/GCP.

[![Run on Google Cloud](https://deploy.cloud.run/button.svg)](https://deploy.rowy.app/)

The one-click deploy makes the process of setting up easy with a step by step
guide and ensures your project is setup correctly.

It deploys [Rowy Run](https://github.com/rowyio/rowyrun), an open-source Cloud
Run instance that operates exclusively on your GCP project. So we never have
access to your service account or any of your data.

Alternatively, you can manually install by
[following this guide](https://docs.rowy.io/setup/install).

## Roadmap

[View our roadmap](https://demo.rowy.io/table/roadmap) on Rowy - Upvote, downvote, share your thoughts!

If you'd like to propose a feature, submit an issue [here](https://github.com/rowyio/rowy/issues/new?assignees=&labels=&template=feature_request.md&title=).

## Support the project

- Join a community of developers on [Discord](https://discord.gg/fjBugmvzZP) and share your ideas/feedback 💬
- Follow us on [Twitter](https://twitter.com/rowyio) and help [spread the word](https://twitter.com/intent/tweet?text=Check%20out%20@rowyio%20-%20It%27s%20like%20an%20open-source%20Airtable%20for%20your%20database,%20but%20with%20a%20built-in%20code%20editor%20for%20cloud%20functions%20to%20run%20on%20data%20CRUD!%0a%0aEsp%20if%20building%20on%20@googlecloud%20and%20@Firebase%20stack,%20it%20is%20the%20fastest%20way%20to%20build%20your%20product.%20Live%20demo:%20https://demo.rowy.io) 🙏
- Give us a star to this Github repo ⭐️
- Submit a PR. Take a look at our [contribution guide](https://github.com/rowyio/rowy/blob/main/CONTRIBUTING.md) and get started with [good first issues](https://github.com/rowyio/rowy/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22).

## Help

- Live chat support on [Discord](https://discord.gg/fjBugmvzZP)
- [Email](mailto:hello@rowy.io)
