---
chapter: The Refspec
layout: slide
tags: ['advanced/refspec']
---

    +<source>:<destination>


{% capture notes %}
* Review _remote_ in `.git/config` and pattern
* Discuss `+<source>:<destination>` pattern
    * Fast-forward example:
    * `git pull origin master:refs/heads/master`
    * Non-Fast-forward example:
    * `git pull origin +master:refs/heads/master`
* Multiple _fetch_ and targeted resources
* Edit .git/config and identify remote
    * Original: `fetch = +refs/heads/*:refs/remotes/origin/*`
    * Master-Only: `fetch = +refs/heads/master:refs/remotes/origin/master`
* Custom Push
    * `push = refs/heads/master:refs/heads/qa/master`
* Removing branches with assymetric refspec
    * `git push origin :<branch-to-delete>`
* Using with Pull Requests locally
    * `+refs/pull/*/head:refs/remotes/origin/pull/*`
{% endcapture %}
{% include hydeslides/core/notes %}