# Roadmap
**Last updated: April 12, 2016**

TensorFlow is a fast moving project. In order for the community to better
understand what the near future will bring, this document shares what we are
working on internally. Many of these features were requested by the community,
and we welcome
[contributions](https://github.com/tensorflow/tensorflow/labels/contributions%20welcome).

The features on this list are targeted for the next few months. At this point,
we do not have timelines for these features.

### Improve support for C++ only users
* Graph construction
* Gradients
* Shape Inference

### Making TensorFlow easier to use
* Higher level APIs (for instance, layers)

### Performance
* Speed and memory benchmarks
* Performance and memory usage improvements

### Core Features
* Repeated partial graph evaluation ([#672](https://github.com/tensorflow/tensorflow/issues/672))

### Platforms
* iOS support ([#16](https://github.com/tensorflow/tensorflow/issues/16))
* OpenCL support ([#22](https://github.com/tensorflow/tensorflow/issues/22))
* Windows support ([#17](https://github.com/tensorflow/tensorflow/issues/17))
* MacOS GPU support

### Community
* Integration with other machine learning frameworks
* Better installation support; support for package managers
