# Example Uses

This page describes some of the current uses of the TensorFlow system.

> If you are using TensorFlow for research, for education, or for production
> usage in some product, we would love to add something about your usage here.
> Please feel free to email us a brief description of how you're using
> TensorFlow, or send us a pull request to add an entry to this file.

Listed below are some of the many uses of TensorFlow.

* **RankBrain**
  * **Organization**: Google
  * **Domain**: Information Retrieval
  * **Description**:  A large-scale deployment of deep neural nets for search ranking on www.google.com.
  * **More info**: ["Google Turning Over Its Lucrative Search to AI Machines"](http://www.bloomberg.com/news/articles/2015-10-26/google-turning-its-lucrative-web-search-over-to-ai-machines)

* **Inception Image Classification Model**
  * **Organization**: Google
  * **Description**: Baseline model and follow on research into highly accurate computer vision models, starting with the model that won the 2014 Imagenet image classification challenge
  * **More Info**: Baseline model described in [Arxiv paper](http://arxiv.org/abs/1409.4842)

* **SmartReply**
  * **Organization**: Google
  * **Description**: Deep LSTM model to automatically generate email responses
  * **More Info**: [Google research blog post](http://googleresearch.blogspot.com/2015/11/computer-respond-to-this-email.html)

* **Massively Multitask Networks for Drug Discovery**
  * **Organization**: Google and Stanford University
  * **Domain**: Drug discovery
  * **Description**:  A deep neural network model for identifying promising drug candidates.
  * **More info**: [Arxiv paper](http://arxiv.org/abs/1502.02072)

* **On-Device Computer Vision for OCR**
  * **Organization**: Google
  * **Description**: On-device computer vision model to do optical character recognition to enable real-time translation.
  * **More info**: [Google Research blog post](http://googleresearch.blogspot.com/2015/07/how-google-translate-squeezes-deep.html)
