---
title: Visualizations
url: /user-guide/visualizations/
---
Visualizations are available to help you gain deeper insights into your projects' current statuses and histories.

## How do I compare current state for multiple projects or project components?
The Projects space allows you to filter the projects in your instance by multiple, measure-based criteria. Once you've chosen your set, you don't have to stare at the raw numbers to identify the risks its projects face. Instead, several visualizations (**Projects > Perspective**) are available to help you understand each project's relative position in terms of each of the major axes:

* Risk - Reliability and Security ratings, test coverage, technical debt, and lines of code
* Reliability - Reliability rating, Reliability remediation effort, lines of code, and Bug count
* Security - Security rating, Security remediation effort, lines of code, and Vulnerability count
* Maintainability - Maintainability rating, Technical debt, lines of code, and Code Smell count
* Coverage - Coverage, complexity, and uncovered lines
* Duplications - Duplicated Lines %, lines of code, and duplicated blocks
* At the project level these same visualizations are available in the Measures tab to help you compare project components. The Project Overview corresponds to the Risk visualization in the Projects space, For the other five graphs, choose the Overview option under the relevant domain.

Additionally, treemaps are also available for percentage and rating metrics at the project level. Navigate to them in the Measures tab using the perspective selector in the right pane.

## How do I visualize metric history?
At the project level, the Activity tab offers several canned line graphs of selected metrics across time, with convenient mouseovers to show graph details and the ability to easily narrow the graph to a slice of the project's history. Beyond the canned graphs, you also have the ability to map the metrics of your choice against each other in a Custom graph.

![](/images/visualizations.png)
