---
title: Importing Third-Party Issues
url: /analysis/external-issues/
---

This page lists analysis parameters related to the import of issues raised by external, third-party analyzers. If your analyzer isn't on this page, see the [Generic Issue Import Format](/analysis/generic-issue/) for a generic way to import external issues.

SonarSource analyzers do not run your external analyzers or generate reports. They only import pre-generated reports. Below you'll find language- and tool-specific analysis parameters for importing reports generated by external analyzers. 

In the [Guides](https://community.sonarsource.com/c/announce/guides) category of the [SonarSource Community forum](https://community.sonarsource.com/) you might find instructions on generating these reports.

Some properties support the following wildcards in paths. The remarks for properties that support wildcards will mention that fact. If the remarks do not say wildcards are supported, then they are not.:

Symbol|Meaning
---|---
`?`|a single character
`*`|any number of characters
`**`|any number of directories

Unless otherwise specified, the following properties accept both absolute paths and paths relative to project root.

Language|Property|Remarks
----|----|----
Apex|`sonar.apex.pmd.reportPaths`|Comma-delimited list of paths to [PMD Apex](https://pmd.github.io/pmd-5.5.7/pmd-apex/rules/index.html) [XML reports](https://pmd.github.io/latest/pmd_userdocs_installation.html#running-pmd-via-command-line)|
CSS|`sonar.css.stylelint.reportPaths`|Comma-delimited list of paths to [StyleLint.io](https://stylelint.io/) reports|
Go|`sonar.go.govet.reportPaths`|Comma-delimited list of paths to [GoVet](https://golang.org/cmd/vet/) reports|
Go|`sonar.go.golint.reportPaths`|Comma-delimited list of paths to [GoLint](https://github.com/golang/lint) reports|
Go|`sonar.go.gometalinter.reportPaths`|Comma-delimited list of paths to [GoMetaLinter](https://github.com/alecthomas/gometalinter) reports|
Go|`sonar.go.golangci-lint.reportPaths`|Comma-delimited list of paths to [golangci-lint](https://github.com/golangci/golangci-lint) reports in checkstyle format (use `--out-format checkstyle` golangci-lint option)|
Java|`sonar.java.spotbugs.reportPaths`|Comma-delimited list of paths to reports from [SpotBugs](https://spotbugs.github.io/), FindSecBugs, or FindBugs|
Java|`sonar.java.pmd.reportPaths`|Comma-delimited list of paths to reports from [PMD](http://maven.apache.org/plugins/maven-pmd-plugin/usage.html)
Java|`sonar.java.checkstyle.reportPaths`|Comma-delimited list of paths to reports from [Checkstyle](http://maven.apache.org/plugins/maven-checkstyle-plugin/checkstyle-mojo)
JavaScript|`sonar.eslint.reportPaths`|Comma-delimited list of paths to JSON [ESLint](https://eslint.org/) reports (use `-f json` ESLint option)
Kotlin|`sonar.androidLint.reportPaths`|Comma-delimited list of paths to AndroidLint reports
Kotlin|`sonar.kotlin.detekt.reportPaths`|Comma-delimited list of paths to [Detekt](https://github.com/arturbosch/detekt) reports
Python|`sonar.python.pylint.reportPath`|Path to a [Pylint](http://www.pylint.org/) report. Wildcards are supported|
Python|![](/images/cross.svg) **Deprecated** `sonar.python.pylint_config` `sonar.python.pylint`|By default SonarPython will execute the pylint command for you if you haven't specified the path to a PyLint report. Use `sonar.python.pylint` to use a pylint executable in a non-default location. The property **must** be set on windows (even for the default location), using either escaped backslashes, or single forward slashes (e.g. `C:\\Python26\\Scripts\\pylint.bat`, `C:/Python26/Scripts/pylint.bat`). Use `sonar.python.pylint_config` to specify the relative or absolute path to a non-default pylint configuration file.
Python|`sonar.python.bandit.reportPaths`|Comma-delimited list of paths to [Bandit](https://github.com/PyCQA/bandit/blob/master/README.rst) reports
Python|`sonar.python.flake8.reportPaths`|Comma-delimited list of paths to [Flake8](https://flake8.pycqa.org/en/latest/) reports
Ruby|`sonar.ruby.rubocop.reportPaths`|Comma-delimited list of paths to [Rubocop](https://github.com/rubocop-hq/rubocop) reports
Scala|`sonar.scala.scalastyle.reportPaths`|Comma-delimited list of paths to [Scalastyle](http://www.scalastyle.org/) reports
Scala|`sonar.scala.scapegoat.reportPaths`|Comma-delimited list of paths to [Scapegoat](https://github.com/sksamuel/scapegoat) reports in the **Scalastyle format**
Swift|`sonar.swift.swiftLint.reportPaths`|Comma-delimited list of paths to [SwiftLint](https://github.com/realm/SwiftLint) reports in JSON format
TypeScript|`sonar.typescript.tslint.reportPaths`|Comma-delimited list of paths to [TSLint](https://palantir.github.io/tslint/) reports in JSON format (use `-t json` TSLint option)|

**Notes on external .NET issues**  
Issues from third-party Roslyn analyzers (including Roslyn analyzers provided by Microsoft) are included in the MSBuild output and imported by default into {instance} so no properties exist to enable that behavior. Instead, properties are available to adjust the import and to _stop_ importing those issues.

Note that Roslyn issues with an *error* severity automatically fail the build, and it is not recommended to run the Scanner for MSBuild's end step if the MSBuild step fails for any reason because it will result in an essentially empty analysis, which will close all outstanding issues in the project.

Language|Property|Remarks
----|----|----
C#|`sonar.cs.roslyn.ignoreIssues`|Set to `true` to disable import of external issues. Defaults to `false`.
C#|`sonar.cs.roslyn.bugCategories` `sonar.cs.roslyn.vulnerabilityCategories` `sonar.cs.roslyn.codeSmellCategories`|Comma-delimited list of categories whose issues should be classified as Bugs, Vulnerabilities, or Code Smells. 
VB.NET|`sonar.vbnet.roslyn.ignoreIssues`|Set to `true` to disable import of external issues. Defaults to `false`.
VB.NET|`sonar.vbnet.roslyn.bugCategories` `sonar.vbnet.roslyn.vulnerabilityCategories` `sonar.vbnet.roslyn.codeSmellCategories`|Comma-delimited list of categories whose issues should be classified as Bugs, Vulnerabilities, or Code Smells. 
