CREATE TABLE "RULES_PROFILES"(
    "ID" INTEGER NOT NULL AUTO_INCREMENT (1,1),
    "UUID" VARCHAR(40) NOT NULL,
    "NAME" VARCHAR(100) NOT NULL,
    "LANGUAGE" VARCHAR(20),
    "KEE" VARCHAR(255) NOT NULL,
    "IS_BUILT_IN" BOOLEAN NOT NULL,
    "RULES_UPDATED_AT" VARCHAR(100),
    "CREATED_AT" TIMESTAMP,
    "UPDATED_AT" TIMESTAMP
);
ALTER TABLE "RULES_PROFILES" ADD CONSTRAINT "PK_RULES_PROFILES" PRIMARY KEY("ID");
CREATE UNIQUE INDEX "UNIQ_QPROF_KEY" ON "RULES_PROFILES"("KEE");

CREATE TABLE "ACTIVE_RULES"(
    "UUID" VARCHAR(40) NOT NULL,
    "PROFILE_ID" INTEGER NOT NULL,
    "PROFILE_UUID" VARCHAR(40),
    "RULE_ID" INTEGER NOT NULL,
    "FAILURE_LEVEL" INTEGER NOT NULL,
    "INHERITANCE" VARCHAR(10),
    "CREATED_AT" BIGINT,
    "UPDATED_AT" BIGINT
);
ALTER TABLE "ACTIVE_RULES" ADD CONSTRAINT "PK_ACTIVE_RULES" PRIMARY KEY("UUID");
CREATE UNIQUE INDEX "UNIQ_PROFILE_RULE_IDS" ON "ACTIVE_RULES"("PROFILE_ID", "RULE_ID");
