CREATE TABLE "RULES_PARAMETERS"(
    "ID" INTEGER NOT NULL AUTO_INCREMENT (1,1),
    "UUID" VARCHAR(40) NOT NULL,
    "RULE_ID" INTEGER NOT NULL,
    "NAME" VARCHAR(128) NOT NULL,
    "DESCRIPTION" VARCHAR(4000),
    "PARAM_TYPE" VARCHAR(512) NOT NULL,
    "DEFAULT_VALUE" VARCHAR(4000)
);
ALTER TABLE "RULES_PARAMETERS" ADD CONSTRAINT "PK_RULES_PARAMETERS" PRIMARY KEY("ID");
CREATE INDEX "RULES_PARAMETERS_RULE_ID" ON "RULES_PARAMETERS"("RULE_ID");
CREATE UNIQUE INDEX "RULES_PARAMETERS_UNIQUE" ON "RULES_PARAMETERS"("RULE_ID", "NAME");

CREATE TABLE "ACTIVE_RULE_PARAMETERS"(
    "ACTIVE_RULE_ID" INTEGER NOT NULL,
    "RULES_PARAMETER_ID" INTEGER NOT NULL,
    "RULES_PARAMETER_UUID" VARCHAR(40),
    "VALUE" VARCHAR(4000),
    "RULES_PARAMETER_KEY" VARCHAR(128),
    "UUID" VARCHAR(40) NOT NULL
);
ALTER TABLE "ACTIVE_RULE_PARAMETERS" ADD CONSTRAINT "PK_ACTIVE_RULE_PARAMETERS" PRIMARY KEY("UUID");
CREATE INDEX "IX_ARP_ON_ACTIVE_RULE_ID" ON "ACTIVE_RULE_PARAMETERS"("ACTIVE_RULE_ID");
