/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1BitString;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.DecodedPublicKey;
import java.math.BigInteger;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class EllipticCurvePublicKey
extends DecodedPublicKey {
    private static final long serialVersionUID = 7537378153089968013L;
    private final boolean yCoordinateIsEven;
    private final BigInteger xCoordinate;
    private final BigInteger yCoordinate;

    EllipticCurvePublicKey(BigInteger xCoordinate, BigInteger yCoordinate) {
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.yCoordinateIsEven = yCoordinate.mod(BigInteger.valueOf(2L)).equals(BigInteger.ZERO);
    }

    EllipticCurvePublicKey(BigInteger xCoordinate, boolean yCoordinateIsEven) {
        this.xCoordinate = xCoordinate;
        this.yCoordinateIsEven = yCoordinateIsEven;
        this.yCoordinate = null;
    }

    EllipticCurvePublicKey(ASN1BitString subjectPublicKey) throws CertException {
        block10: {
            try {
                byte[] keyBytes = subjectPublicKey.getBytes();
                if (keyBytes.length == 65) {
                    if (keyBytes[0] != 4) {
                        throw new CertException(CertMessages.ERR_EC_PUBLIC_KEY_PARSE_UNEXPECTED_UNCOMPRESSED_FIRST_BYTE.get(StaticUtils.toHex(keyBytes[0])));
                    }
                    byte[] xBytes = new byte[32];
                    byte[] yBytes = new byte[32];
                    System.arraycopy(keyBytes, 1, xBytes, 0, 32);
                    System.arraycopy(keyBytes, 33, yBytes, 0, 32);
                    this.xCoordinate = new BigInteger(xBytes);
                    this.yCoordinate = new BigInteger(yBytes);
                    this.yCoordinateIsEven = (keyBytes[64] & 1) == 0;
                    break block10;
                }
                if (keyBytes.length == 33) {
                    this.yCoordinate = null;
                    if (keyBytes[0] == 2) {
                        this.yCoordinateIsEven = true;
                    } else if (keyBytes[0] == 3) {
                        this.yCoordinateIsEven = false;
                    } else {
                        throw new CertException(CertMessages.ERR_EC_PUBLIC_KEY_PARSE_UNEXPECTED_COMPRESSED_FIRST_BYTE.get(StaticUtils.toHex(keyBytes[0])));
                    }
                    byte[] xBytes = new byte[32];
                    System.arraycopy(keyBytes, 1, xBytes, 0, 32);
                    this.xCoordinate = new BigInteger(xBytes);
                    break block10;
                }
                throw new CertException(CertMessages.ERR_EC_PUBLIC_KEY_PARSE_UNEXPECTED_SIZE.get(keyBytes.length));
            }
            catch (CertException e) {
                Debug.debugException(e);
                throw e;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new CertException(CertMessages.ERR_EC_PUBLIC_KEY_PARSE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    ASN1BitString encode() throws CertException {
        byte[] publicKeyBytes;
        if (this.yCoordinate == null) {
            publicKeyBytes = new byte[33];
            publicKeyBytes[0] = this.yCoordinateIsEven ? 2 : 3;
        } else {
            publicKeyBytes = new byte[65];
            publicKeyBytes[0] = 4;
        }
        byte[] xCoordinateBytes = this.xCoordinate.toByteArray();
        if (xCoordinateBytes.length > 32) {
            throw new CertException(CertMessages.ERR_EC_PUBLIC_KEY_ENCODE_X_TOO_LARGE.get(this.toString(), xCoordinateBytes.length));
        }
        int xStartPos = 33 - xCoordinateBytes.length;
        System.arraycopy(xCoordinateBytes, 0, publicKeyBytes, xStartPos, xCoordinateBytes.length);
        if (this.yCoordinate != null) {
            byte[] yCoordinateBytes = this.yCoordinate.toByteArray();
            if (yCoordinateBytes.length > 32) {
                throw new CertException(CertMessages.ERR_EC_PUBLIC_KEY_ENCODE_Y_TOO_LARGE.get(this.toString(), yCoordinateBytes.length));
            }
            int yStartPos = 65 - yCoordinateBytes.length;
            System.arraycopy(yCoordinateBytes, 0, publicKeyBytes, yStartPos, yCoordinateBytes.length);
        }
        boolean[] bits = ASN1BitString.getBitsForBytes(publicKeyBytes);
        return new ASN1BitString(bits);
    }

    public boolean usesCompressedForm() {
        return this.yCoordinate == null;
    }

    public BigInteger getXCoordinate() {
        return this.xCoordinate;
    }

    public BigInteger getYCoordinate() {
        return this.yCoordinate;
    }

    public boolean yCoordinateIsEven() {
        return this.yCoordinateIsEven;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("EllipticCurvePublicKey(usesCompressedForm=");
        buffer.append(this.yCoordinate == null);
        buffer.append(", xCoordinate=");
        buffer.append(this.xCoordinate);
        if (this.yCoordinate == null) {
            buffer.append(", yCoordinateIsEven=");
            buffer.append(this.yCoordinateIsEven);
        } else {
            buffer.append(", yCoordinate=");
            buffer.append(this.yCoordinate);
        }
        buffer.append(')');
    }
}

