/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.io.File;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.process.Encryption;

public class Props {
    private final Properties props;
    private final Encryption encryption;

    public Props(Properties props) {
        this.props = props;
        this.encryption = new Encryption(props.getProperty("sonar.secretKeyPath"));
    }

    public boolean contains(String key) {
        return this.props.containsKey(key);
    }

    @CheckForNull
    public String of(String key) {
        String value = this.props.getProperty(key);
        if (value != null && this.encryption.isEncrypted(value)) {
            value = this.encryption.decrypt(value);
        }
        return value;
    }

    public String of(String key, @Nullable String defaultValue) {
        String s = this.of(key);
        return s == null ? defaultValue : s;
    }

    public boolean booleanOf(String key) {
        String s = this.of(key);
        return s != null && Boolean.parseBoolean(s);
    }

    public boolean booleanOf(String key, boolean defaultValue) {
        String s = this.of(key);
        return s != null ? Boolean.parseBoolean(s) : defaultValue;
    }

    @CheckForNull
    public File fileOf(String key) {
        String s = this.of(key);
        return s != null ? new File(s) : null;
    }

    public Integer intOf(String key) {
        String s = this.of(key);
        if (s != null && !"".equals(s)) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Value of property " + key + " is not an integer: " + s, e);
            }
        }
        return null;
    }

    public int intOf(String key, int defaultValue) {
        Integer i = this.intOf(key);
        return i == null ? defaultValue : i;
    }

    public Properties rawProperties() {
        return this.props;
    }

    public Props set(String key, @Nullable String value) {
        this.props.setProperty(key, value);
        return this;
    }

    public void setDefault(String key, String value) {
        String s = this.props.getProperty(key);
        if (StringUtils.isBlank(s)) {
            this.props.setProperty(key, value);
        }
    }
}

