/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.process.JmxUtils;
import org.sonar.process.ProcessMXBean;
import org.sonar.process.ProcessUtils;
import org.sonar.process.Props;

public abstract class MonitoredProcess
implements ProcessMXBean {
    public static final String NAME_PROPERTY = "pName";
    private static final long AUTOKILL_TIMEOUT_MS = 30000L;
    private static final long AUTOKILL_CHECK_DELAY_MS = 5000L;
    public static final String MISSING_NAME_ARGUMENT = "Missing Name argument";
    private Long lastPing;
    private final String name;
    protected final Props props;
    private ScheduledFuture<?> pingTask = null;
    private ScheduledExecutorService monitor;
    private final boolean isMonitored;

    protected MonitoredProcess(Props props) throws Exception {
        this(props, false);
    }

    protected MonitoredProcess(Props props, boolean monitor) throws Exception {
        this.isMonitored = monitor;
        this.props = props;
        this.name = props.of(NAME_PROPERTY);
        if (StringUtils.isEmpty(this.name)) {
            throw new IllegalStateException(MISSING_NAME_ARGUMENT);
        }
        JmxUtils.registerMBean(this, this.name);
        ProcessUtils.addSelfShutdownHook(this);
    }

    public final void start() {
        if (this.monitor != null) {
            throw new IllegalStateException("Already started");
        }
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug("Process[{}] starting", (Object)this.name);
        this.scheduleAutokill(this.isMonitored);
        this.doStart();
        logger.debug("Process[{}] started", (Object)this.name);
    }

    private void scheduleAutokill(final Boolean isMonitored) {
        Runnable breakOnMissingPing = new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                if (time - MonitoredProcess.this.lastPing > 30000L) {
                    LoggerFactory.getLogger(this.getClass()).info(String.format("Did not receive any ping during %d seconds. Shutting down.", 30L));
                    if (isMonitored.booleanValue()) {
                        MonitoredProcess.this.terminate();
                    }
                }
            }
        };
        this.lastPing = System.currentTimeMillis();
        this.monitor = Executors.newScheduledThreadPool(1);
        this.pingTask = this.monitor.scheduleAtFixedRate(breakOnMissingPing, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public final long ping() {
        this.lastPing = System.currentTimeMillis();
        return this.lastPing;
    }

    @Override
    public final void terminate() {
        if (this.monitor != null) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.debug("Process[{}] terminating", (Object)this.name);
            this.monitor.shutdownNow();
            this.monitor = null;
            if (this.pingTask != null) {
                this.pingTask.cancel(true);
                this.pingTask = null;
            }
            try {
                this.doTerminate();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Fail to terminate " + this.name, e);
            }
            logger.debug("Process[{}] terminated", (Object)this.name);
        }
    }

    @Override
    public final boolean isReady() {
        try {
            return this.doIsReady();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    protected abstract void doStart();

    protected abstract void doTerminate();

    protected abstract boolean doIsReady();
}

