/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxUtils {
    public static final String WEB_SERVER_NAME = "web";
    public static final String SEARCH_SERVER_NAME = "search";

    private JmxUtils() {
    }

    public static ObjectName objectName(String name) {
        try {
            return new ObjectName("org.sonar", "name", name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Cannot create ObjectName for " + name, e);
        }
    }

    public static void registerMBean(Object mbean, String name) {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            if (mbeanServer.isRegistered(JmxUtils.objectName(name))) {
                mbeanServer.unregisterMBean(JmxUtils.objectName(name));
            }
            mbeanServer.registerMBean(mbean, JmxUtils.objectName(name));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to register JMX MBean named " + name, e);
        }
    }
}

