/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.saml;

import java.io.IOException;
import java.util.Base64;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateRequestBuilder;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateResponse;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.saml.SamlBaseRestHandler;

public class RestSamlAuthenticateAction
extends SamlBaseRestHandler
implements RestHandler {
    static final ObjectParser<Input, Void> PARSER = new ObjectParser("saml_authenticate", Input::new);

    public RestSamlAuthenticateAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/saml/authenticate", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_security/saml/authenticate", (RestHandler)this);
    }

    public String getName() {
        return "xpack_security_saml_authenticate_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            Input input = (Input)PARSER.parse(parser, null);
            this.logger.trace("SAML Authenticate: [{}...] [{}]", (Object)Strings.cleanTruncate((String)input.content, (int)128), input.ids);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> {
                byte[] bytes = this.decodeBase64(input.content);
                SamlAuthenticateRequestBuilder requestBuilder = new SecurityClient((ElasticsearchClient)client).prepareSamlAuthenticate(bytes, input.ids);
                requestBuilder.execute((ActionListener)new RestBuilderListener<SamlAuthenticateResponse>(channel){

                    public RestResponse buildResponse(SamlAuthenticateResponse response, XContentBuilder builder) throws Exception {
                        builder.startObject().field("username", response.getPrincipal()).field("access_token", response.getTokenString()).field("refresh_token", response.getRefreshToken()).field("expires_in", response.getExpiresIn().seconds()).endObject();
                        return new BytesRestResponse(RestStatus.OK, builder);
                    }
                });
            };
            return restChannelConsumer;
        }
    }

    private byte[] decodeBase64(String content) {
        content = content.replaceAll("\\s+", "");
        try {
            return Base64.getDecoder().decode(content);
        }
        catch (IllegalArgumentException e) {
            this.logger.info("Failed to decode base64 string [{}] - {}", (Object)content, (Object)e.toString());
            throw e;
        }
    }

    static {
        PARSER.declareString(Input::setContent, new ParseField("content", new String[0]));
        PARSER.declareStringArray(Input::setIds, new ParseField("ids", new String[0]));
    }

    static class Input {
        String content;
        List<String> ids;

        Input() {
        }

        void setContent(String content) {
            this.content = content;
        }

        void setIds(List<String> ids) {
            this.ids = ids;
        }
    }
}

