/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.xpack.sql.type.ExtTypes;

public enum DataType {
    NULL("null", JDBCType.NULL, 0, 0, 0, false, false, false),
    UNSUPPORTED(JDBCType.OTHER, 0, 0, 0, false, false, false),
    BOOLEAN("boolean", JDBCType.BOOLEAN, 1, 1, 1, false, false, false),
    BYTE("byte", JDBCType.TINYINT, 1, 3, 5, true, false, true),
    SHORT("short", JDBCType.SMALLINT, 2, 5, 6, true, false, true),
    INTEGER("integer", JDBCType.INTEGER, 4, 10, 11, true, false, true),
    LONG("long", JDBCType.BIGINT, 8, 19, 20, true, false, true),
    DOUBLE("double", JDBCType.DOUBLE, 8, 15, 25, false, true, true),
    FLOAT("float", JDBCType.REAL, 4, 7, 15, false, true, true),
    HALF_FLOAT("half_float", JDBCType.FLOAT, 8, 16, 25, false, true, true),
    SCALED_FLOAT("scaled_float", JDBCType.FLOAT, 8, 19, 25, false, true, true),
    KEYWORD("keyword", JDBCType.VARCHAR, Integer.MAX_VALUE, 256, 0, false, false, true),
    TEXT("text", JDBCType.VARCHAR, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false, false, false),
    OBJECT("object", JDBCType.STRUCT, -1, 0, 0, false, false, false),
    NESTED("nested", JDBCType.STRUCT, -1, 0, 0, false, false, false),
    BINARY("binary", JDBCType.VARBINARY, -1, Integer.MAX_VALUE, 0, false, false, false),
    DATE(JDBCType.DATE, 8, 29, 29, false, false, true),
    DATETIME("date", JDBCType.TIMESTAMP, 8, 29, 29, false, false, true),
    IP("ip", JDBCType.VARCHAR, 39, 39, 0, false, false, true),
    INTERVAL_YEAR(ExtTypes.INTERVAL_YEAR, 4, 7, 7, false, false, false),
    INTERVAL_MONTH(ExtTypes.INTERVAL_MONTH, 4, 7, 7, false, false, false),
    INTERVAL_DAY(ExtTypes.INTERVAL_DAY, 8, 23, 23, false, false, false),
    INTERVAL_HOUR(ExtTypes.INTERVAL_HOUR, 8, 23, 23, false, false, false),
    INTERVAL_MINUTE(ExtTypes.INTERVAL_MINUTE, 8, 23, 23, false, false, false),
    INTERVAL_SECOND(ExtTypes.INTERVAL_SECOND, 8, 23, 23, false, false, false),
    INTERVAL_YEAR_TO_MONTH(ExtTypes.INTERVAL_YEAR_TO_MONTH, 4, 7, 7, false, false, false),
    INTERVAL_DAY_TO_HOUR(ExtTypes.INTERVAL_DAY_TO_HOUR, 8, 23, 23, false, false, false),
    INTERVAL_DAY_TO_MINUTE(ExtTypes.INTERVAL_DAY_TO_MINUTE, 8, 23, 23, false, false, false),
    INTERVAL_DAY_TO_SECOND(ExtTypes.INTERVAL_DAY_TO_SECOND, 8, 23, 23, false, false, false),
    INTERVAL_HOUR_TO_MINUTE(ExtTypes.INTERVAL_HOUR_TO_MINUTE, 8, 23, 23, false, false, false),
    INTERVAL_HOUR_TO_SECOND(ExtTypes.INTERVAL_HOUR_TO_SECOND, 8, 23, 23, false, false, false),
    INTERVAL_MINUTE_TO_SECOND(ExtTypes.INTERVAL_MINUTE_TO_SECOND, 8, 23, 23, false, false, false);

    private static final Map<String, DataType> ODBC_TO_ES;
    private static final Map<String, DataType> SQL_TO_ES;
    public final String typeName = this.name().toLowerCase(Locale.ROOT);
    public final String esType;
    public final SQLType sqlType;
    public final int size;
    public final int defaultPrecision;
    public final int displaySize;
    private final boolean isInteger;
    private final boolean isRational;
    public final boolean defaultDocValues;

    private DataType(SQLType sqlType, int size, int defaultPrecision, int displaySize, boolean isInteger, boolean isRational, boolean defaultDocValues) {
        this(null, sqlType, size, defaultPrecision, displaySize, isInteger, isRational, defaultDocValues);
    }

    private DataType(String esType, SQLType sqlType, int size, int defaultPrecision, int displaySize, boolean isInteger, boolean isRational, boolean defaultDocValues) {
        this.esType = esType;
        this.sqlType = sqlType;
        this.size = size;
        this.defaultPrecision = defaultPrecision;
        this.displaySize = displaySize;
        this.isInteger = isInteger;
        this.isRational = isRational;
        this.defaultDocValues = defaultDocValues;
    }

    public String sqlName() {
        return this.sqlType.getName();
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public boolean isRational() {
        return this.isRational;
    }

    public boolean isNumeric() {
        return this.isInteger || this.isRational;
    }

    public boolean isSigned() {
        return this.isNumeric();
    }

    public boolean isString() {
        return this == KEYWORD || this == TEXT;
    }

    public boolean isPrimitive() {
        return this != OBJECT && this != NESTED && this != UNSUPPORTED;
    }

    public boolean isDateBased() {
        return this == DATE || this == DATETIME;
    }

    public static DataType fromOdbcType(String odbcType) {
        return ODBC_TO_ES.get(odbcType);
    }

    public static DataType fromSqlOrEsType(String typeName) {
        return SQL_TO_ES.get(typeName.toUpperCase(Locale.ROOT));
    }

    public static DataType fromTypeName(String esType) {
        String uppercase = esType.toUpperCase(Locale.ROOT);
        if (uppercase.equals("DATE")) {
            return DATETIME;
        }
        try {
            return DataType.valueOf(uppercase);
        }
        catch (IllegalArgumentException ex) {
            return UNSUPPORTED;
        }
    }

    public String format() {
        return this.isDateBased() ? "epoch_millis" : null;
    }

    static {
        ODBC_TO_ES = new HashMap<String, DataType>(36);
        ODBC_TO_ES.put("SQL_BIT", BOOLEAN);
        ODBC_TO_ES.put("SQL_TINYINT", BYTE);
        ODBC_TO_ES.put("SQL_SMALLINT", SHORT);
        ODBC_TO_ES.put("SQL_INTEGER", INTEGER);
        ODBC_TO_ES.put("SQL_BIGINT", LONG);
        ODBC_TO_ES.put("SQL_REAL", FLOAT);
        ODBC_TO_ES.put("SQL_FLOAT", DOUBLE);
        ODBC_TO_ES.put("SQL_DOUBLE", DOUBLE);
        ODBC_TO_ES.put("SQL_DECIMAL", DOUBLE);
        ODBC_TO_ES.put("SQL_NUMERIC", DOUBLE);
        ODBC_TO_ES.put("SQL_GUID", KEYWORD);
        ODBC_TO_ES.put("SQL_CHAR", KEYWORD);
        ODBC_TO_ES.put("SQL_WCHAR", KEYWORD);
        ODBC_TO_ES.put("SQL_VARCHAR", TEXT);
        ODBC_TO_ES.put("SQL_WVARCHAR", TEXT);
        ODBC_TO_ES.put("SQL_LONGVARCHAR", TEXT);
        ODBC_TO_ES.put("SQL_WLONGVARCHAR", TEXT);
        ODBC_TO_ES.put("SQL_BINARY", BINARY);
        ODBC_TO_ES.put("SQL_VARBINARY", BINARY);
        ODBC_TO_ES.put("SQL_LONGVARBINARY", BINARY);
        ODBC_TO_ES.put("SQL_DATE", DATE);
        ODBC_TO_ES.put("SQL_TIME", DATETIME);
        ODBC_TO_ES.put("SQL_TIMESTAMP", DATETIME);
        ODBC_TO_ES.put("SQL_INTERVAL_HOUR_TO_MINUTE", INTERVAL_HOUR_TO_MINUTE);
        ODBC_TO_ES.put("SQL_INTERVAL_HOUR_TO_SECOND", INTERVAL_HOUR_TO_SECOND);
        ODBC_TO_ES.put("SQL_INTERVAL_MINUTE_TO_SECOND", INTERVAL_MINUTE_TO_SECOND);
        ODBC_TO_ES.put("SQL_INTERVAL_MONTH", INTERVAL_MONTH);
        ODBC_TO_ES.put("SQL_INTERVAL_YEAR", INTERVAL_YEAR);
        ODBC_TO_ES.put("SQL_INTERVAL_YEAR_TO_MONTH", INTERVAL_YEAR_TO_MONTH);
        ODBC_TO_ES.put("SQL_INTERVAL_DAY", INTERVAL_DAY);
        ODBC_TO_ES.put("SQL_INTERVAL_HOUR", INTERVAL_HOUR);
        ODBC_TO_ES.put("SQL_INTERVAL_MINUTE", INTERVAL_MINUTE);
        ODBC_TO_ES.put("SQL_INTERVAL_SECOND", INTERVAL_SECOND);
        ODBC_TO_ES.put("SQL_INTERVAL_DAY_TO_HOUR", INTERVAL_DAY_TO_HOUR);
        ODBC_TO_ES.put("SQL_INTERVAL_DAY_TO_MINUTE", INTERVAL_DAY_TO_MINUTE);
        ODBC_TO_ES.put("SQL_INTERVAL_DAY_TO_SECOND", INTERVAL_DAY_TO_SECOND);
        SQL_TO_ES = new HashMap<String, DataType>(45);
        for (DataType type : DataType.values()) {
            if (!type.isPrimitive()) continue;
            SQL_TO_ES.put(type.name(), type);
        }
        for (Map.Entry entry : ODBC_TO_ES.entrySet()) {
            SQL_TO_ES.put(((String)entry.getKey()).substring(4), (DataType)((Object)entry.getValue()));
        }
        SQL_TO_ES.put("BOOL", BOOLEAN);
        SQL_TO_ES.put("INT", INTEGER);
        SQL_TO_ES.put("STRING", KEYWORD);
    }
}

