/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Alias;
import org.elasticsearch.xpack.sql.expression.Exists;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.Order;
import org.elasticsearch.xpack.sql.expression.ScalarSubquery;
import org.elasticsearch.xpack.sql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.sql.expression.UnresolvedStar;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.literal.Interval;
import org.elasticsearch.xpack.sql.expression.literal.IntervalDayTime;
import org.elasticsearch.xpack.sql.expression.literal.IntervalYearMonth;
import org.elasticsearch.xpack.sql.expression.literal.Intervals;
import org.elasticsearch.xpack.sql.expression.predicate.Range;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.MatchQueryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.MultiMatchQueryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.StringQueryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.logical.And;
import org.elasticsearch.xpack.sql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.sql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.sql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.sql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Mod;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Neg;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Sub;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.NullEquals;
import org.elasticsearch.xpack.sql.expression.predicate.regex.Like;
import org.elasticsearch.xpack.sql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.sql.expression.predicate.regex.RLike;
import org.elasticsearch.xpack.sql.parser.IdentifierBuilder;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.type.DataTypes;
import org.elasticsearch.xpack.sql.util.DateUtils;
import org.elasticsearch.xpack.sql.util.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

abstract class ExpressionBuilder
extends IdentifierBuilder {
    private final Map<Token, SqlTypedParamValue> params;

    ExpressionBuilder(Map<Token, SqlTypedParamValue> params) {
        this.params = params;
    }

    protected Expression expression(ParseTree ctx) {
        return this.typedParsing(ctx, Expression.class);
    }

    protected List<Expression> expressions(List<? extends ParserRuleContext> contexts) {
        return this.visitList(contexts, Expression.class);
    }

    @Override
    public Expression visitSingleExpression(SqlBaseParser.SingleExpressionContext ctx) {
        return this.expression((ParseTree)ctx.expression());
    }

    @Override
    public Expression visitSelectExpression(SqlBaseParser.SelectExpressionContext ctx) {
        Expression exp = this.expression((ParseTree)ctx.expression());
        String alias = this.visitIdentifier(ctx.identifier());
        if (alias != null) {
            exp = new Alias(ExpressionBuilder.source(ctx), alias, exp);
        }
        return exp;
    }

    @Override
    public Expression visitStar(SqlBaseParser.StarContext ctx) {
        return new UnresolvedStar(ExpressionBuilder.source(ctx), ctx.qualifiedName() != null ? new UnresolvedAttribute(ExpressionBuilder.source(ctx.qualifiedName()), this.visitQualifiedName(ctx.qualifiedName())) : null);
    }

    @Override
    public Object visitDereference(SqlBaseParser.DereferenceContext ctx) {
        return new UnresolvedAttribute(ExpressionBuilder.source(ctx), this.visitQualifiedName(ctx.qualifiedName()));
    }

    @Override
    public Expression visitExists(SqlBaseParser.ExistsContext ctx) {
        return new Exists(ExpressionBuilder.source(ctx), this.plan((ParseTree)ctx.query()));
    }

    @Override
    public Expression visitComparison(SqlBaseParser.ComparisonContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        TerminalNode op = (TerminalNode)ctx.comparisonOperator().getChild(0);
        Source source = ExpressionBuilder.source(ctx);
        switch (op.getSymbol().getType()) {
            case 101: {
                return new Equals(source, left, right);
            }
            case 102: {
                return new NullEquals(source, left, right);
            }
            case 103: {
                return new NotEquals(source, left, right);
            }
            case 104: {
                return new LessThan(source, left, right);
            }
            case 105: {
                return new LessThanOrEqual(source, left, right);
            }
            case 106: {
                return new GreaterThan(source, left, right);
            }
            case 107: {
                return new GreaterThanOrEqual(source, left, right);
            }
        }
        throw new ParsingException(source, "Unknown operator {}", source.text());
    }

    @Override
    public Expression visitPredicated(SqlBaseParser.PredicatedContext ctx) {
        Expression exp = this.expression((ParseTree)ctx.valueExpression());
        if (ctx.predicate() == null) {
            return exp;
        }
        SqlBaseParser.PredicateContext pCtx = ctx.predicate();
        Source source = this.source(ctx.valueExpression(), ctx);
        ScalarFunction e = null;
        switch (pCtx.kind.getType()) {
            case 12: {
                e = new Range(source, exp, this.expression((ParseTree)pCtx.lower), true, this.expression((ParseTree)pCtx.upper), true);
                break;
            }
            case 43: {
                if (pCtx.query() != null) {
                    throw new ParsingException(source, "IN query not supported yet", new Object[0]);
                }
                e = new In(source, exp, this.expressions(pCtx.valueExpression()));
                break;
            }
            case 50: {
                e = new Like(source, exp, this.visitPattern(pCtx.pattern()));
                break;
            }
            case 71: {
                e = new RLike(source, exp, this.string(pCtx.regex));
                break;
            }
            case 60: {
                if (pCtx.NOT() != null) {
                    return new IsNotNull(source, exp);
                }
                return new IsNull(source, exp);
            }
            default: {
                throw new ParsingException(source, "Unknown predicate {}", source.text());
            }
        }
        return pCtx.NOT() != null ? new Not(source, e) : e;
    }

    @Override
    public LikePattern visitLikePattern(SqlBaseParser.LikePatternContext ctx) {
        return ctx == null ? null : this.visitPattern(ctx.pattern());
    }

    @Override
    public LikePattern visitPattern(SqlBaseParser.PatternContext ctx) {
        String escapeString;
        if (ctx == null) {
            return null;
        }
        String pattern = this.string(ctx.value);
        int pos = pattern.indexOf(42);
        if (pos >= 0) {
            throw new ParsingException(ExpressionBuilder.source(ctx.value), "Invalid char [*] found in pattern [{}] at position {}; use [%] or [_] instead", pattern, pos);
        }
        char escape = '\u0000';
        SqlBaseParser.PatternEscapeContext escapeCtx = ctx.patternEscape();
        String string = escapeString = escapeCtx == null ? null : this.string(escapeCtx.escape);
        if (Strings.hasText((String)escapeString)) {
            if (escapeString.length() > 1) {
                throw new ParsingException(ExpressionBuilder.source(escapeCtx), "A character not a string required for escaping; found [{}]", escapeString);
            }
            if (escapeString.length() == 1) {
                escape = escapeString.charAt(0);
                if (escape == '*' || escape == '%' || escape == '_') {
                    throw new ParsingException(ExpressionBuilder.source(escapeCtx.escape), "Char [{}] cannot be used for escaping", Character.valueOf(escape));
                }
                for (int i = 0; i < pattern.length(); ++i) {
                    char current = pattern.charAt(i);
                    if (current != escape) continue;
                    if (i + 1 == pattern.length()) {
                        throw new ParsingException(ExpressionBuilder.source(ctx.value), "Pattern [{}] is invalid as escape char [{}] at position {} does not escape anything", pattern, Character.valueOf(escape), i);
                    }
                    char next = pattern.charAt(i + 1);
                    if (next == '%' || next == '_') continue;
                    throw new ParsingException(ExpressionBuilder.source(ctx.value), "Pattern [{}] is invalid as escape char [{}] at position {} can only escape wildcard chars; found [{}]", pattern, Character.valueOf(escape), i, Character.valueOf(next));
                }
            }
        }
        return new LikePattern(pattern, escape);
    }

    @Override
    public Object visitArithmeticUnary(SqlBaseParser.ArithmeticUnaryContext ctx) {
        Expression value = this.expression((ParseTree)ctx.valueExpression());
        Source source = ExpressionBuilder.source(ctx);
        switch (ctx.operator.getType()) {
            case 108: {
                return value;
            }
            case 109: {
                if (value instanceof Literal) {
                    return value;
                }
                return new Neg(ExpressionBuilder.source(ctx), value);
            }
        }
        throw new ParsingException(source, "Unknown arithmetic {}", source.text());
    }

    @Override
    public Object visitArithmeticBinary(SqlBaseParser.ArithmeticBinaryContext ctx) {
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        Source source = ExpressionBuilder.source(ctx);
        switch (ctx.operator.getType()) {
            case 110: {
                return new Mul(source, left, right);
            }
            case 111: {
                return new Div(source, left, right);
            }
            case 112: {
                return new Mod(source, left, right);
            }
            case 108: {
                return new Add(source, left, right);
            }
            case 109: {
                return new Sub(source, left, right);
            }
        }
        throw new ParsingException(source, "Unknown arithmetic {}", source.text());
    }

    @Override
    public Object visitStringQuery(SqlBaseParser.StringQueryContext ctx) {
        return new StringQueryPredicate(ExpressionBuilder.source(ctx), this.string(ctx.queryString), this.getQueryOptions(ctx.matchQueryOptions()));
    }

    @Override
    public Object visitMatchQuery(SqlBaseParser.MatchQueryContext ctx) {
        return new MatchQueryPredicate(ExpressionBuilder.source(ctx), new UnresolvedAttribute(ExpressionBuilder.source(ctx.singleField), this.visitQualifiedName(ctx.singleField)), this.string(ctx.queryString), this.getQueryOptions(ctx.matchQueryOptions()));
    }

    @Override
    public Object visitMultiMatchQuery(SqlBaseParser.MultiMatchQueryContext ctx) {
        return new MultiMatchQueryPredicate(ExpressionBuilder.source(ctx), this.string(ctx.multiFields), this.string(ctx.queryString), this.getQueryOptions(ctx.matchQueryOptions()));
    }

    private String getQueryOptions(SqlBaseParser.MatchQueryOptionsContext optionsCtx) {
        StringJoiner sj = new StringJoiner(";");
        for (SqlBaseParser.StringContext sc : optionsCtx.string()) {
            sj.add(this.string(sc));
        }
        return sj.toString();
    }

    @Override
    public Order visitOrderBy(SqlBaseParser.OrderByContext ctx) {
        return new Order(ExpressionBuilder.source(ctx), this.expression((ParseTree)ctx.expression()), ctx.DESC() != null ? Order.OrderDirection.DESC : Order.OrderDirection.ASC, ctx.NULLS() != null ? (ctx.FIRST() != null ? Order.NullsPosition.FIRST : Order.NullsPosition.LAST) : null);
    }

    @Override
    public DataType visitPrimitiveDataType(SqlBaseParser.PrimitiveDataTypeContext ctx) {
        String type = this.visitIdentifier(ctx.identifier());
        DataType dataType = DataType.fromSqlOrEsType(type);
        if (dataType == null) {
            throw new ParsingException(ExpressionBuilder.source(ctx), "Does not recognize type [{}]", type);
        }
        return dataType;
    }

    @Override
    public Cast visitCastExpression(SqlBaseParser.CastExpressionContext ctx) {
        DataType dataType;
        SqlBaseParser.CastTemplateContext castTc = ctx.castTemplate();
        if (castTc != null) {
            return new Cast(ExpressionBuilder.source(castTc), this.expression((ParseTree)castTc.expression()), this.typedParsing((ParseTree)castTc.dataType(), DataType.class));
        }
        SqlBaseParser.ConvertTemplateContext convertTc = ctx.convertTemplate();
        String convertDataType = convertTc.dataType().getText().toUpperCase(Locale.ROOT);
        if (convertDataType.startsWith("SQL_")) {
            dataType = DataType.fromOdbcType(convertDataType);
            if (dataType == null) {
                throw new ParsingException(ExpressionBuilder.source(convertTc.dataType()), "Invalid data type [{}] provided", convertDataType);
            }
        } else {
            try {
                dataType = DataType.valueOf(convertDataType);
            }
            catch (IllegalArgumentException e) {
                throw new ParsingException(ExpressionBuilder.source(convertTc.dataType()), "Invalid data type [{}] provided", convertDataType);
            }
        }
        return new Cast(ExpressionBuilder.source(convertTc), this.expression((ParseTree)convertTc.expression()), dataType);
    }

    @Override
    public Function visitExtractExpression(SqlBaseParser.ExtractExpressionContext ctx) {
        SqlBaseParser.ExtractTemplateContext template = ctx.extractTemplate();
        String fieldString = this.visitIdentifier(template.field);
        return new UnresolvedFunction(ExpressionBuilder.source(template), fieldString, UnresolvedFunction.ResolutionType.EXTRACT, Collections.singletonList(this.expression((ParseTree)template.valueExpression())));
    }

    @Override
    public Object visitBuiltinDateTimeFunction(SqlBaseParser.BuiltinDateTimeFunctionContext ctx) {
        Source source = ExpressionBuilder.source(ctx);
        String functionName = ctx.name.getText();
        switch (ctx.name.getType()) {
            case 20: {
                return new UnresolvedFunction(source, functionName, UnresolvedFunction.ResolutionType.STANDARD, Collections.emptyList());
            }
            case 19: {
                return new UnresolvedFunction(source, functionName, UnresolvedFunction.ResolutionType.STANDARD, Collections.emptyList());
            }
        }
        throw new ParsingException(source, "Unknown function [{}]", functionName);
    }

    @Override
    public Function visitFunctionExpression(SqlBaseParser.FunctionExpressionContext ctx) {
        SqlBaseParser.FunctionTemplateContext template = ctx.functionTemplate();
        String name = template.functionName().getText();
        boolean isDistinct = template.setQuantifier() != null && template.setQuantifier().DISTINCT() != null;
        UnresolvedFunction.ResolutionType resolutionType = isDistinct ? UnresolvedFunction.ResolutionType.DISTINCT : UnresolvedFunction.ResolutionType.STANDARD;
        return new UnresolvedFunction(ExpressionBuilder.source(ctx), name, resolutionType, this.expressions(template.expression()));
    }

    @Override
    public Expression visitSubqueryExpression(SqlBaseParser.SubqueryExpressionContext ctx) {
        return new ScalarSubquery(ExpressionBuilder.source(ctx), this.plan((ParseTree)ctx.query()));
    }

    @Override
    public Expression visitParenthesizedExpression(SqlBaseParser.ParenthesizedExpressionContext ctx) {
        return this.expression((ParseTree)ctx.expression());
    }

    @Override
    public Object visitLogicalNot(SqlBaseParser.LogicalNotContext ctx) {
        return new Not(ExpressionBuilder.source(ctx), this.expression((ParseTree)ctx.booleanExpression()));
    }

    @Override
    public Object visitLogicalBinary(SqlBaseParser.LogicalBinaryContext ctx) {
        int type = ctx.operator.getType();
        Source source = ExpressionBuilder.source(ctx);
        Expression left = this.expression((ParseTree)ctx.left);
        Expression right = this.expression((ParseTree)ctx.right);
        if (type == 8) {
            return new And(source, left, right);
        }
        if (type == 64) {
            return new Or(source, left, right);
        }
        throw new ParsingException(source, "Don't know how to parse {}", new Object[]{ctx});
    }

    @Override
    public Expression visitNullLiteral(SqlBaseParser.NullLiteralContext ctx) {
        return new Literal(ExpressionBuilder.source(ctx), null, DataType.NULL);
    }

    @Override
    public Literal visitInterval(SqlBaseParser.IntervalContext interval) {
        Intervals.TimeUnit leading = this.visitIntervalField(interval.leading);
        Intervals.TimeUnit trailing = this.visitIntervalField(interval.trailing);
        if (trailing != null) {
            if (leading == Intervals.TimeUnit.YEAR && trailing != Intervals.TimeUnit.MONTH) {
                throw new ParsingException(ExpressionBuilder.source(interval.trailing), "Invalid interval declaration; YEAR trailing unit required to be MONTH, received {}", new Object[]{trailing});
            }
            if (trailing.ordinal() <= leading.ordinal()) {
                EnumSet<Intervals.TimeUnit> range = EnumSet.range(leading, Intervals.TimeUnit.SECOND);
                range.remove((Object)leading);
                throw new ParsingException(ExpressionBuilder.source(interval.trailing), "Invalid interval declaration; trailing unit [{}] needs to be smaller than leading unit[{}], expected one of {}", new Object[]{trailing, leading, range});
            }
        }
        DataType intervalType = Intervals.intervalType(ExpressionBuilder.source(interval), leading, trailing);
        boolean negative = false;
        ParserRuleContext parentCtx = interval.getParent();
        if (parentCtx != null && parentCtx instanceof SqlBaseParser.IntervalLiteralContext && (parentCtx = parentCtx.getParent()) instanceof SqlBaseParser.ConstantDefaultContext && (parentCtx = parentCtx.getParent()) instanceof SqlBaseParser.ValueExpressionDefaultContext && (parentCtx = parentCtx.getParent()) instanceof SqlBaseParser.ArithmeticUnaryContext) {
            SqlBaseParser.ArithmeticUnaryContext auc = (SqlBaseParser.ArithmeticUnaryContext)parentCtx;
            negative = auc.MINUS() != null;
        }
        negative ^= interval.sign != null && interval.sign.getType() == 109;
        TemporalAmount value = null;
        if (interval.valueNumeric != null) {
            if (trailing != null) {
                throw new ParsingException(ExpressionBuilder.source(interval.trailing), "Invalid interval declaration; trailing unit [{}] specified but the value is with numeric (single unit), use the string notation instead", new Object[]{trailing});
            }
            value = this.of(interval.valueNumeric, leading);
        } else {
            value = this.of(interval.valuePattern, negative, intervalType);
        }
        Interval timeInterval = value instanceof Period ? new IntervalYearMonth((Period)value, intervalType) : new IntervalDayTime((Duration)value, intervalType);
        return new Literal(ExpressionBuilder.source(interval), timeInterval, timeInterval.dataType());
    }

    private TemporalAmount of(SqlBaseParser.NumberContext valueNumeric, Intervals.TimeUnit unit) {
        Literal value = (Literal)this.visit((ParseTree)valueNumeric);
        Number numeric = (Number)value.fold();
        if (Math.rint(numeric.doubleValue()) != (double)numeric.longValue()) {
            throw new ParsingException(ExpressionBuilder.source(valueNumeric), "Fractional values are not supported for intervals", new Object[0]);
        }
        return Intervals.of(ExpressionBuilder.source(valueNumeric), numeric.longValue(), unit);
    }

    private TemporalAmount of(SqlBaseParser.StringContext valuePattern, boolean negative, DataType intervalType) {
        String valueString = this.string(valuePattern);
        Source source = ExpressionBuilder.source(valuePattern);
        TemporalAmount interval = Intervals.parseInterval(source, valueString, intervalType);
        if (negative) {
            interval = Intervals.negate(interval);
        }
        return interval;
    }

    @Override
    public Intervals.TimeUnit visitIntervalField(SqlBaseParser.IntervalFieldContext ctx) {
        if (ctx == null) {
            return null;
        }
        switch (((TerminalNode)ctx.getChild(TerminalNode.class, 0)).getSymbol().getType()) {
            case 90: 
            case 91: {
                return Intervals.TimeUnit.YEAR;
            }
            case 56: 
            case 57: {
                return Intervals.TimeUnit.MONTH;
            }
            case 21: 
            case 22: {
                return Intervals.TimeUnit.DAY;
            }
            case 41: 
            case 42: {
                return Intervals.TimeUnit.HOUR;
            }
            case 54: 
            case 55: {
                return Intervals.TimeUnit.MINUTE;
            }
            case 74: 
            case 75: {
                return Intervals.TimeUnit.SECOND;
            }
        }
        throw new IllegalArgumentException("Unsupported interval field: " + ctx.getText());
    }

    @Override
    public Expression visitBooleanLiteral(SqlBaseParser.BooleanLiteralContext ctx) {
        boolean value;
        try {
            value = Booleans.parseBoolean((String)ctx.getText().toLowerCase(Locale.ROOT), (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException(ExpressionBuilder.source(ctx), iae.getMessage(), new Object[0]);
        }
        return new Literal(ExpressionBuilder.source(ctx), value, DataType.BOOLEAN);
    }

    @Override
    public Expression visitStringLiteral(SqlBaseParser.StringLiteralContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (TerminalNode node : ctx.STRING()) {
            sb.append(ExpressionBuilder.unquoteString(ExpressionBuilder.text((ParseTree)node)));
        }
        return new Literal(ExpressionBuilder.source(ctx), sb.toString(), DataType.KEYWORD);
    }

    @Override
    public Literal visitDecimalLiteral(SqlBaseParser.DecimalLiteralContext ctx) {
        Tuple<Source, String> tuple = ExpressionBuilder.withMinus(ctx);
        try {
            return new Literal((Source)tuple.v1(), StringUtils.parseDouble((String)tuple.v2()), DataType.DOUBLE);
        }
        catch (SqlIllegalArgumentException siae) {
            throw new ParsingException((Source)tuple.v1(), siae.getMessage(), new Object[0]);
        }
    }

    @Override
    public Literal visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext ctx) {
        long value;
        Tuple<Source, String> tuple = ExpressionBuilder.withMinus(ctx);
        try {
            value = StringUtils.parseLong((String)tuple.v2());
        }
        catch (SqlIllegalArgumentException siae) {
            throw new ParsingException((Source)tuple.v1(), siae.getMessage(), new Object[0]);
        }
        Number val = value;
        DataType type = DataType.LONG;
        if ((long)((int)value) == value) {
            type = DataType.INTEGER;
            val = (int)value;
        }
        return new Literal((Source)tuple.v1(), val, type);
    }

    @Override
    public Literal visitParamLiteral(SqlBaseParser.ParamLiteralContext ctx) {
        DataType sourceType;
        SqlTypedParamValue param = this.param(ctx.PARAM());
        DataType dataType = DataType.fromTypeName(param.type);
        Source source = ExpressionBuilder.source(ctx);
        if (param.value == null) {
            return new Literal(source, null, dataType);
        }
        try {
            sourceType = DataTypes.fromJava(param.value);
        }
        catch (SqlIllegalArgumentException ex) {
            throw new ParsingException((Exception)((Object)ex), source, "Unexpected actual parameter type [{}] for type [{}]", param.value.getClass().getName(), param.type);
        }
        if (sourceType == dataType) {
            return new Literal(source, param.value, dataType);
        }
        try {
            return new Literal(source, DataTypeConversion.conversionFor(sourceType, dataType).convert(param.value), dataType);
        }
        catch (SqlIllegalArgumentException ex) {
            throw new ParsingException((Exception)((Object)ex), source, "Unexpected actual parameter type [{}] for type [{}]", new Object[]{sourceType, param.type});
        }
    }

    @Override
    public String visitString(SqlBaseParser.StringContext ctx) {
        return this.string(ctx);
    }

    String string(SqlBaseParser.StringContext ctx) {
        if (ctx == null) {
            return null;
        }
        SqlTypedParamValue param = this.param(ctx.PARAM());
        if (param != null) {
            return param.value != null ? param.value.toString() : null;
        }
        return ExpressionBuilder.unquoteString(ctx.getText());
    }

    private SqlTypedParamValue param(TerminalNode node) {
        if (node == null) {
            return null;
        }
        Token token = node.getSymbol();
        if (!this.params.containsKey(token)) {
            throw new ParsingException(ExpressionBuilder.source(node), "Unexpected parameter", new Object[0]);
        }
        return this.params.get(token);
    }

    @Override
    public Literal visitDateEscapedLiteral(SqlBaseParser.DateEscapedLiteralContext ctx) {
        String string = this.string(ctx.string());
        Source source = ExpressionBuilder.source(ctx);
        DateTime dt = null;
        try {
            dt = ISODateTimeFormat.date().parseDateTime(string);
        }
        catch (IllegalArgumentException ex) {
            throw new ParsingException(source, "Invalid date received; {}", ex.getMessage());
        }
        return new Literal(source, DateUtils.asDateOnly(dt), DataType.DATE);
    }

    @Override
    public Literal visitTimeEscapedLiteral(SqlBaseParser.TimeEscapedLiteralContext ctx) {
        String string = this.string(ctx.string());
        Source source = ExpressionBuilder.source(ctx);
        DateTime dt = null;
        try {
            dt = ISODateTimeFormat.hourMinuteSecond().parseDateTime(string);
        }
        catch (IllegalArgumentException ex) {
            throw new ParsingException(source, "Invalid time received; {}", ex.getMessage());
        }
        throw new SqlIllegalArgumentException("Time (only) literals are not supported; a date component is required as well");
    }

    @Override
    public Literal visitTimestampEscapedLiteral(SqlBaseParser.TimestampEscapedLiteralContext ctx) {
        String string = this.string(ctx.string());
        Source source = ExpressionBuilder.source(ctx);
        DateTime dt = null;
        try {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendLiteral(" ").append(ISODateTimeFormat.hourMinuteSecondFraction()).toFormatter();
            dt = formatter.parseDateTime(string);
        }
        catch (IllegalArgumentException ex) {
            throw new ParsingException(source, "Invalid timestamp received; {}", ex.getMessage());
        }
        return new Literal(source, DateUtils.asDateTime(dt), DataType.DATETIME);
    }

    @Override
    public Literal visitGuidEscapedLiteral(SqlBaseParser.GuidEscapedLiteralContext ctx) {
        int[] separatorPos;
        String string = this.string(ctx.string());
        Source source = ExpressionBuilder.source(ctx.string());
        String lowerCase = string.toLowerCase(Locale.ROOT);
        String errorPrefix = "Invalid GUID, ";
        if (lowerCase.length() != 36) {
            throw new ParsingException(source, "{}too {}", errorPrefix, lowerCase.length() > 36 ? "long" : "short");
        }
        for (int pos : separatorPos = new int[]{8, 13, 18, 23}) {
            if (lowerCase.charAt(pos) == '-') continue;
            throw new ParsingException(source, "{}expected group separator at offset [{}], found [{}]", errorPrefix, pos, Character.valueOf(string.charAt(pos)));
        }
        String HEXA = "0123456789abcdef";
        for (int i = 0; i < lowerCase.length(); ++i) {
            boolean inspect = true;
            for (int pos : separatorPos) {
                if (i == pos) {
                    inspect = false;
                    break;
                }
                if (pos > i) break;
            }
            if (!inspect || HEXA.indexOf(lowerCase.charAt(i)) >= 0) continue;
            throw new ParsingException(source, "{}expected hexadecimal at offset[{}], found [{}]", errorPrefix, i, Character.valueOf(string.charAt(i)));
        }
        return new Literal(ExpressionBuilder.source(ctx), string, DataType.KEYWORD);
    }

    private static Tuple<Source, String> withMinus(SqlBaseParser.NumberContext ctx) {
        String string = ctx.getText();
        Source source = ExpressionBuilder.minusAwareSource(ctx);
        if (source != null) {
            string = "-" + string;
        } else {
            source = ExpressionBuilder.source(ctx);
        }
        return new Tuple((Object)source, (Object)string);
    }

    private static Source minusAwareSource(SqlBaseParser.NumberContext ctx) {
        ParserRuleContext parentCtx = ctx.getParent();
        if (parentCtx != null) {
            if (parentCtx instanceof SqlBaseParser.NumericLiteralContext) {
                if ((parentCtx = parentCtx.getParent()) != null && parentCtx instanceof SqlBaseParser.ConstantDefaultContext && (parentCtx = parentCtx.getParent()) != null && parentCtx instanceof SqlBaseParser.ValueExpressionDefaultContext && (parentCtx = parentCtx.getParent()) != null && parentCtx instanceof SqlBaseParser.ArithmeticUnaryContext && ((SqlBaseParser.ArithmeticUnaryContext)parentCtx).MINUS() != null) {
                    return ExpressionBuilder.source(parentCtx);
                }
            } else if (parentCtx instanceof SqlBaseParser.IntervalContext) {
                SqlBaseParser.IntervalContext ic = (SqlBaseParser.IntervalContext)parentCtx;
                if (ic.sign != null && ic.sign.getType() == 109) {
                    return ExpressionBuilder.source(ic);
                }
            } else if (parentCtx instanceof SqlBaseParser.SysTypesContext && ((SqlBaseParser.SysTypesContext)parentCtx).MINUS() != null) {
                return ExpressionBuilder.source(parentCtx);
            }
        }
        return null;
    }
}

