/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketscript;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketscript.BucketScriptPipelineAggregator;

public class BucketScriptPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<BucketScriptPipelineAggregationBuilder> {
    public static final String NAME = "bucket_script";
    private final Script script;
    private final Map<String, String> bucketsPathsMap;
    private String format = null;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;

    public BucketScriptPipelineAggregationBuilder(String name, Map<String, String> bucketsPathsMap, Script script) {
        super(name, NAME, new TreeMap<String, String>(bucketsPathsMap).values().toArray(new String[bucketsPathsMap.size()]));
        this.bucketsPathsMap = bucketsPathsMap;
        this.script = script;
    }

    public BucketScriptPipelineAggregationBuilder(String name, Script script, String ... bucketsPaths) {
        this(name, BucketScriptPipelineAggregationBuilder.convertToBucketsPathMap(bucketsPaths), script);
    }

    public BucketScriptPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        int mapSize = in.readVInt();
        this.bucketsPathsMap = new HashMap<String, String>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            this.bucketsPathsMap.put(in.readString(), in.readString());
        }
        this.script = new Script(in);
        this.format = in.readOptionalString();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.bucketsPathsMap.size());
        for (Map.Entry<String, String> e : this.bucketsPathsMap.entrySet()) {
            out.writeString(e.getKey());
            out.writeString(e.getValue());
        }
        this.script.writeTo(out);
        out.writeOptionalString(this.format);
        this.gapPolicy.writeTo(out);
    }

    private static Map<String, String> convertToBucketsPathMap(String[] bucketsPaths) {
        HashMap<String, String> bucketsPathsMap = new HashMap<String, String>();
        for (int i = 0; i < bucketsPaths.length; ++i) {
            bucketsPathsMap.put("_value" + i, bucketsPaths[i]);
        }
        return bucketsPathsMap;
    }

    public BucketScriptPipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    public BucketScriptPipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[gapPolicy] must not be null: [" + this.name + "]");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
        return new BucketScriptPipelineAggregator(this.name, this.bucketsPathsMap, this.script, this.formatter(), this.gapPolicy, metaData);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName(), this.bucketsPathsMap);
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), this.script);
        if (this.format != null) {
            builder.field(PipelineAggregator.Parser.FORMAT.getPreferredName(), this.format);
        }
        builder.field(PipelineAggregator.Parser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        return builder;
    }

    public static BucketScriptPipelineAggregationBuilder parse(String reducerName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        Script script = null;
        String currentFieldName = null;
        HashMap<String, String> bucketsPathsMap = null;
        String format = null;
        BucketHelpers.GapPolicy gapPolicy = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (PipelineAggregator.Parser.FORMAT.match(currentFieldName, parser.getDeprecationHandler())) {
                    format = parser.text();
                    continue;
                }
                if (PipelineAggregator.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    bucketsPathsMap = new HashMap<String, String>();
                    bucketsPathsMap.put("_value", parser.text());
                    continue;
                }
                if (PipelineAggregator.Parser.GAP_POLICY.match(currentFieldName, parser.getDeprecationHandler())) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(parser.text(), parser.getTokenLocation());
                    continue;
                }
                if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    script = Script.parse(parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (PipelineAggregator.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPathsMap = new HashMap();
                    for (int i = 0; i < paths.size(); ++i) {
                        bucketsPathsMap.put("_value" + i, (String)paths.get(i));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    script = Script.parse(parser);
                    continue;
                }
                if (PipelineAggregator.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    Map<String, Object> map = parser.map();
                    bucketsPathsMap = new HashMap();
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        bucketsPathsMap.put(entry.getKey(), String.valueOf(entry.getValue()));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " in [" + reducerName + "].", new Object[0]);
        }
        if (bucketsPathsMap == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + "] for series_arithmetic aggregation [" + reducerName + "]", new Object[0]);
        }
        if (script == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] for series_arithmetic aggregation [" + reducerName + "]", new Object[0]);
        }
        BucketScriptPipelineAggregationBuilder factory = new BucketScriptPipelineAggregationBuilder(reducerName, bucketsPathsMap, script);
        if (format != null) {
            factory.format(format);
        }
        if (gapPolicy != null) {
            factory.gapPolicy(gapPolicy);
        }
        return factory;
    }

    @Override
    protected boolean overrideBucketsPath() {
        return true;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(new Object[]{this.bucketsPathsMap, this.script, this.format, this.gapPolicy});
    }

    @Override
    protected boolean doEquals(Object obj) {
        BucketScriptPipelineAggregationBuilder other = (BucketScriptPipelineAggregationBuilder)obj;
        return Objects.equals(this.bucketsPathsMap, other.bucketsPathsMap) && Objects.equals(this.script, other.script) && Objects.equals(this.format, other.format) && Objects.equals((Object)this.gapPolicy, (Object)other.gapPolicy);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

