/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.elasticsearch.search.aggregations.bucket.composite.TermsSortedDocsProducer;

class GlobalOrdinalValuesSource
extends SingleDimensionValuesSource<BytesRef> {
    private final CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc;
    private LongArray values;
    private SortedSetDocValues lookup;
    private long currentValue;
    private Long afterValueGlobalOrd;
    private boolean isTopValueInsertionPoint;
    private long lastLookupOrd = -1L;
    private BytesRef lastLookupValue;

    GlobalOrdinalValuesSource(BigArrays bigArrays, MappedFieldType type, CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc, DocValueFormat format, boolean missingBucket, Object missing, int size, int reverseMul) {
        super(bigArrays, format, type, missingBucket, missing, size, reverseMul);
        this.docValuesFunc = docValuesFunc;
        this.values = bigArrays.newLongArray(Math.min(size, 100), false);
    }

    @Override
    void copyCurrent(int slot) {
        this.values = this.bigArrays.grow(this.values, (long)(slot + 1));
        this.values.set(slot, this.currentValue);
    }

    @Override
    int compare(int from, int to) {
        return Long.compare(this.values.get(from), this.values.get(to)) * this.reverseMul;
    }

    @Override
    int compareCurrent(int slot) {
        return Long.compare(this.currentValue, this.values.get(slot)) * this.reverseMul;
    }

    @Override
    int compareCurrentWithAfter() {
        int cmp = Long.compare(this.currentValue, this.afterValueGlobalOrd);
        if (cmp == 0 && this.isTopValueInsertionPoint) {
            return this.reverseMul;
        }
        return cmp * this.reverseMul;
    }

    @Override
    int hashCode(int slot) {
        return Long.hashCode(this.values.get(slot));
    }

    @Override
    int hashCodeCurrent() {
        return Long.hashCode(this.currentValue);
    }

    @Override
    void setAfter(Comparable value) {
        if (this.missingBucket && value == null) {
            this.afterValue = null;
            this.afterValueGlobalOrd = -1L;
        } else if (value.getClass() == String.class) {
            this.afterValue = this.format.parseBytesRef(value.toString());
        } else {
            throw new IllegalArgumentException("invalid value, expected string, got " + value.getClass().getSimpleName());
        }
    }

    @Override
    BytesRef toComparable(int slot) throws IOException {
        long globalOrd = this.values.get(slot);
        if (this.missingBucket && globalOrd == -1L) {
            return null;
        }
        if (globalOrd == this.lastLookupOrd) {
            return this.lastLookupValue;
        }
        this.lastLookupOrd = globalOrd;
        this.lastLookupValue = BytesRef.deepCopyOf(this.lookup.lookupOrd(this.values.get(slot)));
        return this.lastLookupValue;
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedSetDocValues dvs = this.docValuesFunc.apply(context);
        if (this.lookup == null) {
            this.initLookup(dvs);
        }
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    long ord;
                    while ((ord = dvs.nextOrd()) != -1L) {
                        GlobalOrdinalValuesSource.this.currentValue = ord;
                        next.collect(doc, bucket);
                    }
                } else if (GlobalOrdinalValuesSource.this.missingBucket) {
                    GlobalOrdinalValuesSource.this.currentValue = -1L;
                    next.collect(doc, bucket);
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable value, LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        if (value.getClass() != BytesRef.class) {
            throw new IllegalArgumentException("Expected BytesRef, got " + value.getClass());
        }
        final BytesRef term = (BytesRef)value;
        final SortedSetDocValues dvs = this.docValuesFunc.apply(context);
        if (this.lookup == null) {
            this.initLookup(dvs);
        }
        return new LeafBucketCollector(){
            boolean currentValueIsSet = false;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (!this.currentValueIsSet && dvs.advanceExact(doc)) {
                    long ord;
                    while ((ord = dvs.nextOrd()) != -1L) {
                        if (!term.equals(GlobalOrdinalValuesSource.this.lookup.lookupOrd(ord))) continue;
                        this.currentValueIsSet = true;
                        GlobalOrdinalValuesSource.this.currentValue = ord;
                        break;
                    }
                }
                assert (this.currentValueIsSet);
                next.collect(doc, bucket);
            }
        };
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || !(this.fieldType instanceof StringFieldType) || query != null && query.getClass() != MatchAllDocsQuery.class) {
            return null;
        }
        return new TermsSortedDocsProducer(this.fieldType.name());
    }

    @Override
    public void close() {
        Releasables.close(this.values);
    }

    private void initLookup(SortedSetDocValues dvs) throws IOException {
        this.lookup = dvs;
        if (this.afterValue != null && this.afterValueGlobalOrd == null) {
            this.afterValueGlobalOrd = this.lookup.lookupTerm((BytesRef)this.afterValue);
            if (this.afterValueGlobalOrd < 0L) {
                this.afterValueGlobalOrd = -this.afterValueGlobalOrd.longValue() - 1L;
                this.isTopValueInsertionPoint = true;
            }
        }
    }
}

