/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.AbstractBulkIndexByScrollRequest;
import org.elasticsearch.index.reindex.RemoteInfo;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.TaskId;

public class ReindexRequest
extends AbstractBulkIndexByScrollRequest<ReindexRequest>
implements CompositeIndicesRequest,
ToXContentObject {
    private IndexRequest destination;
    private RemoteInfo remoteInfo;

    public ReindexRequest() {
        this(new SearchRequest(), new IndexRequest(), true);
    }

    ReindexRequest(SearchRequest search, IndexRequest destination) {
        this(search, destination, true);
    }

    private ReindexRequest(SearchRequest search, IndexRequest destination, boolean setDefaults) {
        super(search, setDefaults);
        this.destination = destination;
    }

    public ReindexRequest(StreamInput in) throws IOException {
        super.readFrom(in);
        this.destination = new IndexRequest();
        this.destination.readFrom(in);
        this.remoteInfo = in.readOptionalWriteable(RemoteInfo::new);
    }

    @Override
    protected ReindexRequest self() {
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = super.validate();
        if (this.getSearchRequest().indices() == null || this.getSearchRequest().indices().length == 0) {
            e = ValidateActions.addValidationError("use _all if you really want to copy from all existing indexes", e);
        }
        if (this.getSearchRequest().source().fetchSource() != null && !this.getSearchRequest().source().fetchSource().fetchSource()) {
            e = ValidateActions.addValidationError("_source:false is not supported in this context", e);
        }
        if (this.destination.index() == null) {
            e = ValidateActions.addValidationError("index must be specified", e);
            return e;
        }
        if (!this.routingIsValid()) {
            e = ValidateActions.addValidationError("routing must be unset, [keep], [discard] or [=<some new value>]", e);
        }
        if (this.destination.versionType() == VersionType.INTERNAL && this.destination.version() != -3L && this.destination.version() != -4L) {
            e = ValidateActions.addValidationError("unsupported version for internal versioning [" + this.destination.version() + ']', e);
        }
        if (this.getRemoteInfo() != null) {
            if (this.getSearchRequest().source().query() != null) {
                e = ValidateActions.addValidationError("reindex from remote sources should use RemoteInfo's query instead of source's query", e);
            }
            if (this.getSlices() == 0 || this.getSlices() > 1) {
                e = ValidateActions.addValidationError("reindex from remote sources doesn't support slices > 1 but was [" + this.getSlices() + "]", e);
            }
        }
        return e;
    }

    private boolean routingIsValid() {
        if (this.destination.routing() == null || this.destination.routing().startsWith("=")) {
            return true;
        }
        switch (this.destination.routing()) {
            case "keep": 
            case "discard": {
                return true;
            }
        }
        return false;
    }

    public ReindexRequest setSourceIndices(String ... sourceIndices) {
        if (sourceIndices != null) {
            this.getSearchRequest().indices(sourceIndices);
        }
        return this;
    }

    public ReindexRequest setSourceDocTypes(String ... docTypes) {
        if (docTypes != null) {
            this.getSearchRequest().types(docTypes);
        }
        return this;
    }

    public ReindexRequest setSourceBatchSize(int size) {
        this.getSearchRequest().source().size(size);
        return this;
    }

    public ReindexRequest setSourceQuery(QueryBuilder queryBuilder) {
        if (queryBuilder != null) {
            this.getSearchRequest().source().query(queryBuilder);
        }
        return this;
    }

    public ReindexRequest addSortField(String name, SortOrder order) {
        this.getSearchRequest().source().sort(name, order);
        return this;
    }

    public ReindexRequest setDestIndex(String destIndex) {
        if (destIndex != null) {
            this.getDestination().index(destIndex);
        }
        return this;
    }

    public ReindexRequest setDestDocType(String docType) {
        this.getDestination().type(docType);
        return this;
    }

    public ReindexRequest setDestRouting(String routing) {
        this.getDestination().routing(routing);
        return this;
    }

    public ReindexRequest setDestVersionType(VersionType versionType) {
        this.getDestination().versionType(versionType);
        return this;
    }

    public void setDestPipeline(String pipelineName) {
        this.getDestination().setPipeline(pipelineName);
    }

    public ReindexRequest setDestOpType(String opType) {
        this.getDestination().opType(opType);
        return this;
    }

    public ReindexRequest setRemoteInfo(RemoteInfo remoteInfo) {
        this.remoteInfo = remoteInfo;
        return this;
    }

    public IndexRequest getDestination() {
        return this.destination;
    }

    public RemoteInfo getRemoteInfo() {
        return this.remoteInfo;
    }

    @Override
    public ReindexRequest forSlice(TaskId slicingTask, SearchRequest slice, int totalSlices) {
        ReindexRequest sliced = this.doForSlice(new ReindexRequest(slice, this.destination, false), slicingTask, totalSlices);
        sliced.setRemoteInfo(this.remoteInfo);
        return sliced;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.destination.writeTo(out);
        out.writeOptionalWriteable(this.remoteInfo);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("reindex from ");
        if (this.remoteInfo != null) {
            b.append('[').append(this.remoteInfo).append(']');
        }
        this.searchToString(b);
        b.append(" to [").append(this.destination.index()).append(']');
        if (this.destination.type() != null) {
            b.append('[').append(this.destination.type()).append(']');
        }
        return b.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("source");
        if (this.remoteInfo != null) {
            builder.field("remote", this.remoteInfo);
            builder.rawField("query", this.remoteInfo.getQuery().streamInput(), builder.contentType());
        }
        builder.array("index", this.getSearchRequest().indices());
        builder.array("type", this.getSearchRequest().types());
        this.getSearchRequest().source().innerToXContent(builder, params);
        builder.endObject();
        builder.startObject("dest");
        builder.field("index", this.getDestination().index());
        if (this.getDestination().type() != null) {
            builder.field("type", this.getDestination().type());
        }
        if (this.getDestination().routing() != null) {
            builder.field("routing", this.getDestination().routing());
        }
        builder.field("op_type", this.getDestination().opType().getLowercase());
        if (this.getDestination().getPipeline() != null) {
            builder.field("pipeline", this.getDestination().getPipeline());
        }
        builder.field("version_type", VersionType.toString(this.getDestination().versionType()));
        builder.endObject();
        if (this.getSize() != -1 || this.getSize() > 0) {
            builder.field("size", this.getSize());
        }
        if (this.getScript() != null) {
            builder.field("script", this.getScript());
        }
        if (!this.isAbortOnVersionConflict()) {
            builder.field("conflicts", "proceed");
        }
        builder.endObject();
        return builder;
    }
}

