/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.EnumSet;
import java.util.Set;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ArrayUtils;

public abstract class SecureSetting<T>
extends Setting<T> {
    private static final boolean ALLOW_INSECURE_SETTINGS = Booleans.parseBoolean(System.getProperty("es.allow_insecure_settings", "false"));
    private static final Set<Setting.Property> ALLOWED_PROPERTIES = EnumSet.of(Setting.Property.Deprecated);
    private static final Setting.Property[] FIXED_PROPERTIES = new Setting.Property[]{Setting.Property.NodeScope};

    private SecureSetting(String key, Setting.Property ... properties) {
        super(key, (String)null, null, ArrayUtils.concat(properties, FIXED_PROPERTIES, Setting.Property.class));
        assert (this.assertAllowedProperties(properties));
        KeyStoreWrapper.validateSettingName(key);
    }

    private boolean assertAllowedProperties(Setting.Property ... properties) {
        for (Setting.Property property : properties) {
            if (ALLOWED_PROPERTIES.contains((Object)property)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDefaultRaw(Settings settings) {
        throw new UnsupportedOperationException("secure settings are not strings");
    }

    @Override
    public T getDefault(Settings settings) {
        throw new UnsupportedOperationException("secure settings are not strings");
    }

    @Override
    String innerGetRaw(Settings settings) {
        throw new UnsupportedOperationException("secure settings are not strings");
    }

    @Override
    public boolean exists(Settings settings) {
        SecureSettings secureSettings = settings.getSecureSettings();
        return secureSettings != null && secureSettings.getSettingNames().contains(this.getKey());
    }

    @Override
    public T get(Settings settings) {
        this.checkDeprecation(settings);
        SecureSettings secureSettings = settings.getSecureSettings();
        if (secureSettings == null || !secureSettings.getSettingNames().contains(this.getKey())) {
            if (super.exists(settings)) {
                throw new IllegalArgumentException("Setting [" + this.getKey() + "] is a secure setting and must be stored inside the Elasticsearch keystore, but was found inside elasticsearch.yml");
            }
            return this.getFallback(settings);
        }
        try {
            return this.getSecret(secureSettings);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("failed to read secure setting " + this.getKey(), e);
        }
    }

    abstract T getSecret(SecureSettings var1) throws GeneralSecurityException;

    abstract T getFallback(Settings var1);

    @Override
    public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
    }

    public static Setting<SecureString> secureString(String name, Setting<SecureString> fallback, Setting.Property ... properties) {
        return new SecureStringSetting(name, (Setting)fallback, properties);
    }

    public static Setting<SecureString> insecureString(String name) {
        return new InsecureStringSetting(name);
    }

    public static Setting<InputStream> secureFile(String name, Setting<InputStream> fallback, Setting.Property ... properties) {
        return new SecureFileSetting(name, (Setting)fallback, properties);
    }

    private static class SecureFileSetting
    extends SecureSetting<InputStream> {
        private final Setting<InputStream> fallback;

        private SecureFileSetting(String name, Setting<InputStream> fallback, Setting.Property ... properties) {
            super(name, properties);
            this.fallback = fallback;
        }

        @Override
        protected InputStream getSecret(SecureSettings secureSettings) throws GeneralSecurityException {
            return secureSettings.getFile(this.getKey());
        }

        @Override
        InputStream getFallback(Settings settings) {
            if (this.fallback != null) {
                return this.fallback.get(settings);
            }
            return null;
        }
    }

    private static class InsecureStringSetting
    extends Setting<SecureString> {
        private final String name;

        private InsecureStringSetting(String name) {
            super(name, "", SecureString::new, Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope);
            this.name = name;
        }

        @Override
        public SecureString get(Settings settings) {
            if (!ALLOW_INSECURE_SETTINGS && this.exists(settings)) {
                throw new IllegalArgumentException("Setting [" + this.name + "] is insecure, but property [allow_insecure_settings] is not set");
            }
            return (SecureString)super.get(settings);
        }
    }

    private static class SecureStringSetting
    extends SecureSetting<SecureString> {
        private final Setting<SecureString> fallback;

        private SecureStringSetting(String name, Setting<SecureString> fallback, Setting.Property ... properties) {
            super(name, properties);
            this.fallback = fallback;
        }

        @Override
        protected SecureString getSecret(SecureSettings secureSettings) throws GeneralSecurityException {
            return secureSettings.getString(this.getKey());
        }

        @Override
        SecureString getFallback(Settings settings) {
            if (this.fallback != null) {
                return this.fallback.get(settings);
            }
            return new SecureString(new char[0]);
        }
    }
}

