/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.LongConsumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;

public class Lucene {
    public static final String LATEST_DOC_VALUES_FORMAT = "Lucene70";
    public static final String LATEST_POSTINGS_FORMAT = "Lucene50";
    public static final String LATEST_CODEC = "Lucene70";
    public static final String SOFT_DELETES_FIELD = "__soft_deletes";
    public static final NamedAnalyzer STANDARD_ANALYZER;
    public static final NamedAnalyzer KEYWORD_ANALYZER;
    public static final ScoreDoc[] EMPTY_SCORE_DOCS;
    public static final TopDocs EMPTY_TOP_DOCS;
    private static final Class<?> GEO_DISTANCE_SORT_TYPE_CLASS;

    private Lucene() {
    }

    public static Version parseVersion(@Nullable String version, Version defaultVersion, Logger logger) {
        if (version == null) {
            return defaultVersion;
        }
        try {
            return Version.parse(version);
        }
        catch (ParseException e) {
            logger.warn(() -> new ParameterizedMessage("no version match {}, default to {}", (Object)version, (Object)defaultVersion), (Throwable)e);
            return defaultVersion;
        }
    }

    public static SegmentInfos readSegmentInfos(Directory directory) throws IOException {
        return SegmentInfos.readLatestCommit(directory);
    }

    public static Iterable<String> files(SegmentInfos infos) throws IOException {
        ArrayList<Collection<String>> list = new ArrayList<Collection<String>>();
        list.add(Collections.singleton(infos.getSegmentsFileName()));
        for (SegmentCommitInfo info : infos) {
            list.add(info.files());
        }
        return Iterables.flatten(list);
    }

    public static int getNumDocs(SegmentInfos info) {
        int numDocs = 0;
        for (SegmentCommitInfo si : info) {
            numDocs += si.info.maxDoc() - si.getDelCount() - si.getSoftDelCount();
        }
        return numDocs;
    }

    public static SegmentInfos readSegmentInfos(IndexCommit commit) throws IOException {
        String filename = IndexFileNames.fileNameFromGeneration("segments", "", commit.getGeneration());
        return SegmentInfos.readCommit(commit.getDirectory(), filename);
    }

    private static SegmentInfos readSegmentInfos(String segmentsFileName, Directory directory) throws IOException {
        return SegmentInfos.readCommit(directory, segmentsFileName);
    }

    public static SegmentInfos pruneUnreferencedFiles(String segmentsFileName, Directory directory) throws IOException {
        SegmentInfos si = Lucene.readSegmentInfos(segmentsFileName, directory);
        try (Lock writeLock = directory.obtainLock("write.lock");){
            int foundSegmentFiles = 0;
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments") && !file.equals("segments.gen")) continue;
                ++foundSegmentFiles;
                if (file.equals(si.getSegmentsFileName())) continue;
                directory.deleteFile(file);
            }
            assert (SegmentInfos.getLastCommitSegmentsFileName(directory).equals(segmentsFileName));
            if (foundSegmentFiles == 0) {
                throw new IllegalStateException("no commit found in the directory");
            }
        }
        IndexCommit cp = Lucene.getIndexCommit(si, directory);
        IndexWriter writer = new IndexWriter(directory, new IndexWriterConfig(STANDARD_ANALYZER).setSoftDeletesField(SOFT_DELETES_FIELD).setIndexCommit(cp).setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.APPEND));
        writer.close();
        return si;
    }

    public static IndexCommit getIndexCommit(SegmentInfos si, Directory directory) throws IOException {
        return new CommitPoint(si, directory);
    }

    public static void cleanLuceneIndex(Directory directory) throws IOException {
        try (Lock writeLock = directory.obtainLock("write.lock");){
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments") && !file.equals("segments.gen")) continue;
                directory.deleteFile(file);
            }
        }
        IndexWriter writer = new IndexWriter(directory, new IndexWriterConfig(STANDARD_ANALYZER).setSoftDeletesField(SOFT_DELETES_FIELD).setMergePolicy(NoMergePolicy.INSTANCE).setCommitOnClose(false).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        writer.close();
    }

    public static void checkSegmentInfoIntegrity(final Directory directory) throws IOException {
        new SegmentInfos.FindSegmentsFile(directory){

            protected Object doBody(String segmentFileName) throws IOException {
                try (IndexInput input = directory.openInput(segmentFileName, IOContext.READ);){
                    CodecUtil.checksumEntireFile(input);
                }
                return null;
            }
        }.run();
    }

    public static boolean exists(IndexSearcher searcher, Query query) throws IOException {
        Weight weight = searcher.createNormalizedWeight(query, false);
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            Scorer scorer = weight.scorer(context);
            if (scorer == null) continue;
            Bits liveDocs = context.reader().getLiveDocs();
            DocIdSetIterator iterator = scorer.iterator();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(doc)) {
                    return true;
                }
                doc = iterator.nextDoc();
            }
        }
        return false;
    }

    public static TopDocs readTopDocs(StreamInput in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            long totalHits = in.readVLong();
            float maxScore = in.readFloat();
            ScoreDoc[] scoreDocs = new ScoreDoc[in.readVInt()];
            for (int i = 0; i < scoreDocs.length; ++i) {
                scoreDocs[i] = new ScoreDoc(in.readVInt(), in.readFloat());
            }
            return new TopDocs(totalHits, scoreDocs, maxScore);
        }
        if (type == 1) {
            long totalHits = in.readVLong();
            float maxScore = in.readFloat();
            SortField[] fields = in.readArray(Lucene::readSortField, SortField[]::new);
            ScoreDoc[] fieldDocs = new FieldDoc[in.readVInt()];
            for (int i = 0; i < fieldDocs.length; ++i) {
                fieldDocs[i] = Lucene.readFieldDoc(in);
            }
            return new TopFieldDocs(totalHits, fieldDocs, fields, maxScore);
        }
        if (type == 2) {
            long totalHits = in.readVLong();
            float maxScore = in.readFloat();
            String field = in.readString();
            SortField[] fields = in.readArray(Lucene::readSortField, SortField[]::new);
            int size = in.readVInt();
            Object[] collapseValues = new Object[size];
            ScoreDoc[] fieldDocs = new FieldDoc[size];
            for (int i = 0; i < fieldDocs.length; ++i) {
                fieldDocs[i] = Lucene.readFieldDoc(in);
                collapseValues[i] = Lucene.readSortValue(in);
            }
            return new CollapseTopFieldDocs(field, totalHits, fieldDocs, fields, collapseValues, maxScore);
        }
        throw new IllegalStateException("Unknown type " + type);
    }

    public static FieldDoc readFieldDoc(StreamInput in) throws IOException {
        Object[] cFields = new Comparable[in.readVInt()];
        for (int j = 0; j < cFields.length; ++j) {
            byte type = in.readByte();
            if (type == 0) {
                cFields[j] = null;
                continue;
            }
            if (type == 1) {
                cFields[j] = in.readString();
                continue;
            }
            if (type == 2) {
                cFields[j] = in.readInt();
                continue;
            }
            if (type == 3) {
                cFields[j] = in.readLong();
                continue;
            }
            if (type == 4) {
                cFields[j] = Float.valueOf(in.readFloat());
                continue;
            }
            if (type == 5) {
                cFields[j] = in.readDouble();
                continue;
            }
            if (type == 6) {
                cFields[j] = in.readByte();
                continue;
            }
            if (type == 7) {
                cFields[j] = in.readShort();
                continue;
            }
            if (type == 8) {
                cFields[j] = in.readBoolean();
                continue;
            }
            if (type == 9) {
                cFields[j] = in.readBytesRef();
                continue;
            }
            throw new IOException("Can't match type [" + type + "]");
        }
        return new FieldDoc(in.readVInt(), in.readFloat(), cFields);
    }

    public static Comparable readSortValue(StreamInput in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return in.readString();
        }
        if (type == 2) {
            return Integer.valueOf(in.readInt());
        }
        if (type == 3) {
            return Long.valueOf(in.readLong());
        }
        if (type == 4) {
            return Float.valueOf(in.readFloat());
        }
        if (type == 5) {
            return Double.valueOf(in.readDouble());
        }
        if (type == 6) {
            return Byte.valueOf(in.readByte());
        }
        if (type == 7) {
            return Short.valueOf(in.readShort());
        }
        if (type == 8) {
            return Boolean.valueOf(in.readBoolean());
        }
        if (type == 9) {
            return in.readBytesRef();
        }
        throw new IOException("Can't match type [" + type + "]");
    }

    public static ScoreDoc readScoreDoc(StreamInput in) throws IOException {
        return new ScoreDoc(in.readVInt(), in.readFloat());
    }

    public static void writeTopDocs(StreamOutput out, TopDocs topDocs) throws IOException {
        if (topDocs instanceof CollapseTopFieldDocs) {
            out.writeByte((byte)2);
            CollapseTopFieldDocs collapseDocs = (CollapseTopFieldDocs)topDocs;
            out.writeVLong(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeString(collapseDocs.field);
            out.writeArray(Lucene::writeSortField, collapseDocs.fields);
            out.writeVInt(topDocs.scoreDocs.length);
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                ScoreDoc doc = collapseDocs.scoreDocs[i];
                Lucene.writeFieldDoc(out, (FieldDoc)doc);
                Lucene.writeSortValue(out, collapseDocs.collapseValues[i]);
            }
        } else if (topDocs instanceof TopFieldDocs) {
            out.writeByte((byte)1);
            TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs;
            out.writeVLong(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeArray(Lucene::writeSortField, topFieldDocs.fields);
            out.writeVInt(topDocs.scoreDocs.length);
            for (ScoreDoc doc : topFieldDocs.scoreDocs) {
                Lucene.writeFieldDoc(out, (FieldDoc)doc);
            }
        } else {
            out.writeByte((byte)0);
            out.writeVLong(topDocs.totalHits);
            out.writeFloat(topDocs.getMaxScore());
            out.writeVInt(topDocs.scoreDocs.length);
            for (ScoreDoc doc : topDocs.scoreDocs) {
                Lucene.writeScoreDoc(out, doc);
            }
        }
    }

    private static void writeMissingValue(StreamOutput out, Object missingValue) throws IOException {
        if (missingValue == SortField.STRING_FIRST) {
            out.writeByte((byte)1);
        } else if (missingValue == SortField.STRING_LAST) {
            out.writeByte((byte)2);
        } else {
            out.writeByte((byte)0);
            out.writeGenericValue(missingValue);
        }
    }

    private static Object readMissingValue(StreamInput in) throws IOException {
        byte id = in.readByte();
        switch (id) {
            case 0: {
                return in.readGenericValue();
            }
            case 1: {
                return SortField.STRING_FIRST;
            }
            case 2: {
                return SortField.STRING_LAST;
            }
        }
        throw new IOException("Unknown missing value id: " + id);
    }

    public static void writeSortValue(StreamOutput out, Object field) throws IOException {
        if (field == null) {
            out.writeByte((byte)0);
        } else {
            Class<?> type = field.getClass();
            if (type == String.class) {
                out.writeByte((byte)1);
                out.writeString((String)field);
            } else if (type == Integer.class) {
                out.writeByte((byte)2);
                out.writeInt((Integer)field);
            } else if (type == Long.class) {
                out.writeByte((byte)3);
                out.writeLong((Long)field);
            } else if (type == Float.class) {
                out.writeByte((byte)4);
                out.writeFloat(((Float)field).floatValue());
            } else if (type == Double.class) {
                out.writeByte((byte)5);
                out.writeDouble((Double)field);
            } else if (type == Byte.class) {
                out.writeByte((byte)6);
                out.writeByte((Byte)field);
            } else if (type == Short.class) {
                out.writeByte((byte)7);
                out.writeShort((Short)field);
            } else if (type == Boolean.class) {
                out.writeByte((byte)8);
                out.writeBoolean((Boolean)field);
            } else if (type == BytesRef.class) {
                out.writeByte((byte)9);
                out.writeBytesRef((BytesRef)field);
            } else {
                throw new IOException("Can't handle sort field value of type [" + type + "]");
            }
        }
    }

    public static void writeFieldDoc(StreamOutput out, FieldDoc fieldDoc) throws IOException {
        out.writeVInt(fieldDoc.fields.length);
        for (Object field : fieldDoc.fields) {
            Lucene.writeSortValue(out, field);
        }
        out.writeVInt(fieldDoc.doc);
        out.writeFloat(fieldDoc.score);
    }

    public static void writeScoreDoc(StreamOutput out, ScoreDoc scoreDoc) throws IOException {
        if (!scoreDoc.getClass().equals(ScoreDoc.class)) {
            throw new IllegalArgumentException("This method can only be used to serialize a ScoreDoc, not a " + scoreDoc.getClass());
        }
        out.writeVInt(scoreDoc.doc);
        out.writeFloat(scoreDoc.score);
    }

    public static SortField.Type readSortType(StreamInput in) throws IOException {
        return SortField.Type.values()[in.readVInt()];
    }

    public static SortField readSortField(StreamInput in) throws IOException {
        String field = null;
        if (in.readBoolean()) {
            field = in.readString();
        }
        SortField.Type sortType = Lucene.readSortType(in);
        Object missingValue = Lucene.readMissingValue(in);
        boolean reverse = in.readBoolean();
        SortField sortField = new SortField(field, sortType, reverse);
        if (missingValue != null) {
            sortField.setMissingValue(missingValue);
        }
        return sortField;
    }

    public static void writeSortType(StreamOutput out, SortField.Type sortType) throws IOException {
        out.writeVInt(sortType.ordinal());
    }

    public static void writeSortField(StreamOutput out, SortField sortField) throws IOException {
        SortField newSortField;
        if (sortField.getClass() == GEO_DISTANCE_SORT_TYPE_CLASS) {
            newSortField = new SortField(sortField.getField(), SortField.Type.DOUBLE);
            newSortField.setMissingValue(sortField.getMissingValue());
            sortField = newSortField;
        } else if (sortField.getClass() == SortedSetSortField.class) {
            newSortField = new SortField(sortField.getField(), SortField.Type.STRING, sortField.getReverse());
            newSortField.setMissingValue(sortField.getMissingValue());
            sortField = newSortField;
        } else if (sortField.getClass() == SortedNumericSortField.class) {
            newSortField = new SortField(sortField.getField(), ((SortedNumericSortField)sortField).getNumericType(), sortField.getReverse());
            newSortField.setMissingValue(sortField.getMissingValue());
            sortField = newSortField;
        }
        if (sortField.getClass() != SortField.class) {
            throw new IllegalArgumentException("Cannot serialize SortField impl [" + sortField + "]");
        }
        if (sortField.getField() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(sortField.getField());
        }
        if (sortField.getComparatorSource() != null) {
            IndexFieldData.XFieldComparatorSource comparatorSource = (IndexFieldData.XFieldComparatorSource)sortField.getComparatorSource();
            Lucene.writeSortType(out, comparatorSource.reducedType());
            Lucene.writeMissingValue(out, comparatorSource.missingValue(sortField.getReverse()));
        } else {
            Lucene.writeSortType(out, sortField.getType());
            Lucene.writeMissingValue(out, sortField.getMissingValue());
        }
        out.writeBoolean(sortField.getReverse());
    }

    public static Explanation readExplanation(StreamInput in) throws IOException {
        boolean match = in.readBoolean();
        String description = in.readString();
        Explanation[] subExplanations = new Explanation[in.readVInt()];
        for (int i = 0; i < subExplanations.length; ++i) {
            subExplanations[i] = Lucene.readExplanation(in);
        }
        if (match) {
            return Explanation.match(in.readFloat(), description, subExplanations);
        }
        return Explanation.noMatch(description, subExplanations);
    }

    public static void writeExplanation(StreamOutput out, Explanation explanation) throws IOException {
        out.writeBoolean(explanation.isMatch());
        out.writeString(explanation.getDescription());
        Explanation[] subExplanations = explanation.getDetails();
        out.writeVInt(subExplanations.length);
        for (Explanation subExp : subExplanations) {
            Lucene.writeExplanation(out, subExp);
        }
        if (explanation.isMatch()) {
            out.writeFloat(explanation.getValue());
        }
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return DirectoryReader.indexExists(directory);
    }

    public static boolean waitForIndex(Directory directory, long timeLimitMillis) throws IOException {
        long DELAY = 1000L;
        try {
            for (long waited = 0L; waited < timeLimitMillis; waited += 1000L) {
                if (Lucene.indexExists(directory)) {
                    return true;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return Lucene.indexExists(directory);
    }

    public static boolean isCorruptionException(Throwable t) {
        return ExceptionsHelper.unwrapCorruption(t) != null;
    }

    public static Version parseVersionLenient(String toParse, Version defaultValue) {
        return LenientParser.parse(toParse, defaultValue);
    }

    public static SegmentReader segmentReader(LeafReader reader) {
        if (reader instanceof SegmentReader) {
            return (SegmentReader)reader;
        }
        if (reader instanceof FilterLeafReader) {
            FilterLeafReader fReader = (FilterLeafReader)reader;
            return Lucene.segmentReader(FilterLeafReader.unwrap(fReader));
        }
        if (reader instanceof FilterCodecReader) {
            FilterCodecReader fReader = (FilterCodecReader)reader;
            return Lucene.segmentReader(FilterCodecReader.unwrap(fReader));
        }
        throw new IllegalStateException("Can not extract segment reader from given index reader [" + reader + "]");
    }

    public static Scorer illegalScorer(final String message) {
        return new Scorer(null){

            @Override
            public float score() throws IOException {
                throw new IllegalStateException(message);
            }

            @Override
            public int docID() {
                throw new IllegalStateException(message);
            }

            @Override
            public DocIdSetIterator iterator() {
                throw new IllegalStateException(message);
            }
        };
    }

    public static Bits asSequentialAccessBits(final int maxDoc, @Nullable ScorerSupplier scorerSupplier) throws IOException {
        if (scorerSupplier == null) {
            return new Bits.MatchNoBits(maxDoc);
        }
        Scorer scorer = scorerSupplier.get(Long.MAX_VALUE);
        final TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
        final DocIdSetIterator iterator = twoPhase == null ? scorer.iterator() : twoPhase.approximation();
        return new Bits(){
            int previous = -1;
            boolean previousMatched = false;

            @Override
            public boolean get(int index) {
                if (index < 0 || index >= maxDoc) {
                    throw new IndexOutOfBoundsException(index + " is out of bounds: [" + 0 + "-" + maxDoc + "[");
                }
                if (index < this.previous) {
                    throw new IllegalArgumentException("This Bits instance can only be consumed in order. Got called on [" + index + "] while previously called on [" + this.previous + "]");
                }
                if (index == this.previous) {
                    return this.previousMatched;
                }
                this.previous = index;
                int doc = iterator.docID();
                if (doc < index) {
                    try {
                        doc = iterator.advance(index);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot advance iterator", e);
                    }
                }
                if (index == doc) {
                    try {
                        this.previousMatched = twoPhase == null || twoPhase.matches();
                        return this.previousMatched;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot validate match", e);
                    }
                }
                this.previousMatched = false;
                return false;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
    }

    public static DirectoryReader wrapAllDocsLive(DirectoryReader in) throws IOException {
        return new DirectoryReaderWithAllLiveDocs(in);
    }

    private static int popCount(Bits bits) {
        assert (bits != null);
        int onBits = 0;
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            ++onBits;
        }
        return onBits;
    }

    public static NumericDocValuesField newSoftDeletesField() {
        return new NumericDocValuesField(SOFT_DELETES_FIELD, 1L);
    }

    public static LeafReader emptyReader(final int maxDoc) {
        return new LeafReader(){
            final Bits liveDocs;
            {
                this.liveDocs = new Bits.MatchNoBits(maxDoc);
            }

            @Override
            public Terms terms(String field) {
                return null;
            }

            @Override
            public NumericDocValues getNumericDocValues(String field) {
                return null;
            }

            @Override
            public BinaryDocValues getBinaryDocValues(String field) {
                return null;
            }

            @Override
            public SortedDocValues getSortedDocValues(String field) {
                return null;
            }

            @Override
            public SortedNumericDocValues getSortedNumericDocValues(String field) {
                return null;
            }

            @Override
            public SortedSetDocValues getSortedSetDocValues(String field) {
                return null;
            }

            @Override
            public NumericDocValues getNormValues(String field) {
                return null;
            }

            @Override
            public FieldInfos getFieldInfos() {
                return new FieldInfos(new FieldInfo[0]);
            }

            @Override
            public Bits getLiveDocs() {
                return this.liveDocs;
            }

            @Override
            public PointValues getPointValues(String fieldName) {
                return null;
            }

            @Override
            public void checkIntegrity() {
            }

            @Override
            public Fields getTermVectors(int docID) {
                return null;
            }

            @Override
            public int numDocs() {
                return 0;
            }

            @Override
            public int maxDoc() {
                return maxDoc;
            }

            @Override
            public void document(int docID, StoredFieldVisitor visitor) {
            }

            @Override
            protected void doClose() {
            }

            @Override
            public LeafMetaData getMetaData() {
                return new LeafMetaData(Version.LATEST.major, Version.LATEST, null);
            }

            @Override
            public IndexReader.CacheHelper getCoreCacheHelper() {
                return null;
            }

            @Override
            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
    }

    public static void scanSeqNosInReader(DirectoryReader directoryReader, long fromSeqNo, long toSeqNo, LongConsumer onNewSeqNo) throws IOException {
        DirectoryReader reader = Lucene.wrapAllDocsLive(directoryReader);
        IndexSearcher searcher = new IndexSearcher(reader);
        searcher.setQueryCache(null);
        Query query = LongPoint.newRangeQuery("_seq_no", fromSeqNo, toSeqNo);
        Weight weight = searcher.createWeight(query, false, 1.0f);
        for (LeafReaderContext leaf : reader.leaves()) {
            int docId;
            Scorer scorer = weight.scorer(leaf);
            if (scorer == null) continue;
            DocIdSetIterator docIdSetIterator = scorer.iterator();
            NumericDocValues seqNoDocValues = leaf.reader().getNumericDocValues("_seq_no");
            while ((docId = docIdSetIterator.nextDoc()) != Integer.MAX_VALUE) {
                if (seqNoDocValues == null || !seqNoDocValues.advanceExact(docId)) {
                    throw new IllegalStateException("seq_no doc_values not found for doc_id=" + docId);
                }
                long seqNo = seqNoDocValues.longValue();
                assert (fromSeqNo <= seqNo && seqNo <= toSeqNo) : "from_seq_no=" + fromSeqNo + " seq_no=" + seqNo + " to_seq_no=" + toSeqNo;
                onNewSeqNo.accept(seqNo);
            }
        }
    }

    static {
        Deprecated annotation = PostingsFormat.forName(LATEST_POSTINGS_FORMAT).getClass().getAnnotation(Deprecated.class);
        assert (annotation == null) : "PostingsFromat Lucene50 is deprecated";
        annotation = DocValuesFormat.forName("Lucene70").getClass().getAnnotation(Deprecated.class);
        assert (annotation == null) : "DocValuesFormat Lucene70 is deprecated";
        STANDARD_ANALYZER = new NamedAnalyzer("_standard", AnalyzerScope.GLOBAL, new StandardAnalyzer());
        KEYWORD_ANALYZER = new NamedAnalyzer("_keyword", AnalyzerScope.GLOBAL, (Analyzer)new KeywordAnalyzer());
        EMPTY_SCORE_DOCS = new ScoreDoc[0];
        EMPTY_TOP_DOCS = new TopDocs(0L, EMPTY_SCORE_DOCS, 0.0f);
        GEO_DISTANCE_SORT_TYPE_CLASS = LatLonDocValuesField.newDistanceSort("some_geo_field", 0.0, 0.0).getClass();
    }

    private static final class DirectoryReaderWithAllLiveDocs
    extends FilterDirectoryReader {
        DirectoryReaderWithAllLiveDocs(DirectoryReader in) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                @Override
                public LeafReader wrap(LeafReader leaf) {
                    SegmentReader segmentReader = Lucene.segmentReader(leaf);
                    Bits hardLiveDocs = segmentReader.getHardLiveDocs();
                    if (hardLiveDocs == null) {
                        return new LeafReaderWithLiveDocs(leaf, null, leaf.maxDoc());
                    }
                    int numDocs = segmentReader.maxDoc() - segmentReader.getSegmentInfo().getDelCount();
                    assert (numDocs == Lucene.popCount(hardLiveDocs)) : numDocs + " != " + Lucene.access$100(hardLiveDocs);
                    return new LeafReaderWithLiveDocs(segmentReader, hardLiveDocs, numDocs);
                }
            });
        }

        @Override
        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return Lucene.wrapAllDocsLive(in);
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        static final class LeafReaderWithLiveDocs
        extends FilterLeafReader {
            final Bits liveDocs;
            final int numDocs;

            LeafReaderWithLiveDocs(LeafReader in, Bits liveDocs, int numDocs) {
                super(in);
                this.liveDocs = liveDocs;
                this.numDocs = numDocs;
            }

            @Override
            public Bits getLiveDocs() {
                return this.liveDocs;
            }

            @Override
            public int numDocs() {
                return this.numDocs;
            }

            @Override
            public IndexReader.CacheHelper getCoreCacheHelper() {
                return this.in.getCoreCacheHelper();
            }

            @Override
            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        }
    }

    private static final class CommitPoint
    extends IndexCommit {
        private String segmentsFileName;
        private final Collection<String> files;
        private final Directory dir;
        private final long generation;
        private final Map<String, String> userData;
        private final int segmentCount;

        private CommitPoint(SegmentInfos infos, Directory dir) throws IOException {
            this.segmentsFileName = infos.getSegmentsFileName();
            this.dir = dir;
            this.userData = infos.getUserData();
            this.files = Collections.unmodifiableCollection(infos.files(true));
            this.generation = infos.getGeneration();
            this.segmentCount = infos.size();
        }

        public String toString() {
            return "DirectoryReader.ReaderCommit(" + this.segmentsFileName + ")";
        }

        @Override
        public int getSegmentCount() {
            return this.segmentCount;
        }

        @Override
        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        @Override
        public Collection<String> getFileNames() {
            return this.files;
        }

        @Override
        public Directory getDirectory() {
            return this.dir;
        }

        @Override
        public long getGeneration() {
            return this.generation;
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public Map<String, String> getUserData() {
            return this.userData;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }
    }

    @SuppressForbidden(reason="Version#parseLeniently() used in a central place")
    private static final class LenientParser {
        private LenientParser() {
        }

        public static Version parse(String toParse, Version defaultValue) {
            if (Strings.hasLength(toParse)) {
                try {
                    return Version.parseLeniently(toParse);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }
    }
}

