/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapChecks;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.bootstrap.BootstrapException;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.BootstrapSettings;
import org.elasticsearch.bootstrap.ConsoleCtrlHandler;
import org.elasticsearch.bootstrap.ElasticsearchUncaughtExceptionHandler;
import org.elasticsearch.bootstrap.JNAKernel32Library;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.bootstrap.Natives;
import org.elasticsearch.bootstrap.Security;
import org.elasticsearch.bootstrap.Spawner;
import org.elasticsearch.bootstrap.StartupException;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.PidFile;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.IfConfig;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;

final class Bootstrap {
    private static volatile Bootstrap INSTANCE;
    private volatile Node node;
    private final CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private final Thread keepAliveThread;
    private final Spawner spawner = new Spawner();

    Bootstrap() {
        this.keepAliveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Bootstrap.this.keepAliveLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "elasticsearch[keepAlive/" + Version.CURRENT + "]");
        this.keepAliveThread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Bootstrap.this.keepAliveLatch.countDown();
            }
        });
    }

    public static void initializeNatives(Path tmpFile, boolean mlockAll, boolean systemCallFilter, boolean ctrlHandler) {
        final Logger logger = LogManager.getLogger(Bootstrap.class);
        if (Natives.definitelyRunningAsRoot()) {
            throw new RuntimeException("can not run elasticsearch as root");
        }
        if (systemCallFilter) {
            Natives.tryInstallSystemCallFilter(tmpFile);
        }
        if (mlockAll) {
            if (Constants.WINDOWS) {
                Natives.tryVirtualLock();
            } else {
                Natives.tryMlockall();
            }
        }
        if (ctrlHandler) {
            Natives.addConsoleCtrlHandler(new ConsoleCtrlHandler(){

                @Override
                public boolean handle(int code) {
                    if (2 == code) {
                        logger.info("running graceful exit on windows");
                        try {
                            Bootstrap.stop();
                        }
                        catch (IOException e) {
                            throw new ElasticsearchException("failed to stop node", (Throwable)e, new Object[0]);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        try {
            JNAKernel32Library.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Natives.trySetMaxNumberOfThreads();
        Natives.trySetMaxSizeVirtualMemory();
        Natives.trySetMaxFileSize();
        StringHelper.randomId();
    }

    static void initializeProbes() {
        ProcessProbe.getInstance();
        OsProbe.getInstance();
        JvmInfo.jvmInfo();
    }

    private void setup(boolean addShutdownHook, Environment environment) throws BootstrapException {
        Settings settings = environment.settings();
        try {
            this.spawner.spawnNativeControllers(environment);
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        Bootstrap.initializeNatives(environment.tmpFile(), BootstrapSettings.MEMORY_LOCK_SETTING.get(settings), BootstrapSettings.SYSTEM_CALL_FILTER_SETTING.get(settings), BootstrapSettings.CTRLHANDLER_SETTING.get(settings));
        Bootstrap.initializeProbes();
        if (addShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        IOUtils.close(Bootstrap.this.node, Bootstrap.this.spawner);
                        LoggerContext context = (LoggerContext)LogManager.getContext(false);
                        Configurator.shutdown(context);
                    }
                    catch (IOException ex) {
                        throw new ElasticsearchException("failed to stop node", (Throwable)ex, new Object[0]);
                    }
                }
            });
        }
        try {
            Logger logger = LogManager.getLogger(JarHell.class);
            JarHell.checkJarHell(logger::debug);
        }
        catch (IOException | URISyntaxException e) {
            throw new BootstrapException(e);
        }
        IfConfig.logIfNecessary();
        try {
            Security.configure(environment, BootstrapSettings.SECURITY_FILTER_BAD_DEFAULTS_SETTING.get(settings));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new BootstrapException(e);
        }
        this.node = new Node(environment){

            @Override
            protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> checks) throws NodeValidationException {
                BootstrapChecks.check(context, boundTransportAddress, checks);
            }

            @Override
            protected void registerDerivedNodeNameWithLogger(String nodeName) {
                LogConfigurator.setNodeName(nodeName);
            }
        };
    }

    static SecureSettings loadSecureSettings(Environment initialEnv) throws BootstrapException {
        KeyStoreWrapper keystore;
        try {
            keystore = KeyStoreWrapper.load(initialEnv.configFile());
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        try {
            if (keystore == null) {
                KeyStoreWrapper keyStoreWrapper = KeyStoreWrapper.create();
                keyStoreWrapper.save(initialEnv.configFile(), new char[0]);
                return keyStoreWrapper;
            }
            keystore.decrypt(new char[0]);
            KeyStoreWrapper.upgrade(keystore, initialEnv.configFile(), new char[0]);
        }
        catch (Exception e) {
            throw new BootstrapException(e);
        }
        return keystore;
    }

    private static Environment createEnvironment(boolean foreground, Path pidFile, SecureSettings secureSettings, Settings initialSettings, Path configPath) {
        Terminal terminal = foreground ? Terminal.DEFAULT : null;
        Settings.Builder builder = Settings.builder();
        if (pidFile != null) {
            builder.put(Environment.PIDFILE_SETTING.getKey(), pidFile);
        }
        builder.put(initialSettings);
        if (secureSettings != null) {
            builder.setSecureSettings(secureSettings);
        }
        return InternalSettingsPreparer.prepareEnvironment(builder.build(), terminal, Collections.emptyMap(), configPath);
    }

    private void start() throws NodeValidationException {
        this.node.start();
        this.keepAliveThread.start();
    }

    static void stop() throws IOException {
        try {
            IOUtils.close(Bootstrap.INSTANCE.node, Bootstrap.INSTANCE.spawner);
        }
        finally {
            Bootstrap.INSTANCE.keepAliveLatch.countDown();
        }
    }

    static void init(boolean foreground, Path pidFile, boolean quiet, Environment initialEnv) throws BootstrapException, NodeValidationException, UserException {
        BootstrapInfo.init();
        INSTANCE = new Bootstrap();
        SecureSettings keystore = Bootstrap.loadSecureSettings(initialEnv);
        Environment environment = Bootstrap.createEnvironment(foreground, pidFile, keystore, initialEnv.settings(), initialEnv.configFile());
        if (Node.NODE_NAME_SETTING.exists(environment.settings())) {
            LogConfigurator.setNodeName(Node.NODE_NAME_SETTING.get(environment.settings()));
        }
        try {
            LogConfigurator.configure(environment);
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        if (environment.pidFile() != null) {
            try {
                PidFile.create(environment.pidFile(), true);
            }
            catch (IOException e) {
                throw new BootstrapException(e);
            }
        }
        boolean closeStandardStreams = !foreground || quiet;
        try {
            if (closeStandardStreams) {
                Logger rootLogger = LogManager.getRootLogger();
                Appender maybeConsoleAppender = Loggers.findAppender(rootLogger, ConsoleAppender.class);
                if (maybeConsoleAppender != null) {
                    Loggers.removeAppender(rootLogger, maybeConsoleAppender);
                }
                Bootstrap.closeSystOut();
            }
            Bootstrap.checkLucene();
            Thread.setDefaultUncaughtExceptionHandler(new ElasticsearchUncaughtExceptionHandler());
            INSTANCE.setup(true, environment);
            try {
                IOUtils.close(keystore);
            }
            catch (IOException e) {
                throw new BootstrapException(e);
            }
            INSTANCE.start();
            if (closeStandardStreams) {
                Bootstrap.closeSysError();
            }
        }
        catch (RuntimeException | NodeValidationException e) {
            Logger rootLogger = LogManager.getRootLogger();
            Appender maybeConsoleAppender = Loggers.findAppender(rootLogger, ConsoleAppender.class);
            if (foreground && maybeConsoleAppender != null) {
                Loggers.removeAppender(rootLogger, maybeConsoleAppender);
            }
            Logger logger = LogManager.getLogger(Bootstrap.class);
            if (e instanceof CreationException) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = null;
                try {
                    ps = new PrintStream((OutputStream)os, false, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                    e.addSuppressed(uee);
                }
                new StartupException(e).printStackTrace(ps);
                ps.flush();
                try {
                    logger.error("Guice Exception: {}", (Object)os.toString("UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                    e.addSuppressed(uee);
                }
            } else if (e instanceof NodeValidationException) {
                logger.error("node validation exception\n{}", (Object)e.getMessage());
            } else {
                logger.error("Exception", (Throwable)e);
            }
            if (foreground && maybeConsoleAppender != null) {
                Loggers.addAppender(rootLogger, maybeConsoleAppender);
            }
            throw e;
        }
    }

    @SuppressForbidden(reason="System#out")
    private static void closeSystOut() {
        System.out.close();
    }

    @SuppressForbidden(reason="System#err")
    private static void closeSysError() {
        System.err.close();
    }

    private static void checkLucene() {
        if (!Version.CURRENT.luceneVersion.equals(org.apache.lucene.util.Version.LATEST)) {
            throw new AssertionError((Object)("Lucene version mismatch this version of Elasticsearch requires lucene version [" + Version.CURRENT.luceneVersion + "]  but the current lucene version is [" + org.apache.lucene.util.Version.LATEST + "]"));
        }
    }
}

