/*
 * SonarQube
 * Copyright (C) 2009-2020 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
/* eslint-disable sonarjs/no-duplicate-string */
import { shallow } from 'enzyme';
import * as React from 'react';
import { SCMPopup, SCMPopupProps } from '../SCMPopup';

it('should render correctly', () => {
  expect(shallowRender()).toMatchSnapshot('default');
  expect(
    shallowRender({ line: { line: 3, scmDate: '2017-01-01', scmRevision: 'bar' } })
  ).toMatchSnapshot('no author');
  expect(
    shallowRender({ line: { line: 3, scmAuthor: 'foo', scmRevision: 'bar' } })
  ).toMatchSnapshot('no date');
  expect(
    shallowRender({ line: { line: 3, scmAuthor: 'foo', scmDate: '2017-01-01' } })
  ).toMatchSnapshot('no revision');
});

function shallowRender(props: Partial<SCMPopupProps> = {}) {
  return shallow(
    <SCMPopup
      line={{ line: 3, scmAuthor: 'foo', scmDate: '2017-01-01', scmRevision: 'bar' }}
      {...props}
    />
  );
}
