/*
 * SonarQube
 * Copyright (C) 2009-2020 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import { shallow } from 'enzyme';
import * as React from 'react';
import { ClearButton } from 'sonar-ui-common/components/controls/buttons';
import { click } from 'sonar-ui-common/helpers/testUtils';
import { IndexationNotificationType } from '../../../../types/indexation';
import IndexationNotificationRenderer, {
  IndexationNotificationRendererProps
} from '../IndexationNotificationRenderer';

it.each([
  [IndexationNotificationType.InProgress, false],
  [IndexationNotificationType.InProgress, true],
  [IndexationNotificationType.InProgressWithFailure, false],
  [IndexationNotificationType.InProgressWithFailure, true],
  [IndexationNotificationType.Completed, false],
  [IndexationNotificationType.Completed, true],
  [IndexationNotificationType.CompletedWithFailure, false],
  [IndexationNotificationType.CompletedWithFailure, true]
])(
  'should render correctly for type=%p & isSystemAdmin=%p',
  (type: IndexationNotificationType, isSystemAdmin: boolean) => {
    expect(shallowRender({ type, isSystemAdmin })).toMatchSnapshot();
  }
);

it('should propagate the dismiss event from completed notification', () => {
  const onDismissCompletedNotification = jest.fn();
  const wrapper = shallowRender({
    type: IndexationNotificationType.Completed,
    onDismissCompletedNotification
  });

  click(wrapper.find(ClearButton));
  expect(onDismissCompletedNotification).toHaveBeenCalled();
});

function shallowRender(props: Partial<IndexationNotificationRendererProps> = {}) {
  return shallow<IndexationNotificationRendererProps>(
    <IndexationNotificationRenderer
      type={IndexationNotificationType.InProgress}
      percentCompleted={25}
      isSystemAdmin={false}
      onDismissCompletedNotification={jest.fn()}
      {...props}
    />
  );
}
