---
title: Documentation
url: /
---

<!-- static -->

[[info]]
| **Welcome to the new SonarQube documentation**  
| If you're already running a SonarQube instance, this documentation is also available within SonarQube itself. Just look under the "?" in the top menu to be sure you're always looking at the right documentation for _your_ version!
<!-- /static -->

[SonarQube](http://www.sonarqube.org/)® is an automatic code review tool to detect bugs, vulnerabilities, and code smells in your code. It can integrate with your existing workflow to enable continuous code inspection across your project branches and pull requests.

Below are a few common scenarios. You can also navigate through and search the full documentation in the left pane.

### I'm new to SonarQube
* [Try out SonarQube ](/setup/get-started-2-minutes/).
* Installing [the Server](/setup/install-server/).

### I need to set up analysis
* [Analyzing Source Code](/analysis/overview/)
* [Branches](/branches/overview/)
* [Pull Requests](/analysis/pull-request/)

### I write code
* Why [new code](/user-guide/clean-as-you-code/) is the most important
* [Concepts](/user-guide/concepts/)
* [Quality Gates](/user-guide/quality-gates/)
* [Issues](/user-guide/issues/)

### I administer a project
* [Project Existence](/project-administration/project-existence/)
* What's [included, excluded](/project-administration/narrowing-the-focus/) from analysis 
* [Webhooks](/project-administration/webhooks/)
* [Project Settings](/project-administration/project-settings/)

### I administer a SonarQube Instance
* [Security](/instance-administration/security/)
* [Notifications](/instance-administration/notifications/)
* [Housekeeping](/instance-administration/housekeeping/)

### I do DevOps
* Installing a [production instance](/setup/install-server/).
* [Upgrading](/setup/upgrading/)
* [Monitoring](/instance-administration/monitoring/)
* [Running a Cluster](/setup/operate-cluster/)

### Stay in touch!
* [Get help in the community](https://www.sonarqube.org/community/)
* [Source code](https://github.com/SonarSource)
* [Issue tracker](https://jira.sonarsource.com/)
