---
title: VB.NET
url: /analysis/languages/vbnet/
---

<!-- static -->
<!-- update_center:vbnet -->
<!-- /static -->


## Language-Specific Properties

Discover and update the VB.NET-specific [properties](/analysis/analysis-parameters/) in: <!-- sonarcloud -->Project <!-- /sonarcloud --> **[Administration > General Settings > VB.NET](/#sonarqube-admin#/admin/settings?category=vb.net)**

### Analyze Generated Code

To analyze tool-generated code (e.g. WCF code generated by `SvcUtil.exe`) for a specific VB.NET project, enable the "Analyze generated code" setting inside **Project > Administration > General Settings > VB.NET**. By default, tool-generated code files are skipped from analysis.

## Known Limitations
Currently an error will be thrown when an issue is raised on a line of code containing the following pattern `\s+error\s*:` (i.e. one or more spaces, the string 'error', zero or more spaces and a ':' ) . This is a well known problem on the Microsoft side (see [issue](https://github.com/dotnet/roslyn/issues/5724/)). In order to work around this problem, our analyzer will skip issues reported on any line where the pattern is detected.


## Related Pages
* [Importing External Issues](/analysis/external-issues/) (VSTest, NUnit, MSTest, xUnit)
* [Test Coverage & Execution](/analysis/coverage/) (Visual Studio Code Coverage, dotCover, OpenCover, Coverlet, NCover 3)
* [SonarScanner for MSBuild](/analysis/scan/sonarscanner-for-msbuild/)
* [SonarScanner for Azure DevOps](/analysis/scan/sonarscanner-for-azure-devops/)
