CREATE TABLE "PROJECTS"(
    "UUID" VARCHAR(40) NOT NULL,
    "KEE" VARCHAR(400) NOT NULL,
    "QUALIFIER" VARCHAR(10) NOT NULL,
    "ORGANIZATION_UUID" VARCHAR(40) NOT NULL,
    "NAME" VARCHAR(2000),
    "DESCRIPTION" VARCHAR(2000),
    "PRIVATE" BOOLEAN NOT NULL,
    "TAGS" VARCHAR(500),
    "CREATED_AT" BIGINT,
    "UPDATED_AT" BIGINT NOT NULL
);
ALTER TABLE "PROJECTS" ADD CONSTRAINT "PK_NEW_PROJECTS" PRIMARY KEY("UUID");
CREATE UNIQUE INDEX "UNIQ_PROJECTS_KEE" ON "PROJECTS"("KEE");
CREATE INDEX "IDX_QUALIFIER" ON "PROJECTS"("QUALIFIER");

CREATE TABLE "WEBHOOKS"(
    "UUID" VARCHAR(40) NOT NULL,
    "ORGANIZATION_UUID" VARCHAR(40),
    "PROJECT_UUID" VARCHAR(40),
    "NAME" VARCHAR(100) NOT NULL,
    "URL" VARCHAR(2000) NOT NULL,
    "SECRET" VARCHAR(200),
    "CREATED_AT" BIGINT NOT NULL,
    "UPDATED_AT" BIGINT
);
ALTER TABLE "WEBHOOKS" ADD CONSTRAINT "PK_WEBHOOKS" PRIMARY KEY("UUID");
CREATE INDEX "ORGANIZATION_WEBHOOK" ON "WEBHOOKS"("ORGANIZATION_UUID");
CREATE INDEX "PROJECT_WEBHOOK" ON "WEBHOOKS"("PROJECT_UUID");
