CREATE TABLE "ALM_SETTINGS"(
    "UUID" VARCHAR(40) NOT NULL,
    "ALM_ID" VARCHAR(40) NOT NULL,
    "KEE" VARCHAR(200) NOT NULL,
    "URL" VARCHAR(2000),
    "APP_ID" VARCHAR(80),
    "PRIVATE_KEY" VARCHAR(2000),
    "PAT" VARCHAR(2000),
    "UPDATED_AT" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL
);
ALTER TABLE "ALM_SETTINGS" ADD CONSTRAINT "PK_ALM_SETTINGS" PRIMARY KEY("UUID");
CREATE UNIQUE INDEX "UNIQ_ALM_SETTINGS" ON "ALM_SETTINGS"("KEE");

CREATE TABLE "PROJECT_ALM_SETTINGS"(
    "UUID" VARCHAR(40) NOT NULL,
    "ALM_SETTING_UUID" VARCHAR(40) NOT NULL,
    "PROJECT_UUID" VARCHAR(50) NOT NULL,
    "ALM_REPO" VARCHAR(256),
    "ALM_SLUG" VARCHAR(256),
    "UPDATED_AT" BIGINT NOT NULL,
    "CREATED_AT" BIGINT NOT NULL,
    "SUMMARY_COMMENT_ENABLED" BOOLEAN
);
ALTER TABLE "PROJECT_ALM_SETTINGS" ADD CONSTRAINT "PK_PROJECT_ALM_SETTINGS" PRIMARY KEY("UUID");
CREATE UNIQUE INDEX "UNIQ_PROJECT_ALM_SETTINGS" ON "PROJECT_ALM_SETTINGS"("PROJECT_UUID");
CREATE INDEX "PROJECT_ALM_SETTINGS_ALM" ON "PROJECT_ALM_SETTINGS"("ALM_SETTING_UUID");
CREATE INDEX "PROJECT_ALM_SETTINGS_SLUG" ON "PROJECT_ALM_SETTINGS"("ALM_SLUG");
