CREATE TABLE ALM_SETTINGS(
    UUID VARCHAR(40) NOT NULL,
    ALM_ID VARCHAR(40) NOT NULL,
    KEE VARCHAR(200) NOT NULL,
    URL VARCHAR(2000),
    APP_ID VARCHAR(80),
    PRIVATE_KEY VARCHAR(2000),
    PAT VARCHAR(2000),
    UPDATED_AT BIGINT NOT NULL,
    CREATED_AT BIGINT NOT NULL
);
ALTER TABLE ALM_SETTINGS ADD CONSTRAINT PK_ALM_SETTINGS PRIMARY KEY(UUID);
CREATE UNIQUE INDEX UNIQ_ALM_SETTINGS ON ALM_SETTINGS(KEE);

CREATE TABLE PROJECT_ALM_SETTINGS(
    UUID VARCHAR(40) NOT NULL,
    ALM_SETTING_UUID VARCHAR(40) NOT NULL,
    PROJECT_UUID VARCHAR(50) NOT NULL,
    ALM_REPO VARCHAR(256),
    ALM_SLUG VARCHAR(256),
    UPDATED_AT BIGINT NOT NULL,
    CREATED_AT BIGINT NOT NULL
);
ALTER TABLE PROJECT_ALM_SETTINGS ADD CONSTRAINT PK_PROJECT_ALM_SETTINGS PRIMARY KEY(UUID);
CREATE UNIQUE INDEX UNIQ_PROJECT_ALM_SETTINGS ON PROJECT_ALM_SETTINGS(PROJECT_UUID);
CREATE INDEX PROJECT_ALM_SETTINGS_ALM ON PROJECT_ALM_SETTINGS(ALM_SETTING_UUID);

CREATE TABLE "PROPERTIES" (
  "ID" INTEGER NOT NULL AUTO_INCREMENT (1,1),
  "PROP_KEY" VARCHAR(512) NOT NULL,
  "RESOURCE_ID" INTEGER,
  "USER_ID" INTEGER,
  "IS_EMPTY" BOOLEAN NOT NULL,
  "TEXT_VALUE" VARCHAR(4000),
  "CLOB_VALUE" CLOB,
  "CREATED_AT" BIGINT
);
CREATE INDEX "PROPERTIES_KEY" ON "PROPERTIES" ("PROP_KEY");

CREATE TABLE PROJECTS(
    "ID" INTEGER NOT NULL AUTO_INCREMENT (1,1),
    UUID VARCHAR(50) NOT NULL,
    ORGANIZATION_UUID VARCHAR(40) NOT NULL,
    KEE VARCHAR(400),
    DEPRECATED_KEE VARCHAR(400),
    NAME VARCHAR(2000),
    LONG_NAME VARCHAR(2000),
    DESCRIPTION VARCHAR(2000),
    ENABLED BOOLEAN DEFAULT TRUE NOT NULL,
    SCOPE VARCHAR(3),
    QUALIFIER VARCHAR(10),
    PRIVATE BOOLEAN NOT NULL,
    ROOT_UUID VARCHAR(50) NOT NULL,
    LANGUAGE VARCHAR(20),
    COPY_COMPONENT_UUID VARCHAR(50),
    DEVELOPER_UUID VARCHAR(50),
    PATH VARCHAR(2000),
    UUID_PATH VARCHAR(1500) NOT NULL,
    PROJECT_UUID VARCHAR(50) NOT NULL,
    MODULE_UUID VARCHAR(50),
    MODULE_UUID_PATH VARCHAR(1500),
    AUTHORIZATION_UPDATED_AT BIGINT,
    TAGS VARCHAR(500),
    MAIN_BRANCH_PROJECT_UUID VARCHAR(50),
    B_CHANGED BOOLEAN,
    B_NAME VARCHAR(500),
    B_LONG_NAME VARCHAR(500),
    B_DESCRIPTION VARCHAR(2000),
    B_ENABLED BOOLEAN,
    B_QUALIFIER VARCHAR(10),
    B_LANGUAGE VARCHAR(20),
    B_COPY_COMPONENT_UUID VARCHAR(50),
    B_PATH VARCHAR(2000),
    B_UUID_PATH VARCHAR(1500),
    B_MODULE_UUID VARCHAR(50),
    B_MODULE_UUID_PATH VARCHAR(1500),
    CREATED_AT TIMESTAMP
);
ALTER TABLE PROJECTS ADD CONSTRAINT PK_PROJECTS PRIMARY KEY(ID);
CREATE INDEX PROJECTS_ORGANIZATION ON PROJECTS(ORGANIZATION_UUID);
CREATE UNIQUE INDEX PROJECTS_KEE ON PROJECTS(KEE);
CREATE INDEX PROJECTS_MODULE_UUID ON PROJECTS(MODULE_UUID);
CREATE INDEX PROJECTS_PROJECT_UUID ON PROJECTS(PROJECT_UUID);
CREATE INDEX PROJECTS_QUALIFIER ON PROJECTS(QUALIFIER);
CREATE INDEX PROJECTS_ROOT_UUID ON PROJECTS(ROOT_UUID);
CREATE INDEX PROJECTS_UUID ON PROJECTS(UUID);
