/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.checkstyle;

import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Java;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.checkstyle.CheckstyleProfileExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckstyleConfiguration
implements BatchExtension {
    private static final Logger LOG = LoggerFactory.getLogger(CheckstyleConfiguration.class);
    private CheckstyleProfileExporter confExporter;
    private RulesProfile profile;
    private Project project;

    public CheckstyleConfiguration(CheckstyleProfileExporter confExporter, RulesProfile profile, Project project) {
        this.confExporter = confExporter;
        this.profile = profile;
        this.project = project;
    }

    public File getXMLDefinitionFile() {
        File file;
        OutputStreamWriter writer = null;
        File xmlFile = new File(this.project.getFileSystem().getSonarWorkingDirectory(), "checkstyle.xml");
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile, false), "UTF-8");
            this.confExporter.exportProfile(this.profile, writer);
            ((Writer)writer).flush();
            file = xmlFile;
        }
        catch (IOException e) {
            try {
                throw new SonarException("Fail to save the Checkstyle configuration to " + xmlFile.getPath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return file;
    }

    public List<File> getSourceFiles() {
        return this.project.getFileSystem().getSourceFiles(new Language[]{Java.INSTANCE});
    }

    public File getTargetXMLReport() {
        if (this.project.getConfiguration().getBoolean("sonar.checkstyle.generateXml", false)) {
            return new File(this.project.getFileSystem().getSonarWorkingDirectory(), "checkstyle-result.xml");
        }
        return null;
    }

    public Configuration getCheckstyleConfiguration() throws IOException, CheckstyleException {
        File xmlConfig = this.getXMLDefinitionFile();
        LOG.info("Checkstyle configuration: " + xmlConfig.getAbsolutePath());
        Configuration configuration = CheckstyleConfiguration.toCheckstyleConfiguration(xmlConfig);
        this.defineCharset(configuration);
        return configuration;
    }

    static Configuration toCheckstyleConfiguration(File xmlConfig) throws CheckstyleException {
        return ConfigurationLoader.loadConfiguration((String)xmlConfig.getAbsolutePath(), (PropertyResolver)new PropertiesExpander(new Properties()));
    }

    private void defineCharset(Configuration configuration) {
        Configuration[] modules;
        for (Configuration module : modules = configuration.getChildren()) {
            if (!"Checker".equals(module.getName()) && !"com.puppycrawl.tools.checkstyle.Checker".equals(module.getName()) || !(module instanceof DefaultConfiguration)) continue;
            Charset charset = this.getCharset();
            LOG.info("Checkstyle charset: " + charset.name());
            ((DefaultConfiguration)module).addAttribute("charset", charset.name());
        }
    }

    public Charset getCharset() {
        Charset charset = this.project.getFileSystem().getSourceCharset();
        if (charset == null) {
            charset = Charset.forName(System.getProperty("file.encoding", "UTF-8"));
        }
        return charset;
    }
}

